/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversion.BytesToValue;
import com.amazon.aes.webservices.client.vmconversion.IOHelpers;
import com.amazon.aes.webservices.client.vmconversion.ImageFormatVerifier;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DynamicVHDVerifier
implements ImageFormatVerifier {
    private static final int FOOTER_SIZE = 512;
    private static final int DISK_TYPE_OFFSET = 60;
    private static final int HEADER_SIZE = 1024;
    private static final int HEADER_LOC_OFFSET = 20;
    private static final int FOOTER_CHECKSUM_OFFSET = 64;
    private static final int HEADER_CHECKSUM_OFFEST = 36;
    private static final int BLOCK_SIZE_OFFSET = 32;
    private static final int MAX_TABLE_ENTRIES_OFFSET = 28;
    private static final int DYNAMIC_FORMAT = 3;
    private static final int DIFFERENCING_FORMAT = 4;
    File diskImage;
    RandomAccessFile source;
    int headerOffset;
    int blockSize;
    int maximumTableEntries;

    public DynamicVHDVerifier(File diskImage_) throws VerificationException {
        this.diskImage = diskImage_;
        try {
            this.source = new RandomAccessFile(this.diskImage, "r");
            int diskType = this.processFooter();
            if (diskType != 3) {
                throw new VerificationException("Dynamic vhd format (disk-type = 3) is expected but found " + diskType);
            }
            this.processHeader();
        }
        catch (FileNotFoundException e) {
            throw new VerificationException("Unable to open " + this.diskImage + " for reading.");
        }
        catch (IOException e) {
            throw new VerificationException("Unable to verify file format: " + e.getMessage() + ".");
        }
    }

    public static void assertVHD(File diskImage) throws VerificationException {
        try {
            String expected = "conectix";
            byte[] magic = IOHelpers.readFromFile(diskImage, expected.length());
            String actual = new String(magic);
            if (!expected.equals(actual)) {
                String magicAsHex = String.format("%x", BytesToValue.toLongLittleEndian(magic, 0));
                throw new VerificationException("This does not appear to be a Dynamic VHD disk image (file begins with " + magicAsHex + ").");
            }
        }
        catch (IOException e) {
            throw new VerificationException("Error reading from " + diskImage + ": " + e.getMessage() + ".");
        }
    }

    public static int diskType(File diskImage) throws IOException {
        byte[] buffer = IOHelpers.readFromFile(diskImage, 64);
        return BytesToValue.toIntegerBigEndian(buffer, 60);
    }

    public static boolean isDynamicType(int type) {
        return type == 3;
    }

    public static boolean isDifferencingType(int type) {
        return type == 4;
    }

    public String descriptiveFormatName() {
        return "Dynamic VHD";
    }

    public long convertedSize() {
        return (long)this.maximumTableEntries * (long)this.blockSize;
    }

    protected int processFooter() throws IOException, VerificationException {
        byte[] buff = new byte[512];
        this.source.seek(0L);
        IOHelpers.reallyRead(this.source, buff, 512);
        if (!this.validateCheckSum(buff, 512, 64)) {
            throw new VerificationException("Unable to parse this file: footer failed checksum validation.");
        }
        this.headerOffset = BytesToValue.toIntegerBigEndian(buff, 20);
        int diskType = BytesToValue.toIntegerBigEndian(buff, 60);
        return diskType;
    }

    protected boolean validateCheckSum(byte[] buff, int len, int checksumPos) {
        int foundChecksum = BytesToValue.toIntegerBigEndian(buff, checksumPos);
        buff[checksumPos + 3] = 0;
        buff[checksumPos + 2] = 0;
        buff[checksumPos + 1] = 0;
        buff[checksumPos] = 0;
        int computedChecksum = 0;
        for (int i = 0; i < len; ++i) {
            computedChecksum += BytesToValue.toUnsigned(buff[i]);
        }
        return (computedChecksum ^= 0xFFFFFFFF) == foundChecksum;
    }

    private void processHeader() throws IOException, VerificationException {
        byte[] buff = new byte[1024];
        this.source.seek(this.headerOffset);
        IOHelpers.reallyRead(this.source, buff, 1024);
        if (!this.validateCheckSum(buff, 1024, 36)) {
            throw new VerificationException("Unable to parse this file: header failed checksum validation.");
        }
        this.blockSize = BytesToValue.toIntegerBigEndian(buff, 32);
        this.maximumTableEntries = BytesToValue.toIntegerBigEndian(buff, 28);
    }
}

