/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.ProgressFileRequestEntity;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class DiskImageUploader {
    protected static final int UPLOAD_RETRIES = 3;
    protected static final String TOKEN_NAME = "Ec2ConversionToken";
    ImportVolumeConversionTask task;
    File diskImage;
    long resumeFrom = -1L;
    PrintStream out;

    public DiskImageUploader(File diskImage_, ImportVolumeConversionTask task_, PrintStream out_) {
        this.task = task_;
        this.diskImage = diskImage_;
        this.out = out_;
    }

    public DiskImageUploader(File diskImage_, ImportVolumeConversionTask task_) {
        this(diskImage_, task_, System.out);
    }

    public void setResumeFrom(long from) {
        if (from < 0L) {
            throw new RuntimeException("The resume byte for an upload must be non-negative");
        }
        this.resumeFrom = from;
    }

    protected void addTransferCookie(HttpMethod method) {
        String token = "FAKE TOKEN";
        method.setRequestHeader("Cookie", "Ec2ConversionToken=" + token);
    }

    protected long resumeOffsetFromRangeHeader(String range) {
        Pattern range_spec = Pattern.compile("bytes (\\d+)-(\\d+)/(\\d+|\\*)");
        Matcher matcher = range_spec.matcher(range);
        if (!matcher.find()) {
            throw new InternalException("Error: the server responsed with a malformed Content-Range header");
        }
        long start = Long.parseLong(matcher.group(1));
        long end = Long.parseLong(matcher.group(2));
        if (start != 0L) {
            throw new InternalException("Error: the server responsed with a malformed Content-Range header");
        }
        return end + 1L;
    }

    protected void verifyResponseCode(int responseCode) throws VerificationException {
        if (responseCode >= 200 && responseCode < 300) {
            return;
        }
        if (responseCode >= 500) {
            throw new InternalException("The server is currently unable to accept uploads at this time.\nPlease try again later or check the AWS developer forums to see if it's the result of a known issue.");
        }
        if (responseCode >= 400 && responseCode < 500) {
            throw new VerificationException("Error while attempting to upload the volume, the request may have expired, server returned " + responseCode);
        }
        throw new InternalException("The server returned an unexpected error code: " + responseCode + ". This may indicate a problem with the server or this version of the client tools may be out of date.");
    }

    protected long getResumeByte(HttpClient client) throws IOException, VerificationException {
        HeadMethod method = this.getHeadMethod();
        this.addTransferCookie((HttpMethod)method);
        if (this.resumeFrom >= 0L) {
            this.setContentRange((HttpMethod)method, this.resumeFrom);
        }
        int responseCode = client.executeMethod((HttpMethod)method);
        this.verifyResponseCode(responseCode);
        if (this.resumeFrom >= 0L) {
            return this.resumeFrom;
        }
        Header range = method.getResponseHeader("Content-Range");
        if (range == null) {
            return 0L;
        }
        return this.resumeOffsetFromRangeHeader(range.toString());
    }

    protected void setContentRange(HttpMethod method, long from) {
        long total = this.diskImage.length();
        String hdr = "bytes " + from + "-" + (total - 1L) + "/" + total;
        method.setRequestHeader("Content-Range", hdr);
    }

    protected PutMethod getPutMethod() {
        return new PutMethod("http://foo");
    }

    protected HeadMethod getHeadMethod() {
        return new HeadMethod("http://foo");
    }

    protected int sendFile(HttpClient client, long resumeFrom) throws IOException, VerificationException {
        PutMethod put = this.getPutMethod();
        ProgressFileRequestEntity fileEntity = new ProgressFileRequestEntity(this.diskImage, resumeFrom, this.out);
        put.setRequestEntity((RequestEntity)fileEntity);
        this.addTransferCookie((HttpMethod)put);
        this.setContentRange((HttpMethod)put, resumeFrom);
        this.out.println("sending " + fileEntity.getContentLength() + " bytes");
        int responseCode = client.executeMethod((HttpMethod)put);
        this.verifyResponseCode(responseCode);
        return responseCode;
    }

    public void iterateHeadPutRequests(HttpClient client) throws VerificationException, IOException {
        for (int i = 0; i <= 3; ++i) {
            try {
                long resumePosition = this.getResumeByte(client);
                if (resumePosition < this.diskImage.length()) {
                    this.verifyResponseCode(this.sendFile(client, resumePosition));
                }
                return;
            }
            catch (IOException e) {
                if (i == 3) {
                    throw e;
                }
                this.out.println("Unable to complete transfer: " + e.getMessage());
                this.out.println("Retry attempt #" + (i + 1) + "...");
                continue;
            }
        }
    }

    public void doUpload() throws VerificationException, IOException {
        HttpClient client = new HttpClient();
        this.iterateHeadPutRequests(client);
    }
}

