/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.VolumeDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DescribeVolumes
extends BaseCmd {
    public DescribeVolumes(String[] args) {
        super("ec2dvol", "ec2-describe-volumes");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"filter");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FILTER");
        OptionBuilder.withDescription((String)"Add a filter criterion for the result-set.");
        o.addOption(OptionBuilder.create((String)"F"));
        return o;
    }

    protected String getOptionString() {
        return "[VOLUME [VOLUME [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe previously created volumes.");
        System.out.println("     The VOLUME parameter list specifies the volumes(s) to be described.");
        System.out.println("     If unspecified, all volumes will be described.");
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("filter");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] volumes = this.getNonOptions();
        RequestResultPair rsp = jec2.describeVolumes(volumes, this.getFilters(true));
        for (VolumeDescription d : (List)rsp.getResponse()) {
            out.output(System.out, d);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeVolumes(args).invoke();
    }
}

