/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.ProtectionToken;
import org.apache.ws.security.policy.model.SymmetricBinding;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.X509TokenProcessor;

public class SignEncProtectTokenProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedSignatureToken = false;
    private boolean initializedEncryptionToken = false;
    private boolean initializedProtectionToken = false;

    private void initializeSignatureToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod(new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    private void initializeEncryptionToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod(new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    private void initializeProtectionToken(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.x509Token.copy();
        tmpSpt.setProcessTokenMethod(new X509TokenProcessor());
        spt.setChildToken(tmpSpt);
    }

    public Object doSignatureToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedSignatureToken) break;
                try {
                    this.initializeSignatureToken(spt);
                    this.initializedSignatureToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doEncryptionToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedEncryptionToken) break;
                try {
                    this.initializeEncryptionToken(spt);
                    this.initializedEncryptionToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doProtectionToken(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                ProtectionToken protectionToken = (ProtectionToken)spc.readCurrentPolicyEngineData();
                try {
                    ((SymmetricBinding)spc.readPreviousPolicyEngineData()).setProtectionToken(protectionToken);
                }
                catch (WSSPolicyException e) {
                    return new Boolean(false);
                }
                if (this.initializedProtectionToken) break;
                try {
                    this.initializeProtectionToken(spt);
                    this.initializedProtectionToken = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }
}

