/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.AsymmetricBinding;
import org.apache.ws.security.policy.model.Binding;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.AlgorithmSuiteProcessor;
import org.apache.ws.security.policy.parser.processors.InitiatorRecipientTokenProcessor;
import org.apache.ws.security.policy.parser.processors.LayoutProcessor;

public class AsymmetricBindingProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedAsymmetricBinding = false;

    private void initializeAsymmetricBinding(SecurityPolicyToken spt) throws NoSuchMethodException {
        InitiatorRecipientTokenProcessor irt = new InitiatorRecipientTokenProcessor();
        SecurityPolicyToken tmpSpt = SecurityPolicy.initiatorToken.copy();
        tmpSpt.setProcessTokenMethod(irt);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.recipientToken.copy();
        tmpSpt.setProcessTokenMethod(irt);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.algorithmSuite.copy();
        tmpSpt.setProcessTokenMethod(new AlgorithmSuiteProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.layout.copy();
        tmpSpt.setProcessTokenMethod(new LayoutProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.includeTimestamp.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.encryptBeforeSigning.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signBeforeEncrypting.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.encryptSignature.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.protectTokens.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.onlySignEntireHeadersAndBody.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doAsymmetricBinding(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedAsymmetricBinding) break;
                try {
                    this.initializeAsymmetricBinding(spt);
                    this.initializedAsymmetricBinding = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doIncludeTimestamp(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((Binding)spc.readCurrentPolicyEngineData()).setIncludeTimestamp(true);
        }
        return new Boolean(true);
    }

    public Object doEncryptBeforeSigning(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            try {
                ((AsymmetricBinding)spc.readCurrentPolicyEngineData()).setProtectionOrder(spc.getAssertion().getName().getLocalPart());
            }
            catch (WSSPolicyException e) {
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doSignBeforeEncrypting(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            try {
                ((AsymmetricBinding)spc.readCurrentPolicyEngineData()).setProtectionOrder(spc.getAssertion().getName().getLocalPart());
            }
            catch (WSSPolicyException e) {
                return new Boolean(false);
            }
        }
        return new Boolean(true);
    }

    public Object doEncryptSignature(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((AsymmetricBinding)spc.readCurrentPolicyEngineData()).setSignatureProtection(true);
        }
        return new Boolean(true);
    }

    public Object doProtectTokens(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((AsymmetricBinding)spc.readCurrentPolicyEngineData()).setTokenProtection(true);
        }
        return new Boolean(true);
    }

    public Object doOnlySignEntireHeadersAndBody(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((AsymmetricBinding)spc.readCurrentPolicyEngineData()).setEntireHeaderAndBodySignatures(true);
        }
        return new Boolean(true);
    }
}

