/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser;

import java.util.ArrayList;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.model.PolicyEngineData;
import org.apache.ws.security.policy.model.RootPolicyEngineData;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;

public class SecurityProcessorContext {
    public static final int NONE = 0;
    public static final int START = 1;
    public static final int COMMIT = 2;
    public static final int ABORT = 3;
    public static final String[] ACTION_NAMES = new String[]{"NONE", "START", "COMMIT", "ABORT"};
    private ArrayList tokenStack = new ArrayList();
    private int tokenStackPointer = 0;
    private PrimitiveAssertion assertion = null;
    private ArrayList pedStack = new ArrayList();
    private int pedStackPointer = 0;
    private int action = 0;

    public int getAction() {
        return this.action;
    }

    public void setAction(int act) {
        this.action = act;
    }

    public PrimitiveAssertion getAssertion() {
        return this.assertion;
    }

    public void setAssertion(PrimitiveAssertion asrt) {
        this.assertion = asrt;
    }

    public void pushSecurityToken(SecurityPolicyToken spt) {
        this.tokenStack.add(this.tokenStackPointer, spt);
        ++this.tokenStackPointer;
    }

    public SecurityPolicyToken popSecurityToken() {
        if (this.tokenStackPointer > 0) {
            --this.tokenStackPointer;
            return (SecurityPolicyToken)this.tokenStack.get(this.tokenStackPointer);
        }
        return null;
    }

    public SecurityPolicyToken readCurrentSecurityToken() {
        if (this.tokenStackPointer > 0) {
            return (SecurityPolicyToken)this.tokenStack.get(this.tokenStackPointer - 1);
        }
        return null;
    }

    public void pushPolicyEngineData(PolicyEngineData ped) {
        this.pedStack.add(this.pedStackPointer, ped);
        ++this.pedStackPointer;
    }

    public PolicyEngineData popPolicyEngineData() {
        if (this.pedStackPointer > 0) {
            --this.pedStackPointer;
            return (PolicyEngineData)this.pedStack.get(this.pedStackPointer);
        }
        return null;
    }

    public PolicyEngineData readCurrentPolicyEngineData() {
        if (this.pedStackPointer > 0) {
            return (PolicyEngineData)this.pedStack.get(this.pedStackPointer - 1);
        }
        return null;
    }

    public PolicyEngineData readPreviousPolicyEngineData() {
        if (this.pedStackPointer > 1) {
            return (PolicyEngineData)this.pedStack.get(this.pedStackPointer - 2);
        }
        return null;
    }

    public PolicyEngineData commitPolicyEngineData() {
        if (this.pedStackPointer > 2) {
            --this.pedStackPointer;
            PolicyEngineData ped = (PolicyEngineData)this.pedStack.get(this.pedStackPointer);
            return ped;
        }
        if (this.pedStackPointer == 2) {
            RootPolicyEngineData rootData = (RootPolicyEngineData)this.pedStack.get(0);
            rootData.addTopLevelPED(this.readCurrentPolicyEngineData());
            --this.pedStackPointer;
            return (PolicyEngineData)this.pedStack.get(this.pedStackPointer);
        }
        return null;
    }

    public ArrayList getPedStack() {
        return this.pedStack;
    }
}

