/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Set;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.SignatureConfirmation;
import org.apache.ws.security.message.token.Timestamp;
import org.opensaml.SAMLAssertion;

public class WSSecurityEngineResult {
    private int action;
    private Principal principal;
    private X509Certificate cert;
    private SAMLAssertion assertion;
    private Timestamp timestamp;
    private SecurityContextToken securityContextToken;
    private Set signedElements;
    private byte[] signatureValue = null;
    private SignatureConfirmation sigConf = null;
    private byte[] decryptedKey = null;
    private String encryptedKeyId = null;
    private ArrayList dataRefUris = null;

    public WSSecurityEngineResult(int act, SAMLAssertion ass) {
        this.principal = null;
        this.cert = null;
        this.action = act;
        this.assertion = ass;
    }

    public WSSecurityEngineResult(int act, Principal princ, X509Certificate certificate, Set elements, byte[] sv) {
        this.principal = princ;
        this.action = act;
        this.cert = certificate;
        this.signedElements = elements;
        this.signatureValue = sv;
    }

    public WSSecurityEngineResult(int act, byte[] decryptedKey, String encyptedKeyId, ArrayList dataRefUris) {
        this.action = act;
        this.decryptedKey = decryptedKey;
        this.encryptedKeyId = encyptedKeyId;
        this.dataRefUris = dataRefUris;
    }

    public WSSecurityEngineResult(int act, ArrayList dataRefUris) {
        this.action = act;
        this.dataRefUris = dataRefUris;
    }

    public WSSecurityEngineResult(int act, Timestamp tstamp) {
        this.action = act;
        this.timestamp = tstamp;
    }

    public WSSecurityEngineResult(int act, SecurityContextToken sct) {
        this.action = act;
        this.securityContextToken = sct;
    }

    public WSSecurityEngineResult(int act, SignatureConfirmation sc) {
        this.action = act;
        this.sigConf = sc;
    }

    public int getAction() {
        return this.action;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public SAMLAssertion getAssertion() {
        return this.assertion;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Set getSignedElements() {
        return this.signedElements;
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }

    public SignatureConfirmation getSigConf() {
        return this.sigConf;
    }

    public void setSignatureValue(byte[] signatureValue) {
        this.signatureValue = signatureValue;
    }

    public SecurityContextToken getSecurityContextToken() {
        return this.securityContextToken;
    }

    public byte[] getDecryptedKey() {
        return this.decryptedKey;
    }

    public String getEncryptedKeyId() {
        return this.encryptedKeyId;
    }

    public ArrayList getDataRefUris() {
        return this.dataRefUris;
    }
}

