/*
 * AppleRecords - A DAAP client
 * Copyright (C) 2004  Chris Davies <c.davies@cdavies.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.cdavies.applerecords;

import java.net.URL;

/**
 * 
 * A utility class dedicated to locating image resources for AppleRecords.
 * <p>
 * You supply the name of the image, you get back a URL. Simple as that.
 * 
 * 
 * @author       Chris Davies (c.davies@cdavies.org)
 * @version      0.5 21/06/2004
 *
 */

public class ResourceLocator {
	
	private static final String IMAGE_PATH = "/images/";
	
	/**
	 * 
	 * Locates the gif images used by AppleRecords for the 
	 * purposes of labelling buttons, etc. You supply the name
	 * string (e.g. "play" for play.gif) and get back a URL
	 * indicating where the image lives.
	 *
	 * @param	res	The name of the image resource you wish to locate
	 * @return	A URL indicating where the resource lives
	 * 
	 */
	
	public final URL loadImageResource(String res) {
		
		String _absPath = IMAGE_PATH + res + ".gif";
		return getClass().getResource(_absPath);
		
	}
	
}
