/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.sitraka.ReportFilters;
import org.apache.tools.ant.taskdefs.optional.sitraka.XMLReport;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.w3c.dom.Document;

public class CovReport
extends Task {
    private File home = null;
    private String format = null;
    private File tofile = null;
    private String type = null;
    private Integer percent = null;
    private String filters = null;
    private File snapshot = null;
    private Path sourcePath = null;
    private boolean includeSource = true;
    private Path coveragePath = null;
    private Reference reference = null;

    public void setHome(File value) {
        this.home = value;
    }

    public void setFormat(ReportFormat value) {
        this.format = value.getValue();
    }

    public void setType(ReportType value) {
        this.type = value.getValue();
    }

    public void setIncludesource(boolean value) {
        this.includeSource = value;
    }

    public void setPercent(Integer value) {
        this.percent = value;
    }

    public void setFilters(String values) {
        this.filters = values;
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(((ProjectComponent)this).project);
        }
        return this.sourcePath.createPath();
    }

    public void setSnapshot(File value) {
        this.snapshot = value;
    }

    public void setTofile(File value) {
        this.tofile = value;
    }

    public Path createCoveragepath() {
        if (this.coveragePath == null) {
            this.coveragePath = new Path(((ProjectComponent)this).project);
        }
        return this.coveragePath.createPath();
    }

    public Reference createReference() {
        if (this.reference == null) {
            this.reference = new Reference();
        }
        return this.reference;
    }

    protected void checkOptions() throws BuildException {
        if (this.tofile == null) {
            throw new BuildException("'tofile' attribute must be set.");
        }
        if (this.snapshot == null) {
            throw new BuildException("'snapshot' attribute must be set.");
        }
        if (this.home == null) {
            throw new BuildException("'home' attribute must be set to JProbe home directory");
        }
        this.home = new File(this.home, "coverage");
        File jar = new File(this.home, "coverage.jar");
        if (!jar.exists()) {
            throw new BuildException("Cannot find Coverage directory: " + this.home);
        }
        if (this.reference != null && !"xml".equals(this.format)) {
            this.log("Ignored reference. It cannot be used in non XML report.");
            this.reference = null;
        }
    }

    public void execute() throws BuildException {
        this.checkOptions();
        try {
            Commandline cmdl = new Commandline();
            cmdl.setExecutable(new File(this.home, "jpcovreport").getAbsolutePath());
            String[] params = this.getParameters();
            for (int i = 0; i < params.length; ++i) {
                cmdl.createArgument().setValue(params[i]);
            }
            LogStreamHandler handler = new LogStreamHandler((Task)this, 2, 1);
            Execute exec = new Execute((ExecuteStreamHandler)handler);
            this.log(cmdl.describeCommand(), 3);
            exec.setCommandline(cmdl.getCommandline());
            int exitValue = exec.execute();
            if (exitValue != 0) {
                throw new BuildException("JProbe Coverage Report failed (" + exitValue + ")");
            }
            this.log("coveragePath: " + this.coveragePath, 3);
            this.log("format: " + this.format, 3);
            if (this.reference != null && "xml".equals(this.format)) {
                this.reference.createEnhancedXMLReport();
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to execute JProbe Coverage Report.", (Throwable)e);
        }
    }

    protected String[] getParameters() {
        Vector<String> v = new Vector<String>();
        if (this.format != null) {
            v.addElement("-format=" + this.format);
        }
        if (this.type != null) {
            v.addElement("-type=" + this.type);
        }
        if (this.percent != null) {
            v.addElement("-percent=" + this.percent);
        }
        if (this.filters != null) {
            v.addElement("-filters=" + this.filters);
        }
        v.addElement("-output=" + ((ProjectComponent)this).project.resolveFile(this.tofile.getPath()));
        v.addElement("-snapshot=" + ((ProjectComponent)this).project.resolveFile(this.snapshot.getPath()));
        if (this.sourcePath == null) {
            this.sourcePath = new Path(((ProjectComponent)this).project);
            this.sourcePath.createPath().setLocation(((ProjectComponent)this).project.resolveFile("."));
        }
        v.addElement("-sourcepath=" + this.sourcePath);
        if ("verydetailed".equalsIgnoreCase(this.format) && "xml".equalsIgnoreCase(this.type)) {
            v.addElement("-inc_src_text=" + (this.includeSource ? "on" : "off"));
        }
        Object[] params = new String[v.size()];
        v.copyInto(params);
        return params;
    }

    public class Reference {
        protected Path classPath;
        protected ReportFilters filters;

        public Path createClasspath() {
            if (this.classPath == null) {
                this.classPath = new Path(CovReport.this.getProject());
            }
            return this.classPath.createPath();
        }

        public ReportFilters createFilters() {
            if (this.filters == null) {
                this.filters = new ReportFilters();
            }
            return this.filters;
        }

        protected void createEnhancedXMLReport() throws BuildException {
            if (this.classPath == null) {
                throw new BuildException("Need a 'classpath' element.");
            }
            String[] paths = this.classPath.list();
            if (paths.length == 0) {
                throw new BuildException("Coverage path is invalid. It does not contain any existing path.");
            }
            if (this.filters == null || this.filters.size() == 0) {
                this.createFilters();
                CovReport.this.log("Adding default include filter to *.*()", 3);
                ReportFilters.Include include = new ReportFilters.Include();
                this.filters.addInclude(include);
            }
            try {
                CovReport.this.log("Creating enhanced XML report", 3);
                XMLReport report = new XMLReport(CovReport.this, CovReport.this.tofile);
                report.setReportFilters(this.filters);
                report.setJProbehome(new File(CovReport.this.home.getParent()));
                Document doc = report.createDocument(paths);
                TransformerFactory tfactory = TransformerFactory.newInstance();
                Transformer transformer = tfactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                DOMSource src = new DOMSource(doc);
                StreamResult res = new StreamResult("file:///" + CovReport.this.tofile.toString());
                transformer.transform(src, res);
            }
            catch (Exception e) {
                throw new BuildException("Error while performing enhanced XML report from file " + CovReport.this.tofile, (Throwable)e);
            }
        }
    }

    public static class ReportType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"executive", "summary", "detailed", "verydetailed"};
        }
    }

    public static class ReportFormat
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"html", "text", "xml"};
        }
    }
}

