/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class CovMerge
extends Task {
    private File home = null;
    private File tofile = null;
    private Vector filesets = new Vector();
    private boolean verbose;

    public void setHome(File value) {
        this.home = value;
    }

    public void setTofile(File value) {
        this.tofile = value;
    }

    public void setVerbose(boolean flag) {
        this.verbose = flag;
    }

    public void addFileset(FileSet fs) {
        this.filesets.addElement(fs);
    }

    public void execute() throws BuildException {
        this.checkOptions();
        File paramfile = this.createParamFile();
        try {
            Commandline cmdl = new Commandline();
            cmdl.setExecutable(new File(this.home, "jpcovmerge").getAbsolutePath());
            if (this.verbose) {
                cmdl.createArgument().setValue("-v");
            }
            cmdl.createArgument().setValue("-jp_paramfile=" + paramfile.getAbsolutePath());
            LogStreamHandler handler = new LogStreamHandler((Task)this, 2, 1);
            Execute exec = new Execute((ExecuteStreamHandler)handler);
            this.log(cmdl.describeCommand(), 3);
            exec.setCommandline(cmdl.getCommandline());
            int exitValue = exec.execute();
            if (exitValue != 0) {
                throw new BuildException("JProbe Coverage Merging failed (" + exitValue + ")");
            }
        }
        catch (IOException e) {
            throw new BuildException("Failed to run JProbe Coverage Merge: " + e);
        }
        finally {
            paramfile.delete();
        }
    }

    protected void checkOptions() throws BuildException {
        if (this.tofile == null) {
            throw new BuildException("'tofile' attribute must be set.");
        }
        if (this.home == null || !this.home.isDirectory()) {
            throw new BuildException("Invalid home directory. Must point to JProbe home directory");
        }
        this.home = new File(this.home, "coverage");
        File jar = new File(this.home, "coverage.jar");
        if (!jar.exists()) {
            throw new BuildException("Cannot find Coverage directory: " + this.home);
        }
    }

    protected File[] getSnapshots() {
        Vector<File> v = new Vector<File>();
        int size = this.filesets.size();
        for (int i = 0; i < size; ++i) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] f = ds.getIncludedFiles();
            for (int j = 0; j < f.length; ++j) {
                String pathname = f[j];
                File file = new File(ds.getBasedir(), pathname);
                file = ((ProjectComponent)this).project.resolveFile(file.getPath());
                v.addElement(file);
            }
        }
        Object[] files = new File[v.size()];
        v.copyInto(files);
        return files;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File createParamFile() throws BuildException {
        File[] snapshots = this.getSnapshots();
        File file = this.createTmpFile();
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(file);
                PrintWriter pw = new PrintWriter(fw);
                for (int i = 0; i < snapshots.length; ++i) {
                    pw.println(snapshots[i].getAbsolutePath());
                }
                pw.println(((ProjectComponent)this).project.resolveFile(this.tofile.getPath()));
                pw.flush();
            }
            catch (IOException e) {
                throw new BuildException("I/O error while writing to " + file, (Throwable)e);
            }
            Object var7_7 = null;
            if (fw == null) return file;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fw == null) throw throwable;
            try {
                fw.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        fw.close();
        return file;
    }

    protected File createTmpFile() {
        long rand = new Random(System.currentTimeMillis()).nextLong();
        File file = new File("jpcovmerge" + rand + ".tmp");
        return file;
    }
}

