/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.P4HandlerAdapter;
import org.apache.tools.ant.taskdefs.optional.perforce.SimpleP4OutputHandler;

public class P4Counter
extends P4Base {
    public String counter = null;
    public String property = null;
    public boolean shouldSetValue = false;
    public boolean shouldSetProperty = false;
    public int value = 0;

    public void setName(String counter) {
        this.counter = counter;
    }

    public void setValue(int value) {
        this.value = value;
        this.shouldSetValue = true;
    }

    public void setProperty(String property) {
        this.property = property;
        this.shouldSetProperty = true;
    }

    public void execute() throws BuildException {
        if (this.counter == null || this.counter.length() == 0) {
            throw new BuildException("No counter specified to retrieve");
        }
        if (this.shouldSetValue && this.shouldSetProperty) {
            throw new BuildException("Cannot both set the value of the property and retrieve the value of the property.");
        }
        String command = "counter " + this.P4CmdOpts + " " + this.counter;
        if (!this.shouldSetProperty) {
            command = "-s " + command;
        }
        if (this.shouldSetValue) {
            command = command + " " + this.value;
        }
        if (this.shouldSetProperty) {
            final Project myProj = ((ProjectComponent)this).project;
            P4HandlerAdapter handler = new P4HandlerAdapter(){

                public void process(String line) {
                    P4Counter.this.log("P4Counter retrieved line \"" + line + "\"", 3);
                    try {
                        P4Counter.this.value = Integer.parseInt(line);
                        myProj.setProperty(P4Counter.this.property, "" + P4Counter.this.value);
                    }
                    catch (NumberFormatException nfe) {
                        throw new BuildException("Perforce error. Could not retrieve counter value.");
                    }
                }
            };
            this.execP4Command(command, handler);
        } else {
            this.execP4Command(command, new SimpleP4OutputHandler(this));
        }
    }
}

