/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Package;
import com.ibm.ivj.util.base.Project;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ide.VAJLocalUtil;

class VAJWorkspaceScanner
extends DirectoryScanner {
    private static final String[] DEFAULTEXCLUDES = new String[]{"IBM*/**", "Java class libraries/**", "Sun class libraries*/**", "JSP Page Compile Generated Code/**", "VisualAge*/**"};
    private Vector packagesIncluded = new Vector();

    VAJWorkspaceScanner() {
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    public Vector findMatchingProjects() {
        int i;
        Project[] projects = VAJLocalUtil.getWorkspace().getProjects();
        Vector<Project> matchingProjects = new Vector<Project>();
        boolean allProjectsMatch = false;
        block0: for (i = 0; i < projects.length; ++i) {
            Project project = projects[i];
            for (int j = 0; j < this.includes.length && !allProjectsMatch; ++j) {
                StringTokenizer tok = new StringTokenizer(this.includes[j], File.separator);
                String projectNamePattern = tok.nextToken();
                if (projectNamePattern.equals("**")) {
                    allProjectsMatch = true;
                    continue;
                }
                if (!DirectoryScanner.match((String)projectNamePattern, (String)project.getName())) continue;
                matchingProjects.addElement(project);
                continue block0;
            }
        }
        if (allProjectsMatch) {
            matchingProjects = new Vector();
            for (i = 0; i < projects.length; ++i) {
                matchingProjects.addElement(projects[i]);
            }
        }
        return matchingProjects;
    }

    public Package[] getIncludedPackages() {
        int count = this.packagesIncluded.size();
        Package[] packages = new Package[count];
        for (int i = 0; i < count; ++i) {
            packages[i] = (Package)this.packagesIncluded.elementAt(i);
        }
        return packages;
    }

    public void scan() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        Vector matchingProjects = this.findMatchingProjects();
        Enumeration e = matchingProjects.elements();
        while (e.hasMoreElements()) {
            Project project = (Project)e.nextElement();
            this.scanProject(project);
        }
    }

    public void scanProject(Project project) {
        try {
            Package[] packages = project.getPackages();
            if (packages != null) {
                for (int i = 0; i < packages.length; ++i) {
                    Package item = packages[i];
                    String name = project.getName() + File.separator + item.getName().replace('.', File.separatorChar);
                    if (!this.isIncluded(name) || this.isExcluded(name)) continue;
                    this.packagesIncluded.addElement(item);
                }
            }
        }
        catch (IvjException e) {
            throw VAJLocalUtil.createBuildException("VA Exception occured: ", e);
        }
    }
}

