/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;

public class CommonsLoggingListener
implements BuildListener {
    private boolean initialized = false;
    private LogFactory logFactory;
    static /* synthetic */ Class class$org$apache$tools$ant$Project;
    static /* synthetic */ Class class$org$apache$tools$ant$Target;

    public CommonsLoggingListener() {
        try {
            this.logFactory = LogFactory.getFactory();
        }
        catch (LogConfigurationException e) {
            e.printStackTrace(System.err);
            return;
        }
        this.initialized = true;
    }

    public void buildStarted(BuildEvent event) {
        if (this.initialized) {
            Log log = this.logFactory.getInstance(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = CommonsLoggingListener.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
            log.info((Object)"Build started.");
        }
    }

    public void buildFinished(BuildEvent event) {
        if (this.initialized) {
            Log log = this.logFactory.getInstance(class$org$apache$tools$ant$Project == null ? (class$org$apache$tools$ant$Project = CommonsLoggingListener.class$("org.apache.tools.ant.Project")) : class$org$apache$tools$ant$Project);
            if (event.getException() == null) {
                log.info((Object)"Build finished.");
            } else {
                log.error((Object)"Build finished with error.", event.getException());
            }
        }
    }

    public void targetStarted(BuildEvent event) {
        if (this.initialized) {
            Log log = this.logFactory.getInstance(class$org$apache$tools$ant$Target == null ? (class$org$apache$tools$ant$Target = CommonsLoggingListener.class$("org.apache.tools.ant.Target")) : class$org$apache$tools$ant$Target);
            log.info((Object)("Target \"" + event.getTarget().getName() + "\" started."));
        }
    }

    public void targetFinished(BuildEvent event) {
        if (this.initialized) {
            String targetName = event.getTarget().getName();
            Log log = this.logFactory.getInstance(class$org$apache$tools$ant$Target == null ? (class$org$apache$tools$ant$Target = CommonsLoggingListener.class$("org.apache.tools.ant.Target")) : class$org$apache$tools$ant$Target);
            if (event.getException() == null) {
                log.info((Object)("Target \"" + targetName + "\" finished."));
            } else {
                log.error((Object)("Target \"" + targetName + "\" finished with error."), event.getException());
            }
        }
    }

    public void taskStarted(BuildEvent event) {
        if (this.initialized) {
            Task task = event.getTask();
            Log log = this.logFactory.getInstance(task.getClass().getName());
            log.info((Object)("Task \"" + task.getTaskName() + "\" started."));
        }
    }

    public void taskFinished(BuildEvent event) {
        if (this.initialized) {
            Task task = event.getTask();
            Log log = this.logFactory.getInstance(task.getClass().getName());
            if (event.getException() == null) {
                log.info((Object)("Task \"" + task.getTaskName() + "\" finished."));
            } else {
                log.error((Object)("Task \"" + task.getTaskName() + "\" finished with error."), event.getException());
            }
        }
    }

    public void messageLogged(BuildEvent event) {
        if (this.initialized) {
            Task categoryObject = event.getTask();
            if (categoryObject == null && (categoryObject = event.getTarget()) == null) {
                categoryObject = event.getProject();
            }
            Log log = this.logFactory.getInstance(categoryObject.getClass().getName());
            switch (event.getPriority()) {
                case 0: {
                    log.error((Object)event.getMessage());
                    break;
                }
                case 1: {
                    log.warn((Object)event.getMessage());
                    break;
                }
                case 2: {
                    log.info((Object)event.getMessage());
                    break;
                }
                case 3: {
                    log.debug((Object)event.getMessage());
                    break;
                }
                case 4: {
                    log.debug((Object)event.getMessage());
                    break;
                }
                default: {
                    log.error((Object)event.getMessage());
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

