/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;

public class ExecuteJava
implements Runnable,
TimeoutObserver {
    private Commandline javaCommand = null;
    private Path classpath = null;
    private CommandlineJava.SysProperties sysProperties = null;
    private Method main = null;
    private Long timeout = null;
    private Throwable caught = null;
    private boolean timedOut = false;
    private Thread thread = null;

    public void setJavaCommand(Commandline javaCommand) {
        this.javaCommand = javaCommand;
    }

    public void setClasspath(Path p) {
        this.classpath = p;
    }

    public void setSystemProperties(CommandlineJava.SysProperties s) {
        this.sysProperties = s;
    }

    public void setOutput(PrintStream out) {
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Project project) throws BuildException {
        String classname = this.javaCommand.getExecutable();
        AntClassLoader loader = null;
        try {
            block21: {
                try {
                    if (this.sysProperties != null) {
                        this.sysProperties.setSystem();
                    }
                    Class[] param = new Class[]{Class.forName("[Ljava.lang.String;")};
                    Class target = null;
                    if (this.classpath == null) {
                        target = Class.forName(classname);
                    } else {
                        loader = new AntClassLoader(project.getCoreLoader(), project, this.classpath, false);
                        loader.setIsolated(true);
                        loader.setThreadContextLoader();
                        target = loader.forceLoadClass(classname);
                        AntClassLoader.initializeClass(target);
                    }
                    this.main = target.getMethod("main", param);
                    if (this.main == null) {
                        throw new BuildException("Could not find main() method in " + classname);
                    }
                    if (this.timeout == null) {
                        this.run();
                    } else {
                        this.thread = new Thread((Runnable)this, "ExecuteJava");
                        Task currentThreadTask = project.getThreadTask(Thread.currentThread());
                        project.registerThreadTask(this.thread, currentThreadTask);
                        this.thread.setDaemon(true);
                        Watchdog w = new Watchdog(this.timeout);
                        w.addTimeoutObserver(this);
                        ExecuteJava executeJava = this;
                        synchronized (executeJava) {
                            this.thread.start();
                            w.start();
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (this.timedOut) {
                                project.log("Timeout: sub-process interrupted", 1);
                            } else {
                                this.thread = null;
                                w.stop();
                            }
                        }
                    }
                    if (this.caught != null) {
                        throw this.caught;
                    }
                    Object var12_13 = null;
                    if (loader == null) break block21;
                }
                catch (ClassNotFoundException e) {
                    throw new BuildException("Could not find " + classname + "." + " Make sure you have it in your" + " classpath");
                }
                catch (SecurityException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new BuildException(e);
                }
                loader.resetThreadContextLoader();
                loader.cleanup();
            }
            if (this.sysProperties == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (loader != null) {
                loader.resetThreadContextLoader();
                loader.cleanup();
            }
            if (this.sysProperties == null) throw throwable;
            this.sysProperties.restoreSystem();
            throw throwable;
        }
        this.sysProperties.restoreSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object[] argument = new Object[]{this.javaCommand.getArguments()};
        try {
            this.main.invoke(null, argument);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (!(t instanceof InterruptedException)) {
                this.caught = t;
            }
        }
        catch (Throwable t) {
            this.caught = t;
        }
        finally {
            ExecuteJava e = this;
            synchronized (e) {
                this.notifyAll();
            }
        }
    }

    public synchronized void timeoutOccured(Watchdog w) {
        if (this.thread != null) {
            this.timedOut = true;
            this.thread.interrupt();
        }
        this.notifyAll();
    }

    public boolean killedProcess() {
        return this.timedOut;
    }
}

