/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.forms;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Merge
extends Form {
    public static String name = "Merge Filesets";
    private TextSelectPanel targetText;
    private BinSelectPanel targetBin;
    private ListSelectPanel targetTXT;
    private JTabbedPane mergeInputs;
    private JRadioButton recode;
    private JRadioButton recodeAD;
    private JRadioButton recode12;
    private JRadioButton recodeHV;
    private JRadioButton makeBin;
    private JPanel recodeOp;
    private JRadioButton op1;
    private JRadioButton op2;
    private JRadioButton op3;
    private JRadioButton op4;
    private JRadioButton op5;
    private JRadioButton op6;
    private JRadioButton op7;
    private JPanel optional;

    public Merge(GPLINK mf) {
        super(mf, name);
        this.pack();
        this.setVisible(true);
        this.filterButton.setEnabled(false);
        this.thresholdButton.setEnabled(false);
    }

    protected void initalize() {
        this.targetBin = new BinSelectPanel(this.parent);
        this.targetText = new TextSelectPanel(this.parent);
        this.targetTXT = new ListSelectPanel(this.parent);
        this.mergeInputs = new JTabbedPane();
        this.recodeOp = new JPanel();
        this.recode = new JRadioButton("Standard fileset (--recode)");
        this.recodeAD = new JRadioButton("Raw genotype file (--recodeAD)");
        this.recode12 = new JRadioButton("Standard fileset w/ allele recoding (--recode12)");
        this.recodeHV = new JRadioButton("Haploview fileset (--recodeHV)");
        this.makeBin = new JRadioButton("Binary fileset (--make-bed)");
        this.optional = new JPanel();
        this.op1 = new JRadioButton("1) Consensus call (default)");
        this.op2 = new JRadioButton("2) Only overwrite calls missing in original");
        this.op3 = new JRadioButton("3) Only overwrite calls not missing in new");
        this.op4 = new JRadioButton("4) Never overwrite");
        this.op5 = new JRadioButton("5) Always overwrite");
        this.op6 = new JRadioButton("6) Report all mismatches");
        this.op7 = new JRadioButton("7) Report non-missing mismatches");
        this.validBody = this.targetBin.validInput;
    }

    void createMergeTarget() {
        this.mergeInputs.addTab("Merge Binary Fileset", this.targetBin);
        this.mergeInputs.addTab("Merge Standard Fileset", this.targetText);
        this.mergeInputs.addTab("Merge Multiple Filesets", this.targetTXT);
        ChangeListener checkMergeTab = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Merge.this.op6.setEnabled(Merge.this.mergeInputs.getSelectedIndex() != 2);
                Merge.this.op7.setEnabled(Merge.this.mergeInputs.getSelectedIndex() != 2);
                Merge.this.isBodyValid();
            }
        };
        this.mergeInputs.addChangeListener(checkMergeTab);
    }

    void createRecodeOps() {
        this.recodeOp.setLayout(new BoxLayout(this.recodeOp, 3));
        this.recode.setSelected(true);
        this.recodeOp.add(this.recode);
        this.recodeOp.add(this.recode12);
        this.recodeOp.add(this.recodeAD);
        this.recodeOp.add(this.recodeHV);
        this.recodeOp.add(this.makeBin);
        ButtonGroup recodeGroup = new ButtonGroup();
        recodeGroup.add(this.recode);
        recodeGroup.add(this.recode12);
        recodeGroup.add(this.recodeAD);
        recodeGroup.add(this.recodeHV);
        recodeGroup.add(this.makeBin);
    }

    void createOptions() {
        this.optional.setLayout(new BoxLayout(this.optional, 3));
        ButtonGroup optionGroup = new ButtonGroup();
        optionGroup.add(this.op1);
        this.op1.setSelected(true);
        optionGroup.add(this.op2);
        optionGroup.add(this.op3);
        optionGroup.add(this.op4);
        optionGroup.add(this.op5);
        optionGroup.add(this.op6);
        optionGroup.add(this.op7);
        this.optional.add(this.op1);
        this.optional.add(this.op2);
        this.optional.add(this.op3);
        this.optional.add(this.op4);
        this.optional.add(this.op5);
        this.optional.add(this.op6);
        this.optional.add(this.op7);
    }

    protected JPanel createBody() {
        this.initalize();
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 3));
        this.createOptions();
        this.createMergeTarget();
        this.createRecodeOps();
        body.add(this.mergeInputs);
        JPanel formating = new JPanel();
        formating.setLayout(new BoxLayout(formating, 2));
        formating.add(this.recodeOp);
        formating.add(new JSeparator(1));
        formating.add(this.optional);
        body.add(formating);
        return body;
    }

    protected String processBody() {
        String ans = "";
        if (this.mergeInputs.getSelectedIndex() == 0) {
            ans = String.valueOf(ans) + this.targetBin.getCommand();
        }
        if (this.mergeInputs.getSelectedIndex() == 1) {
            ans = String.valueOf(ans) + this.targetText.getCommand();
        }
        if (this.mergeInputs.getSelectedIndex() == 2) {
            ans = String.valueOf(ans) + this.targetTXT.getCommand();
        }
        if (this.op2.isSelected() && this.op2.isEnabled()) {
            ans = String.valueOf(ans) + " --merge-mode 2";
        }
        if (this.op3.isSelected() && this.op3.isEnabled()) {
            ans = String.valueOf(ans) + " --merge-mode 3";
        }
        if (this.op4.isSelected() && this.op4.isEnabled()) {
            ans = String.valueOf(ans) + " --merge-mode 4";
        }
        if (this.op5.isSelected() && this.op5.isEnabled()) {
            ans = String.valueOf(ans) + " --merge-mode 5";
        }
        if (this.op6.isSelected() && this.op6.isEnabled()) {
            ans = String.valueOf(ans) + " --merge-mode 6";
        }
        if (this.op7.isSelected() && this.op7.isEnabled()) {
            ans = String.valueOf(ans) + " --merge-mode 7";
        }
        if (this.recode.isSelected()) {
            ans = String.valueOf(ans) + " --recode";
        }
        if (this.recodeAD.isSelected()) {
            ans = String.valueOf(ans) + " --recodeAD";
        }
        if (this.recode12.isSelected()) {
            ans = String.valueOf(ans) + " --recode12";
        }
        if (this.recodeHV.isSelected()) {
            ans = String.valueOf(ans) + " --recodeHV";
        }
        if (this.makeBin.isSelected()) {
            ans = String.valueOf(ans) + " --make-bed";
        }
        return ans;
    }

    protected void isBodyValid() {
        this.validBody = this.mergeInputs.getSelectedIndex() == 0 && !this.targetBin.validInput || this.mergeInputs.getSelectedIndex() == 1 && !this.targetText.validInput || this.mergeInputs.getSelectedIndex() == 2 && !this.targetTXT.validInput ? false : !(!this.recode.isSelected() || !this.recode.isEnabled() || this.recodeAD.isSelected() && this.recodeAD.isEnabled() || this.recodeHV.isSelected() && this.recodeHV.isEnabled() || this.recode12.isSelected() && this.recode12.isEnabled() || this.makeBin.isSelected() && this.makeBin.isEnabled());
        this.okForm();
    }

    private JPanel bundle(JLabel label, JTextField field, Form.BrowseButton browse) {
        JPanel ans = new JPanel();
        ans.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        ans.add((Component)label, c);
        c.gridx = 1;
        c.weightx = 1.0;
        ans.add((Component)field, c);
        c.gridx = 2;
        c.weightx = 0.0;
        ans.add((Component)browse, c);
        return ans;
    }

    private class TextSelectPanel
    extends JPanel {
        public boolean validInput = false;
        private float my_alignment = 1.0f;
        private JComboBox stdShort;
        private JCheckBox stdCheck;
        private JTextField pedField;
        private JTextField mapField;
        private Form.BrowseButton pedBrowse;
        private Form.BrowseButton mapBrowse;
        private DocumentListener textValidDL = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                TextSelectPanel.this.checkValid();
            }

            public void removeUpdate(DocumentEvent e) {
                TextSelectPanel.this.checkValid();
            }
        };

        private void createStd() {
            this.setLayout(new BoxLayout(this, 3));
            this.setAlignmentX(this.my_alignment);
            JPanel quick = new JPanel();
            quick.setBorder(new TitledBorder("Quick Fileset"));
            quick.setAlignmentX(this.my_alignment);
            quick.add(this.stdCheck);
            quick.add(this.stdShort);
            this.add(quick);
            this.add(Merge.this.bundle(new JLabel(".ped file"), this.pedField, this.pedBrowse));
            this.add(Merge.this.bundle(new JLabel(".map file"), this.mapField, this.mapBrowse));
        }

        public void checkValid() {
            this.validInput = this.stdCheck.isSelected() ? this.stdShort.getSelectedItem() != null && !this.stdShort.getSelectedItem().toString().equals("") : !this.pedField.getText().equals("") && !this.mapField.getText().equals("");
            Merge.this.isBodyValid();
        }

        public TextSelectPanel(GPLINK mf) {
            this.stdShort = new JComboBox<String>(Merge.this.input.getStdRoots());
            this.pedField = new JTextField(20);
            this.pedField.getDocument().addDocumentListener(this.textValidDL);
            this.pedField.setEnabled(false);
            this.mapField = new JTextField(20);
            this.mapField.setEnabled(false);
            this.mapField.getDocument().addDocumentListener(this.textValidDL);
            this.pedBrowse = new Form.BrowseButton(this.pedField, ".ped", "PED file");
            this.pedBrowse.setEnabled(false);
            this.mapBrowse = new Form.BrowseButton(this.mapField, ".map", "MAP field");
            this.mapBrowse.setEnabled(false);
            this.stdCheck = new JCheckBox();
            this.stdCheck.setSelected(true);
            this.stdCheck.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    boolean state = TextSelectPanel.this.stdCheck.isSelected();
                    TextSelectPanel.this.stdShort.setEnabled(state);
                    TextSelectPanel.this.pedField.setEnabled(!state);
                    TextSelectPanel.this.mapField.setEnabled(!state);
                    TextSelectPanel.this.pedBrowse.setEnabled(!state);
                    TextSelectPanel.this.mapBrowse.setEnabled(!state);
                    TextSelectPanel.this.checkValid();
                }
            });
            this.createStd();
            this.validInput = this.stdShort.getSelectedItem() != null && !this.stdShort.getSelectedItem().toString().equals("");
        }

        public String getCommand() {
            String ans = "--merge";
            if (this.stdCheck.isSelected()) {
                String root = this.stdShort.getSelectedItem().toString();
                ans = String.valueOf(ans) + " " + FileInfo.quote(String.valueOf(Merge.this.parent.data.getHomeFolder()) + root + ".ped") + " " + FileInfo.quote(String.valueOf(Merge.this.parent.data.getHomeFolder()) + root + ".map");
            } else {
                ans = String.valueOf(ans) + " " + FileInfo.quote(this.pedField.getText()) + " " + FileInfo.quote(this.mapField.getText());
            }
            return ans;
        }
    }

    private class BinSelectPanel
    extends JPanel {
        public boolean validInput = false;
        private float my_alignment = 1.0f;
        private JCheckBox flagShort;
        private JTextField bedField;
        private JTextField bimField;
        private JTextField famField;
        private Form.BrowseButton bedBrowse;
        private Form.BrowseButton bimBrowse;
        private Form.BrowseButton famBrowse;
        private JComboBox binShort;
        private DocumentListener binValidDL = new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
                BinSelectPanel.this.checkValid();
            }

            public void removeUpdate(DocumentEvent e) {
                BinSelectPanel.this.checkValid();
            }
        };

        public void checkValid() {
            this.validInput = this.flagShort.isSelected() ? this.binShort.getSelectedItem() != null && !this.binShort.getSelectedItem().toString().equals("") : !this.bedField.getText().equals("") && !this.bimField.getText().equals("") && !this.famField.getText().equals("");
            Merge.this.isBodyValid();
        }

        private BinSelectPanel(GPLINK mf) {
            this.binShort = new JComboBox<String>(Merge.this.input.getBinRoots());
            this.bedField = new JTextField(20);
            this.bedField.setEnabled(false);
            this.bedField.getDocument().addDocumentListener(this.binValidDL);
            this.bedBrowse = new Form.BrowseButton(this.bedField, ".bed", "BED file");
            this.bedBrowse.setEnabled(false);
            this.bimField = new JTextField(20);
            this.bimField.setEnabled(false);
            this.bimField.getDocument().addDocumentListener(this.binValidDL);
            this.bimBrowse = new Form.BrowseButton(this.bimField, ".bim", "BIM file");
            this.bimBrowse.setEnabled(false);
            this.famField = new JTextField(20);
            this.famField.setEnabled(false);
            this.famField.getDocument().addDocumentListener(this.binValidDL);
            this.famBrowse = new Form.BrowseButton(this.famField, ".fam", "FAM file");
            this.famBrowse.setEnabled(false);
            this.flagShort = new JCheckBox();
            this.flagShort.setSelected(true);
            this.flagShort.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    boolean state = BinSelectPanel.this.flagShort.isSelected();
                    BinSelectPanel.this.binShort.setEnabled(state);
                    BinSelectPanel.this.bedField.setEnabled(!state);
                    BinSelectPanel.this.bedBrowse.setEnabled(!state);
                    BinSelectPanel.this.bimField.setEnabled(!state);
                    BinSelectPanel.this.bimBrowse.setEnabled(!state);
                    BinSelectPanel.this.famField.setEnabled(!state);
                    BinSelectPanel.this.famBrowse.setEnabled(!state);
                    BinSelectPanel.this.checkValid();
                }
            });
            this.createBinary();
            this.validInput = this.binShort.getSelectedItem() != null && !this.binShort.getSelectedItem().toString().equals("");
        }

        private void createBinary() {
            this.setLayout(new BoxLayout(this, 3));
            this.setAlignmentX(this.my_alignment);
            JPanel quick = new JPanel();
            quick.setBorder(new TitledBorder("Quick Fileset"));
            quick.setAlignmentX(this.my_alignment);
            quick.add(this.flagShort);
            quick.add(this.binShort);
            this.add(quick);
            this.add(Merge.this.bundle(new JLabel(".bed file"), this.bedField, this.bedBrowse));
            this.add(Merge.this.bundle(new JLabel(".bim file"), this.bimField, this.bimBrowse));
            this.add(Merge.this.bundle(new JLabel("fam file"), this.famField, this.famBrowse));
        }

        public String getCommand() {
            String ans = " --bmerge";
            if (this.flagShort.isSelected()) {
                String root = this.binShort.getSelectedItem().toString();
                ans = String.valueOf(ans) + " " + FileInfo.quote(String.valueOf(Merge.this.parent.data.getHomeFolder()) + root + ".bed") + " " + FileInfo.quote(String.valueOf(Merge.this.parent.data.getHomeFolder()) + root + ".bim") + " " + FileInfo.quote(String.valueOf(Merge.this.parent.data.getHomeFolder()) + root + ".fam");
            } else {
                ans = String.valueOf(ans) + " " + FileInfo.quote(this.bedField.getText()) + " " + FileInfo.quote(this.bimField.getText()) + " " + FileInfo.quote(this.famField.getText());
            }
            return ans;
        }
    }

    private class ListSelectPanel
    extends JPanel {
        public boolean validInput = false;
        private Form.BrowseButton listBrowse;
        private JTextField listField = new JTextField(20);

        public void checkValid() {
            this.validInput = !this.listField.getText().equals("");
            Merge.this.isBodyValid();
        }

        private JPanel createPanel() {
            JPanel ans = new JPanel();
            ans.add(new JLabel("--merge-list "));
            ans.add(this.listField);
            ans.add(this.listBrowse);
            return ans;
        }

        private ListSelectPanel(GPLINK mf) {
            this.listField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                }

                public void insertUpdate(DocumentEvent e) {
                    ListSelectPanel.this.checkValid();
                }

                public void removeUpdate(DocumentEvent e) {
                    ListSelectPanel.this.checkValid();
                }
            });
            this.listBrowse = new Form.BrowseButton(this.listField, ".txt", "TEXT files");
            this.add(this.createPanel());
        }

        public String getCommand() {
            String ans = "--merge-list " + FileInfo.quote(this.listField.getText());
            return ans;
        }
    }
}

