/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.pane;

import edu.harvard.mgh.purcell.gCLINE.data.OperationInfo;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gCLINE.pane.FolderView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public class FileTransferHandler
extends TransferHandler {
    private Logger logger = Logger.getLogger(FileTransferHandler.class);

    private void importString(JComponent c, String str) {
        String[] files;
        if (!c.getClass().equals(JTree.class)) {
            return;
        }
        JTree target = (JTree)c;
        String opName = null;
        if (target.getSelectionPath().getPathCount() >= 2) {
            String temp1 = target.getSelectionPath().getPath()[1].toString();
            opName = temp1.split(":")[0];
        }
        String fileType = "input";
        if (target.getSelectionPath().getPathCount() >= 2 && target.getSelectionPath().getPath()[2].toString().equals(OperationInfo.OUTPUT_LABEL)) {
            fileType = "output";
        }
        if (opName == null) {
            return;
        }
        String[] stringArray = files = str.split("\\n");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String fileStr = stringArray[n];
            String filename = null;
            String disc = null;
            String[] temp = fileStr.split(FolderView.FILE_DISC_SEPERATOR, 2);
            filename = temp[0];
            if (temp.length == 2) {
                disc = temp[1];
            }
            ((Record)target.getModel()).getOp(opName).addFile(fileType, filename, null, disc);
            this.logger.info("[importString(JComponent, String)] " + filename + " is added to " + opName);
            ++n;
        }
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int i = 0;
        while (i < flavors.length) {
            if (DataFlavor.stringFlavor.equals(flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.importString(c, str);
                return true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

