/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gCLINE.data;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gCLINE.data.KeyWords;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationInfo
extends DefaultMutableTreeNode
implements KeyWords {
    public static String INPUT_LABEL = "Input files";
    public static String OUTPUT_LABEL = "Output files";
    private String name;
    private String discription;
    private String cline;
    private DefaultMutableTreeNode input;
    private DefaultMutableTreeNode output;
    private String timestamp;
    public static DateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MMM-dd HH:mm");
    private DefaultTreeModel parentTree;

    public String getName() {
        return this.name;
    }

    public String getDisc() {
        return this.discription;
    }

    public String getCline() {
        return this.cline;
    }

    public Vector<FileInfo> getInputFiles() {
        Vector<FileInfo> ans = new Vector<FileInfo>();
        if (this.input.isLeaf()) {
            return ans;
        }
        FileInfo f = (FileInfo)this.input.getFirstChild();
        while (f != null) {
            ans.add(f);
            f = (FileInfo)f.getNextSibling();
        }
        return ans;
    }

    public Vector<FileInfo> getOutputFiles() {
        Vector<FileInfo> ans = new Vector<FileInfo>();
        if (this.output.isLeaf()) {
            return ans;
        }
        FileInfo f = (FileInfo)this.output.getFirstChild();
        while (f != null) {
            ans.add(f);
            f = (FileInfo)f.getNextSibling();
        }
        return ans;
    }

    public File getLog(File localFolder, String suffix) {
        Vector<FileInfo> allOutput = this.getOutputFiles();
        for (FileInfo f : allOutput) {
            if (!f.toString().endsWith(suffix)) continue;
            return new File(localFolder, f.toString());
        }
        return null;
    }

    static File getLog(File localFolder, String suffix, Vector<String[]> outfiles) {
        for (String[] f : outfiles) {
            if (!f[0].endsWith(suffix)) continue;
            return new File(localFolder, f.toString());
        }
        return null;
    }

    public String getTimeStamp() {
        return this.timestamp;
    }

    public void removeFile(String filename) {
        FileInfo f = (FileInfo)this.input.getFirstChild();
        while (f != null) {
            if (filename.equals(f.toString())) {
                f.removeFromParent();
                if (this.parentTree != null) {
                    this.parentTree.nodeStructureChanged(this.input);
                }
            }
            f = (FileInfo)f.getNextSibling();
        }
        f = (FileInfo)this.output.getFirstChild();
        while (f != null) {
            if (filename.equals(f.toString())) {
                f.removeFromParent();
                if (this.parentTree != null) {
                    this.parentTree.nodeStructureChanged(this.output);
                }
            }
            f = (FileInfo)f.getNextSibling();
        }
    }

    public void addFile(String type, String given_name, String localDisc, String globalDisc) {
        if (globalDisc == null) {
            globalDisc = "";
        }
        if (localDisc == null) {
            localDisc = "";
        }
        if (given_name == null) {
            return;
        }
        if (type.equals("input")) {
            this.addFileToFolder(this.input, new FileInfo(given_name, localDisc, globalDisc));
        }
        if (type.equals("output")) {
            this.addFileToFolder(this.output, new FileInfo(given_name, localDisc, globalDisc));
        }
    }

    private void addFileToFolder(DefaultMutableTreeNode folder, FileInfo givenFile) {
        if (!folder.isLeaf()) {
            FileInfo index = (FileInfo)folder.getFirstChild();
            while (index != null) {
                if (index.toString().equals(givenFile.toString())) {
                    index.removeFromParent();
                }
                index = (FileInfo)index.getNextSibling();
            }
        }
        folder.add(givenFile);
        if (this.parentTree != null) {
            this.parentTree.nodeStructureChanged(folder);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.name) + ": (" + this.timestamp + ") " + this.discription;
    }

    public Vector<String> getOpDetails() {
        Vector<String> ans = new Vector<String>();
        ans.add(this.cline);
        return ans;
    }

    public String printfull() {
        String ans = String.valueOf(this.toString()) + " \n";
        Vector<String> details = this.getOpDetails();
        for (String d : details) {
            ans = String.valueOf(ans) + d + " \n";
        }
        ans = String.valueOf(ans) + "Input Files:\n";
        FileInfo fileIndex = (FileInfo)this.input.getFirstChild();
        while (fileIndex != null) {
            ans = String.valueOf(ans) + fileIndex.toString() + "\n";
            fileIndex = (FileInfo)fileIndex.getNextSibling();
        }
        ans = String.valueOf(ans) + "Output Files:\n";
        fileIndex = (FileInfo)this.output.getFirstChild();
        while (fileIndex != null) {
            ans = String.valueOf(ans) + fileIndex.toString() + "\n";
            fileIndex = (FileInfo)fileIndex.getNextSibling();
        }
        return ans;
    }

    public Element asElement(Document d) {
        FileInfo fileIndex;
        Element op = d.createElement("operation");
        op.setAttribute("name", this.name);
        op.setAttribute("cline", this.cline);
        op.setAttribute("time", this.timestamp);
        op.appendChild(d.createTextNode(this.discription));
        Element ins = d.createElement("input");
        Element outs = d.createElement("output");
        if (!this.input.isLeaf()) {
            fileIndex = (FileInfo)this.input.getFirstChild();
            while (fileIndex != null) {
                ins.appendChild(fileIndex.asElement(d));
                fileIndex = (FileInfo)fileIndex.getNextSibling();
            }
        }
        if (!this.output.isLeaf()) {
            fileIndex = (FileInfo)this.output.getFirstChild();
            while (fileIndex != null) {
                outs.appendChild(fileIndex.asElement(d));
                fileIndex = (FileInfo)fileIndex.getNextSibling();
            }
        }
        op.appendChild(ins);
        op.appendChild(outs);
        return op;
    }

    public OperationInfo(DefaultTreeModel parentTree) {
        this("", "", "", null, parentTree);
    }

    public OperationInfo(String givenName, String givenDisc, String command, String time, DefaultTreeModel givenParentTree) {
        super(givenParentTree, true);
        this.parentTree = givenParentTree;
        this.name = givenName;
        this.discription = givenDisc;
        this.cline = command;
        this.add(new DefaultMutableTreeNode(this.cline));
        this.input = new DefaultMutableTreeNode(INPUT_LABEL);
        this.add(this.input);
        this.output = new DefaultMutableTreeNode(OUTPUT_LABEL);
        this.add(this.output);
        if (time == null) {
            Date date = new Date();
            this.timestamp = DATEFORMAT.format(date);
        } else {
            this.timestamp = time;
        }
    }
}

