/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.rsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPublicKey
extends SshPublicKey {
    RSAPublicKey pubKey;

    public SshRsaPublicKey(RSAPublicKey key) {
        this.pubKey = key;
    }

    public SshRsaPublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader bar = new ByteArrayReader(encoded);
            String header = bar.readString();
            if (!header.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger e = bar.readBigInteger();
            BigInteger n = bar.readBigInteger();
            RSAPublicKeySpec rsaKey = new RSAPublicKeySpec(n, e);
            try {
                KeyFactory kf = KeyFactory.getInstance("RSA");
                this.pubKey = (RSAPublicKey)kf.generatePublic(rsaKey);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidSshKeyException();
            }
            catch (InvalidKeySpecException ikpe) {
                throw new InvalidSshKeyException();
            }
        }
        catch (IOException ioe) {
            throw new InvalidSshKeyException();
        }
    }

    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    public int getBitLength() {
        return this.pubKey.getModulus().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter baw = new ByteArrayWriter();
            baw.writeString(this.getAlgorithmName());
            baw.writeBigInteger(this.pubKey.getPublicExponent());
            baw.writeBigInteger(this.pubKey.getModulus());
            return baw.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean verifySignature(byte[] signature, byte[] data) throws InvalidSshKeySignatureException {
        try {
            if (signature.length != 128) {
                ByteArrayReader bar = new ByteArrayReader(signature);
                byte[] sig = bar.readBinaryString();
                String header = new String(sig);
                if (!header.equals(this.getAlgorithmName())) {
                    throw new InvalidSshKeySignatureException();
                }
                signature = bar.readBinaryString();
            }
            Signature s = Signature.getInstance("SHA1withRSA");
            s.initVerify(this.pubKey);
            s.update(data);
            return s.verify(signature);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InvalidSshKeySignatureException();
        }
        catch (IOException ioe) {
            throw new InvalidSshKeySignatureException();
        }
        catch (InvalidKeyException ike) {
            throw new InvalidSshKeySignatureException();
        }
        catch (SignatureException se) {
            throw new InvalidSshKeySignatureException();
        }
    }
}

