/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.agent.SshAgentAddKey;
import com.sshtools.j2ssh.agent.SshAgentAlive;
import com.sshtools.j2ssh.agent.SshAgentDeleteAllKeys;
import com.sshtools.j2ssh.agent.SshAgentDeleteKey;
import com.sshtools.j2ssh.agent.SshAgentFailure;
import com.sshtools.j2ssh.agent.SshAgentForwardingNotice;
import com.sshtools.j2ssh.agent.SshAgentKeyList;
import com.sshtools.j2ssh.agent.SshAgentListKeys;
import com.sshtools.j2ssh.agent.SshAgentLock;
import com.sshtools.j2ssh.agent.SshAgentOperationComplete;
import com.sshtools.j2ssh.agent.SshAgentPing;
import com.sshtools.j2ssh.agent.SshAgentPrivateKeyOp;
import com.sshtools.j2ssh.agent.SshAgentRandom;
import com.sshtools.j2ssh.agent.SshAgentRandomData;
import com.sshtools.j2ssh.agent.SshAgentRequestVersion;
import com.sshtools.j2ssh.agent.SshAgentSuccess;
import com.sshtools.j2ssh.agent.SshAgentUnlock;
import com.sshtools.j2ssh.agent.SshAgentVersionResponse;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentClient {
    private static Log log = LogFactory.getLog(SshAgentClient.class);
    public static final String HASH_AND_SIGN = "hash-and-sign";
    InputStream in;
    OutputStream out;
    boolean isForwarded = false;
    HashMap messages = new HashMap();
    Socket socket;

    SshAgentClient(boolean isForwarded, String application, InputStream in, OutputStream out) throws IOException {
        log.info("New SshAgentClient instance created");
        this.in = in;
        this.out = out;
        this.isForwarded = isForwarded;
        this.registerMessages();
        if (isForwarded) {
            this.sendForwardingNotice();
        } else {
            this.sendVersionRequest(application);
        }
    }

    SshAgentClient(boolean isForwarded, String application, Socket socket) throws IOException {
        log.info("New SshAgentClient instance created");
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.isForwarded = isForwarded;
        this.registerMessages();
        if (isForwarded) {
            this.sendForwardingNotice();
        } else {
            this.sendVersionRequest(application);
        }
    }

    public static SshAgentClient connectLocalAgent(String application, String location) throws AgentNotAvailableException, IOException {
        try {
            Socket socket = SshAgentClient.connectAgentSocket(location);
            return new SshAgentClient(false, application, socket);
        }
        catch (IOException ex) {
            throw new AgentNotAvailableException();
        }
    }

    public static Socket connectAgentSocket(String location) throws AgentNotAvailableException, IOException {
        try {
            if (location == null) {
                throw new AgentNotAvailableException();
            }
            int idx = location.indexOf(":");
            if (idx == -1) {
                throw new AgentNotAvailableException();
            }
            String host = location.substring(0, idx);
            int port = Integer.parseInt(location.substring(idx + 1));
            Socket socket = new Socket(host, port);
            return socket;
        }
        catch (IOException ex) {
            throw new AgentNotAvailableException();
        }
    }

    public void close() {
        log.info("Closing agent client");
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void registerMessages() {
        this.messages.put(new Integer(103), SshAgentVersionResponse.class);
        this.messages.put(new Integer(101), SshAgentSuccess.class);
        this.messages.put(new Integer(102), SshAgentFailure.class);
        this.messages.put(new Integer(104), SshAgentKeyList.class);
        this.messages.put(new Integer(106), SshAgentRandomData.class);
        this.messages.put(new Integer(150), SshAgentAlive.class);
        this.messages.put(new Integer(105), SshAgentOperationComplete.class);
    }

    protected void sendVersionRequest(String application) throws IOException {
        SubsystemMessage msg = new SshAgentRequestVersion(application);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentVersionResponse) {
            SshAgentVersionResponse reply = (SshAgentVersionResponse)msg;
            if (reply.getVersion() != 2) {
                throw new IOException("The agent verison is not compatible with verison 2");
            }
        } else {
            throw new IOException("The agent did not respond with the appropriate version");
        }
    }

    public void addKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints constraints) throws IOException {
        SubsystemMessage msg = new SshAgentAddKey(prvkey, pubkey, description, constraints);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (!(msg instanceof SshAgentSuccess)) {
            throw new IOException("The key could not be added");
        }
    }

    public byte[] hashAndSign(SshPublicKey key, byte[] data) throws IOException {
        SubsystemMessage msg = new SshAgentPrivateKeyOp(key, HASH_AND_SIGN, data);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentOperationComplete) {
            return ((SshAgentOperationComplete)msg).getData();
        }
        throw new IOException("The operation failed");
    }

    public Map listKeys() throws IOException {
        SubsystemMessage msg = new SshAgentListKeys();
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentKeyList) {
            return ((SshAgentKeyList)msg).getKeys();
        }
        throw new IOException("The agent responsed with an invalid message");
    }

    public boolean lockAgent(String password) throws IOException {
        SubsystemMessage msg = new SshAgentLock(password);
        this.sendMessage(msg);
        msg = this.readMessage();
        return msg instanceof SshAgentSuccess;
    }

    public boolean unlockAgent(String password) throws IOException {
        SubsystemMessage msg = new SshAgentUnlock(password);
        this.sendMessage(msg);
        msg = this.readMessage();
        return msg instanceof SshAgentSuccess;
    }

    public byte[] getRandomData(int count) throws IOException {
        SubsystemMessage msg = new SshAgentRandom(count);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentRandomData) {
            return ((SshAgentRandomData)msg).getRandomData();
        }
        throw new IOException("Agent failed to provide the request random data");
    }

    public void ping(byte[] padding) throws IOException {
        SubsystemMessage msg = new SshAgentPing(padding);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentAlive) {
            if (!Arrays.equals(padding, ((SshAgentAlive)msg).getPadding())) {
                throw new IOException("Agent failed to reply with expected data");
            }
        } else {
            throw new IOException("Agent failed to provide the request random data");
        }
    }

    public void deleteKey(SshPublicKey key, String description) throws IOException {
        SubsystemMessage msg = new SshAgentDeleteKey(key, description);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (!(msg instanceof SshAgentSuccess)) {
            throw new IOException("The agent failed to delete the key");
        }
    }

    public void deleteAllKeys() throws IOException {
        SubsystemMessage msg = new SshAgentDeleteAllKeys();
        this.sendMessage(msg);
        msg = this.readMessage();
        if (!(msg instanceof SshAgentSuccess)) {
            throw new IOException("The agent failed to delete all keys");
        }
    }

    protected void sendForwardingNotice() throws IOException {
        InetAddress addr = InetAddress.getLocalHost();
        SshAgentForwardingNotice msg = new SshAgentForwardingNotice(addr.getHostName(), addr.getHostAddress(), 22);
        this.sendMessage(msg);
    }

    protected void sendMessage(SubsystemMessage msg) throws IOException {
        log.info("Sending message " + msg.getMessageName());
        byte[] msgdata = msg.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(msgdata.length));
        this.out.write(msgdata);
        this.out.flush();
    }

    protected SubsystemMessage readMessage() throws InvalidMessageException {
        try {
            byte[] lendata = new byte[4];
            int len = 0;
            while (len < 3) {
                len += this.in.read(lendata, len, lendata.length - len);
            }
            len = (int)ByteArrayReader.readInt(lendata, 0);
            byte[] msgdata = new byte[len];
            len = 0;
            while (len < msgdata.length) {
                len += this.in.read(msgdata, len, msgdata.length - len);
            }
            Integer id = new Integer(msgdata[0] & 0xFF);
            if (this.messages.containsKey(id)) {
                Class cls = (Class)this.messages.get(id);
                SubsystemMessage msg = (SubsystemMessage)cls.newInstance();
                msg.fromByteArray(msgdata);
                log.info("Received message " + msg.getMessageName());
                return msg;
            }
            throw new InvalidMessageException("Unrecognised message id " + id.toString());
        }
        catch (Exception ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }
}

