/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.GlobalOptionsTab;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.Tabber;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OptionsPanel
extends JPanel {
    protected Log log = LogFactory.getLog(OptionsPanel.class);
    private Tabber tabber = new Tabber();
    private boolean cancelled;

    public OptionsPanel(OptionsTab[] optionalTabs) {
        if (optionalTabs != null) {
            int i = 0;
            while (i < optionalTabs.length) {
                optionalTabs[i].reset();
                this.addTab(optionalTabs[i]);
                ++i;
            }
        }
        this.addTab(new GlobalOptionsTab());
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabber);
    }

    public boolean validateTabs() {
        return this.tabber.validateTabs();
    }

    public void applyTabs() {
        this.tabber.applyTabs();
    }

    public void addTab(OptionsTab tab) {
        this.tabber.addTab(tab);
    }

    public void reset() {
        int i = 0;
        while (i < this.tabber.getTabCount()) {
            ((OptionsTab)this.tabber.getTabAt(i)).reset();
            ++i;
        }
    }

    public static boolean showOptionsDialog(Component parent, OptionsTab[] optionalTabs) {
        OptionsPanel opts = new OptionsPanel(optionalTabs);
        opts.reset();
        JDialog d = null;
        Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, parent);
        d = w instanceof JDialog ? new JDialog((JDialog)w, "Options", true) : (w instanceof JFrame ? new JDialog((JFrame)w, "Options", true) : new JDialog(null, "Options", true));
        final JDialog dialog = d;
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic('c');
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OptionsPanel.this.cancelled = true;
                dialog.setVisible(false);
            }
        });
        JButton ok = new JButton("Ok");
        ok.setMnemonic('o');
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (OptionsPanel.this.validateTabs()) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.getRootPane().setDefaultButton(ok);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 6, 0, 0);
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(buttonPanel, ok, gbc, -1);
        UIUtil.jGridBagAdd(buttonPanel, cancel, gbc, 0);
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.add(buttonPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)opts, "Center");
        mainPanel.add((Component)southPanel, "South");
        dialog.getContentPane().setLayout(new GridLayout(1, 1));
        dialog.getContentPane().add(mainPanel);
        dialog.pack();
        dialog.setResizable(true);
        UIUtil.positionComponent(0, dialog);
        dialog.setVisible(true);
        if (!opts.cancelled) {
            opts.applyTabs();
        }
        return !opts.cancelled;
    }
}

