/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeys;
import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;

public class SSH2AuthorizedKeysFormat
implements AuthorizedKeysFormat {
    private static final String header = "# Open3SP auto-generated authorization file\n";
    private static final String key = "key ";

    public byte[] format(AuthorizedKeys keys) throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException("SSH2 authorized keys format requries seperate key files!");
    }

    public AuthorizedKeys unformat(byte[] formatted) throws IOException, InvalidSshKeyException {
        throw new UnsupportedOperationException("SSH2 authorized keys format requries seperate key files!");
    }

    public byte[] format(AuthorizedKeys keys, AuthorizedKeysFileSaver saver) throws IOException, InvalidSshKeyException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(header.getBytes("US-ASCII"));
        SECSHPublicKeyFormat secsh = new SECSHPublicKeyFormat();
        Iterator it = keys.getAuthorizedKeys().entrySet().iterator();
        while (it != null && it.hasNext()) {
            Map.Entry entry = it.next();
            String username = (String)entry.getValue();
            String filename = String.valueOf(username) + ".pub";
            secsh.setComment(username);
            SshPublicKeyFile pubfile = SshPublicKeyFile.create((SshPublicKey)entry.getKey(), secsh);
            saver.saveFile(filename, pubfile.toString().getBytes("US-ASCII"));
            out.write(key.getBytes("US-ASCII"));
            out.write(filename.getBytes("US-ASCII"));
            out.write(10);
        }
        return out.toByteArray();
    }

    public AuthorizedKeys unformat(byte[] formatted, AuthorizedKeysFileLoader loader) throws IOException, InvalidSshKeyException {
        String line;
        AuthorizedKeys keys = new AuthorizedKeys();
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(formatted)));
        while ((line = reader.readLine()) != null) {
            if (!line.trim().startsWith("key")) continue;
            String filename = line.substring(line.trim().lastIndexOf(" ") + 1).trim();
            SshPublicKeyFile pubfile = SshPublicKeyFile.parse(loader.loadFile(filename));
            String username = filename.substring(0, filename.length() - 4);
            keys.addKey(username, pubfile.toPublicKey());
        }
        return keys;
    }

    public boolean requiresKeyFiles() {
        return true;
    }
}

