(* The listbox widget *)
open Tk
open Widget
open Textvariable
val create : widget -> options list -> widget 
             (* [create p options] creates a new widget with parent p.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val create_named : widget -> string -> options list -> widget 
             (* [create p name options] creates a new widget with
                parent p and new patch component name.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val activate : widget -> index -> unit 
(* tk invocation: <widget> activate <index> *)

val bbox : widget -> index -> int * int * int * int 
(* tk invocation: <widget> bbox <index> *)

val configure : widget -> options list -> unit 
(* tk invocation: <widget> configure <options list> *)

val configure_get : widget -> string 
(* tk invocation: <widget> configure *)

val curselection : widget -> index list 
(* tk invocation: <widget> curselection *)

val delete : widget -> index -> index -> unit 
(* tk invocation: <widget> delete <index> <index> *)

val get : widget -> index -> string 
(* tk invocation: <widget> get <index> *)

val get_range : widget -> index -> index -> string list 
(* tk invocation: <widget> get <index> <index> *)

val index : widget -> index -> int 
(* tk invocation: <widget> index <index> *)

val insert : widget -> index -> string list -> unit 
(* tk invocation: <widget> insert <index> <string list> *)

val nearest : widget -> int -> index 
(* tk invocation: <widget> nearest <int> *)

val scan_dragto : widget -> int -> int -> unit 
(* tk invocation: <widget> scan dragto <int> <int> *)

val scan_mark : widget -> int -> int -> unit 
(* tk invocation: <widget> scan mark <int> <int> *)

val see : widget -> index -> unit 
(* tk invocation: <widget> see <index> *)

val selection_anchor : widget -> index -> unit 
(* tk invocation: <widget> selection anchor <index> *)

val selection_clear : widget -> index -> index -> unit 
(* tk invocation: <widget> selection clear <index> <index> *)

val selection_includes : widget -> index -> bool 
(* tk invocation: <widget> selection includes <index> *)

val selection_set : widget -> index -> index -> unit 
(* tk invocation: <widget> selection set <index> <index> *)

val size : widget -> int 
(* tk invocation: <widget> size *)

val xview : widget -> scrollValue -> unit 
(* tk invocation: <widget> xview <scrollValue> *)

val xview_get : widget -> float * float 
(* tk invocation: <widget> xview *)

val xview_index : widget -> index -> unit 
(* tk invocation: <widget> xview <index> *)

val yview : widget -> scrollValue -> unit 
(* tk invocation: <widget> yview <scrollValue> *)

val yview_get : widget -> float * float 
(* tk invocation: <widget> yview *)

val yview_index : widget -> index -> unit 
(* tk invocation: <widget> yview <index> *)

