(* The imagephoto commands  *)
open Tk
open Widget
open Textvariable
val blank : imagePhoto -> unit 
(* tk invocation: <imagePhoto> blank *)

val configure : imagePhoto -> options list -> unit 
(* tk invocation: <imagePhoto> configure <options list> *)

val configure_get : imagePhoto -> string 
(* tk invocation: <imagePhoto> configure *)

val copy : imagePhoto -> imagePhoto -> photo list -> unit 
(* tk invocation: <imagePhoto> copy <imagePhoto> <photo list> *)

val create : options list -> imagePhoto 
(* tk invocation: image create photo <options list> *)

val delete : imagePhoto -> unit 
(* tk invocation: image delete <imagePhoto> *)

val get : imagePhoto -> int -> int -> int * int * int 
(* tk invocation: <imagePhoto> get <int> <int> *)

val height : imagePhoto -> int 
(* tk invocation: image height <imagePhoto> *)

val read : imagePhoto -> string -> photo list -> unit 
(* tk invocation: <imagePhoto> read <string> <photo list> *)

val redither : imagePhoto -> unit 
(* tk invocation: <imagePhoto> redither *)

val width : imagePhoto -> int 
(* tk invocation: image width <imagePhoto> *)

val write : imagePhoto -> photo list -> unit 
(* tk invocation: <imagePhoto> write <photo list> *)

