(* The wm commands  *)
open Tk
open Widget
open Textvariable
val aspect_get : widget -> int * int * int * int 
(* tk invocation: wm aspect <widget> *)

val aspect_set : widget -> int -> int -> int -> int -> unit 
(* tk invocation: wm aspect <widget> <int> <int> <int> <int> *)

val client_get : widget -> string 
(* tk invocation: wm client <widget> *)

val client_set : widget -> string -> unit 
(* tk invocation: wm client <widget> <string> *)

(* unsafe *)
val colormapwindows_get : widget -> widget list 
(* tk invocation: wm colormapwindows <widget> *)
(* /unsafe *)

val colormapwindows_set : widget -> widget list -> unit 
(* tk invocation: wm colormapwindows <widget> {<widget list>} *)

val command_clear : widget -> unit 
(* tk invocation: wm command <widget>  *)

val command_get : widget -> string list 
(* tk invocation: wm command <widget> *)

val command_set : widget -> string list -> unit 
(* tk invocation: wm command <widget> {<string list>} *)

val deiconify : widget -> unit 
(* tk invocation: wm deiconify <widget> *)

val focusmodel_get : widget -> focusModel 
(* tk invocation: wm focusmodel <widget> *)

val focusmodel_set : widget -> focusModel -> unit 
(* tk invocation: wm focusmodel <widget> <focusModel> *)

val frame : widget -> string 
(* tk invocation: wm frame <widget> *)

val geometry_get : widget -> string 
(* tk invocation: wm geometry <widget> *)

val geometry_set : widget -> string -> unit 
(* tk invocation: wm geometry <widget> <string> *)

val grid_clear : widget -> unit 
(* tk invocation: wm grid <widget>     *)

val grid_get : widget -> int * int * int * int 
(* tk invocation: wm grid <widget> *)

val grid_set : widget -> int -> int -> int -> int -> unit 
(* tk invocation: wm grid <widget> <int> <int> <int> <int> *)

val group_clear : widget -> unit 
(* tk invocation: wm group <widget>  *)

(* unsafe *)
val group_get : widget -> widget 
(* tk invocation: wm group <widget> *)
(* /unsafe *)

val group_set : widget -> widget -> unit 
(* tk invocation: wm group <widget> <widget> *)

val iconbitmap_clear : widget -> unit 
(* tk invocation: wm iconbitmap <widget>  *)

val iconbitmap_get : widget -> bitmap 
(* tk invocation: wm iconbitmap <widget> *)

val iconbitmap_set : widget -> bitmap -> unit 
(* tk invocation: wm iconbitmap <widget> <bitmap> *)

val iconify : widget -> unit 
(* tk invocation: wm iconify <widget> *)

val iconmask_clear : widget -> unit 
(* tk invocation: wm iconmask <widget>  *)

val iconmask_get : widget -> bitmap 
(* tk invocation: wm iconmask <widget> *)

val iconmask_set : widget -> bitmap -> unit 
(* tk invocation: wm iconmask <widget> <bitmap> *)

val iconname_get : widget -> string 
(* tk invocation: wm iconname <widget> *)

val iconname_set : widget -> string -> unit 
(* tk invocation: wm iconname <widget> <string> *)

val iconposition_clear : widget -> unit 
(* tk invocation: wm iconposition <widget>   *)

val iconposition_get : widget -> int * int 
(* tk invocation: wm iconposition <widget> *)

val iconposition_set : widget -> int -> int -> unit 
(* tk invocation: wm iconposition <widget> <int> <int> *)

val iconwindow_clear : widget -> unit 
(* tk invocation: wm iconwindow <widget>  *)

(* unsafe *)
val iconwindow_get : widget -> widget 
(* tk invocation: wm iconwindow <widget> *)
(* /unsafe *)

val iconwindow_set : widget -> widget -> unit 
(* tk invocation: wm iconwindow <widget> <widget> *)

val maxsize_get : widget -> int * int 
(* tk invocation: wm maxsize <widget> *)

val maxsize_set : widget -> int -> int -> unit 
(* tk invocation: wm maxsize <widget> <int> <int> *)

val minsize_get : widget -> int * int 
(* tk invocation: wm minsize <widget> *)

val minsize_set : widget -> int -> int -> unit 
(* tk invocation: wm minsize <widget> <int> <int> *)

val overrideredirect_get : widget -> bool 
(* tk invocation: wm overrideredirect <widget> *)

val overrideredirect_set : widget -> bool -> unit 
(* tk invocation: wm overrideredirect <widget> <bool> *)

val positionfrom_clear : widget -> unit 
(* tk invocation: wm positionfrom <widget>  *)

val positionfrom_get : widget -> wmFrom 
(* tk invocation: wm positionfrom <widget> *)

val positionfrom_set : widget -> wmFrom -> unit 
(* tk invocation: wm positionfrom <widget> <wmFrom> *)

val protocol_clear : widget -> string -> unit 
(* tk invocation: wm protocol <widget> <string>  *)

val protocol_set : widget -> string -> (unit -> unit) -> unit 
(* tk invocation: wm protocol <widget> <string> <(unit -> unit)> *)

val protocols : widget -> string list 
(* tk invocation: wm protocol <widget> *)

val resizable_get : widget -> bool * bool 
(* tk invocation: wm resizable <widget> *)

val resizable_set : widget -> bool -> bool -> unit 
(* tk invocation: wm resizable <widget> <bool> <bool> *)

val sizefrom_clear : widget -> unit 
(* tk invocation: wm sizefrom <widget>  *)

val sizefrom_get : widget -> wmFrom 
(* tk invocation: wm sizefrom <widget> *)

val sizefrom_set : widget -> wmFrom -> unit 
(* tk invocation: wm sizefrom <widget> <wmFrom> *)

val state : widget -> string 
(* tk invocation: wm state <widget> *)

val title_get : widget -> string 
(* tk invocation: wm title <widget> *)

val title_set : widget -> string -> unit 
(* tk invocation: wm title <widget> <string> *)

val transient_clear : widget -> unit 
(* tk invocation: wm transient <widget>  *)

(* unsafe *)
val transient_get : widget -> widget 
(* tk invocation: wm transient <widget> *)
(* /unsafe *)

val transient_set : widget -> widget -> unit 
(* tk invocation: wm transient <widget> <widget> *)

val withdraw : widget -> unit 
(* tk invocation: wm withdraw <widget> *)

