(* The text widget *)
open Tk
open Widget
open Textvariable
val create : widget -> options list -> widget 
             (* [create p options] creates a new widget with parent p.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val create_named : widget -> string -> options list -> widget 
             (* [create p name options] creates a new widget with
                parent p and new patch component name.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val bbox : widget -> textIndex -> int * int * int * int 
(* tk invocation: <widget> bbox <textIndex> *)

val compare : widget -> textIndex -> comparison -> textIndex -> bool 
(* tk invocation: <widget> compare <textIndex> <comparison> <textIndex> *)

val configure : widget -> options list -> unit 
(* tk invocation: <widget> configure <options list> *)

val configure_get : widget -> string 
(* tk invocation: <widget> configure *)

val debug : widget -> bool -> unit 
(* tk invocation: <widget> debug <bool> *)

val delete : widget -> textIndex -> textIndex -> unit 
(* tk invocation: <widget> delete <textIndex> <textIndex> *)

val delete_char : widget -> textIndex -> unit 
(* tk invocation: <widget> delete <textIndex> *)

val dlineinfo : widget -> textIndex -> int * int * int * int * int 
(* tk invocation: <widget> dlineinfo <textIndex> *)

val get : widget -> textIndex -> textIndex -> string 
(* tk invocation: <widget> get <textIndex> <textIndex> *)

val get_char : widget -> textIndex -> string 
(* tk invocation: <widget> get <textIndex> *)

val index : widget -> textIndex -> index 
(* tk invocation: <widget> index <textIndex> *)

val insert : widget -> textIndex -> string -> textTag list -> unit 
(* tk invocation: <widget> insert <textIndex> <string> {<textTag list>} *)

val mark_gravity_get : widget -> textMark -> markDirection 
(* tk invocation: <widget> mark gravity <textMark> *)

val mark_gravity_set : widget -> textMark -> markDirection -> unit 
(* tk invocation: <widget> mark gravity <textMark> <markDirection> *)

val mark_names : widget -> textMark list 
(* tk invocation: <widget> mark names *)

val mark_set : widget -> textMark -> textIndex -> unit 
(* tk invocation: <widget> mark set <textMark> <textIndex> *)

val mark_unset : widget -> textMark list -> unit 
(* tk invocation: <widget> mark unset <textMark list> *)

val scan_dragto : widget -> int -> int -> unit 
(* tk invocation: <widget> scan dragto <int> <int> *)

val scan_mark : widget -> int -> int -> unit 
(* tk invocation: <widget> scan mark <int> <int> *)

val search : widget -> textSearch list -> string -> textIndex -> textIndex -> index 
(* tk invocation: <widget> search <textSearch list> -- <string> <textIndex> <textIndex> *)

val see : widget -> textIndex -> unit 
(* tk invocation: <widget> see <textIndex> *)

val tag_add : widget -> textTag -> textIndex -> textIndex -> unit 
(* tk invocation: <widget> tag add <textTag> <textIndex> <textIndex> *)

val tag_add_char : widget -> textTag -> textIndex -> unit 
(* tk invocation: <widget> tag add <textTag> <textIndex> *)

val tag_allnames : widget -> textTag list 
(* tk invocation: <widget> tag names *)

val tag_configure : widget -> textTag -> options list -> unit 
(* tk invocation: <widget> tag configure <textTag> <options list> *)

val tag_delete : widget -> textTag list -> unit 
(* tk invocation: <widget> tag delete <textTag list> *)

val tag_indexnames : widget -> textIndex -> textTag list 
(* tk invocation: <widget> tag names <textIndex> *)

val tag_lower_below : widget -> textTag -> textTag -> unit 
(* tk invocation: <widget> tag lower <textTag> <textTag> *)

val tag_lower_bot : widget -> textTag -> unit 
(* tk invocation: <widget> tag lower <textTag> *)

val tag_nextrange : widget -> textTag -> textIndex -> textIndex -> index * index 
(* tk invocation: <widget> tag nextrange <textTag> <textIndex> <textIndex> *)

val tag_raise_above : widget -> textTag -> textTag -> unit 
(* tk invocation: <widget> tag raise <textTag> <textTag> *)

val tag_raise_top : widget -> textTag -> unit 
(* tk invocation: <widget> tag raise <textTag> *)

val tag_ranges : widget -> textTag -> index list 
(* tk invocation: <widget> tag ranges <textTag> *)

val tag_remove : widget -> textTag -> textIndex -> textIndex -> unit 
(* tk invocation: <widget> tag remove <textTag> <textIndex> <textIndex> *)

val tag_remove_char : widget -> textTag -> textIndex -> unit 
(* tk invocation: <widget> tag remove <textTag> <textIndex> *)

val window_configure : widget -> textTag -> options list -> unit 
(* tk invocation: <widget> window configure <textTag> <options list> *)

val window_create : widget -> textIndex -> options list -> unit 
(* tk invocation: <widget> window create <textIndex> <options list> *)

val window_names : widget -> widget list 
(* tk invocation: <widget> window names *)

val xview : widget -> scrollValue -> unit 
(* tk invocation: <widget> xview <scrollValue> *)

val xview_get : widget -> float * float 
(* tk invocation: <widget> xview *)

val yview : widget -> scrollValue -> unit 
(* tk invocation: <widget> yview <scrollValue> *)

val yview_get : widget -> float * float 
(* tk invocation: <widget> yview *)

val yview_index : widget -> textIndex -> unit 
(* tk invocation: <widget> yview <textIndex> *)

val yview_index_pickplace : widget -> textIndex -> unit 
(* tk invocation: <widget> yview -pickplace <textIndex> *)

val yview_line : widget -> int -> unit 
(* tk invocation: <widget> yview <int> *)

val tag_bind: widget -> textTag ->
                       (modifier list * xEvent) list -> bindAction -> unit 


