(* The scrollbar widget *)
open Tk
open Widget
open Textvariable
val create : widget -> options list -> widget 
             (* [create p options] creates a new widget with parent p.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val create_named : widget -> string -> options list -> widget 
             (* [create p name options] creates a new widget with
                parent p and new patch component name.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val activate : widget -> widgetElement -> unit 
(* tk invocation: <widget> activate <widgetElement> *)

val activate_get : widget -> widgetElement 
(* tk invocation: <widget> activate *)

val configure : widget -> options list -> unit 
(* tk invocation: <widget> configure <options list> *)

val configure_get : widget -> string 
(* tk invocation: <widget> configure *)

val delta : widget -> int -> int -> float 
(* tk invocation: <widget> delta <int> <int> *)

val fraction : widget -> int -> int -> float 
(* tk invocation: <widget> fraction <int> <int> *)

val get : widget -> float * float 
(* tk invocation: <widget> get *)

val identify : widget -> int -> int -> widgetElement 
(* tk invocation: <widget> identify <int> <int> *)

val old_get : widget -> int * int * int * int 
(* tk invocation: <widget> get *)

val old_set : widget -> int -> int -> int -> int -> unit 
(* tk invocation: <widget> set <int> <int> <int> <int> *)

val set : widget -> float -> float -> unit 
(* tk invocation: <widget> set <float> <float> *)

