(* The menu widget *)
open Tk
open Widget
open Textvariable
val create : widget -> options list -> widget 
             (* [create p options] creates a new widget with parent p.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val create_named : widget -> string -> options list -> widget 
             (* [create p name options] creates a new widget with
                parent p and new patch component name.
                Options are restricted to the widget class subset,
                and checked dynamically. *)
val activate : widget -> index -> unit 
(* tk invocation: <widget> activate <index> *)

val add_cascade : widget -> options list -> unit 
(* tk invocation: <widget> add cascade <options list> *)

val add_checkbutton : widget -> options list -> unit 
(* tk invocation: <widget> add checkbutton <options list> *)

val add_command : widget -> options list -> unit 
(* tk invocation: <widget> add command <options list> *)

val add_radiobutton : widget -> options list -> unit 
(* tk invocation: <widget> add radiobutton <options list> *)

val add_separator : widget -> unit 
(* tk invocation: <widget> add separator *)

val configure : widget -> options list -> unit 
(* tk invocation: <widget> configure <options list> *)

val configure_cascade : widget -> index -> options list -> unit 
(* tk invocation: <widget> entryconfigure <index> <options list> *)

val configure_checkbutton : widget -> index -> options list -> unit 
(* tk invocation: <widget> entryconfigure <index> <options list> *)

val configure_command : widget -> index -> options list -> unit 
(* tk invocation: <widget> entryconfigure <index> <options list> *)

val configure_get : widget -> string 
(* tk invocation: <widget> configure *)

val configure_radiobutton : widget -> index -> options list -> unit 
(* tk invocation: <widget> entryconfigure <index> <options list> *)

val delete : widget -> index -> index -> unit 
(* tk invocation: <widget> delete <index> <index> *)

val entryconfigure_get : widget -> index -> string 
(* tk invocation: <widget> entryconfigure <index> *)

val index : widget -> index -> int 
(* tk invocation: <widget> index <index> *)

val insert_cascade : widget -> index -> options list -> unit 
(* tk invocation: <widget> insert <index> cascade <options list> *)

val insert_checkbutton : widget -> index -> options list -> unit 
(* tk invocation: <widget> insert <index> checkbutton <options list> *)

val insert_command : widget -> index -> options list -> unit 
(* tk invocation: <widget> insert <index> command <options list> *)

val insert_radiobutton : widget -> index -> options list -> unit 
(* tk invocation: <widget> insert <index> radiobutton <options list> *)

val insert_separator : widget -> index -> unit 
(* tk invocation: <widget> insert <index> separator *)

val invoke : widget -> index -> string 
(* tk invocation: <widget> invoke <index> *)

val popup : widget -> int -> int -> unit 
(* tk invocation: tk_popup <widget> <int> <int> *)

val popup_entry : widget -> int -> int -> index -> unit 
(* tk invocation: tk_popup <widget> <int> <int> <index> *)

val post : widget -> int -> int -> unit 
(* tk invocation: <widget> post <int> <int> *)

val postcascade : widget -> index -> unit 
(* tk invocation: <widget> postcascade <index> *)

val typeof : widget -> index -> menuItem 
(* tk invocation: <widget> type <index> *)

val unpost : widget -> unit 
(* tk invocation: <widget> unpost *)

val yposition : widget -> index -> int 
(* tk invocation: <widget> yposition <index> *)

