(* The imagebitmap commands  *)
open Tk
open Widget
open Textvariable
val configure : imageBitmap -> options list -> unit 
(* tk invocation: <imageBitmap> configure <options list> *)

val configure_get : imageBitmap -> string 
(* tk invocation: <imageBitmap> configure *)

val create : options list -> imageBitmap 
(* tk invocation: image create bitmap <options list> *)

val create_named : imageBitmap -> options list -> imageBitmap 
(* tk invocation: image create bitmap <imageBitmap> <options list> *)

val delete : imageBitmap -> unit 
(* tk invocation: image delete <imageBitmap> *)

val height : imageBitmap -> int 
(* tk invocation: image height <imageBitmap> *)

val width : imageBitmap -> int 
(* tk invocation: image width <imageBitmap> *)

