(***** Implantation du graphisme MT pour le frontal CAML
  15/7/95
  Le problme principal est la synchronisation entre le noyau CAML, qui est
  une application DOS, et le frontal qui est une application Windows.
  
  Si CAML tait du Windows natif, on pourrait se servir des possibilits
  de dialogue du systme (DDE). Ici, il faut s'en passer....
  Il est fort difficile de pouvoir changer par l'intermdiaire de la 
  mmoire, il faut donc se rabattre sur le disque et son systme de 
  fichiers
  
  Principe :
  ==========
  un dialogue entre le noyau CAML et le frontal Windows est tabli comme 
  suit :
  
  ROLE DU NOYAU
  Le noyau graphique MT CAML (ce fichier...) va crire, quand on invoque 
  la fonction graph_flush, dans un fichier $MT_GCODE.GML un pseudo-code 
  qui sera interprt par le frontal, en dessinant le graphique dsir. 
  graph_flush n'crit le code sur le disque que s'il existe le fichier 
  $MT_GDONE.GML, qui est effac avant criture du code graphique.
  
  --- remarque : les fonctions individuelles de trac ne declenchent pas 
  d'criture sur le disque, mais sur un port graphique virtuel, implant
  sous la forme d'une chane dynamique CAML. Il est necssaire d'appeler
  graph_flush pour obtenir la moindre sortie graphique !!!
  
  ROLE DU FRONTAL
  Quand la fentre graphique du frontal est ouverte, un scrutation du disque 
  a lieu en permanence (timer). Si un fichier $MT_GCODE.GML
  est trouv, ce fichier est lu en chargeant le code graphique, puis effac,
  en crant un nouveau fichier $MT_GDONE.GML de longueur nulle (ce fichier
  est aussi cr  l'ouverture de la fentre graphique du frontal)
  Cela permet donc une nouvelle intervention du noyau.
  
  EFFICACITE DE L'ENSEMBLE
  Tout a est  peu prs efficace  la condition qu'il existe un cache disque
  performant, vitant autant que faire se peut les lectures effectives du 
  disque. De toutes faons Windows n'est performant que si un tel cache 
  existe (SMARTDRIVE par exemple...)
  *)

(* modifications *)
(* 5/8/95 : graph_floodfill
   ajout la fonction graph_floodfill x y
   qui remplit la surface de couleur uniforme contenant le point x y avec la
   couleur courante de trac *)

(* 18/8/95 : graph_drawtext
   gre maintenant correctement les chanes contenant des guillemets, 
   en les faisant prcder par un backslash avant de les envoyer au frontal.
   *)

(* 13/10/96
   supprim les accents dans les dfinitions (vers d'autres mondes.)
   *)

(* 29/1/97
   dplac les fichier d'change vers la racine du disque dur local.
   Motif : le rpertoire CAMLLIB peut tre en lecture seule (rseau)
   *)


(*****Implantation ********)
(* scrutation de l'existence d'un fichier
  la fonction suivante scrute le disque tant que le fichier f n'est pas
  prsent.
  Quand le fichier existe, il est effac et on sort de la fonction....
  Rle : le fichier scrut sert  assurer la synchronisation entre CAML
  (qui est une application DOS) et le frontal. 
  Pas trs efficace, mais trs simple  comprendre... et  dboguer !!
  *)
exception no_graphic_dialog;;

let GraphicFile_check_and_delete filename = 
  let fini = ref false
  and n = ref 1000
  in
    while not !fini do
      try sys__remove filename; fini := true
        with 
          sys__Sys_error s ->         (* fichier toujours inexistant *)
            n := !n - 1;
            if !n=0 then fini := true
          | err -> raise err
    done;
    if !n=0 then
      (raise no_graphic_dialog "Unsuccessfull dialog with front-end");;

(**** le port de sortie graphique.
  C'est un port virtuel (chane), qui sera interprt par le frontal
  aprs criture dans un fichier.*)
let graph_port = ref "";;

(* les fichiers d'change.
  placs dans la racine du disque local.
  *)
let file_graph_code = "\\$MTGCODE.GML"
and file_graph_temp = "\\~MTGCODE.GML"
and file_graph_done = "\\$MTGDONE.GML";;

(* graph_flush. Cette fonction vide la chane dans le fichier
   C'est la fonction qui assure la synchronisation entre frontal et noyau
   *)
let graph_flush () =
  let graph_channel = ref std_out
  in try
    GraphicFile_check_and_delete file_graph_done;
    graph_channel := (open_out file_graph_temp);
    output_string !graph_channel !graph_port;
    flush !graph_channel;
    close_out !graph_channel;
    graph_port := "";
    graph_channel := std_out;
    sys__rename file_graph_temp file_graph_code
  with
    err ->
      if std_out != !graph_channel then
        begin
          close_out !graph_channel
        end;
      graph_port := "";
      raise err;;

(* la position du curseur graphique
   maintenue uniquement par les fonctions de ce fichier.
   Il n'existe actuellement aucun dialogue du frontal -> CAML, qui
   pourrait permettre de connatre la VRAIE position du curseur... 
   *)
let x_graph_cursor = ref 0.
and y_graph_cursor = ref 0.;;

(* l'affichage lmentaire d'un atome graphique *)
let graph_display a =
  graph_port := !graph_port ^ a;;

(* l'afichage d'une liste d'atomes graphiques *)
let graph_display_each l = 
  do_list 
    (fun x -> graph_display (x ^ " "))
    l;
  (* le test suivant est ncessaire, car si graph_port contient une chane 
     trop longue, de la mmoire n'est pas rcupre par le gc de CAML, ce
     qui provoque assez rapidement des erreurs de dpassement mmoire...
     la limite semble tre de 1024 octets; j'ai choisi 1000 par scurit,
     ce qui laisse 24 octets de marge dans le cas d'affichage de chane
     sur un graphique...
     *)
  if string_length !graph_port > 1000 
  then  graph_flush();;

(**** les routines de base. Autodocumentes *)
let graph_clear () =
  graph_display "cls ";;

let graph_scale xmin xmax ymin ymax = 
  graph_display_each
    ["sc";
     string_of_float xmin;
     string_of_float xmax;
     string_of_float ymin;
     string_of_float ymax];;

let graph_moveto x y = 
  if (!x_graph_cursor, !y_graph_cursor) <> (x, y) then
    begin
      graph_display_each
        ["mt";
         string_of_float x;
         string_of_float y];
      x_graph_cursor := x;
      y_graph_cursor := y;
      ()
    end;;

let graph_plot x y = 
  graph_display_each
    ["pl";
     string_of_float x;
     string_of_float y];;


let graph_lineto x y = 
  if (!x_graph_cursor, !y_graph_cursor) <> (x, y) then
    begin
      graph_display_each
        ["lt";
         string_of_float x;
         string_of_float y];
      x_graph_cursor := x;
      y_graph_cursor := y;
      ()
    end;;

let graph_boxto x y = 
  if (!x_graph_cursor, !y_graph_cursor) <> (x, y) then
    begin
      graph_display_each
        ["bx";
         string_of_float x;
         string_of_float y];
      x_graph_cursor := x;
      y_graph_cursor := y;
      ()
    end;;

let graph_boxfullto x y = 
  if (!x_graph_cursor, !y_graph_cursor) <> (x, y) then
    begin
      graph_display_each
        ["bf";
         string_of_float x;
         string_of_float y];
      x_graph_cursor := x;
      y_graph_cursor := y;
      ()
    end;;

let graph_circle x y r = 
  graph_display_each
    ["ci";
     string_of_float x;
     string_of_float y;
     string_of_float r];
  x_graph_cursor := x;
  y_graph_cursor := y;;

let graph_color r g b = 
  graph_display_each
    ["co";
     string_of_int (abs (r mod 256));
     string_of_int (abs (g mod 256));
     string_of_int (abs (b mod 256))];;

let graph_drawtext text =
  let backslashe_quote s = 
    let rec explore s = function
        [<'`"`; (explore "") r>] -> s ^"\\\"" ^ r
      | [<'c; (explore (s ^ (make_string 1 c))) r>] -> r
      | [<>] -> s
    in
      explore "" (stream_of_string s)
  in
    graph_display_each
      ["dt \"" ^ (backslashe_quote text) ^ "\""];
    graph_moveto !x_graph_cursor !y_graph_cursor;;


let graph_floodfill x y = 
  graph_display_each
    ["ff";
     string_of_float x;
     string_of_float y];;

(* initialisation du graphisme *)
let graph_init () = 
  graph_display "trash";
  graph_flush();
  graph_scale (-2.) 2. (-2.) 2.;
  x_graph_cursor:= 1.; y_graph_cursor:= 1.;
  graph_moveto 0. 0.;
  graph_color 0 0 0;
  graph_flush();;

(* le monde des tortues, en Franais ! *)
let deg_par_radian = 180. /. (4. *. atan 1.);;

(* les commandes reconnues par la tortue de base *)
type ordre_tortue = 
   origine| va_en| avance| recule| 
   tourne_gauche| tourne_droite|
   fixe_cap| leve_crayon| baisse_crayon |
   etat
   ;;

type argument_tortue = 
  a_rien of unit | a_nombre of float | a_coord of float * float;;

type etat_crayon = bas | haut;;

type etat_tortue = 
  {x : float; y : float; cap : float; crayon : etat_crayon};;
  
type resultat_tortue = 
  r_rien of unit | r_etat of etat_tortue;;

(* la gestion des erreurs *)
exception erreur_tortue;;

(* une tortue est une fonction qui, en recevant une commande renvoie une
   fonction charge d'valuer l'argument de la commande.*)
type tortue == ordre_tortue -> argument_tortue -> resultat_tortue;;

(* le crateur de tortue *)
let cree_tortue () =
  let x = ref 0.        (* les variables d'tat de la bte *)
  and y = ref 0.
  and cap = ref 0.
  and crayon = ref bas
  in function        
    etat ->
      (fun (a_rien ()) ->
        r_etat {x = !x; y = !y; cap = !cap; crayon= !crayon}
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | origine ->
      (fun (a_rien ()) -> 
        x:= 0.; y:= 0.; cap:= 0.;
        graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | va_en ->
      (fun (a_coord (xd, yd)) ->
        graph_moveto !x !y;
        x:= xd;
        y:= yd;
        if !crayon = bas then
          graph_lineto !x !y
        else
          graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | avance ->
      (fun (a_nombre longueur) ->
        graph_moveto !x !y;
        x:= !x +. longueur *. cos !cap;
        y:= !y +. longueur *. sin !cap;
        if !crayon = bas then
          graph_lineto !x !y
        else
          graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | recule ->
      (fun (a_nombre longueur) ->
        graph_moveto !x !y;
        x:= !x -. longueur *. cos !cap;
        y:= !y -. longueur *. sin !cap;
        if !crayon = bas then
          graph_lineto !x !y
        else
          graph_moveto !x !y;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | tourne_gauche ->
      (fun (a_nombre angle) ->
        cap:= !cap +. angle;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | tourne_droite ->
      (fun (a_nombre angle) ->
        cap:= !cap -. angle;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | fixe_cap ->
      (fun (a_nombre angle) ->
        cap:= angle;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | leve_crayon ->
      (fun (a_rien ()) ->
        crayon:= haut;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    | baisse_crayon ->
      (fun (a_rien ()) ->
        crayon:= bas;
        r_rien ()
       | _ -> (raise erreur_tortue "Argument incorrect"))
    ;;

(* l'interface "procdurale" commode d'une tortue, avec forage de type *)
let retourne_etat (tortue : tortue) =
  match tortue etat (a_rien ()) with
    r_etat x -> x
    | _ -> (raise erreur_tortue "Argument incorrect");;

let org (tortue:tortue) =
  tortue origine (a_rien ()); ();;

let va (tortue:tortue) x y = 
  tortue va_en (a_coord (x, y)); ();;

let av (tortue:tortue) l = 
  tortue avance (a_nombre l); ();;

let re (tortue:tortue) l = 
  tortue recule (a_nombre l); ();;

let tg (tortue:tortue) a = 
  tortue tourne_gauche (a_nombre a); ();;

let td (tortue:tortue) a = 
  tortue tourne_droite (a_nombre a); ();;

let fc (tortue:tortue) c = 
  tortue fixe_cap (a_nombre c); ();;

let lc (tortue:tortue) =
  tortue leve_crayon (a_rien ()); ();;

let bc (tortue:tortue) =
  tortue baisse_crayon (a_rien ()); ();;
