// FbbListBox.cpp : implementation file
//

#include "stdafx.h"
#include "fbbw.h"
#include "fbbWDlg.h"
#include "FbbListBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFbbListBox

CFbbListBox::CFbbListBox()
{
}

CFbbListBox::~CFbbListBox()
{
}


BEGIN_MESSAGE_MAP(CFbbListBox, CListBox)
	//{{AFX_MSG_MAP(CFbbListBox)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFbbListBox message handlers

void CFbbListBox::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	// TODO: Add your code to draw the specified item
	
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
	
	char szLine[80];
	int res = GetText(lpDrawItemStruct->itemID, szLine);
	if (res == LB_ERR)
		return;
	
	int x1 = lpDrawItemStruct->rcItem.left;
	int y1 = lpDrawItemStruct->rcItem.top;
	int x2 = lpDrawItemStruct->rcItem.right;
	int y2 = lpDrawItemStruct->rcItem.bottom;
	int len = strlen(szLine);
	COLORREF cr;
	
	switch(szLine[2])
	{
	case '>' :
		cr = RGB(0,0, 255);
		break;
	case '<' :
		cr = RGB(255,0,0);
		break;
	default :
		cr = RGB(0,0,0);
		break;
	}
	
	if (lpDrawItemStruct->itemState & ODS_SELECTED)
		pDC->FillSolidRect(x1, y1, x2-x1, y2-y1, RGB(192,192,192));
	else
		pDC->FillSolidRect(x1, y1, x2-x1, y2-y1, GetSysColor(COLOR_WINDOW));
	
	pDC->SetTextColor(cr);
	pDC->SetBkMode(TRANSPARENT);
	
	int nTabStops[] = {16,80,110,145,160,180};
	pDC->TabbedTextOut(x1, y1, szLine+3, len-3, 6, nTabStops, x1);
}


void CFbbListBox::OnLButtonDown(UINT nFlags, CPoint point) 
{
	BOOL bOutside;

	CListBox::OnLButtonDown(nFlags, point);
	UINT nItem = ItemFromPoint(point, bOutside);

	if (bOutside)
	{
		SetCurSel(-1);
		nItem = LB_ERR;
	}

	((CFbbWDlg *)GetParent())->OnListButton(WM_LBUTTONDOWN, nItem, point);
}

void CFbbListBox::OnRButtonDown(UINT nFlags, CPoint point) 
{
	BOOL bOutside;
	
	CListBox::OnRButtonDown(nFlags, point);
	UINT nItem = ItemFromPoint(point, bOutside);

	if (bOutside)
	{
		SetCurSel(-1);
		nItem = LB_ERR;
	}
	else
		SetCurSel(nItem);

	((CFbbWDlg *)GetParent())->OnListButton(WM_RBUTTONDOWN, nItem, point);
}

void CFbbListBox::Line(int nChan, int nStat, char *szTxt)
{
	char line[80];

	int nSel = -1;
	int nSelPos = GetCurSel();

	if ((nSelPos != LB_ERR) && (GetText(nSelPos, line) != LB_ERR))
		nSel = atoi(line);

	int nIndex = 0;

	while (GetText(nIndex, line) != LB_ERR)
	{
		if (atoi(line) == nChan)
		{
			DeleteString(nIndex);
			break;
		}
		++nIndex;
	}

	if (nStat == '!')
	{
		// Remove the selection if disconnected
		if (nSel == nChan)
			nSel = -1;
	}
	else
	{
		sprintf(line, "%02d%c%s", nChan, nStat, szTxt);
		AddString(line);
	}

	if (nSel != -1)
	{
		// Write the selected item
		nIndex = 0;
		while (GetText(nIndex, line) != LB_ERR)
		{
			if (atoi(line) == nSel)
			{
				SetCurSel(nIndex);
				break;
			}
			++nIndex;
		}
	}

}

int CFbbListBox::GetItemInfo(int nPos, int *nChan, char *szCall)
{
	char szLine[80];

	if (GetText(nPos, szLine) == LB_ERR)
		return LB_ERR;

	int nNb = sscanf(szLine+3, "%d %s", nChan, szCall);

	if (nNb != 2)
		return LB_ERR;
	return nPos;
}
