//	GetPass 4.0 - C_FILTER for F6FBB BBS Software

//  Written by Marco Savegnago IW3FQG

#ifndef __GPMD2_H
#define __GPMD2_H

/*

   MD2 C++ Class type prototype

   27/10/1992 Marco Savegnago


   RSA Data Security, Inc., MD2 message-digest algorithm
   Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
   rights reserved.

   License to copy and use this software is granted for
   non-commercial Internet Privacy-Enhanced Mail provided that it is
   identified as the "RSA Data Security, Inc. MD2 Message Digest
   Algorithm" in all material mentioning or referencing this software
   or this function.

   RSA Data Security, Inc. makes no representations concerning either
   the merchantability of this software or the suitability of this
   software for any particular purpose. It is provided "as is"
   without express or implied warranty of any kind.

   These notices must be retained in any copies of any part of this
   documentation and/or software.
*/

class MD2
{
	unsigned int count;                 /* number of bytes, modulo 16 */
	unsigned char state[16];                                 /* state */
	unsigned char checksum[16];                           /* checksum */
	unsigned char buffer[16];                         /* input buffer */
	unsigned char digest[16];                         /* output buffer */
	unsigned char digestString[33];

	void transform(char *block);


public:

	MD2();
	MD2(char *string);
	void init();
	void update(unsigned char *input, unsigned int inputLen );
	void final();
	inline char *getDigest();
	char *getString();
	void setString(char *str);
};

inline MD2::MD2()
{
	init();
}

inline char *MD2::getDigest()
{
	return digest;
}

#endif // __GPMD2_H
