//  GetPass 4.0 - C_FILTER for F6FBB BBS Software

//  Written by Marco Savegnago IW3FQG

#include "gpmsg.h"
#include "gppass.h"
#include "gpapps.h"

#ifdef	__INCL_ACCESS_CTL
#include "gpaccess.h"
#endif

#ifdef __INCL_WARNING
#include "gpwarn.h"
#endif

//#define __DEBUG_HERE
#undef	__DEBUG_HERE

#ifdef	__DEBUG_HERE
#include <fstream.h>
#endif

FilterApp::FilterApp( int na, char **a, ostream&	ostream )
:
	out(ostream)
{

#ifdef __DEBUG_HERE

	ofstream	log("C_FILTER.LOG", ios::out | ios::app);

	static char* cmdLineStr[] =
	{
		"PATH    : ",
		"CALL    : ",
		"LEVEL   : ",
		"FLAG    : ",
		"NEW     : ",
		"USERREC : ",
		"PORT    : ",
		"USERDATA: "
	};

	log	<< endl << "GetPass DEBUGMODE" << endl
			<< "# of Args: " << na << endl << endl;

	for (int i = 0; i < na; i++ )
		log << cmdLineStr[i] << a[i] << endl;

	log << endl;

#else

	if ( na < 6)
	{
		out << endl
			 << "GetPass 4.0 - C_FILTER for F6FBB BBS Software" << endl
			 << endl
			 << "Written by Marco Savegnago IW3FQG " << __DATE__ << endl
			 << endl;


		exit(-1);
	}

#endif

/*******************************************************************

Ad ogni connessione il BBS richiama questo programma passandogli i seguenti
argomenti nella linea di comando:

		  a[0]     a[1]   a[2]  a[3]   a[4]       a[5]    a[6]    a[7]

		C_FILTER CALLSIGN LEVEL FLAG NEW_FLAG USER_RECORD PORT RECEIVED_DATA

C_FILTER     nome del programma se il DOS > 3
CALLSIGN     nominativo di chi si e' collegato.
LEVEL        numero delle volte che il programma e' stato chiamato.
FLAG         USER MASK vedi INIT.SRV
NEW_FLAG     Flag che indica se l'utente e' nuovo
USER_RECORD  User record in user_archive
PORT		 Connection Port
RECEIVE_DATA caratteri ricevuto dall'user.


USER MASK:

	0   : Disable
	1   : Excluded
	2   : Local
	4   : Expert
	8   : Sysop
	16  : BBS
	32  : Pagination
	64  : Guest
 	128 : Modem
 	256 : See-all-messages
 	512 : Unproto list asking is allowed
	1024: List of new messages at logon


*******************************************************************/

	fnsplit( a[ 0 ], curr_drive, curr_dir, curr_name, NULL );
	callsign 	= a[ 1 ];
	level 		= atoi( a[ 2 ] );
	flag 		= atoi( a[ 3 ] );
	new_user 	= atoi( a[ 4 ] );
	port        = atoi( a[ 6 ] );
	userCmd 	= ( na > 7 ) ? a[ 7 ] : NULL;

	set_new_handler( FilterApp::new_failure );
}

FilterApp::run()
{
#ifdef	__DEBUG_HERE
	ofstream	log("C_FILTER.LOG", ios::out | ios::app);
#endif

	char fconfig [ MAXPATH ];

#ifdef	__DLL__
	strcpy(fconfig, "C_FILTER.CNF");
#else
	fnmerge ( fconfig, curr_drive, curr_dir, curr_name, ".CNF" );
#endif

	ConfigFile config ( fconfig, MAX_OPTIONS );

	int ret = config.readFile();

#ifdef	__DEBUG_HERE
	log	<<	"Read config file" << endl;
#endif

	if( ret )
		return( CF_DISC );

	MessageFile message ( config.getStrParam( MESSAGE_FILE ), MAX_MESSAGES );

#ifdef	__DEBUG_HERE
	log	<<	"Read message file" << endl;
#endif

	if ( message.readFile() )
					return( CF_DISC );

#ifdef __INCL_WARNING
	WarningMessage warningMessage( callsign, fconfig, message[WARNING] );
#endif

#ifdef	__INCL_ACCESS_CTL

	int accessType = 2;

	if( config.getBoolParam( ACCESS_CONTROL ) )
	{
		PortAccessControl access(callsign, config.getStrParam( ACCESS_FILE ));

		accessType=access.isValid(port);

		switch(accessType)
		{
			case 0:
				out << message[ INVALID_ACCESS ] << endl << ends;
				return CF_DISC;
			case 3:		// Port don't need the password
				return CF_LOGON;
			default:
				break;
		}
	}

#endif

#ifdef __DEBUG__
	int noPasswordClass = config.getValueParam( NO_PASSWORD_CLASS_MASK );

	if ( flag & noPasswordClass)
#else

	if ( flag & config.getValueParam( NO_PASSWORD_CLASS_MASK ) )
#endif
														return( CF_LOGON );

	if ( ! level && config.getBoolParam( SEND_LOGIN ) )
								out << message[WELCOME] << endl;
#ifdef __DEBUG__
	Boolean  isExcluded = config.getBoolParam( EXCLUDE_EXCLUDED ) ;

	if( ( flag & 1 ) && isExcluded )
#else
	if( ( flag & 1 ) && config.getBoolParam( EXCLUDE_EXCLUDED ) )
#endif
	{
		out << message[EXCLUDED] << endl << ends;
		return CF_DISC;
	}

	if( level > config.getValueParam( RETRY ) )
	{
		out << message[RETRIED_OUT] << endl << ends;
		return CF_DISC;
	}

	if( new_user )
	{
		if( ! config.getBoolParam( ONLY_PASSWORD ) )
		{
			out << message[ NO_PASSWORD_MESSAGE ] << endl << ends;
			return	config.getValueParam(NO_PASSWORD_RETURN_VALUE);
		}

		if ( config.getBoolParam( SEND_INFO ) )
							out << message[ INFO ] << endl << ends;

		return CF_DISC;
	}

	if( config.getBoolParam( STRIP_SSID ) )
	{
		for( register int i = 0; callsign[ i ] && callsign[ i ] != '-'; i++ );
		callsign[ i ] = EOS;
	}

	Boolean userSupportMD2=True, userSupportMatrix=True;

#ifdef	__INCL_ACCESS_CTL

	switch (accessType)
	{
		case 	4: // Port not support MD2
			userSupportMD2 = False;
			break;

		case 	5: // Port not support MATRIX
			userSupportMatrix = False;
			break;

		default:
			break;
	}

#endif

	char option = NOOPTIONS;

	for(int i = 10,j = 1; i <= 14; i++, j *= 2 )
		option |= ( config.getBoolParam( i ) ? j : 0 );

	Password password( callsign, config.getStrParam( PASSWORD_FILE ), option );

	ret = password.readPassword();

	switch( ret )
	{
		case 0: // Password OK
			break;

		case 1: // Password not found
			if( config.getBoolParam( ONLY_PASSWORD ) )
			{
				out << message[ PASSWORD_ERROR ] << endl;

				// If set, send infotext then disconnect.

				if ( config.getBoolParam( SEND_INFO ) )
							out << message[ INFO ] << endl;

				out << ends;

				return CF_DISC;
			}
			else
			{
				out << message[ NO_PASSWORD_MESSAGE ] << endl << ends;

				return	(config.getValueParam(NO_PASSWORD_RETURN_VALUE));
			}
			// break; // dummy

		case 2: // I/O Error
			return ret;

		case 3: // User don't need the password
			return CF_LOGON;

		case 4: // User must be disconected
			out << message[EXCLUDED] << endl << ends;
			return CF_DISC;

		case 5: // User not support MD2
			userSupportMD2 = False;
			break;

		case 6: // User not support MATRIX
			userSupportMatrix = False;
			break;

		default:
#ifdef __DEBUG__
			cerr << "DEBUG: Error from readPassword!" << endl;
#endif
			exit(2);

	}

	Boolean supposeGP=False;

	int passwordType;

	if ( level )
	{
		int ret;
		if( (ret = password.readPrevPassword( level ) ) != 0)
													return ret;

		switch( * userCmd )
		{

//  If a user issue a ? the BBS reply with authentication status.

			case '?':
				out << message[ PASSWORD_KO + password.isRight() ] << endl;
				break;

// If a previous password was right a simply CR log on
// to the sistem, else the BBS will disconnect.

			case EOS:
				if ( password.isRight() )
				{
					out << message[ LOG_ON ] << endl << ends;
#ifdef __INCL_WARNING
					if ( config.getBoolParam( WARNING_MESSAGE ) )
								warningMessage.readWarningMessage();
#endif
					return CF_LOGON;
				}
				else
				{
					out << message[ LOG_OFF ] << endl << ends;
#ifdef __INCL_WARNING

					if ( config.getBoolParam( WARNING_MESSAGE ) )
								warningMessage.makeWarningMessage( level );
#endif
					return CF_DISC;
				}
//				break;  // dummy

// Compare user reply with the previous password case insignificant!
			default:

				// Support for Graphic Packet

				if (!stricmp(userCmd,"SY"))
								supposeGP=True;
				else
					passwordType=password.comparePassword( userCmd );

		}
	}

	if ( ( ret = password.makeNextPassword( level )) != 0 )
											return ret;

	if (passwordType == MD2_TYPE && config.getBoolParam( ONE_MD2 ))
	{
		if (password.isRight())
		{
			out << message[ LOG_ON ] << endl << ends;
			return CF_LOGON;
		}
		else
		{
			out << message[ LOG_OFF ] << endl << ends;
			return CF_DISC;
		}

	}

	if (supposeGP)
		changeSpaceToUnderScore( message [ PASSWORD_REQUEST ] );

	out << message[ PASSWORD_REQUEST ];

	if((userSupportMatrix && config.getBoolParam( _MATRIX_SUPPORT )) || supposeGP)
	{
		for( i=0; i < password.numOfDigit; i++ )
				out << " " <<	password.digit[ i ];
	}

	if ((userSupportMD2 && (option & MD2_SUPPORT)) && ! supposeGP )
								out << "  [" << password.MD2init() << "]" ;

	out << endl << ends;

	return (CF_RELOGIN);
}


void FilterApp::new_failure()
{
#ifdef __DEBUG__
	cerr << "DEBUG: Memory allocation error!" << endl;
#endif
	exit( CF_DISC );
}

