/*
	GetPass 4.0 - C_FILTER for F6FBB BBS Software

FBB software allows filtering on connection. Filtering is not done by the
BBS software but by external programs developed by users.

 When the BBS starts, the C_FILTER does not really need to be there.  But at
the first connect it must exist.  If it does not exist at THAT time, it will
not be checked again.  So if a C_FILTER is added after that, the BBS must be
rebooted for the filter to take effect.

 Connection filter may be interactive and allows to incorporate some features
like dedicated information for predefined callsigns, password filtering,
etc...

 The C_FILTER program must be found by the PATH of MsDos. Its extension can
be COM or EXE, and it must be little and fast as multitasking is stopped
during the activity of this program. If this program is not found, it will
not be called until the BBS is rebooted.

 The C_FILTER may also be created as a DLL.  Both for WinFBB and DosFBB (!!).
The filter must be installed in the path (\FBB\BIN) of Dos.

 When receiving the connection, the C_FILTER program (if found) is called
with some arguments including a level number. This number is incremented each
time the program is called in the same connection session. The first time the
level number will be 0.

 The line arguments given to the C_FILTER program are :

- Callsign (format as F6FBB-8).
- Level number (0 is the first time, up to 99).
- Flags of the user (binary number as user's mask of INIT.SRV).
- New : Flag indicating if the user is unknown in the BBS database.
- Record number of the user in INF.SYS.
- New: one more parameter before the optional text. It indicates the
  port where was connected the user.
- Received data (in one argument).


 The C_FILTER program ends with an exit value. This value is very important
and tells the BBS what to do :

 Return value (for C_FILTER):
 0 : Connection is accepted
 1 : C_FILTER will called again, level is incremented
 2 : Connection is refused, user is disconnected
 3 : Connection is accepted, but in read-only mode
 4 : Connection is accepted, but messages will be hold.
 100 and up
   : C_FILTER will called again, next level is equal to the return value.


	This program was written and maintained by Marco Savegnago IW3FQG

	This is the main thing
*/


#include "gpmsg.h"
#include "gpapps.h"

#pragma codestring "GetPass by IW3FQG"

#ifdef	__DLL__

#define STRICT
#include <windows.h>
#include <strstrea.h>

#undef	__DEBUG_HERE

#ifdef	__DEBUG_HERE
#include <fstream.h>
#endif


/*
 *  C_FILTER example
 *
 *  svc_main is the only exported function. It must exist as WFBB will
 *  look for it. All filters are in the same format. If not NULL,
 *  r_buf allow to give a direct text back to the BBS
 * The size of the buffer is given by the parameter len.
 *
 *  Answers may also go to stdout (slower...).
 *
 *  This code is only an example and was not fully tested. It could
 *  give problems as I am not an expert !
 *
 * The used compiler is a Borland C++ 4.5
 *
 *  The DLL is not linked with the code, but checked and loaded when
 *  needed by WFBB.
 *
 * This is an example of the C_FILTER.DEF file :
 *
 *  LIBRARY        C_FILTER
 *  DESCRIPTION    'C_FILTER DLL for FBB'
 *  EXETYPE        WINDOWS
 *  CODE           PRELOAD MOVEABLE DISCARDABLE
 *  DATA           PRELOAD MOVEABLE SINGLE
 *  HEAPSIZE       1024
 *
 *
 * Parameters are (for C_FILTER):
 * ac[0] : The name of the filter (C_FILTER)
 * ac[1] : The callsign and SSID
 * ac[2] : Level number (from 0)
 * ac[3] : Flags
 * ac[4] : Boolean for new user
 * ac[5] : Recordnumber in INF.SYS
 * ac[6] : Port number
 * ac[7] : Optionnal Command received
 * r_buf : The buffer to put an answer
 * len   : The size of the answer buffer
 *
 * Return value (for C_FILTER):
 * 0 : Connection is accepted
 * 1 : C_FILTER will called again, level is incremented
 * 2 : Connection is refused, user is disconnected
 * 3 : Connection is accepted, but in read-only mode
 * 4 : Connection is accepted, but messages will be hold.
 * 100 and up
 *   : C_FILTER will called again, next level is equal to the return value.
 *
 */


extern "C" int	_export FAR PASCAL	svc_main(int na, char FAR** a, char FAR* r_buf, int len)
{
#ifdef	__DEBUG_HERE

	ofstream	log("C_FILTER.LOG");

	log	<<	"a[0] = " << a[0] << endl;
	log	<<	"a[1] = " << a[1] << endl;
	log	<<	"a[2] = " << a[2] << endl;
	log	<<	"a[3] = " << a[3] << endl;
	log	<<	"a[4] = " << a[4] << endl;
	log	<<	"a[5] = " << a[5] << endl;
	log	<<	"a[6] = " << a[6] << endl;
	log	<<	"a[7] = " << a[7] << endl;

	log	<<	"len = " << len   << endl;

	return 0;

#endif	//	__DEBUG_HERE

	memset(r_buf, '\0', len);

	ostrstream	bout(r_buf, len);

	FilterApp	C_FILTER(na,a,bout);

	return		C_FILTER.run();
}

#else
int main(int na, char **a)
{

#if 0

	FilterApp C_FILTER (na,a,cout);  // Instance of C_FILTER Application

	int ret = C_FILTER.run();	// Run it and then ..

	return ret;		    		// return to the caller !

#else

	return FilterApp(na,a, cout).run();

#endif

}
#endif