/*
Copyright (C) 1997-1998 Erwin Waterlander, Ondrej Popp
This code is generated with Ondrej Popp's C3PO.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "std_macro.h"
#include "structures.h"
#include "error.h"
#include "text.h"
#include "nameset.h"

libfun(char *malloc();)
libfun(char *realloc();)
libmacro( operator  sizeof())

expfun nameset namesetNew(void)
{
   nameset n = (nameset) malloc (sizeof(nameset_struct));
   if (n != NULL)
   {
      n->array = NULL;
      n->size = 0;
   }
   else
      malloc_error("namesetNew()");

   return n;
}
expfun nameset copyNameset(nameset src, bool Deep)
{
   nameset n;

   if (src == NULL)
      return NULL;
   else
   {
      n = (nameset) malloc (sizeof(nameset_struct));
      if (n != NULL)
      {
         n->array = NULL;
         n->size = 0;

         if (Deep == true)
            deepExtendTextNameset(src, n);
         else
            extendTextNameset(src, n);
      }
      else
         malloc_error("copyNameset()");

      return n;
   }
}
expfun void addTexttoNameset(text t, nameset set)
{
   if (set->array eq NULL)
      set->array = (text*) malloc(sizeof(text));
   else
      set->array = (text*) realloc((void *) set->array, sizeof(text) * (set->size + 1));

   if (set->array != NULL)
   {
      set->array[set->size] = t;
      set->size = set->size + 1;
   }
   else
      malloc_error("addTexttoNameset()");
}
expfun void removeTextelementAtNameset(int position, nameset set, bool FreeAtPos)
{
   int index;
   if ((position >= 0) and (position < set->size))
   {
      if (FreeAtPos eq true)
      {
         if (set->array[position] ne NULL)
            free((void *) set->array[position]);
      }

      index = position + 1;
      while(index < set->size)
      {
         putTextelementAtNameset(set->array[index], index - 1, set);
         index = index + 1;
      }
      set->size = set->size - 1;
      if (set->size > 0)
         set->array = (text*) realloc((void *) set->array, sizeof(text) * (set->size));
      else
      {
         free((void *) set->array);
         set->array = NULL;
      }
   }
}
expfun void putTextelementAtNameset(text t, int position, nameset set)
{
   int index;
   if (position >= set->size)
   {
      if ((set->array eq NULL) or (set->size eq 0))
         set->array = (text*) malloc(sizeof(text) * (position + 1));
      else
         set->array = (text*) realloc((void *) set->array, sizeof(text) * (position + 1));

      if (set->array != NULL)
      {
         index = set->size;
         while(index < position)
         {
            set->array[index] = NULL;
            index = index + 1;
         }
         set->size = position + 1;
      }
      else
         malloc_error("putTextelementAtNameset()");
   }
   set->array[position] = t;
}
expfun void insertTextelementAtNameset(text t, int position, nameset set)
{
   int index = set->size;
   while(index > position)
   {
      putTextelementAtNameset(set->array[index-1], index, set);
      index = index - 1;
   }
   putTextelementAtNameset(t, position, set);
}
expfun void extendTextNameset(nameset src, nameset dest)
{
   int index = 0;
   while(index < src->size)
   {
      addTexttoNameset(src->array[index], dest);
      index = index + 1;
   }
}
expfun void deepExtendTextNameset(nameset src, nameset dest)
{
   int index = 0;
   while(index < src->size)
   {
      addTexttoNameset(textNew(src->array[index]), dest);
      index = index + 1;
   }
}
expfun void printNameset(text Offset, nameset n, FILE* fp)
{
   int index;

   text increment = "   ";
   text new_Offset = (text) malloc(sizeof(char) * (strlen(Offset) + strlen(increment) + 1));
   sprintf(new_Offset, "%s%s", Offset, increment);

   fprintf(fp, "%s{\n", Offset);

   if (n == NULL)
   {
      fprintf(fp, "%sNULL\n", new_Offset);
      fprintf(fp, "%s}\n", Offset);
   }
   else
   {

      if (n->array == NULL)
         fprintf(fp, "%stext array : NULL\n", new_Offset);
      else
      {

         fprintf(fp, "%sint size : %d\n", new_Offset, n->size);

         index = 0;
         while(index < n->size)
         {
            if (n->array[index] ne NULL)
               fprintf(fp, "%stext array[%d] : %s\n", new_Offset, index, n->array[index]);
            else
               fprintf(fp, "%stext array[%d] : NULL\n", new_Offset, index);
            index = index + 1;
         }
      }

      fprintf(fp, "%s} <- end nameset\n", Offset);
   }
}
expfun void FreeNameset(nameset n, bool Deep)
{
   int index;

   if (n ne NULL)
   {
      if (Deep eq true)
      {

         index = 0;
         while(index < n->size)
         {
            if (n->array[index] ne NULL)
               free((void *) n->array[index]);

            index = index + 1;
         }
      }

      if (n->array ne NULL)
      {
         free((void *) n->array);
         n->array = NULL;
         n->size = 0;
      }

      free((void *) n);
   }
}
