; TTY handles the usual teletype way of printing a char to the screen,
; but is modified to use ANSI for scrolling, ANSI attributes, and ANSI
; cursor position. ANSI itself has its own function somewhere else.

TTY:	push ax
	push bx
	push di
        mov di,[cs:rpos]	; cursor pos, linear
	  mov bl,al
        mov ax,[cs:rattr]	; attributes (color...)
	  mov al,bl
        mov bx,[cs:rposxy]	; cursor pos, X Y
        cmp al,13
        jbe tspez	; special chars 14..31 are NOT handled!
			; Important? ones: 14/15 SO/S1 (shift, sets bit 7)
			; 17/19 XON/XOFF (DC1/DC3, flow control)
			; 27 ESC (for ANSI, handled there)
tnorm:  STOSW	; ES assumed to be screen segment!
		; (simply put char on screen if not special)
        inc bl
twrap:  test word [crpolicy],8000h
        jz chkmax	; if crpolicy test 8000h Z, do not wrap at line end
        mov ax,bx
        mov ah,0
        cmp ax,[cs:cols]
        jb chkmax
        inc bh		; we were past the right margin, wrap to next line
        mov bl,[cs:rstartxy]	; get left margin from here

	; whenever we may have to scroll, we do the checks below:
Tcurs:          BX2DI	; sync linear with X Y cursor pos
chkmax: mov ax,[cs:rendxy]
        cmp bh,ah
        jb Tnul		; we are still clearly in range
        jnz t_fw_x	; we are really out of range, scrolling
force_wrap:		; if we are on the last line:
        cmp bl,al
        jbE Tnul	; still inside range, even in last line
        mov bl,[cs:rstartxy]	; get left margin from here
        inc bh  	; we end up one line past the end, but
			; scrolling will fix this
t_fw_x:         call A_SCROLL	; see ANSI for this
        dec bh		; because we scrolled, cursor moves up
                BX2DI	; sync linear with X Y cursor pos

Tnul:   mov [rposxy],bx	; update X Y position
        mov [rpos],di	; update linear position
TRET:   pop di
	pop bx
	pop ax
	RET

	; handling chars with special meanings here:
tspez:	; <<< *** NOT handled:  3 ETX  7 BEL  11 VT  12 FF
	cmp al,13
	jz tcr
        cmp al,10
        jz tlf
        cmp al,9
        jz ttab
        cmp al,8
        jz tbs
        jmp short tnorm	; handle all other chars like NORMAL text
tbs:    or bl,bl	; BackSpace - may not wrap back to previous line
        jz Tnul
        dec bl		; revert cursor one position to the left
        dec di
        dec di
        mov ax,[cs:rattr]	; overwrite the char with a (BACK-) space
        STOSW
        	jmp Tcurs	; check for scrolling, sync X Y <-> linear
ttab:   and bl,0f8h	; TABulator
        add bl,8	; <<< *** fixed to 8 tabstops per line,
			; <<< could be improved for flexible tabstops
			; <<< (would be much slower!)
        jmp Tcurs		; check for scrolling
tcr:    test word [crpolicy],8000h	; CarriageReturn:
        jz tnurcr	; can act as CR+LF if crpolicy test 8000h NZ
Tcrlf:  inc bh		; new line AND carriage return
tnurcr: mov bl,[cs:rstartxy]	; get left margin from here - carriage return
	        jmp Tcurs	; check for scrolling
tlf:    test word [crpolicy],8000h	; LineFeed:
        jnz Tcrlf	; can act as CR+LF if crpolicy test 8000h NZ
        inc bh		; new line
	        jmp Tcurs	; check for scrolling

; --------------------------------------------------------------------

GETBIOSDTA:		; find screen geometry for TTY/ANSI
			; *** maybe this should be somewhere
			; *** else, but it also selects the COM port!
			; destroys registers!
        xor si,si       ; err_msg
        mov ax,40h
        mov es,ax
recom:  mov bx,[cs:comnum]	; get number of com ports
        shl bx,1
        mov bx,[es:bx]
        or bx,bx
        jnz jacom
nocom:  dec word [ds:comnum]
        xor ax,ax
        cmp ax,[cs:comnum]
        jle recom
        mov si,msg_nixcom	; *offset*
jacom:
        mov [ds:comdta],bx	; has selected the last exisiting port now
        mov bx,[es:4ah]
        mov [ds:cols],bx	; number of screen columns
        cmp bx,80		; complain if not exactly 80
		; <<< *** if more than 80, we only need to adjust
		; <<< *** some offsets in terminal-data, could be
		; <<< *** done on the fly...
        jz colok
        mov si,msg_wrongcols	; *offset*
                call MSG	; show message
colok:  mov bx,[es:84h]
        xor bh,bh
        cmp bl,24		; we need at least 25 rows on screen
        jnb validrows
        mov bl,24		; if we have less, just pretend to have 25 !
validrows:
        mov [ds:rows],bx
        mov ah,bl
        mov bx,[ds:cols]
        mov al,bl
        dec ax
        mov [ds:rendxy],ax	; maximum values of X and Y for ANSI
        mov ax,[cs:rows]
        mul bl
        add ax,ax
        mov [ds:rend],ax	; store pointer to end of screen
        mov bx,[es:63h]
        mov [ds:crtport],bx	; store CRT port base - needed for Vretrace
        mov ax,0b800h		; based timing (in MSG)
        cmp bx,3d4h		; and use CRT port as decision basis to
        jz color		; select the right video RAM segment
        mov ax,0b000h
        mov word [attr],0f20h	; adjust default colors to mono screen
        mov word [rattr],0f20h
color:  mov [screenseg],ax
	mov es,ax
	push si
                call initgeo	; see below: find buffer size, clear screen
	pop si
	;
	mov al,[cs:rows]
	sub al,[cs:rfirstrow]	
	mov [rscrollreg+1],al	; save max relative line number for scrolling
	mov [asavescrollreg],al
	;
        or si,si
        jz get_ok
        PUSH si
                call MSG	; show message, if one is pending
        POP si
        cmp si,msg_nixcom	; *offset*
	clc
        jnz get_ok
	stc			; no com port found or other fatal error
get_ok: RET

; --------------------------------------------------------------------

initgeo:		; calc end-of-screen-pointer, clear screen
			; now also clears bonus buffers (destroys regs!)
        mov ax,[cs:rows]
        inc ax
        mul byte [cs:cols]
        mov cx,ax
        add ax,ax
        mov [rend],ax
        xor di,di		; now do the clear screen
        cld
        mov ax,[cs:attr]
        rep stosw
	mov ax,[cs:statline]
	call initgeo_clline
	mov ax,[cs:protoline]
	call initgeo_clline
	mov ax,[cs:helpline]
	call initgeo_clline
        RET

initgeo_clline:
	mov cx,[cs:cols]
	mul cl
	add ax,ax
	mov di,ax
	mov ax,[cs:attr]
	rep stosw
	ret

