'This program is free software; you can redistribute it and/or modify it
'under the terms of the GNU General Public License as published by the Free
'Software Foundation; either version 2 of the License, or (at your option)
'any later version.
'
'This program is distributed in the hope that it will be useful, but WITHOUT
'ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
'FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
'more details.
'
'You should have received a copy of the GNU General Public License along
'with this program; if not, write to the Free Software Foundation, Inc.,
'51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
'
'------------------------------------------------------
' FoxCalc v0.83
'
' Author: Mateusz Viste "Fox" (mateusz.viste@mail.ru)
' Compiled with FreeBASIC v0.17
' Homepage at http://mateusz.viste.free.fr/dos
'------------------------------------------------------
'
#INCLUDE "INC\DOS\PC.BI"   ' Enabling the PC-Speaker support
#INCLUDE "INC\VBCOMPAT.BI" ' Enabling FORMAT("#.####... command
#INCLUDE "INC\DOS\DPMI.BI" ' Allow the GetCurrentCodePage function to work

CONST pVer AS STRING = "0.83"
CONST pDate AS STRING = "2007"

TYPE BOOL AS BYTE        ' Creating the BOOL type, as it
CONST TRUE AS BOOL = 1   ' is not supported natively by
CONST FALSE AS BOOL = 0  ' the FreeBASIC compiler.

DECLARE SUB About()
DECLARE SUB PrintMsg(Komunikat AS STRING)
DECLARE SUB MouseRefresh(x AS INTEGER, y AS INTEGER, Forcing AS BOOL = FALSE)
DECLARE SUB Compute()
DECLARE SUB DrawButton(n AS UBYTE, Stan AS UBYTE)
DECLARE SUB PrintWynik(Wynik AS DOUBLE)
DECLARE SUB Quit()
DECLARE SUB DrawBackground()
DECLARE SUB Bip()
DECLARE SUB KeybFlush()
DECLARE FUNCTION GetCurrentCodePage() AS USHORT

DIM SHARED ClickMap(0 TO 24, 0 TO 79) AS BYTE
DIM SHARED Memory AS DOUBLE
DIM SHARED AS BOOL Snd, Neg, MouseSupport, ResetTrigger
DIM SHARED AS BYTE Fract
DIM SHARED AS DOUBLE Result, WorkNumber, TempNumber ' TempNumber is needed for factorial calculation
DIM SHARED Operation AS STRING
DIM SHARED MousePosition(1 TO 3) AS INTEGER
DIM SHARED AsciiButton(1 TO 4) AS STRING * 3
DIM AS INTEGER xPos, yPos, Buttons
DIM AS BYTE x, ClickedButton
Neg = FALSE
Snd = TRUE
ResetTrigger = FALSE
MouseSupport = TRUE
Fract = 0
Result = 0
MousePosition(1) = 1
MousePosition(2) = 1
MousePosition(3) = SCREEN(1, 1, 1)

ClickMap(10,25) = 1 : ClickMap(10,26) = 1 : ClickMap(10,27) = 1
ClickMap(10,29) = 2 : ClickMap(10,30) = 2 : ClickMap(10,31) = 2
ClickMap(10,33) = 3 : ClickMap(10,34) = 3 : ClickMap(10,35) = 3
ClickMap(10,37) = 4 : ClickMap(10,38) = 4 : ClickMap(10,39) = 4
ClickMap(10,41) = 5 : ClickMap(10,42) = 5 : ClickMap(10,43) = 5
ClickMap(12,25) = 6 : ClickMap(12,26) = 6 : ClickMap(12,27) = 6
ClickMap(12,29) = 7 : ClickMap(12,30) = 7 : ClickMap(12,31) = 7
ClickMap(12,33) = 8 : ClickMap(12,34) = 8 : ClickMap(12,35) = 8
ClickMap(12,37) = 9 : ClickMap(12,38) = 9 : ClickMap(12,39) = 9
ClickMap(12,41) = 10: ClickMap(12,42) = 10: ClickMap(12,43) = 10: ClickMap(13,41) = 10: ClickMap(13,42) = 10: ClickMap(13,43) = 10: ClickMap(14,41) = 10: ClickMap(14,42) = 10: ClickMap(14,43) = 10
ClickMap(14,25) = 11: ClickMap(14,26) = 11: ClickMap(14,27) = 11
ClickMap(14,29) = 12: ClickMap(14,30) = 12: ClickMap(14,31) = 12
ClickMap(14,33) = 13: ClickMap(14,34) = 13: ClickMap(14,35) = 13
ClickMap(14,37) = 14: ClickMap(14,38) = 14: ClickMap(14,39) = 14
ClickMap(16,25) = 15: ClickMap(16,26) = 15: ClickMap(16,27) = 15
ClickMap(16,29) = 16: ClickMap(16,30) = 16: ClickMap(16,31) = 16
ClickMap(16,33) = 17: ClickMap(16,34) = 17: ClickMap(16,35) = 17
ClickMap(16,37) = 18: ClickMap(16,38) = 18: ClickMap(16,39) = 18
ClickMap(16,41) = 19: ClickMap(16,42) = 19: ClickMap(16,43) = 19: ClickMap(17,41) = 19: ClickMap(17,42) = 19: ClickMap(17,43) = 19: ClickMap(18,41) = 19: ClickMap(18,42) = 19: ClickMap(18,43) = 19
ClickMap(18,25) = 20: ClickMap(18,26) = 20: ClickMap(18,27) = 20
ClickMap(18,29) = 21: ClickMap(18,30) = 21: ClickMap(18,31) = 21: ClickMap(18,32) = 21: ClickMap(18,33) = 21: ClickMap(18,34) = 21: ClickMap(18,35) = 21
ClickMap(18,37) = 22: ClickMap(18,38) = 22: ClickMap(18,39) = 22
ClickMap(10,48) = 23: ClickMap(10,49) = 23: ClickMap(10,50) = 23
ClickMap(10,52) = 24: ClickMap(10,53) = 24: ClickMap(10,54) = 24
ClickMap(12,48) = 25: ClickMap(12,49) = 25: ClickMap(12,50) = 25
ClickMap(12,52) = 26: ClickMap(12,53) = 26: ClickMap(12,54) = 26
ClickMap(14,48) = 27: ClickMap(14,49) = 27: ClickMap(14,50) = 27
ClickMap(14,52) = 28: ClickMap(14,53) = 28: ClickMap(14,54) = 28
ClickMap(16,48) = 29: ClickMap(16,49) = 29: ClickMap(16,50) = 29
ClickMap(16,52) = 30: ClickMap(16,53) = 30: ClickMap(16,54) = 30
ClickMap(18,48) = 31: ClickMap(18,49) = 31: ClickMap(18,50) = 31
ClickMap(18,52) = 32: ClickMap(18,53) = 32: ClickMap(18,54) = 32


IF SETMOUSE(1, 1, 1) <> 0 THEN PRINT "Mouse init failed - Please check if you loaded a mouse driver!": MouseSupport = FALSE: SLEEP 1
AsciiButton(1) = " / ": AsciiButton(2) = "SQR": AsciiButton(3) = "x^n": AsciiButton(4) = "x^2"
SELECT CASE GetCurrentCodePage
   CASE 437, 860, 861, 863, 865, 737, 790, 991
      AsciiButton(1) = "  ": AsciiButton(2) = "  ": AsciiButton(3) = " x": AsciiButton(4) = " x":
   CASE 775, 850, 857, 858
      AsciiButton(1) = "  ": AsciiButton(2) = "SQR": AsciiButton(3) = "x^n": AsciiButton(4) = " x":
   CASE 852
      AsciiButton(1) = "  ": AsciiButton(2) = "SQR": AsciiButton(3) = "x^n": AsciiButton(4) = "x^2":
   CASE 866
      AsciiButton(1) = " / ": AsciiButton(2) = "  ": AsciiButton(3) = "x^n": AsciiButton(4) = "x^2":
END SELECT

LOCATE ,,0  ' Hiding the blinking text cursor

DrawBackground
PrintWynik(Result)
FOR x = 1 TO 32
   DrawButton(x, 0)
NEXT x


DO
  SELECT CASE INKEY
     CASE ""
        REM It's here just to speed up the program if no key pressed.
     CASE "1"
        ClickedButton = 16
     CASE "2"
        ClickedButton = 17
     CASE "3"
        ClickedButton = 18
     CASE "4"
        ClickedButton = 12
     CASE "5"
        ClickedButton = 13
     CASE "6"
        ClickedButton = 14
     CASE "7"
        ClickedButton = 7
     CASE "8"
        ClickedButton = 8
     CASE "9"
        ClickedButton = 9
     CASE "0"
        ClickedButton = 21
     CASE CHR(13), "=" 'ENTER
        ClickedButton = 19
     CASE "*"
        ClickedButton = 4
     CASE "+"
        ClickedButton = 10
     CASE "-"
        ClickedButton = 5
     CASE ".", ","
        ClickedButton = 22
        KeybFlush
     CASE CHR(27)    'ESC
        ClickedButton = 24
     CASE CHR(8)     'BackSPC
        ClickedButton = 28
     CASE CHR(255) + "S" 'DEL
        ClickedButton = 26
     CASE "!"
        ClickedButton = 15
     CASE "s"
        ClickedButton = 30
     CASE "?"
        ClickedButton = 32
     CASE "%"
        ClickedButton = 2
     CASE "/"
        ClickedButton = 3
     CASE "\"
        ClickedButton = 31
     CASE "m"
        ClickedButton = 23
     CASE "M"
        ClickedButton = 25
     CASE "r"
        ClickedButton = 27
     CASE "c"
        ClickedButton = 29
     CASE "^"
        ClickedButton = 11
     CASE ":"
        ClickedButton = 20
     CASE "["
        ClickedButton = 6
     CASE "]"
        ClickedButton = 1
  END SELECT
  IF ClickedButton > 0 THEN
      DrawButton(ClickedButton, 2)
      IF Snd = TRUE THEN Bip ELSE SLEEP 50
      KeybFlush
      ClickedButton = 0 - ClickedButton
  END IF
  IF ResetTrigger = TRUE THEN ClickedButton = -26: ResetTrigger = FALSE
  IF MouseSupport = TRUE THEN
      GETMOUSE(xPos, yPos,, Buttons)
      MouseRefresh(xPos+1, yPos+1)
  END IF

  IF (Buttons AND 1) AND (ClickedButton = 0) THEN
     ClickedButton = ClickMap(yPos, xPos)
     DrawButton(ClickedButton, 2)
     IF Snd = TRUE AND ClickedButton > 0 THEN Bip
     ClickedButton = 0 - ClickedButton
  END IF
  IF Buttons = 0 AND ClickedButton < 0 THEN
     ClickedButton = ABS(ClickedButton)
     DrawButton(ClickedButton, 0)
     SELECT CASE ClickedButton
       CASE 1
         Compute
         IF Result < 0 THEN Result = 0: PrintMsg("NOT ALLOWED"): ResetTrigger = TRUE ELSE Result = SQR(Result)
         PrintWynik(Result)
       CASE 2
         IF Operation = "-" OR Operation = "+" THEN WorkNumber *= Result / 100 ELSE WorkNumber = WorkNumber / 100
         Compute
       CASE 3
         Compute
         Operation = "/"
       CASE 4
         Compute
         Operation = "*"
       CASE 5
         Compute
         Operation = "-"
       CASE 6
         Compute
         Result = Result^2
         PrintWynik(Result)
       CASE 7
         IF WorkNumber = 0 THEN
              WorkNumber = 7/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"7")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"7")
           ELSEIF Fract > 0 THEN
              WorkNumber += 7/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"7")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 8
         IF WorkNumber = 0 THEN
              WorkNumber = 8/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR(WorkNumber)+"8")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"8")
           ELSEIF Fract > 0 THEN
              WorkNumber += 8/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"8")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 9
         IF WorkNumber = 0 THEN
              WorkNumber = 9/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"9")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"9")
           ELSEIF Fract > 0 THEN
              WorkNumber += 9/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"9")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 10
         Compute
         Operation = "+"
       CASE 11
         Compute
         Operation = "xn"
       CASE 12
         IF WorkNumber = 0 THEN
              WorkNumber = 4/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"4")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"4")
           ELSEIF Fract > 0 THEN
              WorkNumber += 4/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"4")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 13
         IF WorkNumber = 0 THEN
              WorkNumber = 5/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"5")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"5")
           ELSEIF Fract > 0 THEN
              WorkNumber += 5/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"5")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 14
         IF WorkNumber = 0 THEN
              WorkNumber = 6/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"6")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"6")
           ELSEIF Fract > 0 THEN
              WorkNumber += 6/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"6")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 15
         Compute
         IF Result < 0 THEN PrintMsg("NOT ALLOWED"): Result = -1
         IF Result > 76 THEN PrintMsg("OVERFLOW"): Result = -1
         IF FRAC(Result) > 0 THEN PrintMsg("NOT ALLOWED"): Result = -1
         TempNumber = 1
         FOR WorkNumber = 1 TO Result
            TempNumber = TempNumber * WorkNumber
         NEXT WorkNumber
         IF Result <> -1 THEN Result = TempNumber ELSE ResetTrigger = TRUE
         TempNumber = 0
         WorkNumber = 0
         PrintWynik(Result)
       CASE 16
         IF WorkNumber = 0 THEN
              WorkNumber = 1/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"1")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"1")
           ELSEIF Fract > 0 THEN
              WorkNumber += 1/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"1")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 17
         IF WorkNumber = 0 THEN
              WorkNumber = 2/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"2")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"2")
           ELSEIF Fract > 0 THEN
              WorkNumber += 2/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"2")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 18
         IF WorkNumber = 0 THEN
              WorkNumber = 3/(10^Fract)
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) = 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+"3")
           ELSEIF Fract = 0 AND WorkNumber < 100000000000 AND FRAC(WorkNumber) <> 0 THEN
              WorkNumber = VAL(STR(FORMAT(WorkNumber, "#.############"))+"3")
           ELSEIF Fract > 0 THEN
              WorkNumber += 3/(10^Fract)
           ELSEIF Fract < 0 THEN
              WorkNumber = VAL(STR$(WorkNumber)+LEFT("000000000000000000000000000000",ABS(Fract))+"3")
         END IF
         Fract = 0
         PrintWynik(WorkNumber)
       CASE 19
         Compute
       CASE 20
         Compute
         Operation = "MOD"
       CASE 21
         IF WorkNumber <> 0 AND Fract = 0 AND FRAC(WorkNumber) = 0 THEN WorkNumber = VAL(STR$(WorkNumber)+"0")
         IF Fract > 0 THEN Fract += 1
         IF Fract < 0 THEN Fract -= 1
         IF Fract = 0 AND FRAC(WorkNumber) <> 0 THEN Fract = -1
         PrintWynik(WorkNumber)
       CASE 22
         IF FRAC(WorkNumber) = 0 THEN Fract = 1
         PrintWynik(WorkNumber)
       CASE 23
         Compute
         Memory += Result
         DrawButton(27,0)
       CASE 24
         Quit
       CASE 25
         Compute
         Memory -= Result
         DrawButton(27,0)
       CASE 26
         Memory = 0
         DrawButton(27,0)
         WorkNumber = 0
         Operation = ""
         Result = 0
         Neg = FALSE
         Fract = 0
         Compute
       CASE 27
         WorkNumber = Memory
         PrintWynik(WorkNumber)
       CASE 28
         WorkNumber = 0
         Operation = ""
         Result = 0
         Neg = FALSE
         Fract = 0
         Compute
       CASE 29
         Memory = 0
         DrawButton(27, 0)
       CASE 30
         IF Snd = TRUE THEN Snd = FALSE ELSE Snd = TRUE
         DrawButton(30, 0)
         IF ClickMap(yPos, xPos) = 30 THEN MousePosition(3) = SCREEN(yPos+1, xPos+1, 1)
         MouseRefresh(xPos+1, yPos+1, TRUE)
       CASE 31
         IF WorkNumber = 0 THEN
            Neg = TRUE
           ELSEIF WorkNumber > 0 THEN
            WorkNumber = 0 - WorkNumber
           ELSEIF WorkNumber < 0 THEN
            WorkNumber = ABS(WorkNumber)
         END IF
         PrintWynik(WorkNumber)
       CASE 32
         About
     END SELECT
     MouseRefresh(xPos, yPos, TRUE)
     IF ClickedButton > 0 THEN ClickedButton = 0
     IF Neg = TRUE AND WorkNumber <> 0 THEN Neg = FALSE: ClickedButton = 31
  END IF

LOOP


'***  PROGRAM'S END  ***  HERE STARTS ALL SUB PROCEDURE & FUNCTIONS  ***


SUB DrawBackground
  COLOR 7, 1
  LOCATE  5, 22: PRINT "ͻ";
  LOCATE  6, 22: PRINT "                                    ";
  LOCATE  7, 22: PRINT "  Ŀ  ";
  LOCATE  8, 22: PRINT "                                  ";
  LOCATE  9, 22: PRINT "    ";
  LOCATE 10, 22: PRINT "                                    ";
  LOCATE 11, 22: PRINT "                                    ";
  LOCATE 12, 22: PRINT "                                    ";
  LOCATE 13, 22: PRINT "                                    ";
  LOCATE 14, 22: PRINT "                                    ";
  LOCATE 15, 22: PRINT "                                    ";
  LOCATE 16, 22: PRINT "                                    ";
  LOCATE 17, 22: PRINT "                                    ";
  LOCATE 18, 22: PRINT "                                    ";
  LOCATE 19, 22: PRINT "                                    ";
  LOCATE 20, 22: PRINT "                                    ";
  LOCATE 21, 22: PRINT "ͼ";
  COLOR 7, 0
END SUB


SUB Quit
  SETMOUSE(0, 0, 0)
  CLS
  END
END SUB


SUB PrintWynik(Wynik AS DOUBLE)
  DIM TempString AS STRING
  COLOR 10, 0
  LOCATE 8, 26
  IF FRAC(Wynik) <> 0 THEN TempString = FORMAT(Wynik, "############,#0.############") ELSE TempString = FORMAT(Wynik, "###########,#")
  IF ABS(Wynik) >= 1000000000000 THEN TempString = FORMAT(Wynik, "0.00E+000")
  IF Neg = TRUE THEN TempString = "-" + TempString
  IF Fract > 0 THEN TempString = TempString + LEFT(".00000000000000000000000000000", Fract)
  IF Fract < 0 THEN TempString = TempString + LEFT("000000000000000000000000000000", ABS(Fract))
  PRINT SPACE(30-LEN(TempString)) + TempString;
  COLOR 7,0
END SUB


SUB DrawButton(n AS UBYTE, Stan AS UBYTE)
  SELECT CASE Stan
    CASE 0
      COLOR 7, 6
      IF n = 30 AND Snd = TRUE THEN COLOR 14, 6
      IF n = 27 AND Memory <> 0 THEN COLOR 14, 6
    CASE 2
      COLOR 15, 4
  END SELECT

  SELECT CASE n
    CASE 1
      LOCATE 11, 26: PRINT AsciiButton(2);
    CASE 2
      LOCATE 11, 30: PRINT " % ";
    CASE 3
      LOCATE 11, 34: PRINT AsciiButton(1);
    CASE 4
      LOCATE 11, 38: PRINT " * ";
    CASE 5
      LOCATE 11, 42: PRINT " - ";
    CASE 6
      LOCATE 13, 26: PRINT AsciiButton(4);
    CASE 7
      LOCATE 13, 30: PRINT " 7 ";
    CASE 8
      LOCATE 13, 34: PRINT " 8 ";
    CASE 9
      LOCATE 13, 38: PRINT " 9 ";
    CASE 10
      LOCATE 13, 42: PRINT "   ";
      LOCATE 14, 42: PRINT " + ";
      LOCATE 15, 42: PRINT "   ";
    CASE 11
      LOCATE 15, 26: PRINT AsciiButton(3);
    CASE 12
      LOCATE 15, 30: PRINT " 4 ";
    CASE 13
      LOCATE 15, 34: PRINT " 5 ";
    CASE 14
      LOCATE 15, 38: PRINT " 6 ";
    CASE 15
      LOCATE 17, 26: PRINT " x!";
    CASE 16
      LOCATE 17, 30: PRINT " 1 ";
    CASE 17
      LOCATE 17, 34: PRINT " 2 ";
    CASE 18
      LOCATE 17, 38: PRINT " 3 ";
    CASE 19
      LOCATE 17, 42: PRINT "   ";
      LOCATE 18, 42: PRINT " = ";
      LOCATE 19, 42: PRINT "   ";
    CASE 20
      LOCATE 19, 26: PRINT "MOD";
    CASE 21
      LOCATE 19, 30: PRINT "   0   ";
    CASE 22
      LOCATE 19, 38: PRINT " . ";
    CASE 23
      LOCATE 11, 49: PRINT " M+";
    CASE 24
      LOCATE 11, 53: PRINT "OFF";
    CASE 25
      LOCATE 13, 49: PRINT " M-";
    CASE 26
      LOCATE 13, 53: PRINT " AC";
    CASE 27
      LOCATE 15, 49: PRINT " MR";
    CASE 28
      LOCATE 15, 53: PRINT " C ";
    CASE 29
      LOCATE 17, 49: PRINT " MC";
    CASE 30
      LOCATE 17, 53: PRINT "  ";
    CASE 31
      LOCATE 19, 49: PRINT "+/-";
    CASE 32
      LOCATE 19, 53: PRINT " ? ";
  END SELECT
  COLOR 7, 0
END SUB


SUB Bip
   SOUND 800
   SLEEP 50
   SOUND 0
END SUB


SUB Compute
  SELECT CASE Operation
    CASE ""
      IF WorkNumber <> 0 THEN Result = WorkNumber
    CASE "+"
      Result += WorkNumber
    CASE "-"
      Result -= WorkNumber
    CASE "/"
      Result /= WorkNumber
    CASE "*"
      Result *= WorkNumber
    CASE "xn"
      Result = Result^WorkNumber
    CASE "MOD"
      IF WorkNumber = 0 THEN
         PrintMsg("ERROR: DIV BY ZERO")
         Result = 0
       ELSE
         Result MOD= WorkNumber
      END IF
  END SELECT
  Operation = ""
  WorkNumber = 0
  Fract = 0
  IF ABS(FRAC(Result)) <= 0.000000000001 THEN Result = FIX(Result)  'If the calculator shows an integer, it MUST be an integer.
  PrintWynik(Result)
END SUB


SUB About
  DIM Text AS STRING
  DIM x AS UBYTE
  x = 0
  Text = SPACE(31) + "FoxCalc v" + pVer + " - Copyright (C) Mateusz Viste " + CHR(34) + "Fox" + CHR(34) + " " + pDate + " - email: mateusz.viste@mail.ru" + SPACE(31)
  Memory = 0
  DrawButton(27,0)
  WorkNumber = 0
  Operation = ""
  Result = 0
  Neg = FALSE
  Fract = 0
  COLOR 10, 0
  FOR x = 1 TO LEN(Text) - 30
     LOCATE 8, 26
     PRINT MID(Text, x, 30);
     SLEEP 80
  NEXT x
  PrintWynik(WorkNumber)
  KeybFlush
END SUB


SUB KeybFlush
  DO: LOOP UNTIL INKEY = ""
END SUB


SUB PrintMsg(Komunikat AS STRING)
     LOCATE 8, 26: COLOR 4, 0
     PRINT SPACE(30 - LEN(Komunikat)) + Komunikat;
     COLOR 7, 0
     IF snd = TRUE THEN SOUND(200): SLEEP 500: SOUND(0) ELSE SLEEP 500
     SLEEP 1500
     KeybFlush
END SUB


SUB MouseRefresh(x AS INTEGER, y AS INTEGER, Forcing AS BOOL = FALSE)
  IF (x > 0 AND y > 0 AND (x <> MousePosition(1) OR y <> MousePosition(2))) OR Forcing = TRUE THEN
     LOCATE MousePosition(2), MousePosition(1)                 ' Erasing the
     COLOR MousePosition(3) AND &HF, MousePosition(3) SHR 4    ' previous
     PRINT CHR(SCREEN(MousePosition(2), MousePosition(1), 0)); ' cursor.
     MousePosition(1) = x                       ' Saving the current's
     MousePosition(2) = y                       ' cursor position and
     MousePosition(3) = SCREEN(y, x, 1)         ' colors.
     LOCATE y, x
     IF MousePosition(3) SHR 4 <> 0 THEN COLOR 15, 0 ELSE COLOR 0, 8
     PRINT CHR(SCREEN(y, x, 0));
     COLOR 7, 0
  END IF
END SUB


FUNCTION GetCurrentCodePage() AS USHORT
'DIM b AS USHORT
'b = 437
        CONST CF = 1
        DIM regs As __dpmi_regs
        regs.x.ax = &h6601
        IF __dpmi_int(&h21, @regs) = 0 AND (regs.x.flags And CF) = 0 THEN
                Return regs.x.bx
        ELSE
                RETURN 0
        END IF
'GetCurrentCodePage = b
END FUNCTION
