$if 0
--------------------------------------------------------------------
 Title       : HiLite
 Description : Color highlighting for Power Basic 3.1 IDE
 Notes       : TAB size = 4
 Future      : asm code in ProcessScreen ?
 Usage       : HILITE [/TSR filename] [/UNLOAD] [/OFF] [/ON] [/STATUS]
 Bugs        : YET ANOTHER POWERBASIC BUG/NUISANCE !!!
               config.sys was FILES=40 FCBS=4,4 LASTDRIVE=K
               we let lastdrive to L and then...
               POPUP SLEEP FORCED AN ERROR 5, WHATEVER WE TRY !!!
               SOLVED IF WE INCREASED FCBS STATEMENT IN CONFIG.SYS
               FROM 4,4 TO 6,4 !!! PIECE OF CRAP !!!
               ERROR 5 WAS SO... INFORMATIVE !!!
--------------------------------------------------------------------
$endif

$CPU 80386

$OPTIMIZE SPEED
$COMPILE EXE

$DEBUG MAP OFF
$DEBUG PBDEBUG OFF

$LIB COM        OFF
$LIB CGA        OFF
$LIB EGA        OFF
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  OFF

$ERROR BOUNDS   OFF
$ERROR NUMERIC  OFF
$ERROR OVERFLOW OFF
$ERROR STACK    OFF

$FLOAT PROCEDURE

$COM    0
$STRING 16
$STACK  2048
$SOUND  1

$DIM ARRAY

$DYNAMIC
' $STATIC

$OPTION CNTLBREAK OFF

'--------------------------------------------------------------------

DEFINT A-Z
OPTION BINARY BASE 0

%False = 0
%True  = NOT %False

%Debug = %False

%FLAGS = 0
%AX    = 1
%BX    = 2
%CX    = 3
%DX    = 4
%SI    = 5
%DI    = 6
%BP    = 7
%DS    = 8
%ES    = 9

%black      = 0
%blue       = 1
%green      = 2
%cyan       = 3
%red        = 4
%magenta    = 5
%brown      = 6
%white      = 7
%gray       = 8
%lightblue  = 9
%lightgreen = 10
%lightcyan  = 11
%lightred   = 12
%lightmagenta= 13
%yellow     = 14
%brightwhite= 15
%weird      = %black * &H10 + %black
%MinColor   = 0
%MaxColor   = 15

%Dos        = &H21
%Multiplex  = &H2F
%EMS        = &H67

%hi         = &H100
%OneK       = &H400
%EMSPage    = &H4000

%eNone          = 100
%eUsage         = 101
%eDosTooOld     = 102
%eTooMany       = 103
%eConflict      = 104
%eUnknown       = 105
%eNotUnique     = 106
%eJoker         = 107
%eBadName       = 108
%eNotFound      = 109
%eNotLoaded     = 110
%eAlreadyLoaded = 111
%eNeedEMS       = 112
%eNeedMoreEMS   = 113
%eCantUnload    = 114
%eNotYetLoaded  = 115
%eMissingCmd    = 116
%ePbEMS         = 117
%eMissingFileName = 118
%eFileTooSmall  = 119
%eFileTooBig    = 120
%eMissingID     = 121
%eTooFewTokens  = 122
%eTooManyTokens = 123
%eNeedColor     = 124
%eBadColor      = 125
%eBadToken      = 126
%eDuplicate     = 127
%eNeedColorVideo= 128
%eBadDirective  = 129
%eDelimiter     = 130
%eRemReserved   = 131
%ePrivate       = 132

%cmdNone   = &HFF
%cmdTSR    = &H00
%cmdUnload = &H01
%cmdOn     = &H02
%cmdOff    = &H03
%cmdStatus = &H04
%rcWasHere = &H05
%idAX      = &HDAFA
%idDX      = &HFADA
%idFooBar  = &HFFFF

%editorNone  = &H00 ' v1.3
%editorPB31  = &H01 ' v1.3
%editorNE20  = &H02 ' v1.3
%editorPDS71 = &H03 ' v1.3

%PopMultiplex = 16
%PopTimer     = 4
%PopKey       = 1

%MinToken = 1
%MaxToken = 600

%MinLetter = 0                      ' v1.1 <"A"
%MaxLetter = %MinLetter + 26 + 1    ' v1.1 "A".."Z" and >"Z"
%CodeA     = &H41                   ' v1.1 "A"=65=$41
%CodeZ     = &H5A                   ' v1.1 "Z"=90=$5A

%GrabMem    = &HA0000
%UseMem     = &H2000
%NeededEMS  = 250000 ' better safe than sorry
%MinSize    = 16
%MaxSize    = 16384

%PopInterval = 9 ' was 36 (unit=1/18.2s) two seconds seems okay to me

' Ctrl-F10 is not used in PB IDE

%PopKeyShift = &H04 ' Ctrl
%PopKeyScan  = &H44 ' f10
%PopKeyIgnore= &H7B ' ignore all but Ctrl

'--------------------------------------------------------------------

' kludgy but PB does not (yet) like string constants !

SHARED Program$,Version$,Copyright$,errinfo$
SHARED DefaultExtension$,DefaultFile$,ID$,DefaultPopKey$
SHARED Delimiters$,DoubleQuote$,SingleQuote$,RemReserved$

Program$="HILITE"
Version$=" v1.42"
Copyright$=" (c) by PhG"
errinfo$=""
DefaultExtension$=".DEF"
DefaultFile$="HILITE"   ' extension added later if needed
ID$="[HiLite (c) PhG]"
DefaultPopKey$="Ctrl-F10"
Delimiters$=" (),=+-*<>/\[].^:;_"
DoubleQuote$=CHR$(&H22)
SingleQuote$="'"
RemReserved$="REM"      ' must be upper case

DIM TokenStr(%MinToken:%MaxToken) AS SHARED STRING
DIM TokenAttr(%MinToken:%MaxToken) AS SHARED BYTE
DIM TokenCount(%MinLetter:%MaxLetter) AS SHARED INTEGER     ' v1.1
DIM TokenOffset(%MinLetter:%MaxLetter) AS SHARED INTEGER    ' v1.1

SHARED colorRemark,colorConstant,colorString,colorTyped,colorDefault
SHARED colorValue                                           ' v1.2
SHARED fRemark,fConstant,fString,fTyped,fDefault
SHARED fValue	' v1.2 (fNumber seems to be reserved!)

'--------------------------------------------------------------------

ON ERROR GOTO Abort

CALL GetDosVersion (major,minor)
IF (major < 3) AND (minor < 10) THEN ERROR %eDosTooOld

IF IsMono = %True OR IsHerc = %True THEN ERROR %eNeedColorVideo

CALL ParseCLI (order,DataFile$)

SELECT CASE order
CASE %cmdOn
    REG %AX,%idAX
    REG %DX,%idDX
    REG %BX,%cmdOn
    CALL INTERRUPT %Multiplex
    IF (REG(%AX) = %idAX AND REG(%DX) = %idDX AND REG(%BX) = %cmdOn) THEN
        ERROR %eNotYetLoaded
    END IF
CASE %cmdOff
    REG %AX,%idAX
    REG %DX,%idDX
    REG %BX,%cmdOff
    CALL INTERRUPT %Multiplex
    IF (REG(%AX) = %idAX AND REG(%DX) = %idDX AND REG(%BX) = %cmdOff) THEN
        ERROR %eNotLoaded
    END IF
CASE %cmdStatus
    REG %AX,%idAX
    REG %DX,%idDX
    REG %BX,%cmdStatus
    CALL INTERRUPT %Multiplex
    IF (REG(%AX) = %idAX AND REG(%DX) = %idDX AND REG(%BX) = %cmdStatus) THEN
        ERROR %eNotYetLoaded
    END IF
CASE %cmdUnload
    REG %AX,%idAX
    REG %DX,%idDX
    REG %BX,%cmdUnload
    CALL INTERRUPT %Multiplex
    IF (REG(%AX) = %idAX AND REG(%DX) = %idDX AND REG(%BX) = %cmdUnload) THEN
        ERROR %eNotLoaded
    END IF
CASE %cmdTSR
    REG %AX,%idAX
    REG %DX,%idDX
    REG %BX,%cmdTSR
    CALL INTERRUPT %Multiplex
    IF NOT (REG(%AX) = %idAX AND REG(%DX) = %idDX AND REG(%BX) = %cmdTSR) THEN
        ERROR %eAlreadyLoaded
    END IF

    IF EMSHere = %False THEN ERROR %eNeedEMS
    IF GetFreeEMS??? < %NeededEMS THEN ERROR %eNeedMoreEMS

    CALL LoadTokens(DataFile$,LastToken)    ' load and sort them
    CALL IndexTokens(LastToken)             ' v1.1
    ProgramActive = %True                   ' must be *here*!
    CALL Banner(DataFile$,LastToken,ProgramActive)

    x??? = SETMEM(-%GrabMem)
    x??? = SETMEM(%UseMem)

    ProgramActive = %True

    POPUP MULTIPLEX %idAX, %idDX
    POPUP TIMER %PopInterval
    POPUP KEY CHR$(%PopKeyShift, %PopKeyScan, %PopKeyIgnore)
    POPUP SLEEP USING EMS
    DO
        popmethod = POPUP(4)
        SELECT CASE popmethod
        CASE %PopMultiplex
            cmd = REG(%BX)
            SELECT CASE cmd
            CASE %cmdTSR
                REG %AX, %idAX
                REG %DX, %idDX
                REG %BX, %rcWasHere
            CASE %cmdOn
                REG %AX, %idAX
                REG %DX, %idDX
                REG %BX, %rcWasHere
                ProgramActive = %True
                a$= Program$+" : Enabled"
                stdout a$
            CASE %cmdOff
                REG %AX, %idAX
                REG %DX, %idDX
                REG %BX, %rcWasHere
                ProgramActive = %False
                a$= Program$+" : Disabled"
                stdout a$
            CASE %cmdStatus
                REG %AX, %idAX
                REG %DX, %idDX
                REG %BX, %rcWasHere
                CALL Banner (DataFile$, LastToken,ProgramActive)
            CASE %cmdUnload
                REG %AX, %idAX
                REG %DX, %idDX
                REG %BX, %rcWasHere
                ' message MUST be HERE
                a$= Program$+" : Unloading..."
                stdout a$
                ' END here would not fully uninstall, leaving 6 Kb lost
                Retry = 0
                POPUP TIMER 9
                DO WHILE Retry < 1
                    POPUP SLEEP
                    IF POPUP(1) <> %False THEN
                        ' message no longer here
                        POPUP TIMER OFF
                        END %eNone-%eNone
                    END IF
                    INCR Retry
                LOOP
                ' cannot end here with POPUP STUFF a CR nor ERROR % !!! so...
                POPUP TIMER OFF
                BEEP ' signal we're not fully done
                END %eCantUnload-%eNone
            END SELECT
        CASE %PopTimer
            CALL ProcessScreen(ProgramActive,LastToken)
        CASE %PopKey
            ProgramActive = NOT ProgramActive
            IF ProgramActive = %False THEN
                SOUND 555,1
                SOUND 333,1
                POPUP TIMER OFF
            ELSE
                SOUND 333,1
                SOUND 555,1
                POPUP TIMER ON
            END IF
        END SELECT
        POPUP SLEEP
    LOOP
END SELECT
END %eNone-%eNone

'--------------------------------------------------------------------

Abort:
IF ERR = %eUsage THEN
    stdoutln Program$+Version$+Copyright$
    stdoutln ""
    stdoutln "Syntax : "+Program$+" <command> [filename["+DefaultExtension$+"]]"
    stdoutln ""
    stdoutln "<command> /TSR loads program as a TSR (!)"
    stdoutln "          /UNLOAD unloads program from memory"
    stdoutln "          /ON enables program"
    stdoutln "          /OFF disables program"
    stdoutln "          /STATUS shows program's current status"
    stdoutln ""
    stdout   "<filename> is the definition file"
    stdoutln " (default name is "+DefaultFile$+DefaultExtension$+")"
    stdoutln ""
    stdoutln "Toggle key to enable or disable program is <"+DefaultPopKey$+">."
    stdoutln ""
    stdoutln "Each line in the definition file can be :"
    stdoutln "<#<ink> on <paper>> : black, blue, green, cyan, red, magenta, brown, white"
    stdoutln "                      {grey, light blue, light green, light cyan,"
    stdoutln "                      light red, light magenta, yellow, bright white}"
    stdoutln "<directive>         : <REMARK>, <CONSTANT>, <STRING>, <TYPED>, <DEFAULT>,"
    stdoutln "                      <NUMBER>"
    stdout   "<keyword>           : keyword to be highlighted"
    END %eUsage-%eNone
END IF
SELECT CASE ERR
CASE %eDosTooOld
    e$= "DOS version must be 3.1 or greater"
CASE %eTooMany
    e$= "Too many parameters"
CASE %eConflict
    e$= "Conflicting commands"
CASE %eUnknown
    e$= "Unknown command ("+errinfo$+")"
CASE %eNotUnique
    e$= "Too many filenames"
CASE %eJoker
    e$= "Wildcard not allowed in filename"
CASE %eBadName
    e$= "Illegal filename"
CASE %eNotFound
    e$= "File not found ("+errinfo$+")"
CASE %eNotLoaded
    e$= "Program not loaded"
CASE %eAlreadyLoaded
    e$= "Program already loaded"
CASE %eNeedEMS
    e$= "EMS memory needed to run this program"
CASE %eNeedMoreEMS
    e$= "Not enough EMS memory to run this program"
CASE %eCantUnload
    ' does not work so we take care of this message elsewhere
    e$= "Unable to fully unload program"
CASE %eNotYetLoaded
    e$= "Program not yet loaded"
CASE %eMissingCmd
    e$= "Missing command"
CASE %ePbEMS
    e$= "EMS driver problem"
CASE %eMissingFileName
    e$= "Missing filename"
CASE %eFileTooSmall
    e$= "File too small"
CASE %eFileTooBig
    e$= "File too big"
CASE %eMissingID
    e$= "Missing identification string at the beginning of the file"
CASE %eTooFewTokens
    e$= "Too few definitions"
CASE %eTooManyTokens
    e$= "Too many definitions"
CASE %eNeedColor
    e$= "No color yet defined in definition file"
CASE %eBadColor
    e$= "Illegal or same color for ink and/or paper ("+errinfo$+")"
CASE %eBadToken
    e$= "Space not allowed in keyword ("+errinfo$+")"
CASE %eDuplicate
    e$= "Duplicate keyword ("+errinfo$+")"
CASE %eNeedColorVideo
    e$= "Color screen card required (CGA, EGA or VGA)"
CASE %eBadDirective
    e$= "Illegal directive ("+errinfo$+")"
CASE %eDelimiter
    e$= "Delimiter not allowed in keyword ("+errinfo$+")"
CASE %eRemReserved
    e$= "Keyword reserved ("+errinfo$+")"
CASE %ePrivate
    e$= "Just say NO to them"
CASE ELSE
    e$=HEX$(ERADR)
    e$=MID$("0000",1,4-LEN(e$))+e$
    e$= "Error #"+MID$(STR$(ERR),2)+" at address $"+e$
END SELECT
e$=Program$+" : "+e$+" !"
stdout e$
END ERR-%eNone

'--------------------------------------------------------------------

SUB GetDosVersion (major,minor)
REG %AX, &H30 * %hi
CALL INTERRUPT %Dos
rc??=REG(%AX)
major = rc?? MOD %hi    ' al
minor = rc?? \ %hi      ' ah
END SUB

'--------------------------------------------------------------------

FUNCTION Upper$ (s$)
quote$ = CHR$(&H22)
table$ = table$ + "                                "
table$ = table$ + " !"
table$ = table$ + quote$
table$ = table$ + "#$%&'()*+,-./0123456789:;<=>?"
table$ = table$ + "@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_"
table$ = table$ + "`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~"
table$ = table$ + "CUEAAAACEEEIIIAAE  OOOUUYOU     "
table$ = table$ + "AIOUNN                          "
table$ = table$ + "                                "
table$ = table$ + "                                "
new$=""
i = 1
WHILE (i <= LEN(s$))
    char$ = MID$(s$, i, 1)
    code = ASC(char$)
    cap$ = MID$(table$, code+1, 1)
    IF cap$=" " THEN
        new$=new$+char$
    ELSE
        new$ = new$ + cap$
    END IF
    INCR i
WEND
Upper$ = new$
END FUNCTION

'--------------------------------------------------------------------

FUNCTION ArgC
blank=ASC(" ")
cli$=LTRIM$(RTRIM$(COMMAND$))
cli$=Upper$(cli$)
cliPos = 1
cliLen = LEN(cli$)
intoken = %False
argCount = 0
DO UNTIL cliPos > cliLen
    c$=MID$(cli$,cliPos,1)
    c = ASC(c$)
    IF c > blank THEN
        IF intoken = %True THEN
            arg$=arg$+c$
        ELSE
            intoken = %True
            INCR argCount
            arg$=c$
        END IF
    ELSE
        IF intoken = %True THEN
            intoken = %False
        END IF
    END IF
    INCR cliPos
LOOP
ArgC = argCount
END FUNCTION

'--------------------------------------------------------------------

FUNCTION ArgV$ (n)
IF n < 1 OR n > ArgC THEN
    ArgV$=""
    EXIT FUNCTION
END IF
blank=ASC(" ")
cli$=LTRIM$(RTRIM$(COMMAND$))
cli$=Upper$(cli$)
cliPos = 1
cliLen = LEN(cli$)
intoken = %False
argCount = 0
DO UNTIL cliPos > cliLen
    c$=MID$(cli$,cliPos,1)
    c = ASC(c$)
    IF c > blank THEN
        IF intoken = %True THEN
            arg$=arg$+c$
        ELSE
            intoken = %True
            INCR argCount
            IF argCount > n THEN
                EXIT DO
            END IF
            arg$=c$
        END IF
    ELSE
        IF intoken = %True THEN
            intoken = %False
        END IF
    END IF
    INCR cliPos
LOOP
ArgV$ = arg$
END FUNCTION

'--------------------------------------------------------------------

SUB ParseCLI (cmd,f$)
n=ArgC
IF n = 0 THEN
    ERROR %eUsage
END IF

cmd=%cmdNone
f$=""

FOR i = 1 TO n
    parm$=ArgV$(i)
    first$=LEFT$(parm$,1)
    IF first$="-" OR first$="/" THEN
        opt$=MID$(parm$,2)
        SELECT CASE opt$
        CASE "?","H"
            IF n > 1 THEN ERROR %eTooMany
            ERROR %eUsage
        CASE "TSR","R"
            IF cmd <> %cmdNone THEN ERROR %eConflict
            cmd = %cmdTSR
        CASE "UNLOAD","U"
            IF n > 1 THEN ERROR %eTooMany
            cmd = %cmdUnload
        CASE "ON","Y"
            IF n > 1 THEN ERROR %eTooMany
            cmd = %cmdOn
        CASE "OFF","N"
            IF n > 1 THEN ERROR %eTooMany
            cmd = %cmdOff
        CASE "STATUS","S"
            IF n > 1 THEN ERROR %eTooMany
            cmd = %cmdStatus
        CASE ELSE
            errinfo$=parm$
            ERROR %eUnknown
        END SELECT
    ELSE
        IF f$<>"" THEN ERROR %eNotUnique
        IF parm$="?" THEN ERROR %eUsage
        f$=parm$
    END IF
NEXT
IF cmd= %cmdNone THEN ERROR %eMissingCmd
IF cmd= %cmdTSR THEN
    IF f$="" THEN f$=DefaultFile$
    IF INSTR(f$,"*") > 0 OR INSTR(f$,"?") > 0 THEN ERROR %eJoker
    IF INSTR(f$,".") = 0 THEN
        f$ = f$+DefaultExtension$
    END IF
    IF TALLY (f$,".") > 1 THEN ERROR %eBadName
    errinfo$=f$
    IF LEN(DIR$(f$)) = 0 THEN ERROR %eNotFound
END IF
END SUB

'--------------------------------------------------------------------

FUNCTION EMSHere
REG %AX, &H35*%hi+&H67 ' get int 67h address
CALL INTERRUPT %Dos
DriverSegment??=REG(%ES)
DEF SEG = DriverSegment??
DriverName$=PEEK$(&H00+&H0A,8) ' name at offset $0A
DEF SEG
IF DriverName$="EMMXXXX0" THEN
    EMSHere = %True
ELSE
    EMSHere = %False
END IF
END FUNCTION

'--------------------------------------------------------------------

FUNCTION EMSOK
REG %AX , &H40*%hi ' get status
CALL INTERRUPT %EMS
rc?? = REG(%AX)
IF (rc?? \ %hi) = &H00 THEN
    EMSOK = %True
ELSE
    EMSOK = %False
END IF
END FUNCTION

'--------------------------------------------------------------------

FUNCTION GetFreeEMS???
IF EMSOK = %False THEN ERROR %ePbEMS
REG %AX , &H42*%hi ' get # of pages
CALL INTERRUPT %EMS
rc?? = REG(%AX)
IF (rc \ %hi) = &H00 THEN
    GetFreeEMS??? = REG(%BX) * %EMSPage
ELSE
    GetFreeEMS??? = 0
END IF
END FUNCTION

'--------------------------------------------------------------------

SUB LoadTokens(f$,num)
hnd = FREEFILE
num=%MinToken
attr=%weird
OPEN "I",#hnd,f$
size???=LOF(hnd)
SELECT CASE size???
CASE < %MinSize
    CLOSE #hnd
    ERROR %eFileTooSmall
CASE > %MaxSize
    CLOSE #hnd
    ERROR %eFileTooBig
CASE ELSE
    LINE INPUT #hnd,li$
    li$=LTRIM$(RTRIM$(li$))
    IF UCASE$(li$) <> UCASE$(ID$) THEN
        CLOSE #hnd
        ERROR %eMissingID
    END IF
    fRemark     = %False ' init flags
    fConstant   = %False
    fString     = %False
    fTyped      = %False
    fDefault    = %False
    fValue      = %False                    ' v1.2
    DO UNTIL EOF(hnd) OR num > (%MaxToken+1)
        LINE INPUT #hnd,li$
        REPLACE CHR$(9) WITH " " IN li$     ' remove tabs
        li$=LTRIM$(RTRIM$(li$)) ' just in case...
        orgli$=li$
        li$=UCASE$(li$)         ' case insensitive
        first$=LEFT$(li$,1)
        SELECT CASE first$
        CASE "",";"
                                ' ignore empty line and comment
        CASE "<"
            IF attr=%weird THEN
                CLOSE #hnd
                ERROR %eNeedColor
            END IF
            If IsDirective (li$,attr) = %False THEN
                CLOSE #hnd
                errinfo$=orgli$
                ERROR %eBadDirective
            END IF
        CASE "[","#"
            li$=MID$(li$,2)     ' strip delimiter
            attr = GetInkPaper(li$)
            IF attr=%weird THEN
                CLOSE #hnd
                errinfo$=orgli$
                ERROR %eBadColor
            END IF
        CASE ELSE
            IF attr=%weird THEN
                CLOSE #hnd
                ERROR %eNeedColor
            END IF
            IF INSTR(li$," ") > 0 THEN
                CLOSE #hnd
                errinfo$=li$
                ERROR %eBadToken
            END IF
            IF INSTR(li$,DoubleQuote$) > 0 THEN
                CLOSE #hnd
                errinfo$=li$
                ERROR %eDelimiter
            END IF
            IF INSTR(li$,SingleQuote$) > 0 THEN
                CLOSE #hnd
                errinfo$=li$
                ERROR %eDelimiter
            END IF
            IF INSTR(li$,ANY Delimiters$) > 0 THEN
                CLOSE #hnd
                errinfo$=li$
                ERROR %eDelimiter
            END IF
            IF li$=RemReserved$ THEN
                CLOSE #hnd
                errinfo$=li$
                ERROR %eRemReserved
            END IF
            IF li$="ZDF" THEN ' private joke
                CLOSE #hnd
                errinfo$=li$
                ERROR %ePrivate
            END IF
            ARRAY SCAN TokenStr(%MinToken) FOR (num-1), = li$, TO duplicate
            IF duplicate > 0 THEN
                CLOSE #hnd
                errinfo$=li$
                ERROR %eDuplicate
            END IF
            TokenStr(num)=li$
            TokenAttr(num)=attr
            INCR num
        END SELECT
    LOOP
    CLOSE #hnd
END SELECT
IF num = %MinToken THEN ERROR %eTooFewTokens
IF num > (%MaxToken+1) THEN ERROR %eTooManyTokens
ARRAY SORT TokenStr(%MinToken) FOR (num-1), TAGARRAY TokenAttr()
END SUB

'--------------------------------------------------------------------

FUNCTION GetInkPaper (l$)
attribute = %weird ' the worse *may* happen !
l$ = REMOVE$(l$," ")
ink=GetColor(l$)
IF ink < (%MaxColor+1) THEN
    IF LEFT$(l$,2) = "ON" THEN
        l$=MID$(l$,3)
        paper=GetColor(l$)
        IF paper < (%MaxColor \2 +1) THEN ' paper can only be $00..$07 !
            IF ink <> paper THEN
                c$=LEFT$(l$,1)
                IF c$ = "" OR c$="]" OR c$=";" THEN
                    attribute = paper * &H10 + ink
                END IF
            END IF
        END IF
    END IF
END IF
GetInkPaper=attribute
END FUNCTION

'--------------------------------------------------------------------

FUNCTION GetColor (l$)
STATIC TxtColor$()
DIM STATIC TxtColor$(%MinColor:%MaxColor)
IF TxtColor$(%MinColor)<>"BLACK" THEN
    RESTORE txtcolors
    FOR i = %Mincolor TO %MaxColor
        READ t$
        t$=UCASE$(t$)
        TxtColor$(i)=t$
    NEXT
txtcolors:
    DATA "black","blue","green","cyan"
    DATA "red","magenta","brown","white"
    DATA "grey","lightblue","lightgreen","lightcyan"
    DATA "lightred","lightmagenta","yellow","brightwhite"
END IF
i=%MinColor
DO UNTIL i > %MaxColor
    txt$=TxtColor$(i)
    lentxt=LEN(txt$)
    t$=LEFT$(l$,lentxt)
    IF t$=Txt$ THEN EXIT LOOP
    INCR i
LOOP
l$=MID$(l$,lentxt+1)
GetColor = i
END FUNCTION

'--------------------------------------------------------------------

FUNCTION IsDirective (l$,currattr)
flag=%True
SELECT CASE l$
CASE "<REMARK>"         ' must be already in upper case
    fRemark=%True
    colorRemark = currattr
CASE "<CONSTANT>"
    fConstant=%True
    colorConstant = currattr
CASE "<STRING>"
    fString=%True
    colorString = currattr
CASE "<TYPED>"
    fTyped=%True
    colorTyped = currattr
CASE "<DEFAULT>"
    fDefault=%True
    colorDefault = currattr
CASE "<NUMBER>"              ' v1.2V
    fValue=%True
    colorValue = currattr   ' v1.2^
CASE ELSE
    flag=%False
END SELECT
IsDirective = flag
END FUNCTION

'--------------------------------------------------------------------

FUNCTION IsMono
IF BIT (pbvScrnCard,0) = 0 THEN
    IsMono = %False
ELSE
    IsMono = %True
END IF
END FUNCTION

'--------------------------------------------------------------------

FUNCTION IsHerc
IF BIT (pbvScrnCard,6) = 0 THEN
    IsHerc = %False
ELSE
    IsHerc = %True
END IF
END FUNCTION

'--------------------------------------------------------------------

FUNCTION BoolToStr$ (flag)
IF flag = %True THEN
    BoolToStr$="Enabled"
ELSE
    BoolToStr$="Disabled"
END IF
END FUNCTION

'--------------------------------------------------------------------

SUB Banner (f$,numkeywords,flagactive)
stdoutln Program$+Version$+Copyright$
stdoutln ""
stdoutln "Program currently  : "+BoolToStr$(flagactive)
stdoutln "Popup interval     :"+str$(%PopInterval)+" (unit = 1/18.2 second)"
stdoutln "Definition file    : "+f$
stdoutln "Number of keywords :"+str$(numkeywords-1)
stdoutln "Remarks            : "+BoolToStr$(fRemark)
stdoutln "Constants          : "+BoolToStr$(fConstant)
stdoutln "Strings            : "+BoolToStr$(fString)
stdoutln "Numbers            : "+BoolToStr$(fValue)      ' v1.2
stdoutln "Typed variables    : "+BoolToStr$(fTyped)
stdout   "Default color      : "+BoolToStr$(fDefault)
END SUB

'--------------------------------------------------------------------

SUB GetScreenDimensions (ncols,nrows)
ncols=pbvScrnCols
nrows=pbvScrnRows
IF pbvScrnCard AND &B00101100 <> 0 THEN ' give chance to vga/ega/ega
    DEF SEG=&H40
    ncols=PEEK(&H4A)+PEEK(&H4B)* %hi ' ega and better
    nrows=PEEK(&H84)+1
    DEF SEG
END IF
END SUB

'--------------------------------------------------------------------

TYPE ScreenCell
    char AS BYTE
    attr AS BYTE
END TYPE

SUB ProcessScreen (flag,maxndx)
IF flag = %False THEN EXIT SUB      ' disabled
IF pbvScrnMode <> 0 THEN EXIT SUB   ' only mode 0, don't care about mode 7
CALL GetScreenDimensions (numcols,numrows)
IF numcols <> 80 THEN EXIT SUB      ' better safe than sorry!
DIM ScrnBuffer(1:numcols,1:numrows) AS ScreenCell AT &HB800

ThisEditor = %editorNone            ' v1.3 from here
'
' BEGIN CHECK FOR POWERBASIC EDITOR
'
' Ĵrrrrr:ccc
' 1.3.....9.....
'
FirstCol=2
LastCol=numcols-1
FirstRow=3                          ' PB edit window begins at x=2, y=3
LastRow=FirstRow
DO
    IF NOT (LastRow < numrows) THEN EXIT LOOP ' status line hit so abort
    IF ScrnBuffer(1,LastRow).char = &HC0 THEN
        IF ScrnBuffer(3,LastRow).char = &HB4 THEN
            IF ScrnBuffer(9,LastRow).char = &H3A THEN
                ThisEditor = %editorPB31
                DECR LastRow                  ' one line up
            END IF
        END IF
        EXIT LOOP
    END IF
    INCR LastRow
LOOP
'
' END CHECK FOR POWER BASIC EDITOR
'
IF ThisEditor = %editorNone THEN
'
' BEGIN CHECK FOR NORTON EDITOR
'
FirstCol=1
LastCol=numcols-1
FirstRow=2
LastRow=FirstRow
DO
    IF NOT (LastRow < numrows) THEN EXIT LOOP ' status line hit so abort
    IF ScrnBuffer(80,LastRow).char = &H19 THEN            ' down arrow
        IF ScrnBuffer(80,FirstRow).char = &H18 THEN       ' up arrow
            IF ScrnBuffer(79,LastRow+1).char = &H1A THEN  ' right arrow
                ThisEditor = %editorNE20
            END IF
       END IF
       EXIT LOOP
    END IF
    INCR LastRow
LOOP
'
' END CHECK FOR NORTON EDITOR
'
END IF
'
IF ThisEditor = %editorNone THEN ' v1.4 begins here
'
' BEGIN CHECK FOR PDS EDITOR
'
FirstCol=2
LastCol=numcols-1
FirstRow=3
LastRow=FirstRow
DO
    IF NOT (LastRow < numrows) THEN EXIT LOOP ' status line hit so abort
    IF ScrnBuffer(80,LastRow).char = &H19 THEN            ' down arrow
        IF ScrnBuffer(80,FirstRow).char = &H18 THEN       ' up arrow
            IF ScrnBuffer(79,LastRow+1).char = &H1A THEN  ' right arrow
                ThisEditor = %editorPDS71
            END IF
       END IF
       EXIT LOOP
    END IF
    INCR LastRow
LOOP
'
' END CHECK FOR PDS EDITOR
'
END IF                     ' v1.4 ends here
'
IF ThisEditor = %editorNone THEN EXIT SUB ' v1.3 ends here
'
' the following code is slow but seems to be ok : good candidate for ASM !
'

$IF %Debug
starttime##=TIMER
$ENDIF

FOR y = FirstRow TO LastRow
    Word$=""
    x = FirstCol
    DO WHILE NOT (x > LastCol)              ' glad last col is always a space!
        c$=CHR$(ScrnBuffer(x,y).char)
        IF INSTR(Delimiters$,c$) > 0 THEN
            c$=" "
        END IF
        SELECT CASE c$
        CASE " "                            ' delimiter
            IF fDefault = %True THEN
                ScrnBuffer(x,y).attr=colorDefault
            END IF
            IF Word$<>"" THEN
                Word$=UCASE$(Word$)
                IF Word$=RemReserved$ THEN
                    x = x-LEN(RemReserved$) ' should be 3!
                    DO WHILE NOT (x > LastCol)
                        IF fRemark = %True THEN
                            ScrnBuffer(x,y).attr=colorRemark
                        END IF
                        INCR x
                    LOOP
                ELSE
                    attr=%weird             ' flag
            ' v1.0 : ARRAY SCAN TokenStr(%MinToken) FOR (maxndx-1),=Word$,TO ndx
            ' v1.1 begins here
                    firstchar$=LEFT$(Word$,1)
                    firstcode=ASCII(firstchar$)     ' ASC would work too! ;-)
                    IF firstcode < %CodeA THEN
                        ptr=%MinLetter              ' <"A"
                    ELSEIF firstcode > %CodeZ THEN
                        ptr=%MaxLetter              ' >"Z"
                    ELSE
                        ptr=firstcode-%CodeA+1      ' "A".."Z"
                    END IF
                    count=TokenCount(ptr)
                    IF count > 0 THEN
                        firstToken=TokenOffset(ptr)
                        ARRAY SCAN TokenStr(firstToken) FOR (count),=Word$,TO ndx
                        IF ndx > 0 THEN             ' ndx is relative here
                            ndx=ndx+firstToken-1
                        END IF
                    ELSE
                        ndx=0
                    END IF
            ' v1.1 ends here
                    IF ndx > 0 THEN
                        attr=TokenAttr(%MinToken+ndx-1)
                    ELSE                    ' definition file takes precedence
                        IF LEFT$(Word$,1) = "%" THEN
                            IF fConstant = %True THEN
                                attr = colorConstant
                            END IF
                        ELSEIF INSTR("%&!#$@?",RIGHT$(Word$,1)) > 0 THEN
                            IF fTyped = %True THEN
                                attr = colorTyped
                            END IF
                        ELSEIF INSTR("&0123456789",LEFT$(Word$,1)) > 0 THEN ' v1.2V
                            IF fValue = %True THEN
                                attr = colorValue
                            END IF                                          ' v1.2^
                        END IF
                    END IF
                    IF attr <> %weird THEN
                        prevx=x-LEN(Word$)
                        FOR i=prevx TO (x-1)
                            ScrnBuffer(i,y).attr=attr
                        NEXT
                    ELSE
                        prevx=x-LEN(Word$)
                        FOR i=prevx TO (x-1)
                            IF fDefault = %True THEN
                                ScrnBuffer(i,y).attr=colorDefault
                            END IF
                        NEXT
                    END IF
                    Word$=""
                    INCR x
                END IF
            ELSE
                INCR x
            END IF
        CASE DoubleQuote$                   ' string
            DO
                IF fString = %True THEN
                    ScrnBuffer(x,y).attr =colorString
                END IF
                INCR x
                IF x > LastCol THEN
                    EXIT LOOP
                END IF
                IF CHR$(ScrnBuffer(x,y).char) = DoubleQuote$ THEN
                    IF fString = %True THEN
                        ScrnBuffer(x,y).attr =colorString
                    END IF
                    INCR x
                    EXIT LOOP
                END IF
            LOOP
            Word$=""
        CASE SingleQuote$                   ' remark
            DO WHILE NOT (x > LastCol)
                IF fRemark = %True THEN
                    ScrnBuffer(x,y).attr=colorRemark
                END IF
                INCR x
            LOOP
        CASE ELSE
            Word$=Word$+c$
            INCR x
        END SELECT
    LOOP
NEXT
ERASE ScrnBuffer    ' v1.1 seems useless here but no speed gain from REMing

$IF %Debug
endtime##=TIMER
n=FREEFILE
OPEN "A",#n,"hilite.log"
PRINT #n,(endtime##-starttime##)*1000
CLOSE #n
$ENDIF

END SUB

'--------------------------------------------------------------------

SUB IndexTokens(num)
DIM LetterCount(0:255)
FOR i = 0 TO 255
    LetterCount(i)=0
NEXT
offset=%MinToken
DO WHILE offset < num

$IF %Debug
PRINT offset,TokenStr(offset)
$ENDIF

    c$=LEFT$(TokenStr(offset),1)
    c=ASC(c$)
    INCR LetterCount(c)
    INCR offset
LOOP
beforeSum=0
FOR i = 0 TO (%CodeA-1)
    beforeSum=beforeSum+LetterCount(i)
NEXT
afterSum=0
FOR i = (%CodeZ+1) TO 255
    afterSum=afterSum+LetterCount(i)
NEXT
TokenCount(%MinLetter)=beforeSum
TokenCount(%MaxLetter)=afterSum
FOR i = %MinLetter+1 TO %MaxLetter-1
    TokenCount(i)=LetterCount(i+%CodeA-1)
NEXT
curroffset=%MinToken
FOR i = %MinLetter TO %MaxLetter
    count=TokenCount(i)
    IF count <> 0 THEN
        TokenOffset(i)=curroffset   ' sum of previous counts
    END IF
    curroffset=curroffset+count     ' update now
NEXT

$IF %Debug
FOR i = %MinLetter TO %MaxLetter
    PRINT i,CHR$(i+%CodeA-1),TokenCount(i),TokenOffset(i)
NEXT
$ENDIF

ERASE LetterCount
END SUB

'--------------------------------------------------------------------

DECLARE SUB GetStrLoc() ' PowerBasic runtime library

SUB StdOut ( BYVAL Text AS STRING )
! push DS                    ; save DS FOR PowerBASIC
! push WORD Ptr Text         ; push STRING handle ON stack
! CALL GetStrLoc
! jcxz ExitStdOut
! mov  DS, DX
! mov  DX, AX
! mov  AH, &H40              ; DOS WRITE TO file
! mov  BX, 1                 ; file handle 1 is CONS
! INT  &H21
ExitStdOut:
! pop  DS
END SUB

SUB StdOutLn( BYVAL s as string )
CALL StdOut (s + CHR$(13, 10) )
END SUB

