(* ---------------------------------------------------------------
Title         see help
Overview      see help
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              we have to lower threshold in project so that arrays fit
              ah, "clever" dynamic allocation instead of good old arrays
              makes program SEVEN times SLOWER !
              we use SHA-1 here
Bugs
Wish List     better sort but who cares ?
              @sorted file with arg/slice spec ?

--------------------------------------------------------------- *)

MODULE ProcDups;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT SYSTEM;
IMPORT IO;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available;

FROM QD_CRC IMPORT ComputeCRC32, ComputeCRCval, setSigmaUse,
SegmentFileComputeCRC32;

FROM QD_MD5 IMPORT MD5str, MD5digestType,
MD5toString, stringToMD5, ComputeMD5;

FROM QD_SHA IMPORT SHAstr, SHAdigestType,
SHAtoString, stringToSHA, ComputeSHA;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

(* ------------------------------------------------------------ *)

TYPE
    pathtype = path9X;

CONST
    cr              = CHR(13);
    lf              = CHR(10);
    nl              = cr+lf;
    dot             = ".";
    coma            = ",";
    space           = " ";
    blank           = space;
    backslash       = "\";
    netslash        = backslash+backslash;
    parentdir       = dot+dot;
    colon           = ":";
    dquote          = '"';
    dollar          = "$";
    stardotstar     = "*.*";
    nullchar        = 0C;
    (* sigma           = CHR(228); *)
    sigma           = "sigma";
    echoON          = "@ECHO ON";
    echoOFF         = "@ECHO OFF";
    cmdDEL          =  "DEL";
    cmdCOPY         = "COPY";
    cmdMOVE         = "MOVE";
    cmdLIST         = "LIST";
    cmdECHO         = "ECHO";
    cmdKILL         = "KILL"; (* NOT a DOS command ! *)
    extBAT          = ".BAT";
    batchSuffix     = "THEM.BAT"; (* ????THEM.BAT *)
    sREM            = "REM Keeping ";
    uniquemark      = "  "; (* exactly two chars *)
    anchormark      = "!!";
    idmark          = "==";
CONST
    progEXEname     = "PROCDUPS";
    progTitle       = "Q&D Process duplicate files";
    progVersion     = "v1.2d";
    progCopyright   = "by PhG";
    banner          = progTitle+" "+progVersion+" "+progCopyright;

CONST
    errNone         = 0;
    errHelp         = 1;
    errOption       = 2;
    errTooManySpex  = 3;
    errNotFound     = 4;
    errTooMany      = 5;
    errMissingSource= 6;
    errExclusive    = 7;
    errNonsense     = 8;
    errBadSpec      = 9;
    errNotWithOld   = 10;
    errThereCANTbeOnlyOne=11;
    errMethod       = 12;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax : "+progEXEname+" <specification>... [option]..."+nl+
nl+
"  -q    quicker check using filesize, CRC32 and CRC32"+sigma+" (default is MD5)"+nl+
"  -s    safest and slowest check using SHA-1 (default is MD5)"+nl+
"  -t    terse mode"+nl+
"  -e    force "+echoOFF+" in batch file (default is "+echoON+")"+nl+
"  -del  immediately delete duplicates without creating "+cmdDEL+batchSuffix+" batch file"+nl+
"  -r    delete read-only files (provided -d was specified)"+nl+
"  -a    take hidden and system files into account"+nl+
"  -k    create "+cmdKILL+batchSuffix+" batch file, using "+cmdDEL+" command"+nl+
"  -c    create "+cmdCOPY+batchSuffix+" batch file, using "+cmdCOPY+" command"+nl+
"  -m[$] create "+cmdMOVE+batchSuffix+" batch file, using "+cmdMOVE+" command"+nl+
"  -l[?] create "+cmdLIST+batchSuffix+" batch file, using "+cmdECHO+" command (-e forced)"+nl+
"        (-lu = uniques, -lr = references, -ld = duplicates, -ll = -lr -ld)"+nl+
"  -u    display filenames in uppercase (LFNs are not affected)"+nl+
"  -o    do not try and favor first specification"+nl+
"  -x    disable LFN support even if available (result replacement ONLY !)"+nl+
nl+
"a) This command creates a batch file to delete/copy/move duplicate files."+nl+
"b) Even if LFN support is available, <specification> MUST be in f8e3 DOS form."+nl+
"c) Default is to delete duplicates except one copy of each unique file,"+nl+
"   while -k, -c and -m[$] options process all duplicates."+nl+
'd) -l option lists all files ("'+anchormark+'" = reference duplicate, "'+idmark+'" = duplicate).'+nl+
"e) If LFN support is available, and if -x option was NOT specified,"+nl+
"   program will replace each f8e3 DOS result with its matching LFN form"+nl+
"   (LFN form will be automagically delimited with double quotes)."+nl+
'f) As of v1.2, program is seven times slower due to "modern" dynamic storage.'+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManySpex:
        S := "Too many file specifications !";
    | errNotFound:
        S := "No file matches specification(s) !";
    | errTooMany:
        S := "Storage.ALLOCATE() failure while processing ~ ! ";
        Str.Subst(S,"~",einfo);
    | errMissingSource:
        S := "Missing <specification1 [specification2]> !";
    | errExclusive:
        S := "-k, -c, -m[$] and -l[?] options are mutually exclusive !";
    | errNonsense:
        S := "-d option excludes -k, -c, -m[$] and -l[?] options !";
    | errBadSpec:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," specification !");
    | errNotWithOld:
        S := "-l[?] and -o options are mutually exclusive !";
    | errThereCANTbeOnlyOne:
        S := "Only one file matches specification(s) !";
    | errMethod:
        S := "-s and -$ options are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp: ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferOut : ioBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    IamUnique    = 0; (* therefore, firstFile must be > 0 ! *)
    IamReference = MAX(CARDINAL);
    firstFile    = 1; (* 1..count *)
TYPE
    chkmethodtype = (useCRC,useMD5,useSHA);
    fileinfotype = RECORD
        CASE : CARDINAL OF
        | 0:
            fsize       : LONGCARD;
            fCRC32      : LONGCARD;
            fCRC32sigma : LONGCARD;
            zeroeddummy1: LONGCARD; (* 4 bytes for md5 pad structure, done by compiler to biggest structure anyway *)
            zeroeddummy2: LONGCARD; (* 4 bytes for sha *)
        | 1:
            fdigest     : MD5digestType; (* 16 bytes *)
            zeroeddummy : LONGCARD;
        | 2:
            zdigest     : SHAdigestType;; (* 20 bytes *)
        END;
    END;
TYPE
    pEntry = POINTER TO entryType;
    entryType = RECORD
        next      : pEntry;
        index     : CARDINAL;     (* 1.. for sort *)
        basendx   : CARDINAL;     (* baseArray : index of basedir *)
        tag       : CARDINAL;     (* tagArray *)
        info      : fileinfotype; (* infoArray *)
        slen      : SHORTCARD;
        str       : CHAR;         (* fileArray *)
    END;

VAR
    fileanchor : pEntry; (* global because of QSort constraints *)

PROCEDURE initList (VAR anchor : pEntry );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pEntry);
VAR
    needed : CARDINAL;
    p      : pEntry;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(entryType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewEntryPtr (VAR anchor,p:pEntry; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(entryType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewEntryPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : ARRAY OF CHAR; p:pEntry);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

PROCEDURE findByIndex(anchor:pEntry;n:CARDINAL):pEntry;
VAR
    p:pEntry;
BEGIN
    p := anchor;
    LOOP
        IF p = NIL THEN EXIT;END; (* gloups ! should NEVER happen ! *)
        IF p^.index = n THEN EXIT; END;
        p := p^.next;
    END;
    RETURN p;
END findByIndex;

PROCEDURE buildList (VAR anchor:pEntry; VAR lastFile: CARDINAL; ndx:CARDINAL;
                     hiddensystem : BOOLEAN;spec:ARRAY OF CHAR):BOOLEAN;
VAR
    (* countFile : CARDINAL; *)
    found     : BOOLEAN;
    entry     : FIO.DirEntry;
    attr      : FIO.FileAttr;
    len:CARDINAL;
    pp:pEntry;
    N:str16; (* oversized f8e3 *)
BEGIN
    CASE hiddensystem OF
    |FALSE: attr := FIO.FileAttr{aR,aA};
    |TRUE:  attr := allfiles;
    END;
    found := FIO.ReadFirstEntry(spec,attr,entry);
    WHILE found DO
        Str.Copy(N,entry.Name);
        IF Str.RCharPos(N,dot)=MAX(CARDINAL) THEN Str.Append(N,dot);END;
        len:=Str.Length(N);
        IF buildNewEntryPtr(anchor,pp,len)=FALSE THEN RETURN FALSE;END;
        INC(lastFile);
        pp^.basendx:= ndx;
        pp^.index  := lastFile;
        pp^.slen   := SHORTCARD(len);
        Lib.FastMove ( ADR(N),ADR(pp^.str),len );
        found :=FIO.ReadNextEntry(entry);
    END;
    RETURN TRUE;
END buildList;

PROCEDURE dmpEntries (anchor:pEntry;wantedbasendx:CARDINAL;base:ARRAY OF CHAR);
VAR
    p : pEntry;
    S,R:str128;
    basendx:CARDINAL;
BEGIN
    p:=anchor;
    WHILE p # NIL DO
        basendx:=p^.basendx;
        IF basendx = wantedbasendx THEN
            WrStr("index="); IO.WrCard(p^.index,5);
            WrStr("  basendx=");IO.WrCard(basendx,5);
            WrStr("  path=");
            getStr(R,p);
            Str.Prepend(R,base);
            WrStr(R);WrLn;
        END;
        p:=p^.next;
    END;
END dmpEntries;

(* ------------------------------------------------------------ *)

PROCEDURE doswap (i,j:CARDINAL);
VAR
    pi,pj:pEntry;
    tmp:CARDINAL;
BEGIN
    pi:=findByIndex(fileanchor,i);
    pj:=findByIndex(fileanchor,j);
    tmp:=pi^.index;
    pi^.index:=pj^.index;
    pj^.index:=tmp;
END doswap;

PROCEDURE dolessSizeCRCs (i,j:CARDINAL ):BOOLEAN ;
VAR
    pi,pj:pEntry;
BEGIN
    pi:=findByIndex(fileanchor,i);
    pj:=findByIndex(fileanchor,j);

    IF pi^.info.fsize       < pj^.info.fsize       THEN RETURN TRUE; END;
    IF pi^.info.fCRC32sigma < pj^.info.fCRC32sigma THEN RETURN TRUE; END;
    IF pi^.info.fCRC32      < pj^.info.fCRC32      THEN RETURN TRUE; END;
    RETURN FALSE;
END dolessSizeCRCs;

PROCEDURE dolessMD5 (i,j:CARDINAL ):BOOLEAN ;
VAR
    pi,pj:pEntry;
    sI,sJ:MD5str;
BEGIN
    pi:=findByIndex(fileanchor,i);
    pj:=findByIndex(fileanchor,j);

    MD5toString(sI,pi^.info.fdigest);
    MD5toString(sJ,pj^.info.fdigest);
    RETURN (Str.Compare(sI,sJ) < 0) ;
END dolessMD5;

PROCEDURE dolessSHA (i,j:CARDINAL ):BOOLEAN ;
VAR
    pi,pj:pEntry;
    sI,sJ:SHAstr;
BEGIN
    pi:=findByIndex(fileanchor,i);
    pj:=findByIndex(fileanchor,j);

    SHAtoString(sI,pi^.info.zdigest);
    SHAtoString(sJ,pj^.info.zdigest);
    RETURN (Str.Compare(sI,sJ) < 0) ;
END dolessSHA;

(* ------------------------------------------------------------ *)

PROCEDURE fmtSize (v : LONGCARD; pad:CHAR; sep:CHAR) : str16;
CONST
    field = 10+3; (* #,###,###,### *) (* 1Gb+ file okay now *)
VAR
    S,R   : str16;
    len,i : CARDINAL;
    ok  : BOOLEAN;
    ch  : CHAR;
BEGIN
    Str.CardToStr(v,S,10,ok ); (* Str.FixRealToStr( LONGREAL(v),0,S,ok); was overkill *)
    len:=Str.Length(S);
    R := "";
    FOR i := 1 TO len DO
        Str.Prepend(R,S[len-i]);
        IF i < len THEN
            IF (i MOD 3) = 0 THEN
                Str.Prepend(R,sep);
            END;
        END;
    END;
    LOOP
        IF INTEGER(Str.Length(R)) >= ABS(field) THEN EXIT; END;
        IF field < 0 THEN
            Str.Append(R,pad);  (* right alignment *)
        ELSE
            Str.Prepend(R,pad);
        END;
    END;
    RETURN R;
END fmtSize;

PROCEDURE fmtCRC (v : LONGCARD;pad:CHAR) : str16;
CONST
    digits=8;
VAR
    S   : str16;
    ok  : BOOLEAN;
    len : CARDINAL;
BEGIN
    Str.CardToStr(v,S,16,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    Str.Lows(S);
    Str.Prepend(S,dollar);
    RETURN S;
END fmtCRC;

PROCEDURE fmtfileinfo (useLFN,uppercase,unique,killit:BOOLEAN;
                      chkmethod:chkmethodtype;current:fileinfotype;
                      S:ARRAY OF CHAR;
                      VAR R : str1024);
CONST
    separ        = "  ";

    separunique  = " "+uniquemark+" ";
    separanchor  = " "+anchormark+" ";
    separid      = " "+idmark    +" ";
VAR
    hash:MD5str;
    haSHA:SHAstr;
    taille,crc,crcalt:str16;
    shortform,longform:pathtype;
    rc:CARDINAL;
BEGIN
    IF uppercase=FALSE THEN LowerCase(S);END;
    CASE chkmethod OF
    | useSHA:
        SHAtoString(haSHA,current.zdigest); (* already lowercase *)
        Str.Concat(R,dollar,haSHA);
    | useMD5:
        MD5toString(hash,current.fdigest); (* already lowercase *)
        Str.Concat(R,dollar,hash);
    | useCRC:
        taille:= fmtSize (current.fsize, " " , coma);
        crc   := fmtCRC  (current.fCRC32,"0");
        crcalt:= fmtCRC  (current.fCRC32sigma,"0");
        Str.Concat(R,taille,separ);
        Str.Append(R,crc);
        Str.Append(R,separ);
        Str.Append(R,crcalt);
    END;

    IF killit THEN (* first to be tested ! *)
        Str.Append(R,separid);
    ELSE
        IF unique THEN
            Str.Append(R,separunique);
        ELSE
            Str.Append(R,separanchor);
        END;
    END;
    IF useLFN THEN
        Str.Copy(shortform,S);
        IF w9XshortToLong(shortform,rc,longform) THEN
            Str.Append(R,dquote);
            Str.Append(R,longform);
            Str.Append(R,dquote);
        ELSE
            Str.Append(R,shortform);
        END;
    ELSE
        Str.Append(R,S);
    END;
END fmtfileinfo;

PROCEDURE fmtpath ( useLFN:BOOLEAN;S:ARRAY OF CHAR; VAR R:str1024);
VAR
    rc:CARDINAL;
    shortform,longform:pathtype;
BEGIN
    IF useLFN THEN
        Str.Copy(shortform,S);
        IF w9XshortToLong(shortform,rc,longform) THEN
            Str.Copy(R,dquote);
            Str.Append(R,longform);
            Str.Append(R,dquote);
        ELSE
            Str.Copy(R,shortform);
        END;
    ELSE
        Str.Copy(R,S);
    END;
END fmtpath;

(* ------------------------------------------------------------ *)

PROCEDURE buildParent (VAR parent:ARRAY OF CHAR; current:ARRAY OF CHAR):BOOLEAN;
VAR
    p:CARDINAL;
BEGIN
    IF Str.Match(current,"\") THEN RETURN FALSE; END;
    unfixDirectory(current);
    p:=Str.RCharPos(current,"\");
    Str.Slice(parent,current,0,p+1); (* keep final "\" *)
    RETURN TRUE;
END buildParent;

(*
   handle file and dir specs
   fix common cases  : "." -- ".." -- "*\" -- "\*.*"
*)

PROCEDURE chkAndFixSpec (defaultdir,orgspec:ARRAY OF CHAR;
                         VAR newspec,newbase:ARRAY OF CHAR):BOOLEAN;
VAR
    spec,u,d,n,e:str128; (* "u:" "\*\" "*" "*" -- extension has no dot *)
    parent:str128;
BEGIN
    Str.Copy(spec,orgspec);
    IF Str.Pos(spec,netslash) # MAX(CARDINAL) THEN RETURN FALSE; END;
    IF same(spec,dot) THEN Str.Copy(spec,stardotstar);END;
    IF same(spec,parentdir) THEN
        IF buildParent(parent,defaultdir)=FALSE THEN RETURN FALSE; END;
        Str.Copy(spec,parent);
    END;
    IF Str.Match(spec,"*\") THEN Str.Append(spec,stardotstar);END;

    CASE CharCount(spec,colon) OF
    | 0 : ;
    | 1 : IF Str.CharPos(spec,colon) # 1 THEN RETURN FALSE; END; (* only "?:*" allowed *)
    ELSE
        RETURN FALSE;
    END;

    IF Str.Match(spec,"?:\*") THEN
        ;
    ELSIF Str.Match(spec,"?:*") THEN (* same unit or nothing ! *)
        RETURN FALSE;
    ELSIF Str.Match(spec,"\*") THEN
        Str.Prepend(spec,colon);
        Str.Prepend(spec,defaultdir[0]);
    ELSE
        Str.Prepend(spec,defaultdir);
    END;

    IF chkJoker(spec)=FALSE THEN
        IF isDirectory(spec) THEN Str.Append(spec,backslash+stardotstar);END;
    END;

    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(newbase,u,d,"","");
    Lib.MakeAllPath(newspec,"","",n,e);
    RETURN TRUE;
END chkAndFixSpec;

(* ------------------------------------------------------------ *)

PROCEDURE canWrite (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF FIO.Exists(S)=FALSE THEN RETURN TRUE; END;
    RETURN isReadOnly(S);
END canWrite;

PROCEDURE killfile (killro,uppercase:BOOLEAN;S:ARRAY OF CHAR);
CONST
    msgDeleted = "Deleted : ";
    msgSkipped = "Skipped : ";
    msgDeletedRO="Erased  : ";
VAR
    R:str128;
BEGIN
    Str.Copy(R,S);
    IF uppercase=FALSE THEN LowerCase(R);END;

    IF canWrite(S) THEN
        FIO.Erase(S);
        WrStr(msgDeleted);
    ELSE
        IF killro THEN
            setReadWrite(S);
            FIO.Erase(S);
            WrStr(msgDeletedRO);
        ELSE
            WrStr(msgSkipped);
        END;
    END;
    WrStr(R);WrLn;
END killfile;

(* ------------------------------------------------------------ *)

PROCEDURE isUnique (anchor:pEntry;i,lastFile:CARDINAL):BOOLEAN;
VAR
    j:CARDINAL;
    pi,pj:pEntry;
BEGIN
    IF i < lastFile THEN
        j:=i+1; (* check next *)
    ELSE
        j:=i-1; (* check previous *)
    END;
    pi:=findByIndex(anchor,i);
    pj:=findByIndex(anchor,j);
    RETURN (pi^.info # pj^.info);
END isUnique;

(* ------------------------------------------------------------ *)

(* remember we'll perform more than one pass *)

PROCEDURE chkDuplicates (anchor:pEntry;ref,lastFile:CARDINAL;VAR dups:CARDINAL);
VAR
    refdata : fileinfotype;
    i:CARDINAL;
    pref,pi:pEntry;
BEGIN
    pref:=findByIndex(anchor,ref);
    refdata:=pref^.info;
    FOR i:=firstFile TO lastFile DO
        IF i # ref THEN
            pi:=findByIndex(anchor,i);
            IF pi^.info = refdata THEN
                INC(dups);
                CASE pi^.tag OF
                | IamUnique : (* liar ! eh eh ! ;-) *)
                    CASE pref^.tag OF
                    | IamReference:
                        pi^.tag:=ref;
                    | IamUnique:
                        pi^.tag:=ref;
                        pref^.tag:=IamReference;
                    ELSE
                        pi^.tag:=pref^.tag;
                    END;
                ELSE
                    ; (* already handled *)
                END;
            END;
        END;
    END;
END chkDuplicates;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstBase    = 1; (* we'll need -1 *)
    maxBase      = 10;
VAR
    spec         : ARRAY [firstBase..maxBase] OF str128;
    basepath     : ARRAY [firstBase..maxBase] OF str128;
    lastBase     : CARDINAL;
CONST
    steps        = 10;
    animcmd      = animSHOW;
    msgAnalyzing = "Retrieving file data, please wait... ";
    msgFiltering = "Filtering identical files, please wait...";
    msgNoDups    = "No duplicates found.";
    msgHeader    = "::: ";
VAR
    verbose,DEBUG,echoon,immediate,killro,hiddensystem,uppercase:BOOLEAN;
    chkmethod:chkmethodtype;
    useLFN,OLDMETHOD,dotest,dmp : BOOLEAN;
    lastFile,dups  : CARDINAL;
    hout          : FIO.File;
    currentdir : str128; (* oversized just in case *)
    currentry,portion,currportion,lastportion:CARDINAL;
    ref,current : fileinfotype;
    unique,killit:BOOLEAN;
    cmd : (sdel,scopy,smove,smovems,slist,skill);
    listmode:(all,uniques,references,duplicates,notuniques);
    scmd,scmdpostfix: str16;
    S0 : str128; (* same as S *)
    inf:str1024; (* was str128 -- now, we may contain fileinfo and LFN *)
    batchfile:str128;
    pp:pEntry;
VAR
    parmcount,i,opt : CARDINAL;
    S,R             : str128;
    state           : (waiting,gotspec);
BEGIN
    (* Lib.DisableBreakCheck(); *)
    FIO.IOcheck:=FALSE;
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)
    WrLn;

    getCurrentDirectory(currentdir); (* now ! *)

    DEBUG     := FALSE;
    verbose   := TRUE;
    echoon    := TRUE;
    immediate := FALSE;
    killro    := FALSE;
    hiddensystem:=FALSE;
    uppercase := FALSE;
    cmd       := sdel;
    OLDMETHOD := FALSE;
    useLFN    := TRUE;
    chkmethod := useMD5;
    lastBase  := firstBase-1;

    state     := waiting;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "T"+delim+"TERSE"+delim+
                                   "E"+delim+"ECHO"+delim+"ECHOON"+delim+
                                   "DEL"+delim+"DELETE"+delim+
                                   "R"+delim+"READONLY"+delim+
                                   "A"+delim+"ALLFILES"+delim+
                                   "U"+delim+"UPPERCASE"+delim+
                                   "C"+delim+"COPY"+delim+
                                   "M"+delim+"MOVE"+delim+
                                   "M$"+delim+"M$MOVE"+delim+"MS"+delim+"MSMOVE"+delim+
                                   "K"+delim+"KILL"+delim+"DELALL"+delim+
                                   "O"+delim+"OLD"+delim+"OLDER"+delim+"OBSOLETE"+delim+
                                   "L"+delim+"LIST"+delim+
                                   "LU"+delim+"UNIQUES"+delim+
                                   "LR"+delim+"REFERENCES"+delim+
                                   "LD"+delim+"DUPLICATES"+delim+
                                   "LL"+delim+"NOTUNIQUES"+delim+
                                   "X"+delim+"LFN"+delim+"9X"+delim+
                                   "Q"+delim+"QUICK"+delim+"CRC"+delim+"CRC32"+delim+
                                   "S"+delim+"SHA"+delim+"SAFEST"+delim+
                                   "DEBUG"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5   : verbose:=FALSE;
            | 6,7,8 : echoon := FALSE;
            | 9,10  : immediate:=TRUE;
            | 11,12 : killro := TRUE;
            | 13,14 : hiddensystem:=TRUE;
            | 15,16 : uppercase:=TRUE;
            | 17,18 :
                      CASE cmd OF
                      | sdel,scopy:   cmd:=scopy;
                      ELSE            abort(errExclusive,"");
                      END;
            | 19,20 :
                      CASE cmd OF
                      | sdel,smove:   cmd:=smove;
                      ELSE            abort(errExclusive,"");
                      END;
            | 21,22,23,24 :
                      CASE cmd OF
                      | sdel,smovems: cmd:=smovems;
                      ELSE            abort(errExclusive,"");
                      END;
            | 25,26,27 :
                      CASE cmd OF
                      | sdel,skill:   cmd:=skill;
                      ELSE            abort(errExclusive,"");
                      END;
            | 28,29,30,31: OLDMETHOD:=TRUE;
            | 32,33 :
                      CASE cmd OF
                      | sdel,slist:   cmd:=slist;
                      ELSE            abort(errExclusive,"");
                      END;
                      listmode:=all;
            | 34,35:
                      CASE cmd OF
                      | sdel,slist:   cmd:=slist;
                      ELSE            abort(errExclusive,"");
                      END;
                      listmode:=uniques;
            | 36,37:
                      CASE cmd OF
                      | sdel,slist:   cmd:=slist;
                      ELSE            abort(errExclusive,"");
                      END;
                      listmode:=references;
            | 38,39:
                      CASE cmd OF
                      | sdel,slist:   cmd:=slist;
                      ELSE            abort(errExclusive,"");
                      END;
                      listmode:=duplicates;
            | 40,41:
                      CASE cmd OF
                      | sdel,slist:   cmd:=slist;
                      ELSE            abort(errExclusive,"");
                      END;
                      listmode:=notuniques;
            | 42,43,44: useLFN:=FALSE;
            | 45,46,47,48:
                      CASE chkmethod OF
                      | useMD5,useCRC: chkmethod:=useCRC;
                      ELSE             abort(errMethod,"");
                      END;
            | 49,50,51:
                      CASE chkmethod OF
                      | useMD5,useSHA: chkmethod:=useSHA;
                      ELSE abort(errMethod,"");
                      END;
            | 52      : DEBUG:=TRUE;
            ELSE
                abort(errOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            INC(lastBase); (* yes, here *)
            IF lastBase > maxBase THEN abort(errTooManySpex,"");END;
            IF chkAndFixSpec (currentdir,R,
                              spec[lastBase],basepath[lastBase])=FALSE THEN
                    abort(errBadSpec,R);
            END;
            IF state=waiting THEN state:=gotspec;END;
        END;
    END;

    IF state=waiting THEN abort(errMissingSource,""); END;

    CASE cmd OF
    | sdel:   batchfile:=cmdDEL;
    | scopy:  batchfile:=cmdCOPY;
    | smove:  batchfile:=cmdMOVE;
    | slist:  batchfile:=cmdLIST; echoon:=FALSE;
    | skill:  batchfile:=cmdKILL;
    END;
    Str.Append(batchfile,batchSuffix);

    IF OLDMETHOD THEN
        IF cmd = slist THEN abort(errNotWithOld,"");END;
    END;

    IF immediate THEN
        IF cmd # sdel THEN abort(errNonsense,"");END;
    ELSE
        IF FIO.Exists(batchfile) THEN FIO.Erase(batchfile);END; (* safety *)
    END;

    initList(fileanchor);
    lastFile:=firstFile-1;
    FOR i:=firstBase TO lastBase DO
        Str.Concat(S,basepath[i],spec[i]);
        IF DEBUG THEN
            WrStr("DOS specification ");IO.WrCard(i,1);WrStr(" : ");WrStr(S);WrLn;
        END;
        IF buildList(fileanchor,lastFile,i,hiddensystem,S)=FALSE THEN
            Str.Concat(S,basepath[i],spec[i]);
            abort(errTooMany,S);
        END;
        (* dmpEntries(fileanchor,i,basepath[i]); *)
    END;
    IF DEBUG THEN WrLn;END;
    CASE lastFile OF
    | firstFile-1: abort(errNotFound,"");
    | firstFile:   abort(errThereCANTbeOnlyOne,"");
    END;

    WrStr(banner);WrLn;
    WrLn;

    useLFN := ( useLFN AND w9XsupportLFN() );

    setSigmaUse(TRUE); (* default but who knows, eh eh ! *)

    (* let's compute data for each file *)

    currentry   := firstFile; (* 0 is definitely not a good idea *)
    portion     := currentry;

    IF verbose THEN
        video(msgAnalyzing,TRUE);
        animInit(steps, "[", "]", CHR(46), "", "\/" );
        portion:=lastFile DIV steps; INC(portion); (* avoid DIV 0 ! *)
        lastportion := steps+1;
    END;
    (* default needed ! *)
    currportion := currentry DIV portion; (* crash avoided ! *)

    FOR i := firstFile TO lastFile DO
        IF verbose THEN
            anim(animcmd);
            currportion:=currentry DIV portion; (* crash avoided ! *)
            IF currportion # lastportion THEN
                anim(animAdvance);
                lastportion:=currportion;
            END;
        END;

        pp:=findByIndex(fileanchor,i);
        getStr(R,pp);
        Str.Concat(S,basepath[pp^.basendx],R);

        pp^.tag:=IamUnique; (* like everyone else... *)

        CASE chkmethod OF
        | useSHA:
            ComputeSHA (pp^.info.zdigest, S);
        | useMD5:
            ComputeMD5 (pp^.info.fdigest, S);
            pp^.info.zeroeddummy := 0; (* must be done because we'll compare whole structure at once *)
        | useCRC:
            pp^.info.fsize       := getFileSize(S);
            pp^.info.fCRC32      := ComputeCRC32 (S);
            pp^.info.fCRC32sigma := ComputeCRCval ();
            pp^.info.zeroeddummy1:= 0; (* must be done because we'll compare whole structure at once *)
            pp^.info.zeroeddummy2:= 0; (* must be done because we'll compare whole structure at once *)
        END;
        INC(currentry);
    END;

    IF verbose THEN
        anim(animEnd);anim(animClear);
        video(msgAnalyzing,FALSE);
    END;

    (* now, force a clean display *)

    IF (DEBUG OR immediate OR (cmd=slist)) THEN verbose:=FALSE; END;

    IF verbose THEN video(msgFiltering,TRUE);END;

    IF NOT(immediate) THEN
        hout:=FIO.Create(batchfile);
        FIO.AssignBuffer(hout,ioBufferOut);
        IF echoon THEN
            FIO.WrStr(hout,echoON);
        ELSE
            FIO.WrStr(hout,echoOFF);
        END;
        FIO.WrLn(hout);
        FIO.WrLn(hout);
    END;

    CASE cmd OF
    | sdel:    scmd:=cmdDEL;  scmdpostfix:="";
    | scopy:   scmd:=cmdCOPY; scmdpostfix:="";
    | smove:   scmd:=cmdMOVE; scmdpostfix:="";
    | smovems: scmd:=cmdMOVE; scmdpostfix:=" ."; (* silly M$ crap ! *)
    | slist:   scmd:=cmdECHO; scmdpostfix:="";
    | skill:   scmd:=cmdDEL;  scmdpostfix:="";
    END;
    Str.Append(scmd,blank); (* required ! *)

    dups := 0; (* a flag, not a count *)

    (* sort all arrays *)
    CASE chkmethod OF
    | useSHA:
        Lib.QSort(lastFile,dolessSHA,doswap);
    | useMD5:
        Lib.QSort(lastFile,dolessMD5,doswap);
    ELSE
        Lib.QSort(lastFile,dolessSizeCRCs,doswap);
    END;

(* ------------------------------------------------------------ *)
IF OLDMETHOD THEN
(* ------------------------------------------------------------ *)

    pp:=findByIndex(fileanchor,firstFile);
    ref:=pp^.info;

    getStr(R,pp);
    Str.Concat(S,basepath[pp^.basendx],R);
    Str.Copy(S0,S);

    killit:=FALSE;

    IF (DEBUG AND NOT(immediate)) THEN
        unique:=isUnique(fileanchor,firstFile,lastFile);
        fmtfileinfo(useLFN,uppercase,unique,killit,chkmethod , ref,S, inf);
        WrStr(inf);WrLn;
        IF cmd=slist THEN FIO.WrStr(hout,scmd); FIO.WrStr(hout,inf); FIO.WrLn(hout); END;
    END;

    FOR i:=(firstFile+1) TO lastFile DO (* start at next file *)
        pp:=findByIndex(fileanchor,i);
        getStr(R,pp);
        Str.Concat(S,basepath[pp^.basendx],R);

        current:=pp^.info;

        IF current = ref THEN
            IF immediate THEN
                killfile(killro,uppercase,S);
            ELSE
                CASE cmd OF
                | slist:
                     ;
                | sdel:
                     FIO.WrLn(hout); (* NL sep *)
                     FIO.WrStr(hout,sREM);
                     fmtpath(useLFN,S0, inf);
                     FIO.WrStr(hout,inf);
                     FIO.WrLn(hout);
                ELSE
                    IF killit=FALSE THEN (* group ALL files with same CRC here *)
                        FIO.WrLn(hout);       (* NL sep *)
                        FIO.WrStr(hout,scmd);
                        fmtpath(useLFN,S0, inf);
                        FIO.WrStr(hout,inf);
                        FIO.WrStr(hout,scmdpostfix); (* I 8 M$ ! *)
                        FIO.WrLn(hout);
                    END;
                END;
                CASE cmd OF (* yep ! *)
                | slist:
                    ;
                ELSE
                    FIO.WrStr(hout,scmd);
                    fmtpath(useLFN,S, inf);
                    FIO.WrStr(hout,inf);
                    FIO.WrStr(hout,scmdpostfix); (* I 8 M$ ! *)
                    FIO.WrLn(hout);
                END;
            END;
            INC(dups);
            killit := TRUE;
        ELSE
            ref:=current;
            killit := FALSE;
            Str.Copy(S0,S);
        END;

        IF (DEBUG AND NOT(immediate)) THEN
            unique:=isUnique(fileanchor,i,lastFile);
            fmtfileinfo(useLFN,uppercase,unique,killit,chkmethod,current,S, inf);
            WrStr(inf);WrLn;
            IF cmd=slist THEN FIO.WrStr(hout,scmd); FIO.WrStr(hout,inf); FIO.WrLn(hout); END;
        END;
    END;

(* ------------------------------------------------------------ *)
ELSE
(* ------------------------------------------------------------ *)

    (* here, we'll use brute force on unsorted arrays *)

    (* init done, now try and find references in spec1 then in spec2 *)
    FOR opt:=firstBase TO lastBase DO
        FOR i:=firstFile TO lastFile DO
            pp:=findByIndex(fileanchor,i);
            CASE opt OF
            | firstBase : dotest:=(pp^.basendx = firstBase);
            ELSE          dotest:=(pp^.basendx # firstBase);
            END;
            IF dotest THEN chkDuplicates(fileanchor,i,lastFile,dups); END;
        END;
    END;

    CASE cmd OF
    | slist:
        CASE listmode OF
        | all:        S:="all files";
        | uniques:    S:="unique files only";
        | references: S:="reference files only (to be kept)";
        | duplicates: S:="duplicate files only (to be deleted)";
        | notuniques: S:="reference and duplicate files only (to be processed)";
        END;
        CASE listmode OF
        | all:
            ;
        ELSE
            Str.Prepend(S,msgHeader+"Listing "); WrStr(S);WrLn;
            WrLn;
            FIO.WrStr(hout,cmdECHO);FIO.WrStr(hout," ");FIO.WrStr(hout,S);FIO.WrLn(hout);
            FIO.WrLn(hout);
        END;
    END;

    FOR i:=firstFile TO lastFile DO
        pp:=findByIndex(fileanchor,i);
        getStr(R,pp);
        Str.Concat(S,basepath[pp^.basendx],R);

        current:=pp^.info;

        CASE pp^.tag OF
        | IamUnique:     killit:=FALSE; unique:=TRUE;
        | IamReference:  killit:=FALSE; unique:=FALSE;
        ELSE
                         killit:=TRUE;  unique:=FALSE;
        END;

        IF immediate THEN
            IF killit THEN killfile(killro,uppercase,S); END;
        ELSE
            IF DEBUG THEN
                fmtfileinfo(useLFN,uppercase,unique,killit,chkmethod,current,S, inf);
                WrStr(inf);WrLn;
            END;
            CASE cmd OF
            | slist:
                CASE listmode OF
                | all:        dmp:=TRUE;
                | uniques:    dmp:=(pp^.tag = IamUnique);
                | references: dmp:=(pp^.tag = IamReference);
                | duplicates: dmp:=(pp^.tag # IamUnique) AND (pp^.tag # IamReference);
                | notuniques: dmp:=(pp^.tag # IamUnique);
                END;
                IF dmp THEN
                    IF DEBUG=FALSE THEN
                        fmtfileinfo(useLFN,uppercase,unique,killit,chkmethod,current,S, inf);
                        WrStr(inf);WrLn;
                    END;
                    FIO.WrStr(hout,scmd); FIO.WrStr(hout,inf); FIO.WrLn(hout);
                END;
            | sdel:
                IF killit THEN
                    FIO.WrStr(hout,scmd);
                    fmtpath(useLFN,S, inf);
                    FIO.WrStr(hout,inf);
                    FIO.WrStr(hout,scmdpostfix); (* I 8 M$ ! *)
                    FIO.WrLn(hout);
                ELSE
                    IF pp^.tag = IamReference THEN
                        FIO.WrStr(hout,sREM);
                        fmtpath(useLFN,S, inf);
                        FIO.WrStr(hout,inf);
                        FIO.WrLn(hout);
                    END;
                END;
            ELSE
                CASE pp^.tag OF
                | IamUnique :
                    ;
                ELSE
                    FIO.WrStr(hout,scmd);
                    fmtpath(useLFN,S, inf);
                    FIO.WrStr(hout,inf);
                    FIO.WrStr(hout,scmdpostfix); (* I 8 M$ ! *)
                    FIO.WrLn(hout);
                END;
            END;
        END;
    END;

(* ------------------------------------------------------------ *)
END;
(* ------------------------------------------------------------ *)

    IF NOT(immediate) THEN
        FIO.Flush(hout);
        FIO.Close(hout);
    END;

    IF verbose THEN video(msgFiltering,FALSE);END;

    IF (DEBUG AND NOT(immediate) OR (cmd=slist)) THEN WrLn; END;

    IF immediate THEN
        IF dups = 0 THEN
            WrStr(msgHeader+msgNoDups);WrLn;
        END;
    ELSE
        IF dups = 0 THEN
            FIO.Erase(batchfile);
            WrStr(msgHeader+msgNoDups);WrLn;
        ELSE
            WrStr(msgHeader);WrStr(batchfile); WrStr(' batch file has been created.');
            CASE cmd OF
            | sdel:
                ;
            | slist:
                WrStr(" All files were processed.");
            ELSE
                WrStr(" All duplicates were processed.");
            END;
            WrLn;
        END;
    END;

    freeList(fileanchor);

    abort(errNone,"");
END ProcDups.



(*
check v1.1d AND v1.1e outputs for safety

chrono \bat\procdups c:\bat f:\uc\bat c:\bat\tools\ f:\uc\tools\ascii
ren delthem.bat old

chrono \bat\procdups c:\bat f:\uc\bat c:\bat\tools\ f:\uc\tools\ascii /o
ren delthem.bat oldprev

chrono procdups c:\bat f:\uc\bat c:\bat\tools\ f:\uc\tools\ascii
ren delthem.bat new

chrono procdups c:\bat f:\uc\bat c:\bat\tools\ f:\uc\tools\ascii /o
ren delthem.bat newprev

*)


