(* ---------------------------------------------------------------
Title         Q&D Pending delete (delwatched) entries lister
Author        PhG
Overview      list of files deleted and monitored by Novell DOS 7 Delwatch crap
Usage         see help
Notes         useless ! required delwatch data are NOT moved to DirEntry
              "reserved" fields by M2 lib because it uses int 214E !
              in fact, we should rewrite readfirstentry and readnextentry
              with int 2111 (using FCB)... but what for, after all ?
              we just want the list of pending delete files, don't we ?
              now we offer the possibility to use ND7 int 214E/214F call
              (previous one still offered with -safe)
              yes, we SHOULD check for ND7 before running...
Bugs
Wish List

--------------------------------------------------------------- *)

MODULE Pending;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT SYSTEM;

IMPORT IO;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

(* ------------------------------------------------------------ *)

CONST
    sMaxPath      = "16000"; (* must match maxPath infra *)

CONST
    ProgEXEname   = "PENDING";
    ProgTitle     = "Q&D Pending delete (delwatched) entries lister";
    ProgVersion   = "v1.0g";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errOption         = 2;
    errBadSpec        = 3;
    errTooManyDirs    = 4;
    errTooManyParms   = 5;
    errNeedSpec       = 6;
    errNotRealDOS     = 7;
    errPendingFound   = 128;
    errNoPending      = 255;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl=CHR(13)+CHR(10);
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msghelp=
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <[u:]\[path]>... [option]..."+nl+
nl+
"  -c[c|v] count pending files (-cc = -c -v)"+nl+
"  -s      do it safe, NOT using alternate ND7 call (214E/214F with CX=$0088)"+nl+
"  -u      display filenames in uppercase"+nl+
"  -x      scan specified directory only (no recursion)"+nl+
"  -v      verbose"+nl+
nl+
"a) Program will not handle more than "+sMaxPath+" directories."+nl+
"b) With -c[c|v] option, return code is 255 if no pending file, 128 if any."+nl+
"   Any other code is not related to this option."+nl+
"c) Program should only be run from real ND7 DOS."+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msghelp);
    | errOption :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," option !");
    | errBadSpec :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," directory specification !");
    | errTooManyDirs :
        (*
        Str.Concat(S,"Too many directories in ",einfo);
        Str.Append(S," unit !");
        *)
        S := "More than "+sMaxPath+" directories !";
    | errTooManyParms :
        S := "Too many directories specified !";
    | errNeedSpec :
        S := "No directory specified !";
    | errNotRealDOS :
        S := "Real DOS required (such as DR-DOS, Novell DOS or OpenDOS) !";
    | errPendingFound:
        Str.Copy(S,einfo);
    | errNoPending:
        Str.Copy(S,einfo);
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone, errHelp: ;
    | errPendingFound,errNoPending:
        IF same(S,"") = FALSE THEN WrStr(S);WrLn;END;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE ND7ReadFirstDeletedEntry ( DirName : ARRAY OF CHAR;
                                     VAR D   : FIO.DirEntry) : BOOLEAN;
VAR
  r  : SYSTEM.Registers;
  fn : FIO.PathStr;
BEGIN
  Str.Copy(fn,DirName);
  fn[HIGH(fn)] := CHR(0); (* make Null terminated filename *)
  WITH r DO
    AH := 1AH;
    DS := Seg(D);
    DX := Ofs(D);
    Lib.Dos(r);    (* set DTA *)
    AH := 4EH;
    DS := Seg(fn);
    DX := Ofs(fn);
    CX := 0088H; (* ND7 specific, see int 214E in INTER56 *)
    Lib.Dos(r);
    IF (BITSET{SYSTEM.CarryFlag} * Flags) # BITSET{} THEN
      (*
      IF (AX <> 18) THEN
          ErrorCheck(14H, AX, 'ReadFirstEntry : ', DirName);
      END;
      *)
      RETURN FALSE;
    END;
  END;
  RETURN TRUE;
END ND7ReadFirstDeletedEntry;

PROCEDURE ND7ReadNextDeletedEntry(VAR D: FIO.DirEntry) : BOOLEAN;
VAR
  r : SYSTEM.Registers;
BEGIN
  WITH r DO
    AH := 1AH;
    DS := Seg(D);
    DX := Ofs(D);
    Lib.Dos(r);    (* set DTA *)
    AH := 4FH;
    CX := 0088H; (* ND7 specific, see int 214E in INTER56 *)
    Lib.Dos(r);
    IF (BITSET{SYSTEM.CarryFlag} * Flags) # BITSET{} THEN
      (*
      IF (AX <> 18) THEN
          ErrorCheck(15H, AX, 'ReadNextEntry : ', Lib.NilStr);
      END;
      *)
      RETURN FALSE;
    END;
  END;
  RETURN TRUE;
END ND7ReadNextDeletedEntry;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE fmtc (v:CARDINAL):str16;
VAR
    ok:BOOLEAN;
    S:str16;
BEGIN
    Str.CardToStr( LONGCARD(v),S,10,ok);
    IF NOT(ok) THEN S:="???";END;
    RETURN S;
END fmtc;

PROCEDURE PrintFileSize ( v : LONGCARD;wi:CARDINAL);
VAR
    S : str16;
    ok  : BOOLEAN;
    l : CARDINAL;
BEGIN
    Str.CardToStr(v,S,10,ok);
    l := Str.Length(S);
    IF l < wi THEN
        IO.WrCharRep(" ",wi-l);
    END;
    WrStr(S);
END PrintFileSize;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE PrintFileDate ( datedata : CARDINAL );
CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
VAR
    year :CARDINAL;
    month:CARDINAL;
    day  :CARDINAL;
    mm : str16;
BEGIN
    year := CARDINAL(BITSET(datedata) * yyMask) >> yyShft;
    month:= CARDINAL(BITSET(datedata) * mmMask) >> mmShft;
    day  := CARDINAL(BITSET(datedata) * ddMask) >> ddShft;
    IO.WrCard(day,2);
    WrStr(" ");
    CASE month OF (* boy, this is ugly *)
    | 1: mm:="Jan";
    | 2: mm:="Feb";
    | 3: mm:="Mar";
    | 4: mm:="Apr";
    | 5: mm:="May";
    | 6: mm:="Jun";
    | 7: mm:="Jul";
    | 8: mm:="Aug";
    | 9: mm:="Sep";
    |10: mm:="Oct";
    |11: mm:="Nov";
    |12: mm:="Dec";
    END;
    WrStr(mm);
    WrStr(" ");
    IO.WrCard(year+1980,4);
END PrintFileDate;

(*
Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

PROCEDURE PrintFileTime ( timedata:CARDINAL );
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    mmMask=BITSET{5..10};
    mmShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
VAR
    hh,mm,ss : CARDINAL;
BEGIN
    hh := CARDINAL(BITSET(timedata) * hhMask) >> hhShft;
    mm := CARDINAL(BITSET(timedata) * mmMask) >> mmShft;
    ss := CARDINAL(BITSET(timedata) * ssMask) >> ssShft;
    IO.WrCard(hh,2);
    WrStr(":");
    IF mm < 10 THEN
       WrStr("0");
       IO.WrCard(mm,1);
    ELSE
       IO.WrCard(mm,2);
    END;
    WrStr(":");
    IF ss*2 < 10 THEN
       WrStr("0");
       IO.WrCard(ss*2,1); (* yes, we know about shifting back from our ASM6502 days *)
    ELSE
       IO.WrCard(ss*2,2);
    END;
END PrintFileTime;


(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    dot         = ".";
    dotdot      = dot+dot;
    star        = "*";
    stardotstar = star+dot+star;
    backslash   = "\";
    netslash    = backslash+backslash;
    colon       = ":";

CONST
    firstPath = 1;     (* was 0, but 1 required by Lib.QSort and by firstPath-1 of course ! *)
    maxPath   = 16000; (* should do even with obscene win9X systems *)

TYPE
    ptrToEntry = POINTER TO entrytype;
    entrytype  = RECORD
        slen : SHORTCARD;
        string:CHAR; (* variable length *)
    END;
VAR
    Path : ARRAY[firstPath..maxPath] OF ptrToEntry; (* yes, we could use an index in entrytype too... *)

(* ------------------------------------------------------------ *)

PROCEDURE getentry (i:CARDINAL; VAR R : ARRAY OF CHAR);
CONST
    nullchar=CHR(0);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(Path[i]^.slen);
    Lib.FastMove( ADR(Path[i]^.string),ADR(R),len);
    R[len]:=nullchar; (* REQUIRED safety ! *)
END getentry;

PROCEDURE setentry ( i:CARDINAL; S : ARRAY OF CHAR  ) : BOOLEAN ;
VAR
    len,needed:CARDINAL;
BEGIN
    len    := Str.Length(S);
    needed := SIZE(entrytype)-SIZE(CHAR)+len;
    IF Available(needed) THEN
        ALLOCATE(Path[i],needed);
        Path[i]^.slen := SHORTCARD(len);
        Lib.FastMove( ADR(S),ADR(Path[i]^.string),len);
    ELSE
        Path[i]:=NIL;
    END;
    RETURN (Path[i] # NIL);
END setentry;

PROCEDURE clearentry (i:CARDINAL );
VAR
    len,needed:CARDINAL;
BEGIN
    len := CARDINAL(Path[i]^.slen);
    needed:= SIZE(entrytype)-SIZE(CHAR)+len;
    DEALLOCATE(Path[i],needed);
    Path[i]:=NIL;
END clearentry;

(* ------------------------------------------------------------ *)

PROCEDURE fixDirPath (VAR S : ARRAY OF CHAR);
BEGIN
    IF Str.Length(S)=0 THEN Str.Copy(S,backslash); END;
    fixDirectory(S);
END fixDirPath;

PROCEDURE isDirEntry (S : ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isDirEntry;

(* ------------------------------------------------------------ *)

PROCEDURE doDir (DEBUG,eyecandy:BOOLEAN; root : ARRAY OF CHAR;
                 VAR index:CARDINAL;VAR err:BOOLEAN);
VAR
    path    : str128;
    S       : str128;
    entry   : FIO.DirEntry;
    found   : BOOLEAN;
BEGIN
    IF eyecandy THEN Work(cmdShow);END;
    IF err THEN RETURN; END;
    IF index > maxPath THEN
        err:=TRUE;
        RETURN;
    END;
    (*
    Str.Copy(Path[index],root);
    fixDirPath(Path[index]); (* add required \ because it will be REQUIRED *)
    *)
    fixDirPath(root); (* add required \ because it will be REQUIRED *)
    IF DEBUG THEN WrStr(root);WrLn;END;
    IF setentry(index,root)=FALSE THEN
        err:=TRUE;
        RETURN;
    END;

    Str.Copy(path,root);
    fixDirPath(path); (* add required \ *)
    Str.Append(path,stardotstar); (* root\*.* *)

    found := FIO.ReadFirstEntry(path,everything,entry);
    WHILE found DO
        Work(cmdShow);
        Str.Copy(S,root);
        fixDirPath(S);
        Str.Append(S,entry.Name); (* root\f8e3 *)
        IF isDirEntry(entry.Name)=FALSE THEN (* skip . and .. *)
            IF aD IN entry.attr THEN
                INC(index);
                doDir(DEBUG,eyecandy,S,index,err);
            END;
        END;
        found :=FIO.ReadNextEntry(entry);
    END;
END doDir;

PROCEDURE buildPathList (rootdir:ARRAY OF CHAR; flagRecurse,DEBUG:BOOLEAN;
                        VAR lastpath:CARDINAL):BOOLEAN;
CONST
    msg1 = "Building list of directories for ";
VAR
    i        : CARDINAL;
    error,rc,eyecandy : BOOLEAN;
    prompt   : str128;
BEGIN
    eyecandy:=NOT(DEBUG);
    Str.Concat(prompt,msg1,rootdir);

    IF eyecandy THEN video(prompt,TRUE);Work(cmdInit); END;

    error := FALSE;
    i     := firstPath;
    IF flagRecurse THEN
        doDir(DEBUG,eyecandy,rootdir,i,error);
    ELSE
        fixDirPath(rootdir); (* just in case ! but should not be necessary here *)
        (* Str.Copy(Path[i],rootdir); *)
        IF DEBUG THEN WrStr(rootdir);WrLn;END;
        IF setentry(i,rootdir)=FALSE THEN RETURN FALSE;END;
    END;

    IF eyecandy THEN Work(cmdStop); video (prompt,FALSE); END;

    lastpath := i;
    rc := NOT ( error ); (* reverse flag and return true if no error *)
    RETURN rc;
END buildPathList;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE appattr (VAR R:ARRAY OF CHAR; flag:BOOLEAN; t,f:CHAR);
BEGIN
    IF flag THEN
        Str.Append(R,t);
    ELSE
        Str.Append(R,f);
    END;
END appattr;

PROCEDURE fmtAttr (attr:FIO.FileAttr) : str80;
VAR
    S : str80;
BEGIN
    S:="";
    appattr(S, (aD IN attr), "D" , "-");
    appattr(S, (aR IN attr), "R" , "-");
    appattr(S, (aH IN attr), "H" , "-");
    appattr(S, (aS IN attr), "S" , "-");
    appattr(S, (aA IN attr), "A" , "-");
    appattr(S, (aV IN attr), "V" , "-");

    Str.Lows(S); (* prettier display ! *)
    RETURN S;
END fmtAttr;

(*

  WARNING ! online help is wrong ! here's real FIO.DEF DirEntry definition :

  Attrib = (readonly,hidden,system,volume,directory,archive);
  FileAttr = SET OF Attrib;
  DirEntry = RECORD
               Reserved_Handle: CARDINAL;         (* for OS/2 *)
               rsvd : ARRAY[0..18] OF SHORTCARD;
               attr : FileAttr;
               time : CARDINAL;
               date : CARDINAL;
               size : LONGCARD;
               Name : PathTail;
             END;

*)

PROCEDURE scanWeirdoes(basepath:ARRAY OF CHAR;
                       attribs : FIO.FileAttr;
                       nd7specific,ucase,chkpending : BOOLEAN;
                       VAR count:CARDINAL;VAR totalsize:LONGCARD);
CONST
    (* supposed to be chr($05) but is chr($e5) = sigma = normal deleted and ND7 delwatched too *)
    pendingDeleteMark = CHR(0E5H);
(*
TYPE
    delwatchDataType = RECORD
        reserved : ARRAY [0..18] OF SHORTCARD;
    END;
*)
VAR
    found        : BOOLEAN;
    entry        : FIO.DirEntry;
    spec         : str128;
    S            : str128;
    i            : CARDINAL;
(*    delwatchData : delwatchDataType; *)
    yes          : BOOLEAN;
BEGIN
    fixDirPath(basepath);
    Str.Copy(spec,basepath);
    Str.Append(spec,stardotstar);

    CASE nd7specific OF
    | FALSE : found := FIO.ReadFirstEntry(spec,reallyeverything,entry);
    | TRUE  : found := ND7ReadFirstDeletedEntry(spec,entry);
    END;
    WHILE found=TRUE DO
        CASE nd7specific OF
        | FALSE:
            yes := FALSE;
            IF (attribs * entry.attr) # FIO.FileAttr{} THEN (* set intersection *)
                IF entry.Name[0] = pendingDeleteMark THEN yes:=TRUE; END;
            END;
        | TRUE:
            yes := TRUE;
        END;
        IF yes THEN
            (*
            (* utterly useless ! *)
            FOR i := 0 TO 18 DO
                delwatchData.reserved[i] := entry.rsvd[i];
            END;
            *)
            IF NOT(chkpending) THEN
                IF nd7specific THEN
                    WrStr(fmtAttr(entry.attr));
                    WrStr("  ");
                    PrintFileSize(entry.size,9);
                    WrStr("  ");
                    PrintFileDate(entry.date);
                    WrStr("  ");
                    PrintFileTime(entry.time);
                    WrStr("  ");
                ELSE
                    WrStr(fmtAttr(entry.attr));
                    WrStr("  ");
                END;

                Str.Copy(S,basepath);
                Str.Append(S,entry.Name);
                IF ucase THEN
                    (* already in uppercase here *)
                ELSE
                    LowerCase(S);
                END;
                WrStr(S);
                WrLn;
            END;

            INC(count);
            INC(totalsize,entry.size);
        END;
        CASE nd7specific OF
        | FALSE : found:=FIO.ReadNextEntry(entry);
        | TRUE :  found:=ND7ReadNextDeletedEntry(entry);
        END;
    END;
END scanWeirdoes;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE chk9xXPnt (  ) : BOOLEAN;
VAR
    majmin : CARDINAL; (* 6.00=600H *)
BEGIN
    majmin := getDosVersion();
    IF majmin = DosVersion(5,50) THEN RETURN TRUE;END;
    RETURN (majmin >= DosVersion(7,0));
END chk9xXPnt;

(* ------------------------------------------------------------ *)

CONST
    alphaset      = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"; (* uppercase *)
    digits        = "0123456789";
    symbols       = "_-$!(){}~#&@";
    DOScharset    = alphaset+digits+symbols + colon+backslash;

PROCEDURE isAlpha (c : CHAR) : BOOLEAN;
BEGIN
    IF Str.CharPos(alphaset,c)=MAX(CARDINAL) THEN
        RETURN FALSE;
    ELSE
        RETURN TRUE;
    END;
END isAlpha;

(*
    default and R are already directory fixed and in uppercase
*)

PROCEDURE isLegalSpec (defaultdir:ARRAY OF CHAR; VAR R:ARRAY OF CHAR):BOOLEAN;
VAR
    i:CARDINAL;
    u,d,n,e:str128; (* "u:" "\*\" "" "" *)
BEGIN
    IF same(R,dot) THEN Str.Copy(R,defaultdir);END;
    fixDirectory(R); (* add trailing \ if required *)
    IF chkJoker(R) THEN RETURN FALSE; END;
    IF Str.Pos(R,netslash) # MAX(CARDINAL) THEN RETURN FALSE; END;
    CASE CharCount(R,colon) OF
    | 0 : ;
    | 1 : IF Str.CharPos(R,colon) # 1 THEN RETURN FALSE; END; (* only "?:*" allowed *)
    ELSE
        RETURN FALSE;
    END;

    FOR i := 1 TO Str.Length(R) DO
        IF Belongs(DOScharset,R[i-1])=FALSE THEN RETURN FALSE;END;
    END;

    IF Str.Match(R,"?:\*") THEN RETURN TRUE;END;
    IF Str.Match(R,"\*") THEN
        Str.Prepend(R,colon);
        Str.Prepend(R,defaultdir[0]);
        RETURN TRUE;
    END;
    Str.Prepend(R,defaultdir);

    RETURN TRUE;
END isLegalSpec;

(* ------------------------------------------------------------ *)

CONST
    msgRecurse   = "Recursively scanning ";
    msgNoRecurse = "Scanning ";
    msgChk       = "+++ Return code is | (| found)";
    placeholder  = "|";
CONST
    firstSpec = 1;
    maxSpec   = 16; (* was A..Z at most *)
VAR
    i, j, parmcount,opt : CARDINAL;
    S,R             : str128;
    N               : str16;
    spec            : ARRAY [firstSpec..maxSpec] OF str128;
    lastSpec        : CARDINAL;
    lastpath        : CARDINAL;
    count,prevcount : CARDINAL; (* should really be enough ! *)
    wanted          : FIO.FileAttr;
    nd7specific     : BOOLEAN;
    uppercase       : BOOLEAN;
    recurse         : BOOLEAN;
    chkpending      : BOOLEAN;
    verbose         : BOOLEAN;
    wastedsize      : LONGCARD;
    DEBUG           : BOOLEAN;
    ok              : BOOLEAN;

    currdrive       : SHORTCARD;
    currdir         : str128;
    defaultdir      : str128;

BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn; (* yes, here now for help, errors, etc. *)

    lastSpec := firstSpec;
    wanted   := FIO.FileAttr{aV}; (* delwatched entries are flagged as VOLUME *)
    nd7specific:=TRUE;
    uppercase := FALSE;
    recurse   := TRUE;
    verbose   := FALSE;
    chkpending:= FALSE;
    DEBUG     := FALSE;

    parmcount := Lib.ParamCount();
    IF parmcount=0 THEN abort(errHelp,""); END;

    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    (* we have unit letter and "\xxx" directory now *)

    Str.Copy(defaultdir,CHR(ORD("A")-1+currdrive));
    Str.Append(defaultdir,colon);
    Str.Append(defaultdir,currdir);
    UpperCase(defaultdir); (* probably useless *)
    fixDirectory(defaultdir);      (* add required trailing "\" *)

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"HELP"+delim+
                                 "S"+delim+"SAFE"+delim+
                                 "U"+delim+"UPPERCASE"+delim+
                                 "X"+delim+"NORECURSION"+delim+
                                 "C"+delim+"COUNT"+delim+
                                 "V"+delim+"VERBOSE"+delim+
                                 "CC"+delim+"CV"+delim+
                                 "DEBUG"
                              );
            CASE opt OF
            | 1,2 : abort(errHelp,"");
            | 3,4 : nd7specific := FALSE;
            | 5,6 : uppercase   := TRUE;
            | 7,8 : recurse     := FALSE;
            | 9,10: chkpending  := TRUE;
            |11,12: verbose     := TRUE;
            |13,14: chkpending  := TRUE;
                    verbose     := TRUE;
            |15   : DEBUG       := TRUE;
            ELSE
                abort(errOption,S);
            END;
        ELSE
            IF lastSpec > maxSpec THEN abort(errTooManyParms,""); END;
            (* check uppercase R and change it according to defaultdir if needed *)
            IF isLegalSpec(defaultdir,R) = FALSE THEN abort(errBadSpec,S); END;
            Str.Copy( spec[lastSpec] , R );
            INC(lastSpec);
       END;
    END;

    IF lastSpec = firstSpec THEN abort(errNeedSpec,"");END;
    DEC (lastSpec); (* important ! *)

    IF NOT(DEBUG) THEN
        IF chk9xXPnt() THEN abort(errNotRealDOS,"");END;
    END;

    (*
    WrStr(Banner);WrLn;
    WrLn;
    *)

    IF NOT(chkpending) THEN
        IF recurse THEN
            WrStr(msgRecurse);
        ELSE
            WrStr(msgNoRecurse);
        END;
        FOR i := firstSpec TO lastSpec DO
            WrStr(spec[i]);
            IF i < lastSpec THEN WrStr(" ; ");END;
        END;
        WrLn;
        WrLn;
    END;

    wastedsize := 0;
    count      := 0;

    FOR i := firstSpec TO lastSpec DO
        prevcount := count;
        Str.Copy(S,spec[i]);
        ok:= buildPathList(S, recurse,DEBUG,lastpath); (* rootdir *)
        IF NOT(ok) THEN abort(errTooManyDirs,S); END;
        FOR j := firstPath TO lastpath DO
            getentry(j,S);
            scanWeirdoes (S,wanted,nd7specific,uppercase,chkpending,
                         count,wastedsize);
        END;
        IF count # prevcount THEN WrLn; END;

        FOR j := firstPath TO lastpath DO clearentry(j);END;
    END;

    IF chkpending THEN
        CASE count OF
        | 0: i:=errNoPending;    R:="no entry";
        | 1: i:=errPendingFound; R:="1 entry";
        ELSE
             i:=errPendingFound; Str.Concat(R, fmtc( count), " "); Str.Append(R,"entries");
        END;
        IF verbose THEN
            S:=msgChk;
            Str.Subst(S,placeholder,fmtc(i));
            Str.Subst(S,placeholder,R);
        ELSE
            S:="";
        END;
        abort(i,S);
    ELSE
        WrStr("Summary : ");
        IO.WrLngCard(wastedsize,1);
        WrStr (" wasted byte");
        IF wastedsize <= 1 THEN
            WrStr(" ");
        ELSE
            WrStr("s");
        END;
        WrStr (" in ");
        IO.WrCard(count,1);
        IF count <= 1 THEN
            WrStr(" entry");
        ELSE
            WrStr(" entries");
        END;
        WrLn;
        abort(errNone,"");
    END;
END Pending.

