(* ---------------------------------------------------------------
Title         see help
Overview      Yet Another Completely Useless Program
Usage         see help
Notes
Bugs

Wish List

--------------------------------------------------------------- *)

MODULE reStamp;

IMPORT Str;
IMPORT Lib;
IMPORT FIO;
IMPORT SYSTEM;

FROM IO IMPORT WrStr, WrLn;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec,
fileClose;

(* ------------------------------------------------------------ *)

CONST
    cr          = CHR(13);
    lf          = CHR(10);
    nl          = cr+lf;
    arobas      = "@";
    dot         = ".";
    dotdot      = dot+dot;
    nullchar    = 0C;
    semicolon   = ";";
    pound       = "#";
    star        = "*";
    dash        = "-";
    colon       = ":";
    stardotstar = star+dot+star;
    dquote      = '"';
    slash       = "/";
CONST
    dateplaceholder = star;
    defaultDMY      = "1-Feb-2063";
CONST
    extLST      = ".LST";
    specLST     = "*"+extLST;
    specSWP     = "*.SWP";
    specPAR     = "*.PAR";
    specPAGEFILE= "*\PAGEFILE.SYS";
CONST
    progEXEname   = "RESTAMP";
    progTitle     = "Q&D ReStamp";
    progVersion   = "v1.0b";
    progCopyright = "by PhG";
    banner        = progTitle+" "+progVersion+" "+progCopyright;
CONST
    errNone            = 0;
    errHelp            = 1;
    errUnknownOption   = 2;
    errTooManyParms    = 3;
    errMissingSpec     = 4;
    errNotFound        = 5;
    errNotFile         = 6;
    errJokerList       = 7;
    errNoMatch         = 8;
    errTooMany         = 9;
    errJokerPath       = 10;
    errDosVersion      = 11;
    errBadDate         = 12;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)

errmsg =
banner+nl+
nl+
"Syntax : "+progEXEname+" <filespec|@filelist["+extLST+"]> [-d:$] [-y]"+nl+
nl+
"  -d:$ base date (dd-mm-yyyy format, "+dateplaceholder+" = today, default is "+defaultDMY+")"+nl+
"  -y   actually perform update"+nl+
nl+
"This program modifies date and time stamps of specified files :"+nl+
"time is renumbered from 00:00:00 to 23:59:58 with a 2 seconds increment,"+nl+
"following the original directory or filelist order."+nl+
nl+
"A filelist should contain either canonical pathnames,"+nl+
"or mere filenames to be searched for in current directory."+nl+
"Jokers are not allowed in filelist. Read-only attribute is ignored and lost."+nl+
nl+
"In order to reset original stamps, redirect output to a file :"+nl+
"note some editing will be required (TOUCH or DTSYNC will be useful)."+nl;

VAR
    S  : str1024; (* we may get a LFN *)
BEGIN
    CASE e OF
    | errHelp :
        WrStr(errmsg);
    | errUnknownOption:
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errTooManyParms:
        Str.Concat(S,einfo," is one parameter too many !");
    | errMissingSpec:
        S := "Missing <filespec> or <@filelist["+extLST+"]> !";
    | errNotFound:
        Str.Concat(S,einfo," does not exist !");
    | errNotFile:
        Str.Concat(S,einfo," looks like a directory !");
    | errJokerList:
        S := "Jokers are not allowed in <filelist["+extLST+"]> !";
    | errNoMatch:
        S := "No file matches <filespec>";
    | errTooMany:
        S := "Storage.ALLOCATE() failure !"; (* or 65535 matches ! *)
    | errJokerPath:
        S := "Jokers are not allowed in path !";
    | errDosVersion:
        Str.Concat(S,"This program requires a DOS ",einfo);Str.Append(S," or better !");
    | errBadDate:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," date format !");
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ;
    ELSE
        WrStr(progEXEname+" : ");WrStr(S);WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize      = (8 * 512) + FIO.BufferOverhead;
    firstioBufferByte = 1;
    lastioBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstioBufferByte..lastioBufferByte] OF BYTE;
VAR
    ioBufferList : ioBufferType;

(* ------------------------------------------------------------ *)

PROCEDURE atLeastDosVersion (minmajor,minminor:CARDINAL) : BOOLEAN;
VAR
    R             : SYSTEM.Registers;
    minDosVersion : CARDINAL;
    major         : CARDINAL;
    minor         : CARDINAL;
    thisDosVersion: CARDINAL;
BEGIN
    minDosVersion := (minmajor << 8) + minminor;
    R.AX := 3000H;
    Lib.Dos(R);
    major := CARDINAL(R.AL);
    minor := CARDINAL(R.AH);
    thisDosVersion := (major << 8) + minor;
    IF thisDosVersion < minDosVersion THEN RETURN FALSE; END;
    RETURN TRUE;
END atLeastDosVersion;

PROCEDURE chkJokerPath (spec:pathtype  ):BOOLEAN;
VAR
    S,u,d,n,e:pathtype;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(S,u,d,"","");
    RETURN chkJoker(S);
END chkJokerPath;

(* Str.Match is not case sensitive *)

PROCEDURE isReservedPattern (S:ARRAY OF CHAR):BOOLEAN;
BEGIN
    IF Str.Match(S,specSWP) THEN RETURN TRUE; END;
    IF Str.Match(S,specPAR) THEN RETURN TRUE; END;
    RETURN Str.Match(S,specPAGEFILE);
END isReservedPattern;

PROCEDURE isReservedEntry (S : ARRAY OF CHAR) : BOOLEAN; (* assume uppercase *)
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    IF same(S,dotdot) THEN RETURN TRUE; END;
    RETURN isReservedPattern(S);
END isReservedEntry;

CONST
    firstEntry = 1; (* 1..count *)
TYPE
    ptrToEntry = POINTER TO entryType;
    entryType = RECORD
        next   : ptrToEntry;
        slen   : CARDINAL; (* a SHORTCARD would DO fine IN almost all cases  *)
        string : CHAR;      (* here, after other data, because variable length *)
    END;

PROCEDURE buildMatchList (VAR anchor:ptrToEntry;
                          useLFN:BOOLEAN;spec:pathtype):CARDINAL;
VAR
    S,u,d,n,e,dirbase,filespec:pathtype; (* some are oversized but safety first ! *)
    newInList : ptrToEntry;
    lastEntry,len,needed : CARDINAL;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    DOSentry     : FIO.DirEntry;
    rc,found:BOOLEAN;
    dosattr:FIO.FileAttr;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Lib.MakeAllPath(dirbase,u,d,"","");
    fixDirectory(dirbase);
    Lib.MakeAllPath(filespec,"","",n,e);

    lastEntry:=firstEntry-1;
    anchor:=NIL;

    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,DOSentry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(S,w9Xentry.fullfilename);
        ELSE
            Str.Copy(S,DOSentry.Name);
        END;
        IF isReservedEntry(S) THEN (* skip "." ".." "*.SWP" "*.PAR" *)
            ; (* silently ignore this spec *)
        ELSE
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=DOSentry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                INC(lastEntry);
                IF lastEntry=MAX(CARDINAL) THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL);
                END; (* too many files but let's fake ALLOCATE failure *)
                Str.Prepend(S,dirbase);
                len:=Str.Length(S);
                needed:=SIZE(entryType)-SIZE(CHAR)+len;
                IF Available(needed)=FALSE THEN
                    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL);
                END; (* storage ALLOCATE failure *)
                CASE lastEntry OF
                | firstEntry :
                    ALLOCATE( anchor,needed);
                    newInList := anchor;
                ELSE
                    ALLOCATE(newInList^.next,needed);
                    newInList :=newInList^.next;
                END;
                Lib.FastMove( ADR(S),ADR(newInList^.string),len);
                newInList^.slen := len;
                newInList^.next := NIL;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(DOSentry);
        END;
    END;
    IF useLFN THEN rc:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN lastEntry;
END buildMatchList;

PROCEDURE freeMatchList (anchor:ptrToEntry);
VAR
    len,needed      : CARDINAL;
    firstInList,newInList   : ptrToEntry;
BEGIN
    firstInList := anchor;
    newInList := firstInList;
    WHILE newInList # NIL DO
        len         := CARDINAL(newInList^.slen);
        needed      := SIZE(entryType)-SIZE(CHAR)+len;
        firstInList := firstInList^.next;
        DEALLOCATE (newInList,needed);
        newInList := firstInList;
    END
END freeMatchList;

PROCEDURE getMatchEntry (VAR R:pathtype;
                         n:CARDINAL; anchor:ptrToEntry);
VAR
    i,len:CARDINAL;
    newInList:ptrToEntry;
    S:pathtype;
BEGIN
    newInList := anchor;
    DEC(n); (* trick to force to anchor if 1, and locate correct string if > 1 *)
    FOR i:=firstEntry TO n DO
         newInList := newInList^.next;
    END;
    len         := newInList^.slen;
    Lib.FastMove( ADR(newInList^.string),ADR(S),len);
    S[len]      := nullchar; (* REQUIRED safety ! *)
    Str.Copy(R,S); (* yep, compiler won't let us fill R directly *)
END getMatchEntry;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    sERR      = "--- ";
    sOK       = "+++ ";
    sINFO     = "::: ";
    sJoker    = "Joker(s)     : ";
    sDir      = "Directory    : ";
    sFNF      = "Not found    : ";
    sSeconds  = "24h rollover : ";
    sOld      = "Old stamp    : ";
    sNew      = "New stamp    : ";
    sUpdated  = "Updated      : ";

PROCEDURE fmsg (S1,S2:ARRAY OF CHAR; F:pathtype);
BEGIN
    WrStr(S1);WrStr(S2);
    WrStr(dquote); WrStr(F); WrStr(dquote);WrLn;
END fmsg;

(* ------------------------------------------------------------ *)

TYPE
    datetype = RECORD
        day   : CARDINAL;
        month : CARDINAL;
        year  : CARDINAL; (* 1980 is already added *)
        dayOfWeek : Lib.DayType;
    END;

PROCEDURE getDateNow (VAR d : datetype);
VAR
    dayOfWeek : Lib.DayType;
BEGIN
    Lib.GetDate(d.year,d.month,d.day,dayOfWeek);
END getDateNow;

PROCEDURE parseDate (S : ARRAY OF CHAR;
                     VAR date : datetype) : BOOLEAN;
CONST
    digits   = "0123456789";
    alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
CONST
    separator=dash;
    legaldateset = digits+separator+alphabet;
    mindd=1;
    maxdd=31;
    minmm=1;
    maxmm=12;
    minyy=1980; (* base year for messdos *)
    maxyy=2099;
VAR
    i : CARDINAL;
    R : str80;
    v : LONGCARD;
    ok: BOOLEAN;
BEGIN
    UpperCase(S); (* in case months would be letters *)
    ReplaceChar(S,slash,separator);
    FOR i := 0 TO (Str.Length(S)-1) DO
        IF Str.CharPos(legaldateset,S[i])=MAX(CARDINAL) THEN RETURN FALSE; END;
    END;
    IF CharCount(S,separator) # 2 THEN RETURN FALSE; END;

    Str.ItemS(R,S,separator,0);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < mindd) OR (v > maxdd) THEN RETURN FALSE; END;
    date.day := CARDINAL(v);

    Str.ItemS(R,S,separator,1);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN
        Str.Prepend(R,dash); (* fake command line parameter ! *)
        i := GetOptIndex(R,"JAN"+delim+"JAN"+delim+
                           "FEB"+delim+"FEV"+delim+
                           "MAR"+delim+"MAR"+delim+
                           "APR"+delim+"AVR"+delim+
                           "MAY"+delim+"MAI"+delim+
                           "JUN"+delim+"JUN"+delim+
                           "JUL"+delim+"JUI"+delim+
                           "AUG"+delim+"AOU"+delim+
                           "SEP"+delim+"SEP"+delim+
                           "OCT"+delim+"OCT"+delim+
                           "NOV"+delim+"NOV"+delim+
                           "DEC"+delim+"DEC");
        CASE i OF
        | 1..24 :
            v := LONGCARD(i+1) DIV 2;
        ELSE
            RETURN FALSE;
        END;
    END;
    IF (v < minmm) OR (v > maxmm) THEN RETURN FALSE; END;
    date.month := CARDINAL(v);

    Str.ItemS(R,S,separator,2);
    v := Str.StrToCard(R,10,ok);
    IF ok=FALSE THEN RETURN FALSE; END;
    IF (v < minyy) OR (v > maxyy) THEN RETURN FALSE; END;
    date.year := CARDINAL(v);
    RETURN TRUE;
END parseDate;

(* ------------------------------------------------------------ *)

CONST
    mintime      = LONGCARD(0);
    maxtime      = LONGCARD( (23*60+59)*60 ); (* 86340 *)
    timeinterval = LONGCARD(2);

TYPE
    dttype = RECORD
        CASE : BOOLEAN OF
        | TRUE  :
            hms : CARDINAL; (* hms is low  *)
            ymd : CARDINAL; (* ymd is high *)
        | FALSE :
            dt : LONGCARD;
        END;
    END;

(*
Year stored relative to 1980 (ex. 1988 stores as 8)
    year      month    day   

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number

Seconds are 0 to 29 -- DOS stores nearest even / 2
  hours    minutes   seconds 

 F E D C B A 9 8 7 6 5 4 3 2 1 0   <-- Bit Number
*)

CONST
    yyMask=BITSET{9..15};
    yyShft=9;
    mmMask=BITSET{5..8};
    mmShft=5;
    ddMask=BITSET{0..4};
    ddShft=0;
CONST
    hhMask=BITSET{11..15};
    hhShft=11;
    miMask=BITSET{5..10};
    miShft=5;
    ssMask=BITSET{0..4};
    ssShft=0;
CONST
    DOSbaseYear = 1980;

PROCEDURE unpackdate (ymd:CARDINAL;VAR y,m,d:CARDINAL);
BEGIN
    y :=  CARDINAL(BITSET(ymd) * yyMask) >> yyShft ;
    m :=  CARDINAL(BITSET(ymd) * mmMask) >> mmShft ;
    d :=  CARDINAL(BITSET(ymd) * ddMask) >> ddShft ;
    INC(y,DOSbaseYear);
END unpackdate;

PROCEDURE unpacktime (hms:CARDINAL;VAR h,m,s:CARDINAL);
BEGIN
    h :=  CARDINAL(BITSET(hms) * hhMask) >> hhShft ;
    m :=  CARDINAL(BITSET(hms) * miMask) >> miShft ;
    s :=  CARDINAL(BITSET(hms) * ssMask) >> ssShft ;
    s := s << 1; (* yes, yes, "* 2" works too... *)
END unpacktime;

PROCEDURE packdate (d,m,y : CARDINAL  ) : CARDINAL;
BEGIN
    y := (y - DOSbaseYear) << yyShft; (* 1980 *)
    m := m  << mmShft;
    RETURN (y + m + d);
END packdate;

PROCEDURE packtime (h,m,s:CARDINAL  ) : CARDINAL;
BEGIN
    h := h << hhShft;
    m := m << mmShft;
    s := s >> 1;
    RETURN (h + m + s);
END packtime;

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str16;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str16;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtDate (txt:BOOLEAN; y,m,d:CARDINAL) : str80;
CONST
    separator = dash;
    pad       ="0";
    baseyear  = 1900;
    tmonths   = "Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ???";
    tmonths2  = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ???";
VAR
    R : str80;
BEGIN
    IF ((m < 1) OR (m > 12)) THEN m := 13; END;
    IF txt THEN
        Str.ItemS(R,tmonths2," ",CARDINAL(m)-1);
    ELSE
        Str.Copy(R,using(CARDINAL(m),2,pad));
    END;
    Str.Prepend(R,separator);
    Str.Prepend(R,using(CARDINAL(d),2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(CARDINAL(y),4,pad));
    RETURN R;
END fmtDate;

PROCEDURE fmtTime (full:BOOLEAN; h,m,s:CARDINAL) : str16;
CONST
    separator = colon;
    pad       = "0";
VAR
    R : str16;
BEGIN
    R := using(CARDINAL(h),2,pad);
    Str.Append(R,separator);
    Str.Append(R,using(CARDINAL(m),2,pad));
    IF full THEN
        Str.Append(R,separator);
        Str.Append(R,using(CARDINAL(s),2,pad));
    END;
    RETURN R;
END fmtTime;

(* 23:42:12 = 85332 *)

PROCEDURE secondsToHMS (seconds:LONGCARD;VAR hh,mm,ss:CARDINAL);
CONST
    secondsPerHour = 60*60;
    minutesPerHour = 60;
    secondsPerMinute=60;
BEGIN
    hh := CARDINAL (seconds DIV secondsPerHour);
    mm := CARDINAL (seconds DIV minutesPerHour) MOD secondsPerMinute;
    ss := CARDINAL (seconds MOD 60 );
END secondsToHMS;

(* ------------------------------------------------------------ *)

PROCEDURE doStamp (VAR seconds:LONGCARD;
                  useLFN,apply:BOOLEAN;dateref:datetype;S:pathtype);
VAR
    hin:FIO.File;
    stamp:dttype;
    y,m,d, hh,mm,ss:CARDINAL;
    R:str128;
BEGIN
    IF chkJoker(S) THEN
        fmsg(sERR,sJoker,S);
        RETURN;
    END;
    IF fileIsDirectorySpec(useLFN,S) THEN
        fmsg(sERR,sDir,S);
        RETURN;
    END;
    IF fileExists(useLFN,S)= FALSE THEN
        fmsg(sERR,sFNF,S);
        RETURN;
    END;
    IF seconds > maxtime THEN
        fmsg(sERR,sSeconds,S);
        RETURN;
    END;

    IF fileIsRO(useLFN,S) THEN fileSetRW(useLFN,S);END; (* we won't reset RO attribute *)

    hin:=fileOpenRead(useLFN,S);
    stamp.dt:=FIO.GetFileDate(hin);

    unpackdate (stamp.ymd,  y ,m ,d );
    unpacktime (stamp.hms,  hh,mm,ss);

    Str.Concat(R,sOld, fmtDate(FALSE,y,m,d) );
    Str.Append(R,"  ");
    Str.Append(R,fmtTime (TRUE,hh,mm,ss) );
    Str.Append(R,"  ");
    fmsg(sINFO,R,S);

    d:=dateref.day;
    m:=dateref.month;
    y:=dateref.year;
    secondsToHMS(seconds,hh,mm,ss);
    Str.Concat(R,sNew, fmtDate(FALSE,y,m,d) );
    Str.Append(R,"  ");
    Str.Append(R,fmtTime (TRUE,hh,mm,ss) );
    Str.Append(R,"  ");
    fmsg(sINFO,R,S);

    stamp.ymd:=packdate(d,m,y);
    stamp.hms:=packtime(hh,mm,ss);
    IF apply THEN
        FIO.SetFileDate(hin,stamp.dt);
        fmsg(sOK,sUpdated, S);
    END;
    fileClose(useLFN,hin);

    INC(seconds,timeinterval);
END doStamp;

(* assume non-zero length *)

PROCEDURE unquote (VAR S:pathtype);
CONST
    pattern = dquote+star+dquote;
BEGIN
    IF Str.Match(S,pattern) THEN ReplaceChar(S,dquote,"");END;
END unquote;

PROCEDURE chkList (useLFN,apply:BOOLEAN;dateref:datetype;list:pathtype);
VAR
    hlist:FIO.File;
    S:pathtype; (* more than oversized *)
    seconds:LONGCARD;
BEGIN
    seconds:=mintime;
    hlist:=fileOpenRead(useLFN,list);
    FIO.AssignBuffer(hlist,ioBufferList);
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hlist,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);
        RtrimBlanks(S);
        CASE S[0] OF
        | nullchar,semicolon,pound:
            ;
        ELSE
            unquote(S);
            IF isReservedEntry(S) = FALSE THEN
                doStamp(seconds, useLFN,apply,dateref,S);
            END;
        END;
    END;
    fileClose(useLFN,hlist);
END chkList;

PROCEDURE chkMatches (useLFN,apply:BOOLEAN;dateref:datetype; lastEntry:CARDINAL;anchor:ptrToEntry);
VAR
    S:pathtype;
    i:CARDINAL;
    seconds:LONGCARD;
BEGIN
    seconds:=mintime;
    i:=firstEntry-1;
    LOOP
        INC(i);
        IF i > lastEntry THEN EXIT; END;
        getMatchEntry(S, i,anchor);
        doStamp(seconds,useLFN,apply,dateref,S);
    END;
END chkMatches;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 1;
VAR
    parmcount,i,opt,lastparm:CARDINAL;
    S,R,spec:pathtype;
    useLFN,apply:BOOLEAN;
    parm:ARRAY [firstparm..maxparm] OF pathtype;
    anchor:ptrToEntry;
    sDMY : str16; (* "##-###-####" *)
    dateref : datetype;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    IF atLeastDosVersion(3,20)=FALSE THEN abort(errDosVersion,"3.20"); END;

    lastparm    := firstparm-1;
    apply       := FALSE;
    useLFN      := TRUE;

    Str.Copy(sDMY,defaultDMY);
    IF parseDate(sDMY,dateref)=FALSE THEN abort(errBadDate,sDMY);END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "Y"+delim+"YES"+delim+
                                  "D:"+delim+"DATE:"
                              );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5:    apply     := TRUE;
            | 6,7:    GetString(R, sDMY); (* DMY is uppercased *)
                      IF same(sDMY,dateplaceholder) THEN
                          getDateNow(dateref);
                      ELSE
                          IF parseDate(sDMY,dateref)=FALSE THEN abort(errBadDate,R);END;
                      END;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errTooManyParms,S);END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;
    IF lastparm < firstparm THEN abort(errMissingSpec,"");END;

    useLFN:=( useLFN AND w9XsupportLFN() );
    IF useLFN=FALSE THEN
        FOR i:=firstparm TO lastparm DO
            UpperCase( parm[i] );
        END;
    END;
    Str.Copy(spec,parm[firstparm]);

    CASE spec[0] OF
    | arobas:
        Str.Delete(spec,0,1);
        IF Str.RCharPos(spec,dot)=MAX(CARDINAL) THEN Str.Append(spec,extLST);END;
        IF chkJoker(spec) THEN abort(errJokerList,spec);END;
        IF fileIsDirectorySpec(useLFN,spec) THEN abort(errNotFile,spec);END;
        IF fileExists(useLFN,spec)=FALSE THEN abort(errNotFound,spec);END;
        chkList (useLFN,apply,dateref,spec);
    ELSE
        IF same(spec,dot) THEN Str.Copy(spec,stardotstar);END;
        IF chkJokerPath(spec) THEN abort(errJokerPath,spec);END;
        i:=buildMatchList (anchor, useLFN,spec);
        CASE i OF
        | 0:
            abort(errNoMatch,S);
        | MAX(CARDINAL):
            abort(errTooMany,S);
        ELSE
            chkMatches (useLFN,apply,dateref,i,anchor);
        END;
        freeMatchList(anchor);
    END;

    abort(errNone,"");
END reStamp.

