(* -----------------------------------------------------------

------------------------------------------------------------ *)

MODULE fmtMDlog;

IMPORT Lib, FIO, Str, IO;

FROM IO IMPORT WrStr,WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileExistsAlt,
fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

(* ------------------------------------------------------------ *)

TYPE
    logtype = (unknown,
              cs,csb,csraw,csbraw,mdsummer,mdsum,nirsoft,
              unsupportedtarget);

CONST
    cr = CHR(13);
    lf = CHR(10);
    nl = cr+lf;
    slash     = "/";
    antislash = "\";
    unixsep   = slash;
    doswinsep = antislash;
CONST
    errNone             = 0;
    errHelp             = 1;
    errOpt              = 2;
    errParm             = 3;
    errExpect           = 4;
    errNotFound         = 5;
    errFmt              = 6;
    errUnknown          = 7;
    errData             = 8;
    errAbsolute         = 9;
    errRelative         = 10;
    errSame             = 11;
    errUnsupportedTarget= 12;

CONST
    sNSDASHES           = "==========";
    sNSFULLPATH         = "Full Path";
    sNSFILENAME         = "Filename";
    sNSMD5              = "MD5";
    sNSFILESIZE         = "File Size";
    sNSERROR            = "???";
    widigest            = 32; (* MD5 digest width in chars *)

CONST
    csheader =
    "MD5                                Length      Path"+nl+
    "---------------------------------  ----------  ---------------";
    hbar =
    "==============================================================";

CONST
    exe     = "FMTMDLOG";
    version = "v1.1a";
    msgHelp = "Q&D Format Message Digest Log "+version+" by PhG"+nl+
nl+
"Syntax : "+exe+" <source_file> <target_format> [-check]"+nl+
nl+
"    -c ignore safety checks (identical formats and relative to absolute paths)"+nl+
nl+
"This program converts a MD5 logfile from one format to another."+nl+
nl+
"a) <source_file> is a DOS filename."+nl+
"b) Output should be redirected to a file."+nl+
"c) Supported formats are CS (CS), CSB (CS -b), CSRAW (CS -g),"+nl+
"   CSBRAW (CS -b -g), SUMMER (MD5SUMMER or FSUM), SUM (MD5SUM or MD5SUMS -u)"+nl+
"   and NIRSOFT (HASHMYFILES)."+nl+
"d) NIRSOFT is supported as source format only."+nl+
'e) CS, CSRAW and SUM target formats use "'+sNSFULLPATH+'",'+nl+
'   while CSB, CSBRAW and SUMMER target formats use "'+sNSFULLPATH+'" without "?:\".'+nl+
'f) Unix "'+unixsep+'" path separator will be changed to DOS/Win "'+doswinsep+'" path separator.';

PROCEDURE abort (rc:CARDINAL;S:ARRAY OF CHAR);
BEGIN
    IF Str.Length(S) # 0 THEN WrLn; WrStr(S);WrLn;END;
    Lib.SetReturnCode( SHORTCARD(rc) );
    HALT;
END abort;

PROCEDURE dbg ( DEBUG:BOOLEAN;S:ARRAY OF CHAR  );
BEGIN
    IF DEBUG THEN WrStr("// ");WrStr(S);WrLn;END;
END dbg;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType    = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    ioBufferIn : ioBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* q&d rulez here *)

PROCEDURE getLogFmt (useLFN:BOOLEAN;F:pathtype ):logtype;
CONST
    afterdigest = widigest-1; (* we'll test 0..31 i.e. 32.. :  > test *)
VAR
    fmt:logtype;
    S:str1024;
    hin:FIO.File;
    state:(waiting,whatCS);
    pstar,pcolon:CARDINAL;
BEGIN
    fmt:=unknown;
    hin:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(hin,ioBufferIn);
    FIO.EOF:=FALSE;
    state:=waiting;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        FIO.RdStr(hin,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        IF ( S[0] = CHR(0) ) AND FIO.EOF THEN EXIT; END;
        IF S[0] # CHR(0) THEN
            CASE state OF
            | waiting:
                (* IF Str.Match(S,"*MD5*Length*Path*") THEN
                    state:=whatCS; *)
                IF Str.Match(S,"*--  ----------  --*") THEN
                    state:=whatCS;
              ELSIF Str.Match(S,"$*") THEN
                    IF Str.Match(S,"$*:\*") THEN
                        fmt:=csraw;
                    ELSE
                        fmt:=csbraw;
                    END;
                    EXIT;
                ELSIF Str.Match(S,sNSDASHES+"*") THEN
                    fmt:=nirsoft;
                    EXIT;
                ELSE
                    fmt:=unknown;
                    pstar:=Str.CharPos(S,"*");
                    IF pstar = MAX(CARDINAL) THEN
                        ;
                    ELSE
                        IF pstar > afterdigest THEN
                            pcolon:=Str.CharPos(S,":");
                            IF pcolon = MAX(CARDINAL) THEN
                                fmt:=mdsummer;
                            ELSE
                                IF pstar < pcolon THEN fmt:=mdsum;END;
                            END;
                        END;
                    END;
                    IF fmt # unknown THEN EXIT; END;
                END;
            | whatCS:
                IF Str.Match(S,"$*:\*") THEN
                    fmt:=cs;
                ELSE
                    fmt:=csb;
                END;
                EXIT;
            END;
        END;
    END;
    fileClose(useLFN,hin);
    RETURN fmt;
END getLogFmt;

(* ------------------------------------------------------------ *)

PROCEDURE parseMD (full:BOOLEAN;S:ARRAY OF CHAR;
                  VAR spath : pathtype;
                  VAR sdigest,ssize:ARRAY OF CHAR);
VAR
    p: CARDINAL;
BEGIN
    IF S[0]="$" THEN Str.Delete(S,0,1);END;
    Str.Slice(sdigest,S,0,widigest);
    Str.Delete(S,0,widigest);
    LtrimBlanks(S);
    IF full THEN
        p:=Str.CharPos(S," ");
        IF p # MAX(CARDINAL) THEN
            Str.Slice(ssize,S,0,p);
            Str.Delete(S,0,p);
            LtrimBlanks(S);
        ELSE
            Str.Copy(ssize,"0");
        END;
    ELSE
        Str.Copy(ssize,"0");
    END;
    IF S[0]="*" THEN Str.Delete(S,0,1);END;
    Str.Copy(spath,S);
END parseMD;

PROCEDURE nsParse (VAR R:ARRAY OF CHAR; S:ARRAY OF CHAR  );
VAR
    p:CARDINAL;

BEGIN
    p:=Str.CharPos(S,":");
    IF p=MAX(CARDINAL) THEN
        Str.Copy(R,sNSERROR);
    ELSE
        Str.Delete(S,0,p+1);
        LtrimBlanks(S);
        Str.Copy(R,S);
    END;
END nsParse;

PROCEDURE onlyDigits (VAR S:ARRAY OF CHAR   );
CONST
    sDigits = "0123456789";
VAR
    i:CARDINAL;
    R:str80;
    c:CHAR;
BEGIN
    R:="";
    FOR i:=1 TO Str.Length(S) DO
        c:=S[i-1];
        IF Str.CharPos(sDigits,c) # MAX(CARDINAL) THEN Str.Append(R,c);END;
    END;
    Str.Copy(S,R);
END onlyDigits;

PROCEDURE filteroutunit (VAR S:pathtype);
BEGIN
    IF Str.Match(S,"?:\*") THEN Str.Delete(S,0,3);END;
END filteroutunit;

PROCEDURE getdesc (fmt:logtype):str80;
VAR
    S:str80;
BEGIN
    CASE fmt OF
    | mdsum:     S:="md5sum or md5sums -u (SUM)";
    | mdsummer:  S:="md5summer or fsum (SUMMER)";
    | nirsoft:   S:="hashmyfiles (NIRSOFT)";
    | cs:        S:="cs (CS)";
    | csb:       S:="cs -b (CSB)";
    | csraw:     S:="cs -g (CSRAW)";
    | csbraw:    S:="cs -b -g (CSBRAW)";
    ELSE
                 S:="unknown";
    END;
    RETURN S;
END getdesc;

PROCEDURE fmtoutput (VAR S:ARRAY OF CHAR;
                     dstfmt:logtype;sPath:pathtype;sDigest,sSize:ARRAY OF CHAR);
VAR
    i:CARDINAL;
BEGIN
    CASE dstfmt OF
    | cs,csb,csraw,csbraw:
        Str.Concat(S,"$",sDigest);
        Str.Append(S,"  ");
        FOR i:=Str.Length(sSize)+1 TO 10 DO
            Str.Append(S," ");
        END;
        Str.Append(S,sSize);
        Str.Append(S,"  ");
        Str.Append(S,sPath);
    | mdsummer,mdsum:
        Str.Concat(S,sDigest," *");Str.Append(S,sPath);
    END;
END fmtoutput;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doConv (srcfmt,dstfmt:logtype;DEBUG,useLFN:BOOLEAN;F:pathtype ):BOOLEAN;
VAR
    S:str1024;
    hin:FIO.File;
    rc:BOOLEAN;
    fpos:LONGCARD;
    nsheaderdumped:BOOLEAN;
    state:(waiting,rewind,grabdata,grabnirsoft);
    sPath,nsCANONICAL:pathtype;
    sDigest,sSize:str80;
BEGIN
    rc:=FALSE;
    nsheaderdumped:=FALSE;
    state:=waiting;
    hin:=fileOpenRead(useLFN,F);
    FIO.AssignBuffer(hin,ioBufferIn);
    FIO.EOF:=FALSE;
    LOOP
        IF FIO.EOF THEN EXIT; END;
        IF state = waiting THEN fpos:=FIO.GetPos(hin); END;
        FIO.RdStr(hin,S);
        LtrimBlanks(S);
        RtrimBlanks(S);
        IF ( S[0] = CHR(0) ) AND FIO.EOF THEN EXIT; END;
        IF S[0] # CHR(0) THEN
dbg(DEBUG,S);
            CASE state OF
            | waiting:
dbg(DEBUG,"state = waiting");
                CASE srcfmt OF
                | cs,csb,csraw,csbraw:
                    IF Str.Match(S,"$*") THEN state:=rewind;END;
                | mdsummer:
                    IF Str.CharPos(S,"*") # MAX(CARDINAL) THEN state:=rewind;END;
                | mdsum:
                    IF Str.CharPos(S,":") # MAX(CARDINAL) THEN state:=rewind;END;
                | nirsoft:
                    IF NOT(nsheaderdumped) THEN
                        CASE dstfmt OF
                        | cs,csb: WrStr(csheader);WrLn; nsheaderdumped:=TRUE;
                        END;
                    END;
                    IF Str.Match(S,sNSDASHES+"*") THEN
                        nsCANONICAL := "";
                        sDigest     := "";
                        sSize       := "";
                        state       := grabnirsoft;
                    END;
                END;
            | rewind:
dbg(DEBUG,"state = rewind");
                CASE dstfmt OF
                | cs,csb: WrStr(csheader);WrLn;
                END;
                FIO.Seek(hin,fpos); (* rewind *)
                rc:=TRUE;
                state:=grabdata;
            | grabdata:
dbg(DEBUG,"state = grabdata");
                CASE srcfmt OF
                | cs,csb,csraw,csbraw:
                    parseMD(TRUE ,S, sPath,sDigest,sSize);
                | mdsummer,mdsum:
                    parseMD(FALSE,S, sPath,sDigest,sSize);
                END;
                CASE dstfmt OF
                | csb,csbraw,mdsummer : filteroutunit(sPath);
                END;
dbg(DEBUG,sPath);
dbg(DEBUG,sDigest);
dbg(DEBUG,sSize);
                fmtoutput(S, dstfmt,sPath,sDigest,sSize);
                ReplaceChar(S,unixsep,doswinsep);
                WrStr(S);WrLn;
            | grabnirsoft:
dbg(DEBUG,"state = grabnirsoft");
                IF Str.Match(S,sNSDASHES+"*") THEN
                    sPath := nsCANONICAL;
                    CASE dstfmt OF
                    | csb,csbraw,mdsummer: filteroutunit(sPath);
                    END;
dbg(DEBUG,sPath);
dbg(DEBUG,sDigest);
dbg(DEBUG,sSize);
                    fmtoutput(S, dstfmt,sPath,sDigest,sSize);
                    ReplaceChar(S,unixsep,doswinsep);
                    WrStr(S);WrLn;
                    state:=waiting;
                (*
                ELSIF Str.Match(S,sNSFILENAME+"*") THEN
                    nsParse(nsFN,S); *)
                ELSIF Str.Match(S,sNSMD5+"*") THEN
                    nsParse(sDigest,S);
                ELSIF Str.Match(S,sNSFULLPATH+"*") THEN
                    nsParse(nsCANONICAL,S);
                ELSIF Str.Match(S,sNSFILESIZE+"*") THEN
                    nsParse(sSize,S);
                    onlyDigits(sSize);
                END;
                rc:=TRUE;
            END;
        END;
    END;
    fileClose(useLFN,hin);
    RETURN rc;
END doConv;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    firstparm = 1;
    maxparm   = 2;
VAR
    S,R:str128;
    F:str128;
    SF,LF:path9X;
    DEBUG,useLFN,nosafetycheck,VERBOSE:BOOLEAN;
    rc:CARDINAL;
    i,opt,parmcount,lastparm:CARDINAL;
    parm : ARRAY [firstparm..maxparm] OF str128;
    srcfmt,dstfmt:logtype;
BEGIN
    FIO.IOcheck := FALSE; (* don't let topspeed handle problems *)
    FIO.ShareMode:=FIO.ShareDenyNone; (* very, very important ! *)
    (* WrLn; *)

    DEBUG           := FALSE;
    nosafetycheck   := FALSE;
    VERBOSE         := FALSE;
    lastparm        := firstparm-1;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,msgHelp);END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R, "?"+delim+"H"+delim+"HELP"+delim+
                                  "DEBUG"+delim+
                                  "C"+delim+"CHECK"+delim+
                                  "V"+delim+"VERBOSE"
                              );
            CASE opt OF
            | 1,2,3   : abort(errHelp,msgHelp);
            | 4       : DEBUG:=TRUE;
            | 5,6     : nosafetycheck:=TRUE;
            | 7,8     : VERBOSE := TRUE;
            ELSE
                abort(errOpt,"Unknown option !");
            END;
        ELSE
            INC(lastparm);
            IF lastparm > maxparm THEN abort(errParm,"Too many parameters !");END;
            Str.Copy(parm[lastparm],S); (* keep case *)
        END;
    END;
    CASE lastparm OF
    | firstparm -1 : abort(errExpect,"<source_file> <target_format> expected !");
    | firstparm    : abort(errExpect,              "<target_format> expected !");
    END;

    Str.Copy(LF, parm[firstparm] );
    IF Str.CharPos(LF,".")=MAX(CARDINAL) THEN Str.Append(LF,".");END;
    useLFN:=w9XsupportLFN();
    IF useLFN THEN
        IF w9XlongToShort(LF,rc,SF) THEN
            Str.Copy(F,SF);
        ELSE
            Str.Copy(F,LF);
        END;
    ELSE
        Str.Copy(F,LF);
    END;
    IF fileExists(useLFN,LF)=FALSE THEN abort(errNotFound,"<source_file> does not exist !");END;

    Str.Concat(R,"-",parm[firstparm+1]);
    UpperCase(R);
    opt := GetOptIndex(R,"CS,CSB,SUMMER,SUM,CSRAW,CSBRAW,NIRSOFT");
    CASE opt OF
    | 1: dstfmt := cs;
    | 2: dstfmt := csb;
    | 3: dstfmt := mdsummer;
    | 4: dstfmt := mdsum;
    | 5: dstfmt := csraw;
    | 6: dstfmt := csbraw;
    | 7: dstfmt := unsupportedtarget;
    ELSE
         dstfmt := unknown;
    END;

    CASE dstfmt OF
    | unsupportedtarget:
        abort(errUnsupportedTarget,"Unsupported <target_format> !");
    | unknown:
        abort(errFmt,"Unknown <target_format> !");
    END;

    srcfmt:=getLogFmt(useLFN,LF);

    IF VERBOSE THEN
        WrStr("======================================================");WrLn;
        WrStr("::: Source format : ");WrStr(getdesc(srcfmt));WrLn;
        WrStr("::: Target format : ");WrStr(getdesc(dstfmt));WrLn;
    END;

    IF srcfmt = unknown THEN abort(errUnknown,"Unknown <source_file> format !"); END;
    IF srcfmt = dstfmt THEN
        IF nosafetycheck =FALSE THEN
            abort(errSame,"<target_format> is identical to <source_file> !");
        END;
    END;

    IF VERBOSE THEN
        WrStr("======================================================");WrLn;
        WrLn;
    END;

    IF NOT(nosafetycheck) THEN
        CASE srcfmt OF
        | csb,csbraw,mdsummer:      (* relative *)
            CASE dstfmt OF
            | cs,csraw,mdsum,nirsoft:
                abort(errRelative,"<source_format> is relative while <target_format> is absolute !");
            END;
        END;
    END;

    Str.Concat(S,"Source format : ",getdesc(srcfmt));
dbg(DEBUG,S);
    Str.Concat(S,"Target format : ",getdesc(dstfmt));
dbg(DEBUG,S);

    IF doConv(srcfmt,dstfmt,DEBUG,useLFN,LF) = FALSE THEN abort(errData,"Corrupt file !");END;

    abort(errNone,"");
END fmtMDlog.

(*

0         1         2         3         4         5
012345678901234567890123456789012345678901234567890123456789

//CS
MD5                                Length      Path
---------------------------------  ----------  ---------------
$06f6f6ce6a65d5693d6379adb0aaaf64       23331  c:\z\newname.exe
$62e6d2280ecba85d87a21e3b5d56c188       29193  c:\z\bak\newline.exe

//CSRAW
$06f6f6ce6a65d5693d6379adb0aaaf64       23331  c:\z\newname.exe
$62e6d2280ecba85d87a21e3b5d56c188       29193  c:\z\bak\newline.exe

//CSB
MD5                                Length      Path
---------------------------------  ----------  ---------------
$06f6f6ce6a65d5693d6379adb0aaaf64       23331  newname.exe
$62e6d2280ecba85d87a21e3b5d56c188       29193  bak\newline.exe

//CSBRAW
$06f6f6ce6a65d5693d6379adb0aaaf64       23331  newname.exe
$62e6d2280ecba85d87a21e3b5d56c188       29193  bak\newline.exe

//SUMMER
# MD5 checksums generated by MD5summer (http://www.md5summer.org)
# Generated 29-03-2011 01:02:04

06f6f6ce6a65d5693d6379adb0aaaf64 *bak/NEWNAME.EXE
8b5e92c70f0794e265ad0d31bae51620 *NEWFONT.EXE

//SUM
06f6f6ce6a65d5693d6379adb0aaaf64 *C:\Z\NEWNAME.EXE
62e6d2280ecba85d87a21e3b5d56c188 *C:\Z\BAK\NEWLINE.EXE

//HASHMYFILES text report
==================================================
Filename          : lide25vst11012en.exe
MD5               : 7d772bf61b85a82e0dbae86a06d04e58
SHA1              : 6c4291f50c7ce51535bb74a7c1dcfdfcf24fb3c8
CRC32             : 3746ef3a
Full Path         : H:\zph\lide25vst11012en.exe
Modified Time     : 21/06/2011 18:43:40
Created Time      : 22/06/2011 11:41:54
File Size         : 8995152
File Version      :
Product Version   :
Identical         : 2
Extension         : exe
File Attributes   : A
==================================================

*)

(*
            Acs  Acsraw  Amdsum  Anirsoft  Rcsb  Rcsbraw  Rmdsummer  TARGET
Acs         !    +       +       -         +     +        +
Acsraw      +    !       +       -         +     +        +
Amdsum      +    +       !       -         +     +        +
Anirsoft    +    +       +       !         +     +        +
Rcsb        -    -       -       -         !     +        +
Rcsbraw     -    -       -       -         +     !        +
Rmdsummer   -    -       -       -         +     +        !
SOURCE
*)



(*
//TEST.BAT
@echo off
set _p=fmtmdlog -v
set _f=fmtmdlog.rpt

if exist %_f% del %_f%

set _s=CS
%_p%     %_s%    CS       >> %_f%
%_p%     %_s%    CSRAW    >> %_f%
%_p%     %_s%    SUM      >> %_f%
%_p%     %_s%    NIRSOFT  >> %_f%
%_p%     %_s%    CSB      >> %_f%
%_p%     %_s%    CSBRAW   >> %_f%
%_p%     %_s%    SUMMER   >> %_f%

set _s=CSRAW
%_p%     %_s%    CS       >> %_f%
%_p%     %_s%    CSRAW    >> %_f%
%_p%     %_s%    SUM      >> %_f%
%_p%     %_s%    NIRSOFT  >> %_f%
%_p%     %_s%    CSB      >> %_f%
%_p%     %_s%    CSBRAW   >> %_f%
%_p%     %_s%    SUMMER   >> %_f%

set _s=SUM
%_p%     %_s%    CS      >> %_f%
%_p%     %_s%    CSRAW   >> %_f%
%_p%     %_s%    SUM     >> %_f%
%_p%     %_s%    NIRSOFT >> %_f%
%_p%     %_s%    CSB     >> %_f%
%_p%     %_s%    CSBRAW  >> %_f%
%_p%     %_s%    SUMMER  >> %_f%

set _s=HASH
%_p%     %_s%    CS      >> %_f%
%_p%     %_s%    CSRAW   >> %_f%
%_p%     %_s%    SUM     >> %_f%
%_p%     %_s%    NIRSOFT >> %_f%
%_p%     %_s%    CSB     >> %_f%
%_p%     %_s%    CSBRAW  >> %_f%
%_p%     %_s%    SUMMER  >> %_f%

set _s=CSB
%_p%     %_s%    CS      >> %_f%
%_p%     %_s%    CSRAW   >> %_f%
%_p%     %_s%    SUM     >> %_f%
%_p%     %_s%    NIRSOFT >> %_f%
%_p%     %_s%    CSB     >> %_f%
%_p%     %_s%    CSBRAW  >> %_f%
%_p%     %_s%    SUMMER  >> %_f%

set _s=CSBRAW
%_p%     %_s%    CS      >> %_f%
%_p%     %_s%    CSRAW   >> %_f%
%_p%     %_s%    SUM     >> %_f%
%_p%     %_s%    NIRSOFT >> %_f%
%_p%     %_s%    CSB     >> %_f%
%_p%     %_s%    CSBRAW  >> %_f%
%_p%     %_s%    SUMMER  >> %_f%

set _s=SUMMER
%_p%     %_s%    CS      >> %_f%
%_p%     %_s%    CSRAW   >> %_f%
%_p%     %_s%    SUM     >> %_f%
%_p%     %_s%    NIRSOFT >> %_f%
%_p%     %_s%    CSB     >> %_f%
%_p%     %_s%    CSBRAW  >> %_f%
%_p%     %_s%    SUMMER  >> %_f%

:end

set _s=
set _f=
set _p=
*)
