

(*

   Pourquoi faire simple quand on peut rinventer la roue ? ;-)

   assume date won't change while we're initializing...

   remove ".bat" if specified as not to abort EMM386 : weird !

   weird (bis) : it won't run w386zero.com !

*)

MODULE Chrono;

IMPORT Lib;
IMPORT Str;

FROM IO IMPORT WrStr,WrLn;

TYPE
    str128 = ARRAY [0..127] OF CHAR;

(* ------------------------------------------------------------ *)

CONST
    errNone  = 0;
    errHelp  = 1;
    errCli   = 2;
    errFatal = 3;

PROCEDURE abort (e : SHORTCARD);
BEGIN
    Lib.SetReturnCode(e);
    HALT;
END abort;

CONST
    nullchar = CHR(0);
    dash     = "-";
    colon    = ":";
    blank    = " ";
    dquote   = '"';

(* ------------------------------------------------------------ *)

PROCEDURE getCli (VAR S : ARRAY OF CHAR);
VAR
    i : CARDINAL;
BEGIN
    i := 0;
    LOOP
        S[i] := Lib.CommandLine^[i];
        IF S[i] = nullchar THEN EXIT; END;
        INC(i);
    END;
END getCli;

PROCEDURE splitCli(cli:ARRAY OF CHAR;VAR cmd,parms : ARRAY OF CHAR);
VAR
    len   : CARDINAL;
    i     : CARDINAL;
    ch    : CHAR;
BEGIN
    len   := Str.Length(cli);
    i     := 0;
    LOOP
        IF i >= len THEN EXIT; END;
        ch := cli[i];
        IF ORD(ch) > ORD(blank) THEN EXIT; END;
        INC(i);
    END;
    LOOP
        IF i >= len THEN EXIT; END;
        ch := cli[i];
        IF ORD(ch) <= ORD(blank) THEN EXIT; END;
        INC(i);
    END;
    Str.Slice(cmd,cli,0,i);
    Str.Delete(cli,0,i);
    Str.Copy(parms,cli);
END splitCli;

(* ------------------------------------------------------------ *)

TYPE
    DTtype = RECORD
        year      : CARDINAL;
        month     : CARDINAL;
        day       : CARDINAL;
        hours     : CARDINAL;
        minutes   : CARDINAL;
        seconds   : CARDINAL;
        hundredth : CARDINAL;
        weekday   : Lib.DayType;
    END;

PROCEDURE GetDateTimeNow (VAR dt : DTtype);
BEGIN
    Lib.GetDate(dt.year,dt.month,dt.day,dt.weekday);
    Lib.GetTime(dt.hours,dt.minutes,dt.seconds,dt.hundredth);
END GetDateTimeNow;

(* ------------------------------------------------------------ *)

PROCEDURE using (n : CARDINAL; digits : CARDINAL; pad : CHAR) : str128;
VAR
    ok   : BOOLEAN;
    v    : LONGCARD;
    len  : CARDINAL;
    S    : str128;
BEGIN
    v := LONGCARD(n);
    Str.CardToStr(v,S,10,ok);
    len := Str.Length(S);
    LOOP
        IF Str.Length(S) >= digits THEN EXIT; END;
        Str.Prepend(S,pad);
    END;
    RETURN S;
END using;

PROCEDURE fmtDate (dt : DTtype; pad : CHAR) : str128;
CONST
    separator = dash;
    tmonths   = "Jan Fv Mar Avr Mai Jun Jui Ao Sep Oct Nov Dc ";
    tmonths2  = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ";
VAR
    R : str128;
BEGIN
    Str.ItemS(R,tmonths2," ",dt.month-1);
    Str.Prepend(R,separator);
    Str.Prepend(R,using(dt.day,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(dt.year,4,pad));
    RETURN R;
END fmtDate;

PROCEDURE fmtTime (dt : DTtype; pad : CHAR) : str128;
CONST
    separator = colon;
VAR
    R : str128;
BEGIN
    R := using(dt.hours,2,pad);
    Str.Append(R,separator);
    Str.Append(R,using(dt.minutes,2,pad));
    Str.Append(R,separator);
    Str.Append(R,using(dt.seconds,2,pad));
    Str.Append(R,".");
    Str.Append(R,using(dt.hundredth,2,pad));
    RETURN R;
END fmtTime;

CONST
    (*              "dd-mmm-yyyy at " *)
    msgDateFiller = "               ";

PROCEDURE fmtDateTime ( dt : DTtype) : str128;
VAR
    dmy : str128;
    hms : str128;
    R   : str128;
BEGIN
    dmy:=fmtDate(dt," ");
    hms:=fmtTime(dt,"0");
    R := " at ";
    Str.Prepend(R,dmy);
    Str.Append(R,hms);
    RETURN R;
END fmtDateTime;

(* by lazyness, assume program won't be run for more than one day ! *)

PROCEDURE fmtDelta (start,done : DTtype) : str128;
CONST
    minutesPerHour   = 60;
    secondsPerMinute = 60;
    hundred          = 100;
    midnight         = 24*minutesPerHour*secondsPerMinute*hundred;
VAR
    R        : str128;
    n        : LONGCARD; (* in hundredths of seconds *)
    hmsStart : LONGCARD;
    hmsEnd   : LONGCARD;
    delta    : DTtype;
BEGIN
    n := LONGCARD(start.hours) * minutesPerHour + LONGCARD(start.minutes);
    n := n * secondsPerMinute + LONGCARD(start.seconds);
    n := n * hundred + LONGCARD(start.hundredth);
    hmsStart := n;
    n := LONGCARD(done.hours)   * minutesPerHour + LONGCARD(done.minutes);
    n := n * secondsPerMinute + LONGCARD(done.seconds);
    n := n * hundred + LONGCARD(done.hundredth);
    hmsEnd := n;

    IF start.day # done.day THEN (* assume no more than one day ! *)
        hmsEnd := hmsEnd + midnight;
    END;
    n := hmsEnd-hmsStart; (* always >= 0 *)
    delta.hours    :=CARDINAL (n DIV (minutesPerHour*secondsPerMinute*hundred) );
    delta.minutes  :=CARDINAL((n DIV (               secondsPerMinute*hundred) ) MOD 60 );
    delta.seconds  :=CARDINAL((n DIV (                                hundred) ) MOD 60 );
    delta.hundredth:=CARDINAL (n MOD hundred);
    R := fmtTime(delta,"0");
    RETURN R;
END fmtDelta;

(* ------------------------------------------------------------ *)

(* fix weird problem if .bat specified : EMM386 bombs ! *)

PROCEDURE fixBatch (VAR cmd : ARRAY OF CHAR);
CONST
    extBat = ".BAT";
    len    = 4;
VAR
    S : str128;
    p : CARDINAL;
BEGIN
    Str.Copy(S,cmd);
    Str.Caps(S);  (* required here ! *)
    p := Str.Pos(S,extBat);
    IF p # MAX(CARDINAL) THEN
        Str.Delete(cmd,p,len);
    END;
END fixBatch;

PROCEDURE WrQuotedStr (S:ARRAY OF CHAR);
BEGIN
    WrStr(dquote);WrStr(S);WrStr(dquote);
END WrQuotedStr;

(* ------------------------------------------------------------ *)

CONST
    msgInternal = "Internal command : ";
    msgExternal = "External command : ";
    msgParms    = "Command line     : ";
    msgStarted  = "Start            : ";
    msgEnded    = "End              : ";
    msgElapsed  = "Elapsed          : ";
VAR
    S,cli,cmd,parms   : str128;
    start,done        : DTtype;
    parmcount,rc      : CARDINAL;
    showhelp,external : BOOLEAN;
BEGIN
    parmcount:=Lib.ParamCount();
    showhelp:=FALSE;
    CASE parmcount OF
    | 0 : showhelp:=TRUE;
    | 1 : Lib.ParamStr(S,1);
          showhelp:= ( (Str.Compare(S,"-?")=0) OR (Str.Compare(S,"/?")=0) );
    END;
    IF showhelp THEN
        WrLn;
        WrStr ("Q&D Chrono v1.0 by PhG");WrLn;
        WrLn;
        WrStr ("Syntax : CHRONO <command> [parameter]...");
        WrLn;
        abort(errHelp);
    END;
    getCli(cli);
    splitCli(cli,cmd,parms);
    fixBatch(cmd);
    GetDateTimeNow(start);
    rc := Lib.Exec (cmd,parms,NIL);
    GetDateTimeNow(done);
    IF rc = MAX(CARDINAL) THEN
        (* external failed : try internal command or batch *)
        GetDateTimeNow(start);
        rc := Lib.ExecCmd (cli);
        GetDateTimeNow(done);
        IF rc = MAX(CARDINAL) THEN
            WrStr ("CHRONO : Unexpected fatal error !");
            abort(errFatal);
        END;
        external := FALSE;
    ELSE
        external := TRUE;
    END;

    WrLn;

    IF external THEN
        WrStr(msgExternal);WrQuotedStr(cmd);WrLn;
        WrStr(msgParms);WrQuotedStr(parms);WrLn;
    ELSE
        WrStr(msgInternal);WrQuotedStr(cli);WrLn;
    END;

    (* WrLn; *)
    WrStr(msgStarted);
    S:=fmtDateTime(start);
    WrStr(S);WrLn;
    WrStr(msgEnded);
    S:=fmtDateTime(done);
    WrStr(S);WrLn;
    (* WrLn; *)
    WrStr(msgElapsed);
    S:=fmtDelta(start,done);
    WrStr(msgDateFiller);
    WrStr(S);WrLn;

    abort(errNone);
END Chrono.


