' ---------------------------------------------------------------
' Title         Q&D Shuttle
' Overview      Yet another useless demo...
' Usage         SHUTTLE
' Notes         can't remember where I got the shuttle data !
' Bugs
' Wish List
' ---------------------------------------------------------------

$CPU            80286

$OPTIMIZE       SIZE
$COMPILE        EXE

$DEBUG MAP      OFF
$DEBUG PBDEBUG  OFF

$LIB COM        OFF
$LIB CGA        OFF
$LIB EGA        ON
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  ON

$ERROR BOUNDS   Off
$ERROR NUMERIC  Off
$ERROR OVERFLOW Off
$ERROR STACK    Off

$FLOAT          PROCEDURE

$COM            0
$STRING         16
$STACK          8192 ' big stack for big local array in SUB
$SOUND          1

$DIM            ARRAY

$DYNAMIC

$OPTION         CNTLBREAK ON ' OFF in final EXE

'--------------------------------------------------------------------

DEFsng A-Z
OPTION ARRAY BASE 0
OPTION BINARY BASE 0

%False = 0
%True  = NOT %False

'--------------------------------------------------------------------
' internal functions

DECLARE SUB GetStrLoc() ' PowerBasic runtime library

SUB StdOut ( BYVAL Text AS STRING )
! push DS                    ; save DS FOR PowerBASIC
! push WORD Ptr Text         ; push STRING handle on stack
! CALL GetStrLoc
! jcxz ExitStdOut
! mov  DS, DX
! mov  DX, AX
! mov  AH, &H40              ; DOS WRITE TO file
! mov  BX, 1                 ; file handle 1 is CONS
! INT  &H21
ExitStdOut:
! pop  DS
END SUB

SUB StdOutLn( BYVAL s$ )
CALL StdOut (s$ + CHR$(13, 10) )
END SUB

'--------------------------------------------------------------------
' global

%quantity=5

%firstVertex = 1
%maxVertex   = 300

%firstVector = 1
%maxVector   = 300

type vertextype
    x as single
    y as single
    z as single
end type

dim einfo as shared string
dim exename as shared string
dim banner as shared string
dim lastvertex as shared integer
dim lastvector as shared integer
dim vertex (%firstvertex:%maxvertex) as shared vertextype
dim vector (%firstvector:%maxvector) as shared integer
dim pi as single
dim p2 as single

'--------------------------------------------------------------------
'
ON ERROR GOTO Abort

GOTO Start: ' jump to main() ;-)

'--------------------------------------------------------------------
' error handling

%eNone      = 100
%eHelp      = %eNone+1
%eNeedVGA   = %eNone+2
%eTooManyVertices = %eNone+3
%eTooManyVectors  = %eNone+4

Abort:
IF ERR = %eHelp THEN
    stdoutln ""
    stdoutln "Title  : "+Banner$
    stdoutln ""
    stdoutln "Usage  : Yet another useless demo..."
    stdoutln ""
    stdoutln "Syntax : "+ExeName$
END IF
SELECT CASE ERR
case %eNeedVGA
    e$="VGA card required !"
case %eTooManyVertices
    e$="Too many vertices !"
case %eTooManyVectors
    e$="Too many vectors !"

CASE ELSE
    e$=HEX$(ERADR) ' ERADR is a longint (7fFFffFF)
    e$=MID$("00000000",1,8-LEN(e$))+e$
    e$= "Error #"+MID$(STR$(ERR),2)+" at $"+e$+" !"
END SELECT
e$=exeName$+" : "+e$
IF err <> %eHelp AND err <> %eNone THEN
    stdoutln ""
    stdoutln e$
end if
END ERR-%eNone

'--------------------------------------------------------------------

sub initdata
restore vertexdata
lastvertex=%firstvertex
do
    read x,y,z
    if x=0 and y=0 and z=0 then exit loop
    vertex(lastvertex).x=x
    vertex(lastvertex).y=y
    vertex(lastvertex).z=z
    incr lastvertex
    if lastvertex > %maxvertex then error %eTooManyVertices
loop
decr lastvertex

restore vectordata
lastvector=%firstvector
do
    read v
    if v=0 then exit loop
    vector(lastvector)=v
    incr lastvector
    if lastvector > %maxvector then error %eTooManyVectors
loop
decr lastvector

end sub

vertexdata:
' 124
DATA 0,-2.2,46,1.5,-2.6,46,2.2,-4.6,46,1.7,-6.5,46,0,-6.7,46
DATA -1.7,-6.5,46,-2.2,-4.6,46,-1.5,-2.6,46
DATA 0,-.8,43,2.8,-1.5,43,4,-4.5,43,3,-7.2,43,0,-8,43,-3,-7.2,43
DATA -4,-4.5,43,-2.8,-1.5,43
DATA 0,1.7,38,4.6,0,38,5.8,-4.4,38,4,-8.2,38,0,-9,38,-4,-8.2,38
DATA -5.8,-4.4,38,-4.6,0,38
DATA 0,4,32.5,4.5,1,32.5,5.8,-4.6,32.5,4,-9,32.5,0,-9.5,32.5,-4,-9,32.5
DATA -5.8,-4.6,32.5,-4.5,1,32.5
DATA 0,8,26.3,3.5,7,26.3,7.8,2,26.3,8,-7,26.3,0,-9.8,26.3,-8,-7,26.3
DATA -7.8,2,26.3,-3.5,7,26.3
DATA 0,8,21.5,3.8,7.5,21.5,8,3,21.5,8,-8,21.5,0,-9.8,21.5,-8,-8,21.5
DATA -8,3,21.5,-3.8,7.5,21.5
DATA 0,8,14,4.7,7,14,8,4,14,8,-8.7,14,0,-10,14,-8,-8.7,14,-8,4,14
DATA -4.7,7,14
DATA 0,8,4,4.7,7,4,8,4,4,8,-8.7,4,0,-10,4,-8,-8.7,4,-8,4,4
DATA -4.7,7,4
DATA 0,8,-12,4.7,7,-12,8,4,-12,8,-8.7,-12,0,-10,-12,-8,-8.7,-12,-8,4,-12
DATA -4.7,7,-12
DATA 0,8,-27.3,4.7,7,-27.3,8,4,-27.3,8,-8.7,-27.3,0,-10,-27.3,-8,-8.7,-27.3
DATA -8,4,-27.3,-4.7,7,-27.3
DATA 0,8,-35.6,4.7,7,-35.6,8,4,-35.6,8,-8.7,-35.6,0,-10,-35.6,-8,-8.7,-35.6
DATA -8,4,-35.6,-4.7,7,-35.6
DATA 0,9,-43,2,8.5,-43,8.8,1.5,-43,9,-10,-43,0,-10.8,-43,-9,-10,-43
DATA -8.8,1.5,-43,-2,8.5,-43
DATA 0,9.5,-48,2,9.3,-48,9.2,1.5,-48,10,-10,-48,0,-10.2,-48,-10,-10,-48
DATA -9.2,1.5,-48,-2,9.3,-48
DATA 8.7,-8.7,21,15,-8.7,-16,35,-10,-36,35,-10,-40
DATA -8.7,-8.7,21,-15,-8.7,-16,-35,-10,-36,-35,-10,-40
DATA 0,13,-37,0,33,-60,0,33,-69,0,14,-60
DATA 6,11,-43,6,11,-48,11,5,-43,11,5,-48,-6,11,-43,-6,11,-48,-11,5,-43
DATA -11,5,-48
data 0,0,0

vectordata:
' 259
DATA -1,2,3,4,5,6,7,8,1,-9,10,11,12,13,14,15,16,9,-17,18,19,20,21,22,23,24,17
DATA -25,26,27,28,29,30,31,32,25,-33,34,35,36,37,38,39,40,33
DATA -41,42,43,44,45,46,47,48,41,-49,50,51,52,53,54,55,56,49
DATA -57,58,59,60,61,62,63,64,57,-65,66,67,68,69,70,71,72,65
DATA -73,74,75,76,77,78,79,80,73,-81,82,83,84,85,86,87,88,81
DATA -89,90,91,92,93,94,95,96,89,-97,98,99,100,101,102,103,104,97
DATA -1,9,17,25,33,41,49,57,65,73,81,89,97
DATA -2,10,18,26,34,42,50,58,66,74,82,90,98
DATA -3,11,19,27,35,43,51,59,67,75,83,91,99
DATA -4,12,20,28,36,44,52,60,68,76,84,92,100
DATA -5,13,21,29,37,45,53,61,69,77,85,93,101
DATA -6,14,22,30,38,46,54,62,70,78,86,94,102
DATA -7,15,23,31,39,47,55,63,71,79,87,95,103
DATA -8,16,24,32,40,48,56,64,72,80,88,96,104
DATA -44,105,106,107,108,92
DATA -46,109,110,111,112,94
DATA -81,113,114,115,116,89
DATA -82,117,118,-83,119,120
DATA -87,121,122,-88,123,124
DATA -117,119,-121,123,-118,120,-122,124
data 0

'--------------------------------------------------------------------

FUNCTION IsVGA()
IF BIT (pbvScrnCard,5) = 0 THEN
    IsVGA = %False
ELSE
    IsVGA = %True
END IF
END FUNCTION

SUB WaitVGARetrace
!   mov dx,&h03DA
l1:
!   in al,dx
!   and al,&h08
!   jnz l1
l2:
!   in al,dx
!   and al,&h08
!   jz  l2
END SUB

%text = 0
%cga  = 2 ' 640x200 CGA
%hires= 12

SUB setTextMode
SCREEN %cga ' reset width to 80
SCREEN %text
END SUB

%xmax   = 640-1
%ymax   = 480-1
%xmin   = 0
%ymin   = 0

%cx = %xmax \ 2
%cy = %ymax \ 2

function setHiresMode()
screen %hires
end function

'--------------------------------------------------------------------

Start:

EXEName$        = "SHUTTLE"
ProgramName$    = "Q&D Shuttle"
Version$        = "v1.0"
Copyright$      = "by PhG"
Banner$         = ProgramName$+" "+Version$+" "+Copyright$

cli$=command$
cli$=ltrim$(rtrim$(cli$))
cli$=ucase$(cli$)
if cli$ <> "" then error %eHelp

if isVGA =%false then error %eNeedVGA

rc=SetHiresMode
initdata
pi=4 * atn(1)
p2=pi+pi

rotx=10
roty=10
rotz=10
zooming=1

d=%ymax / 2

do
    color 15
    cls
    locate 1,1
    print "Xc :";rotx
    print "Yu :";roty
    print "Ze :";rotz
    print "+- :";zooming

    alphaX=p2*rotx / 255 - pi
    alphaY=p2*roty / 255
    alphaZ=p2*rotz / 255

    AM = cos(alphaZ) * Cos(alphaY) - Sin(alphaY) * Sin(alphaX) * sin(alphaZ)
    BM = -cos(alphaZ) * Sin(alphaY) - Sin(alphaX) * Cos(alphaY) * sin(alphaZ)
    CM = Cos(alphaX) * sin(alphaZ)
    DM = Sin(alphaY) * Cos(alphaX)
    EM = Cos(alphaX) * Cos(alphaY)
    FM = Sin(alphaX)
    GM = -Cos(alphaY) * sin(alphaZ) - Sin(alphaY) * Sin(alphaX) * cos(alphaZ)
    HM = Sin(alphaY) * sin(alphaZ) - Sin(alphaX) * Cos(alphaY) * cos(alphaZ)
    IM = Cos(alphaX) * cos(alphaZ)

    XV = -D * Cos(alphaX) * Sin(alphaY)
    YV = -D * Cos(alphaX) * Cos(alphaY)
    ZV = -D * Sin(alphaX)

    FOR i=1 TO lastvector
        ndx=vector(i)
        select case ndx
        case < 0
            dodraw=%false
        case else
            dodraw=%true
        end select
        ndx=abs(ndx)

        X = Vertex( ndx ).x
        Y = Vertex( ndx ).y
        Z = Vertex( ndx ).z

        X = X - XV
        Y = Y - YV
        Z = Z - ZV
        X3 = AM * X + BM * Y + CM * Z
        Y3 = DM * X + EM * Y + FM * Z
        Z3 = GM * X + HM * Y + IM * Z
        U = %cx + zooming * D * X3 / Y3
        V = %cy - zooming * D * Z3 / Y3
        newh = u
        newv = v
        IF dodraw=%true THEN LINE (oldh,oldv)-(newh,newv),10

        oldh = newh
        oldv = newv
    NEXT

    do
    loop until instat
    c$=inkey$
    select case ucase$(c$)
    case "X"
        incr rotx,%quantity
    case "C"
        decr rotx,%quantity
    case "Y"
        incr roty,%quantity
    case "U"
        decr roty,%quantity
    case "Z"
        incr rotz,%quantity
    case "E"
        decr rotz,%quantity
    case "+"
        incr zooming, 0.1
    case "-"
        decr zooming, 0.1
    case chr$(27)
        exit loop
    end select
    if rotx < 0 then incr rotx,360
    if roty < 0 then incr roty,360
    if rotz < 0 then incr rotz,360
    rotx=rotx mod 360
    roty=roty mod 360
    rotz=rotz mod 360

loop

SetTextMode
error %eNone
