
(* -----------------------------------------------------------------
Title         Q&D Parabolic Splines -- Curves
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              smoothing was tried (with 3 pages), but was both slow AND ugly
Bugs          not a real bug : we exclude black from possible colors,
              yet we allow redefinition of paper. Go figure ! ;-)

Wish List     tsk tsk...

----------------------------------------------------------------- *)

MODULE Curves;

IMPORT Lib;
IMPORT Str;
IMPORT SYSTEM;
IMPORT MsMouse;

FROM IO IMPORT WrStr, WrLn, WrLngHex;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode;

FROM ModeX IMPORT
Mode_320x200,Mode_320x400,Mode_360x200,Mode_360x400,
Mode_320x240,Mode_320x480,Mode_360x240,Mode_360x480,
SET_VGA_MODEX, SET_MODEX, CLEAR_VGA_SCREEN, SET_POINT, READ_POINT,
FILL_BLOCK, DRAW_LINE, SET_DAC_REGISTER, GET_DAC_REGISTER,
LOAD_DAC_REGISTERS, READ_DAC_REGISTERS,
SET_ACTIVE_PAGE, GET_ACTIVE_PAGE, SET_DISPLAY_PAGE, GET_DISPLAY_PAGE,
SET_WINDOW, GET_X_OFFSET, GET_Y_OFFSET, SYNC_DISPLAY,
GPRINTC, TGPRINTC, PRINT_STR, TPRINT_STR,
SET_DISPLAY_FONT, DRAW_BITMAP, TDRAW_BITMAP, COPY_PAGE, COPY_BITMAP,
mxTrue, mxFalse, mxnil,
c_BLACK, c_BLUE, c_GREEN, c_CYAN, c_RED, c_PURPLE, c_BROWN, c_WHITE,
c_GREY, c_bBLUE, c_bGREEN, c_bCYAN, c_bRED, c_bPURPLE, c_YELLOW, c_bWHITE,
c_BRIGHT,
Ky_F1, Ky_F2, Ky_F3, Ky_F4, Ky_F5, Ky_F6, Ky_F7, Ky_F8, Ky_F9, Ky_F10,
Ky_Up, Ky_Left, Ky_Right, Ky_Down,
Ky_SUp, Ky_SLeft, Ky_SRight, Ky_SDown,
Ky_Home, Ky_End, Ky_PgUp, Ky_PgDn,
Ky_SHome, Ky_SEnd, Ky_SPgUp, Ky_SPgDn,
Ky_Ins, Ky_Del, Ky_SIns, Ky_SDel, Ky_Tab, Ky_RvsTab, Ky_STab,
Ky_BS, Ky_CR, Ky_ESC, Ky_Clr, Ky_Plus, Ky_Minus,
Ky_AltA, Ky_AltB, Ky_AltC, Ky_AltD, Ky_AltE, Ky_AltF, Ky_AltG,
Ky_AltH, Ky_AltI, Ky_AltJ, Ky_AltK, Ky_AltL, Ky_AltM, Ky_AltN,
Ky_AltO, Ky_AltP, Ky_AltQ, Ky_AltR, Ky_AltS, Ky_AltT, Ky_AltU,
Ky_AltV, Ky_AltW, Ky_AltX, Ky_AltY, Ky_AltZ,
DOS_PRINT, DOS_PRINTS, SET_VIDEO_MODE,
SCAN_KEYBOARD, RANDOM_INT, INIT_RANDOM, INT_SQR, TIMER_COUNT;

(* ------------------------------------------------------------ *)

CONST
    cr         = CHR(13);
    lf         = CHR(10);
    Ky_Space   = 00020H;

(* ------------------------------------------------------------ *)

CONST
    sMode = "320x400x256";

CONST
    ProgEXEname   = "CURVES";
    ProgTitle     = "Q&D Curves"+" "+sMode;
    ProgVersion   = "v1.0f";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
    credit        = "(public domain Mode X v1.04 library by Matt Pritchard)";
CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errCannotSetHires = 5;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    nl = cr+lf;
    (*
     00000000011111111112222222222333333333344444444445555555555666666666677777777778
     1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
    *)
    helpmsg =
    Banner+nl+
    nl+
    credit+nl+
    nl+
    "Syntax : "+ProgEXEname+" [option]..."+nl+
    nl+
    "-c:# number of control points ([2..100], default=20)"+nl+
    "-s:# number of segments ([2..50], default=10)"+nl+
    "-t:# number of trails ([1..50], default=20)"+nl+
    "-m:# color mode (0=fixed, 1=random, 2..7=fading, default=2)"+nl+
    "-p:# RGB paper color (default=$000000)"+nl+
    "-i:# RGB ink color (default=$FFFF00 if m[0,2], else random)"+nl+
    "-f:# RGB ink to fade to color (default=$AF0000 if m[0,2], else random)"+nl+
    "-l:# lower speed ([1..50], default=5)"+nl+
    "-u:# upper speed ([1..50], default=10)"+nl+
    "-w:# wait ([0..50], default=0)"+nl+
    "-x   if m[3..6], use 16 colors palette for brightest (default=256 colors)"+nl+
    "-a   if m[3..6], use all 16 or 256 colors for brightest (default=bright only)"+nl+
    "-d:# if m[3..6], divisor shift for dimmest ([1..4], default=1)"+nl+
    "-r:# if m[3..6], number of rounds before color change (0=none, default=40)"+nl+
    "-n:# if m[4..6], increment for color RGB component fade ([1..15], default=2)"+nl+
    "-q:# if m[4..6], probability of change for n if it is 0 ([0..100], default=50)"+nl+
    "-o:# if m[4..6], probability of motion reverse if is # 0 ([0..100], default=20)"+nl+
    "-k:# if m[4..6], average dimmest RGB color component ([$00..$3F], default=$10)"+nl+
    "-z   abort not only on keypress but on mouseclick too"+nl+
    nl+
    '"+"'+" and "+'"-"'+" keys increment/decrement the number of trails,"+nl+
    '"F2"'+" and "+'"F1"'+" keys increment/decrement the number of control points,"+nl+
    '"F4"'+" and "+'"F3"'+" keys increment/decrement the lower speed,"+nl+
    '"F6"'+" and "+'"F5"'+" keys increment/decrement the upper speed."+nl+
    "Each color component SHOULD be in the [$00..$3F] range."+nl+
    "Not too ugly results for m=3..6 require some tweaking of options. ;-)"+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo);
        Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo);
        Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errCannotSetHires:
        Str.Concat(S,"Cannot set required ",einfo);
        Str.Append(S," mode !");

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getrndlongrange (min,max:LONGCARD  ):LONGCARD;
VAR
    range : LONGCARD;
    rnd : REAL;
BEGIN
    range := max-min+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(min);
    RETURN LONGCARD(rnd);
END getrndlongrange;

PROCEDURE getrndrange ( min,max:INTEGER ):INTEGER;
VAR
    range : CARDINAL;
BEGIN
    range := CARDINAL(max-min)+1 ;
    RETURN min+INTEGER(RANDOM_INT(range));
END getrndrange;

(* ------------------------------------------------------------ *)

CONST
    gPaperNDX = 128;
    gInkNDX   = 129; (* more than enough room for trails *)

VAR
    gControlPoints : CARDINAL;
    gSegments      : CARDINAL;
    gTrails        : CARDINAL;
    gMode          : (fixed,random,
                      fading,multifading,realfade,fullfade,newfade,rollfade);
    gPaper         : LONGCARD;
    gInk           : LONGCARD;
    gInkFadeTo     : LONGCARD;
    gMinSpeed      : CARDINAL;
    gMaxSpeed      : CARDINAL;
    gWait          : CARDINAL;
    gCycles        : CARDINAL;
    gShift         : CARDINAL;
    gRGBinc        : INTEGER;
    gPercent       : INTEGER;
    gPercentReverse: INTEGER;
    gDimLimit      : CARDINAL;

PROCEDURE initDefaults ();
BEGIN
    gControlPoints := 20;
    gSegments      := 10;
    gTrails        := 20;
    gMode          := fading;
    gPaper         := 0000000H;
    gInk           := 0FFFF00H;
    gInkFadeTo     := 0AF0000H;
    gMinSpeed      := 5;
    gMaxSpeed      := 10;
    gWait          := 0;
    gCycles        := 40; (* was 200 *)
    gShift         := 1;  (* 1=divide by 2, 2=divide by 4, etc. *)
    gRGBinc        := 2;  (* for RGB color component $00..$3F *)
    gPercent       := 50;
    gPercentReverse:= 20;
    gDimLimit      := 010H;
END initDefaults;

CONST
    minControlPoints = 2;
    maxControlPoints = 100;
    minSegments      = 2;
    maxSegments      = 50;
    minTrails        = 1;
    maxTrails        = 50;
    minColor         = 0000000H;
    maxColor         = 0FFFFFFH;
    brightest        = 03FH; (* RGB component *)
    (* dimlimit         = 010H; (* RGB component *) *)
    dimmest          = 000H; (* RGB component *)
    median           = 02AH; (* for RGB component if only bright *)
    minSpeed         = 1;
    maxSpeed         = 50;
    minWait          = 0;
    maxWait          = 50;
    minCycles        = 0;
    maxCycles        = 10000;
    minShift         = 1;
    maxShift         = 4;
    minRGBinc        = 1;
    maxRGBinc        = 15;
    minPercent       = 0;
    maxPercent       = 100;
    minPercentReverse = 0;
    maxPercentReverse = 100;
CONST
    firstknot        = 1;
    maxknot          = maxControlPoints;
    firstknotndx     = firstknot-1;
    maxknotndx       = maxknot+2;
    firsttrail       = minTrails;
    maxtrail         = maxTrails+1;
TYPE
    knotentry = RECORD
        x : INTEGER;
        y : INTEGER;
        dx: INTEGER;
        dy: INTEGER;
    END;
VAR
    knot : ARRAY [firstknotndx..maxknotndx],[firsttrail..maxtrail] OF knotentry;
    couleur : ARRAY [firsttrail..maxtrail] OF CARDINAL;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

CONST
    xMin=0;
    yMin=0;
    Page1=0;
    Page2=1;
    hires=Mode_320x400;   (* 320x400 *)
    xMax=320;
    yMax=400;
    PagesVirtual=2;
    xMaxVirtual=xMax;
    yMaxVirtual=yMax;

PROCEDURE doHires ():BOOLEAN;
BEGIN
    RETURN (SET_VGA_MODEX(hires,xMaxVirtual,yMaxVirtual,PagesVirtual) <> 0);
END doHires;

PROCEDURE doText ();
BEGIN
    SET_VIDEO_MODE(3);
END doText;

CONST
    egarange = 64; (* remember an EGA/VGA uses [$00..$3F], nothing more ! *)

PROCEDURE remap (ndx:CARDINAL;rgb:LONGCARD);
VAR
    r,g,b:CARDINAL;
BEGIN
    r := CARDINAL(rgb >> 16) MOD egarange;
    g := CARDINAL(rgb >> 8) MOD egarange;
    b := CARDINAL(rgb MOD egarange);
    SET_DAC_REGISTER(ndx,r,g,b);
END remap;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD):LONGCARD;
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    indx,icount:INTEGER;
BEGIN
    r1 := INTEGER ((startink >> 16) MOD egarange);
    g1 := INTEGER ((startink >> 8) MOD egarange);
    b1 := INTEGER ((startink MOD egarange));
    r2 := INTEGER ((endink >> 16) MOD egarange);
    g2 := INTEGER ((endink >> 8) MOD egarange);
    b2 := INTEGER ((endink MOD egarange));
    IF count = 0 THEN (* avoid divide by 0 !!! *)
        RETURN (LONGCARD(r1) << rshift) + (LONGCARD(g1) << gshift) + LONGCARD(b1);
    END;

    indx  :=INTEGER(ndx);
    icount:=INTEGER(count);

    r := r1 + ((r2 - r1) * indx) DIV icount;
    g := g1 + ((g2 - g1) * indx) DIV icount;
    b := b1 + ((b2 - b1) * indx) DIV icount;
    IF r < 0 THEN r:=0; END;
    IF g < 0 THEN g:=0; END;
    IF b < 0 THEN b:=0; END;

    RETURN (LONGCARD(r) << rshift) + (LONGCARD(g) << gshift) + LONGCARD(b);
END blend;

(* ------------------------------------------------------------ *)

(* ripped from GRAPH.DEF : importing'em adds useless initialisation code ! *)

CONST
    _BLACK         =  0000000H;
    _BLUE          =  02A0000H;
    _GREEN         =  0002A00H;
    _CYAN          =  02A2A00H;
    _RED           =  000002AH;
    _MAGENTA       =  02A002AH;
    _BROWN         =  000152AH;
    _GRAY          =  0151515H;
    _WHITE         =  02A2A2AH;
    _LIGHTBLUE     =  03F1515H;
    _LIGHTGREEN    =  0153F15H;
    _LIGHTCYAN     =  03F3F15H;
    _LIGHTRED      =  015153FH;
    _LIGHTMAGENTA  =  03F153FH;
    _LIGHTYELLOW   =  0153F3FH;
    _BRIGHTWHITE   =  03F3F3FH;

TYPE
    palette16=ARRAY[1..16] OF LONGCARD;
CONST
    pal16=palette16(
    _BLACK     ,
    _BLUE      ,
    _GREEN     ,
    _CYAN      ,
    _RED       ,
    _MAGENTA   ,
    _BROWN     ,
    _GRAY      ,
    _WHITE     ,
    _LIGHTBLUE ,
    _LIGHTGREEN,
    _LIGHTCYAN ,
    _LIGHTRED  ,
    _LIGHTMAGENTA,
    _LIGHTYELLOW ,
    _BRIGHTWHITE );
CONST
    minInk16 = 0;   (* black *)
    maxInk16 = 15;
    medInk16 = 8;   (* white *)

PROCEDURE normalize (VAR lc:LONGCARD;dimandbright:BOOLEAN);
VAR
    r,g,b,average,lower:CARDINAL;
BEGIN
    CASE dimandbright OF
    | TRUE : lower := gDimLimit;
    | FALSE: lower := median;
    END;
    r := CARDINAL(lc MOD 100H);
    g := CARDINAL(lc DIV 100H) MOD 100H;
    b := CARDINAL(lc DIV 10000H);
    r := r >> 2; (* MOD egarange; *)
    g := g >> 2;
    b := b >> 2;
    LOOP
        average := (r+g+b) DIV 3;
        IF average >= lower THEN EXIT; END;
        INC(r);
        INC(g);
        INC(b);
    END;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
END normalize;

PROCEDURE newcomponent (VAR component,motion:INTEGER;
                        lowerlimit,delta,percent,percentreverse:INTEGER);
CONST
    minproba = minPercent+1;
    maxproba = maxPercent-1;
BEGIN
    (* check if motion = 0 and change it according to random test *)
    CASE motion OF
    | 0 :
        IF getrndrange(minproba,maxproba) < percent THEN
            LOOP
                motion := getrndrange(-delta,delta);
                IF motion # 0 THEN EXIT; END;
            END;
        END;
    ELSE
        IF getrndrange(minproba,maxproba) < percentreverse THEN
            motion:=-motion;
        END;
    END;

    INC(component,motion);
    IF ( (component > lowerlimit) AND (component < egarange) ) THEN
        (* nada ! *)
    ELSE
        DEC(component,motion); (* restore value *)
        motion := -motion;
    END;
END newcomponent;

PROCEDURE newRGB (VAR lc:LONGCARD;VAR addr,addg,addb:INTEGER;
                  dimandbright:BOOLEAN; incr,proba,probareverse : INTEGER);
VAR
    r,g,b,average:INTEGER;
    lower:INTEGER;
BEGIN
    CASE dimandbright OF
    | TRUE: lower:= gDimLimit;
    |FALSE: lower:= median;
    END;
    r := INTEGER(lc MOD 100H);
    g := INTEGER(lc DIV 100H) MOD 100H;
    b := INTEGER(lc DIV 10000H);
    newcomponent(r,addr,lower,incr,proba,probareverse);
    newcomponent(g,addg,lower,incr,proba,probareverse);
    newcomponent(b,addb,lower,incr,proba,probareverse);
    LOOP
        average := (r+g+b) DIV 3;
        IF average >= lower THEN EXIT; END;
        INC(r);r:=r MOD egarange; (* seem to cure motionless color problem... but berk ! *)
        INC(g);g:=g MOD egarange;
        INC(b);b:=b MOD egarange;
    END;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
END newRGB;

PROCEDURE genRGB (  ):LONGCARD;
VAR
    r,g,b,average : CARDINAL;
    bgr : LONGCARD;
BEGIN
    (* getrndlongrange(dimmest,brightest); *)
    LOOP
        r := getrndrange(dimmest,brightest);
        g := getrndrange(dimmest,brightest);
        b := getrndrange(dimmest,brightest);
        average := (r+g+b) DIV 3;
        IF average >= gDimLimit THEN EXIT; END;
    END;
    bgr := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
    RETURN bgr;
END genRGB;

PROCEDURE reduce (lc:LONGCARD;shift:CARDINAL):LONGCARD; (* bgr, in fact *)
VAR
    r,g,b,average:CARDINAL;
BEGIN
    r := CARDINAL(lc MOD 100H);
    g := CARDINAL(lc DIV 100H) MOD 100H;
    b := CARDINAL(lc DIV 10000H);
    r := r >> shift;
    g := g >> shift;
    b := b >> shift;
    LOOP
        average := (r+g+b) DIV 3;
        IF average >= gDimLimit THEN EXIT; END;
        INC(r);
        INC(g);
        INC(b);
    END;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
    RETURN lc;
END reduce;

(* ------------------------------------------------------------ *)

PROCEDURE newdelta (lower,upper:INTEGER):INTEGER;
VAR
    delta : INTEGER;
BEGIN
    LOOP
        delta := getrndrange (-upper, upper);
        IF ABS(delta) >= lower THEN EXIT; END;
    END;
    RETURN delta;
END newdelta;

PROCEDURE initknots (numPts,numTrails:CARDINAL);
VAR
    i,ndx:CARDINAL;
BEGIN
    (*
    INIT_RANDOM;
    Lib.RANDOMIZE;
    *)
    ndx := firsttrail;
    FOR i := firstknot TO numPts DO
        knot[i,ndx].x := getrndrange(xMin,xMax);
        knot[i,ndx].y := getrndrange(yMin,yMax);
        knot[i,ndx].dx:= newdelta(gMinSpeed,gMaxSpeed);
        knot[i,ndx].dy:= newdelta(gMinSpeed,gMaxSpeed);
    END;
    FOR i := firstknot TO numPts DO
        FOR ndx := numTrails TO firsttrail BY -1 DO
            knot[i,ndx+1] := knot[i,ndx];
        END;
    END;
END initknots;

PROCEDURE moveknots (numPts,numTrails:CARDINAL);
VAR
    i,ndx: CARDINAL;
    p:INTEGER;
BEGIN
    FOR i := firstknot TO numPts DO
        FOR ndx := numTrails TO firsttrail BY -1 DO
            knot[i,ndx+1] := knot[i,ndx];
        END;
    END;
    ndx := firsttrail;
    FOR i := firstknot TO numPts DO
        LOOP
            p := knot[i,ndx].x + knot[i,ndx].dx;
            IF ( (p >= xMin) AND (p < xMax) ) THEN EXIT; END;
            knot[i,ndx].dx := newdelta(gMinSpeed,gMaxSpeed);
        END;
        knot[i,ndx].x := p;
        LOOP
            p := knot[i,ndx].y + knot[i,ndx].dy;
            IF ( (p >= yMin) AND (p < yMax) ) THEN EXIT; END;
            knot[i,ndx].dy := newdelta(gMinSpeed,gMaxSpeed);
        END;
        knot[i,ndx].y := p;
    END;
END moveknots;

(* ------------------------------------------------------------ *)

PROCEDURE Parab_Calc (T,D : REAL; Apx, Bpx, Cpx, Apy, Bpy, Cpy:INTEGER; VAR x,y:INTEGER);
VAR
    T2 : REAL;
    xx,yy:REAL;
BEGIN
    T2 := T * T;
    xx := ((REAL(Apx) * T2) + (REAL(Bpx) * T) + REAL(Cpx)) / D;
    yy := ((REAL(Apy) * T2) + (REAL(Bpy) * T) + REAL(Cpy)) / D;
    x := INTEGER(xx);
    y := INTEGER(yy);
END Parab_Calc;

PROCEDURE Parab_ComputeCoeffs (n, ndx:CARDINAL; VAR Apx, Bpx, Cpx, Apy, Bpy, Cpy:INTEGER);
BEGIN
    Apx := knot[n - 1, ndx].x - 2 * knot[n, ndx].x + knot[n + 1, ndx].x;
    Bpx := -2 * knot[n - 1, ndx].x + 2 * knot[n, ndx].x;
    Cpx := knot[n - 1, ndx].x + knot[n, ndx].x;
    Apy := knot[n - 1, ndx].y - 2 * knot[n, ndx].y + knot[n + 1, ndx].y;
    Bpy := -2 * knot[n - 1, ndx].y + 2 * knot[n, ndx].y;
    Cpy := knot[n - 1, ndx].y + knot[n, ndx].y;
END Parab_ComputeCoeffs;

PROCEDURE parabolicSplineIndividual (numPts,ndx,numSegments,ink:CARDINAL);
VAR
    i,j,n:CARDINAL;
    Apx,Bpx,Cpx,Apy,Bpy,Cpy:INTEGER;
    lastX,lastY:INTEGER;
    x,y:INTEGER;
    v1,res : REAL;
    half:CARDINAL;
BEGIN
    n := numPts;
    knot[firstknot - 1, ndx] := knot[n, ndx];
    knot[n + 1, ndx] := knot[firstknot, ndx];
    knot[n + 2, ndx] := knot[firstknot + 1, ndx];

    lastX := knot[firstknot, ndx].x;
    lastY := knot[firstknot, ndx].y;

    res := REAL(numSegments);
    half := numSegments DIV 2;

    i := firstknot;
    Parab_ComputeCoeffs (i, ndx, Apx, Bpx, Cpx, Apy, Bpy, Cpy);
    FOR j := 0 TO numSegments DO
        v1 := REAL(j);
        Parab_Calc (v1 / res, 2.0, Apx, Bpx, Cpx, Apy, Bpy, Cpy, x, y);
        IF j >= half THEN
            DRAW_LINE(lastX, lastY, x, y, ink);
        END;
        lastX := x;
        lastY := y;
    END;

    FOR i := firstknot + 1 TO n DO
        Parab_ComputeCoeffs (i, ndx, Apx, Bpx, Cpx, Apy, Bpy, Cpy);
        FOR j := 0 TO numSegments DO
            v1 := REAL(j);
            Parab_Calc (v1 / res, 2.0, Apx, Bpx, Cpx, Apy, Bpy, Cpy, x, y);
            DRAW_LINE(lastX, lastY, x, y, ink);
            lastX := x;
            lastY := y;
        END;
    END;

    i := n+1;
    Parab_ComputeCoeffs (i, ndx, Apx, Bpx, Cpx, Apy, Bpy, Cpy);
    FOR j := 0 TO numSegments DO
        v1 := REAL(j);
        Parab_Calc (v1 / res, 2.0, Apx, Bpx, Cpx, Apy, Bpy, Cpy, x, y);
        IF j < half THEN
            DRAW_LINE(lastX, lastY, x, y, ink);
        END;
        lastX := x;
        lastY := y;
    END;
END parabolicSplineIndividual;

PROCEDURE parabolicSpline (numPts,numTrails,numSegments:CARDINAL);
VAR
    i,ndx:CARDINAL;
BEGIN
    FOR ndx := numTrails TO firsttrail BY -1 DO
        parabolicSplineIndividual (numPts, ndx, numSegments,couleur[ndx]);
    END;
END parabolicSpline;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE okrange (lower,upper:CARDINAL; VAR v:CARDINAL;n:INTEGER):BOOLEAN ;
VAR
    i,k:CARDINAL;
BEGIN
    k:=0;
    FOR i := 1 TO ABS(n) DO
        IF n < 0 THEN
            DEC(v);
            IF v < lower THEN v:=lower;INC(k);END;
        ELSE
            INC(v);
            IF v > upper THEN v:=upper;INC(k);END;
        END;
    END;
    RETURN (k=0);
END okrange;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE longvalue (S:ARRAY OF CHAR;min,max:LONGCARD;VAR r:LONGCARD):BOOLEAN;
VAR
    R : str128;
    ok: BOOLEAN;
BEGIN
    GetString(S,R);
    IF Str.Length(R)=0 THEN RETURN FALSE; END;
    IF R[0]="$" THEN
        Str.Delete(R,0,1);
        r:=Str.StrToCard(R,16,ok);
        IF ok=FALSE THEN RETURN FALSE; END;
    ELSE
        IF GetLongCard(S,r)=FALSE THEN RETURN FALSE; END;
    END;
    IF r < min THEN RETURN FALSE; END;
    IF r > max THEN RETURN FALSE; END;
    RETURN TRUE;
END longvalue;

PROCEDURE swapCards (VAR v1,v2:CARDINAL);
VAR
    tmp:CARDINAL;
BEGIN
    IF v1 <= v2 THEN RETURN; END;
    tmp := v2;
    v2  := v1;
    v1  := tmp;
END swapCards;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

(* ------------------------------------------------------------ *)

VAR
    parmcount,i,opt   : CARDINAL;
    S,R               : str128;
    n                 : CARDINAL;
    workpage          : CARDINAL;
    stopmouse         : BOOLEAN;
    dimAndBright      : BOOLEAN;
    rounds            : CARDINAL;
    extendedpal       : BOOLEAN;
    addr,addg,addb    : INTEGER;
    addr2,addg2,addb2 : INTEGER;
    gotInk,gotInkFadeTo:BOOLEAN;
    newcount : BOOLEAN;
    pause    : BOOLEAN;
    ival     : INTEGER;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    initDefaults;
    stopmouse    := FALSE;
    dimAndBright := FALSE;
    extendedpal  := TRUE;
    gotInk       := FALSE;
    gotInkFadeTo := FALSE;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R)=TRUE THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "C:"+delim+"CONTROLPOINTS:"+delim+
                                 "S:"+delim+"SEGMENTS:"+delim+
                                 "T:"+delim+"TRAILS:"+delim+
                                 "M:"+delim+"MODE:"+delim+
                                 "P:"+delim+"PAPER:"+delim+
                                 "I:"+delim+"INK:"+delim+
                                 "F:"+delim+"INKFADETO:"+delim+
                                 "L:"+delim+"LOWERSPEED:"+delim+
                                 "U:"+delim+"UPPERSPEED:"+delim+
                                 "W:"+delim+"WAIT:"+delim+
                                 "Z"+delim+"MOUSE"+delim+
                                 "A"+delim+"ALL"+delim+
                                 "D:"+delim+"DIVISOR:"+delim+
                                 "R:"+delim+"ROUNDS:"+delim+
                                 "X"+delim+"EXTENDED"+delim+
                                 "N:"+delim+"DELTARGB:"+delim+
                                 "Q:"+delim+"PERCENT:"+delim+
                                 "O:"+delim+"REVERSE:"+delim+
                                 "K:"+delim+"DIMMEST:"
                              );
            CASE opt OF
            | 1,2,3 :
                abort(errHelp,"");
            | 4,5 :
                IF value(R,minControlPoints,maxControlPoints,gControlPoints)=FALSE THEN
                    abort(errRange,"number of control points");
                END;
            | 6,7 :
                IF value(R,minSegments,maxSegments,gSegments)=FALSE THEN
                    abort(errRange,"number of segments");
                END;
            | 8,9 :
                IF value(R,minTrails,maxTrails,gTrails)=FALSE THEN
                    abort(errRange,"number of trails");
                END;
            | 10,11:
                IF value(R,ORD(fixed),ORD(rollfade),n)=FALSE THEN
                    abort(errRange,"color mode");
                END;
                CASE n OF
                | ORD(fixed)        : gMode := fixed;
                | ORD(random)       : gMode := random;
                | ORD(fading)       : gMode := fading;
                | ORD(multifading)  : gMode := multifading;
                | ORD(realfade)     : gMode := realfade;
                | ORD(fullfade)     : gMode := fullfade;
                | ORD(newfade)      : gMode := newfade;
                | ORD(rollfade)     : gMode := rollfade;
                END;
            | 12,13:
                IF longvalue(R,minColor,maxColor,gPaper)=FALSE THEN
                    abort(errRange,"paper");
                END;
            | 14,15:
                IF longvalue(R,minColor,maxColor,gInk)=FALSE THEN
                    abort(errRange,"ink");
                END;
                gotInk := TRUE;
            | 16,17:
                IF longvalue(R,minColor,maxColor,gInkFadeTo)=FALSE THEN
                    abort(errRange,"ink to fade to");
                END;
                gotInkFadeTo := TRUE;
            | 18,19:
                IF value(R,minSpeed,maxSpeed,gMinSpeed)=FALSE THEN
                    abort(errRange,"minimum speed");
                END;
            | 20,21:
                IF value(R,minSpeed,maxSpeed,gMaxSpeed)=FALSE THEN
                    abort(errRange,"maximum speed");
                END;
            | 22,23:
                IF value(R,minWait,maxWait,gWait)=FALSE THEN
                    abort(errRange,"wait");
                END;
            | 24,25:
                stopmouse := TRUE;
            | 26,27:
                dimAndBright := TRUE;
            | 28,29:
                IF value(R,minShift,maxShift,gShift)=FALSE THEN
                    abort(errRange,"divisor shift");
                END;
            | 30,31:
                IF value(R,minCycles,maxCycles,gCycles)=FALSE THEN
                    abort(errRange,"rounds");
                END;
            | 32,33:
                extendedpal := FALSE;
            | 34,35:
                IF value(R,minRGBinc,maxRGBinc,n)=FALSE THEN
                    abort(errRange,"RGB increment");
                END;
                gRGBinc := INTEGER(n);
            | 36,37:
                IF value(R,minPercent,maxPercent,n)=FALSE THEN
                    abort(errRange,"percentage");
                END;
                gPercent := INTEGER(n);
            | 38,39:
                IF value(R,minPercentReverse,maxPercentReverse,n)=FALSE THEN
                    abort(errRange,"motion reverse percentage");
                END;
                gPercentReverse := INTEGER(n);
            | 40,41:
                IF value(R,dimmest,brightest,gDimLimit)=FALSE THEN
                    abort(errRange,"average dimmest RGB color component");
                END;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;
    swapCards(gMinSpeed,gMaxSpeed);

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;

    IF doHires()=FALSE THEN
        doText;
        abort(errCannotSetHires,sMode);
    END;

    INIT_RANDOM;
    Lib.RANDOMIZE;
    initknots(gControlPoints,maxTrails); (* was gTrails -- perform INIT_RANDOM and Lib.RANDOMIZE *)
    SET_ACTIVE_PAGE (Page2);
    CLEAR_VGA_SCREEN (gPaperNDX);
    COPY_PAGE (Page2,Page1);
    workpage := Page2;

    (* colors defined once for all *)

    remap(gPaperNDX,gPaper); (* remap AFTER hires ! *)
    remap(gInkNDX,gInk);

    CASE gMode OF
    | multifading,realfade,fullfade,newfade :
        IF extendedpal THEN
            IF gotInk=FALSE THEN
                gInk := genRGB();
                normalize(gInk,dimAndBright);
            ELSE
                normalize(gInk,TRUE); (* force all color range *)
            END;
            IF gMode = newfade THEN
                IF gotInkFadeTo=FALSE THEN
                    gInkFadeTo := genRGB();
                    normalize(gInkFadeTo,dimAndBright);
                ELSE
                    normalize(gInkFadeTo,TRUE);
                END;
            END;
        ELSE
            CASE dimAndBright OF
            | TRUE:  n := minInk16;
            | FALSE: n := medInk16;
            END;
            INC(n);
            i := getrndrange(n,maxInk16); (* exclude 0 (black) *)
            IF gotInk=FALSE THEN
                gInk := pal16[i];
            END;
            IF gMode=newfade THEN
                i := getrndrange(n,maxInk16); (* exclude 0 (black) *)
                IF gotInkFadeTo=FALSE THEN
                    gInkFadeTo := pal16[i];
                END;
            END;
        END;
        IF gMode # newfade THEN
            IF gotInkFadeTo=FALSE THEN
                gInkFadeTo := reduce(gInk,gShift); (* should be almost black *)
            END;
        END;
        rounds := gCycles; (* for multifading, realfade and fullfade *)
        (* following code is for realfade and fullfade *)
        addr   := getrndrange(-gRGBinc,gRGBinc);
        addg   := getrndrange(-gRGBinc,gRGBinc);
        addb   := getrndrange(-gRGBinc,gRGBinc);
        (* following code is for fullfade *)
        addr2  := getrndrange(-gRGBinc,gRGBinc);
        addg2  := getrndrange(-gRGBinc,gRGBinc);
        addb2  := getrndrange(-gRGBinc,gRGBinc);
    END;

    n := 0;
    FOR i := firsttrail TO gTrails DO
        CASE gMode OF
        | fixed:
            couleur[i] := gInkNDX;
        | random:
            remap(gInkNDX+n,genRGB());
            couleur[i] := gInkNDX + n;
        | fading,multifading,realfade,fullfade,newfade,rollfade:
            remap(gInkNDX+n,blend(n,gTrails-1,gInk,gInkFadeTo));
            couleur[i] := gInkNDX + n;
        END;
        INC(n);
    END;

    pause := FALSE;

    LOOP
        FOR i := 1 TO gWait DO
            WaitVGAretrace;
        END;
        IF pause=FALSE THEN
            SET_DISPLAY_PAGE (workpage);
            CASE workpage OF
            | Page1:  workpage:=Page2;
            | Page2: workpage:=Page1;
            END;
            SET_ACTIVE_PAGE(workpage);
            CLEAR_VGA_SCREEN(gPaperNDX);

            moveknots(gControlPoints,gTrails);
            parabolicSpline(gControlPoints,gTrails,gSegments);
        END;
        newcount := FALSE;
        n := SCAN_KEYBOARD();
        CASE n OF
        | Ky_Plus : (* seems definition was wrong ! *)
            IF gTrails < maxTrails THEN
                INC(gTrails);
            END;
            newcount := TRUE;
        | Ky_Minus : (* seems definition was wrong ! *)
            IF gTrails > minTrails THEN
                DEC(gTrails);
            END;
            newcount := TRUE;
        | Ky_CR,Ky_ESC : EXIT;
        | Ky_Space : pause := NOT(pause);
        | Ky_F1:
             ival := -1;
             IF okrange(minControlPoints,maxControlPoints,gControlPoints, ival) THEN
                initknots(gControlPoints,maxTrails);
             END;
        | Ky_F2:
             ival := 1;
             IF okrange(minControlPoints,maxControlPoints,gControlPoints, ival) THEN
                initknots(gControlPoints,maxTrails);
             END;
        | Ky_F3:
             ival := -1;
             IF okrange(minSpeed,maxSpeed,gMinSpeed, ival) THEN
                swapCards(gMinSpeed,gMaxSpeed);
             END;
        | Ky_F4:
             ival := 1;
             IF okrange(minSpeed,maxSpeed,gMinSpeed, ival) THEN
                swapCards(gMinSpeed,gMaxSpeed);
             END;

        | Ky_F5:
             ival := -1;
             IF okrange(minSpeed,maxSpeed,gMaxSpeed, ival) THEN
                swapCards(gMinSpeed,gMaxSpeed);
             END;
        | Ky_F6:
             ival := 1;
             IF okrange(minSpeed,maxSpeed,gMaxSpeed, ival) THEN
                swapCards(gMinSpeed,gMaxSpeed);
             END;
        END;
        (* IF (n # Ky_Space) THEN pause:=FALSE;END; *)
        IF newcount THEN
            (* ugly refresh if we fully reinit here *)
            n := 0;
            FOR i := firsttrail TO gTrails DO
                CASE gMode OF
                | fixed:
                    couleur[i] := gInkNDX;
                | random:
                    remap(gInkNDX+n,genRGB());
                    couleur[i] := gInkNDX + n;
                | fading,multifading,realfade,fullfade,newfade,rollfade:
                    remap(gInkNDX+n,blend(n,gTrails-1,gInk,gInkFadeTo));
                    couleur[i] := gInkNDX + n;
                END;
                INC(n);
            END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;

        CASE gMode OF
        | random:
            i:=getrndrange(firsttrail,gTrails);
            DEC(i,firsttrail); (* from 0 now *)
            remap(gInkNDX+i,genRGB());
            (* couleur[i] := gInkNDX + i; (* useless in fact ! ;-) *) *)
        | multifading:
            IF gCycles # 0 THEN
                DEC(rounds);
                IF rounds=0 THEN
                    IF extendedpal THEN
                        gInk := genRGB();
                        normalize(gInk,dimAndBright);
                    ELSE
                        CASE dimAndBright OF
                        | TRUE:  n := minInk16;
                        | FALSE: n := medInk16;
                        END;
                        INC(n);
                        i    := getrndrange(n,maxInk16); (* 1.. or 9.. *)
                        gInk := pal16[i];
                    END;
                    gInkFadeTo := reduce(gInk,gShift); (* should be almost black *)
                    rounds     := gCycles;
                    n := 0;
                    FOR i := firsttrail TO gTrails DO
                        remap(gInkNDX+n,blend(n,gTrails-1,gInk,gInkFadeTo));
                        (* couleur[i] := gInkNDX + n; (* useless in fact ! ;-) *) *)
                        INC(n);
                    END;
                END;
            END;
        | realfade:
            IF gCycles # 0 THEN
                DEC(rounds);
                IF rounds=0 THEN
                    rounds := gCycles;
                    newRGB(gInk,addr,addg,addb,dimAndBright,gRGBinc,gPercent,gPercentReverse); (* gInk already normalized *)
                    gInkFadeTo := reduce(gInk,gShift); (* should be almost black *)
                    n := 0;
                    FOR i := firsttrail TO gTrails DO
                        remap(gInkNDX+n,blend(n,gTrails-1,gInk,gInkFadeTo));
                        (* couleur[i] := gInkNDX + n; (* useless in fact ! ;-) *) *)
                        INC(n);
                    END;
                END;
            END;
        | fullfade,newfade:
            IF gCycles # 0 THEN
                DEC(rounds);
                IF rounds=0 THEN
                    rounds := gCycles;
                    newRGB(gInk,addr,addg,addb,dimAndBright,gRGBinc,gPercent,gPercentReverse); (* gInk already normalized *)
                    newRGB(gInkFadeTo,addr2,addg2,addb2,TRUE,gRGBinc,gPercent,gPercentReverse); (* we allow dimmed targets *)
                    n := 0;
                    FOR i := firsttrail TO gTrails DO
                        remap(gInkNDX+n,blend(n,gTrails-1,gInk,gInkFadeTo));
                        (* couleur[i] := gInkNDX + n; (* useless in fact ! ;-) *) *)
                        INC(n);
                    END;
                END;
            END;
        | rollfade:
            n:=couleur[firsttrail];
            FOR i := firsttrail TO (gTrails-1) DO
                couleur[i]:=couleur[i+1];
            END;
            couleur[gTrails]:=n;
            (*
            n:=couleur[gTrails];
            i:=gTrails;
            LOOP
                couleur[i]:=couleur[i-1];
                DEC(i);
                IF i = firsttrail THEN EXIT; END;
            END;
            couleur[firsttrail]:=n;
            *)
        END;
    END;

    SET_DISPLAY_PAGE(Page1);
    doText;
(* WrLngHex(gInk,8);WrLngHex(gInkFadeTo,8); *)
    abort(errNone,"");
END Curves.

