(* ---------------------------------------------------------------
Title         Q&D Between
Author        PhG
Overview      from a text file, keep lines located between <opening> and <closing>
Usage         see help
Notes         very, very, very quick & dirty... :-(
              warning if the same line can contain <opening> and <closing>
              ("---V" and "---" in Ralf Brown's lists)
              yes, we know, we could use dynamic string allocation or file pointers...
              yes, we know batches won't like search with "%" etc. !
Bugs
Wish List     LFN support ? bah...

--------------------------------------------------------------- *)

MODULE Between;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite,
getFileSize, verifyString, cleantabs;

(* ------------------------------------------------------------ *)

CONST
    percent  = "%";
    dotdot   = "..";
    netslash = "\\";
    nl = CHR(13)+CHR(10);
CONST
    ProgEXEname   = "BETWEEN";
    ProgTitle     = "Q&D Between";
    ProgVersion   = "v1.0d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone          = 0;
    errHelp          = 1;
    errUnknownOption = 2;
    errTooManyParms  = 3;
    errSyntaxMissing = 4;
    errSame          = 5;
    errJokers        = 6;
    errNotFound      = 7;
    errAlready       = 8;
    errReadOnly      = 9;
    errIllegal       = 10;
    errAbsurdity     = 11;
    errBadAlias      = 12;
    errAborted       = 13;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    msgHelp =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" <opening> <closing> <source> [report] [option]..."+nl+
nl+
"Read each line from <source> and write it to [report] only if line is enclosed"+nl+
"between lines containing <opening> and <closing> strings."+nl+
nl+
"  -a   append to existing <report>, creating it if required"+nl+
"  -o   overwrite existing <report>"+nl+
"  -c   case-sensitive filter"+nl+
"  -s   stricter requirement (<opening> ... <closing> pairs)"+nl+
"  -n   no dashes separator line"+nl+
"  -q   quiet"+nl+
"  -f   include filename in report"+nl+
'  -p:? replace specified character with "'+percent+'" in <opening> and <closing>'+nl+
"  -*   ignore <closing> text and dump lines from <opening> until end of file"+nl+
nl+
"a) Options MUST be specified AFTER <opening> and <closing> parameters,"+nl+
"   unless unexpected results are expected. ;-)"+nl+
"b) <opening> and <closing> strings must be carefully chosen as not to overlap."+nl+
"c) Each line in <source> must be smaller than 1024 characters."+nl+
"d) LFN support is NeverWare. ;-)"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(msgHelp);
    | errUnknownOption :
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," option !");
    | errTooManyParms :
        Str.Concat(S,"Uneeded ",einfo);Str.Append(S," parameter !");
    | errSyntaxMissing:
        S := "Bad command line syntax !";
    | errSame         :
        S := "<source> and <report> cannot be identical !";
    | errJokers       :
        Str.Concat(S,"Jokers not allowed in ",einfo);Str.Append(S," specification !");
    | errNotFound     :
        Str.Concat(S,einfo," does not exist !");
    | errAlready :
        Str.Concat(S,einfo," already exists !");
    | errReadOnly:
        Str.Concat(S,einfo," is read-only !");
    | errIllegal:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," filename !");
    | errAbsurdity :
        S := "-append and -overwrite options are mutually exclusive !";
    | errBadAlias:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," percent alias !");
    | errAborted:
        S := "Aborted by user !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp:
        ;
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
VAR
    inBuffer  : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
    outBuffer : ARRAY [firstBufferByte..lastBufferByte] OF BYTE;

(* ------------------------------------------------------------ *)

PROCEDURE doBetween (src,dest,opening,closing:ARRAY OF CHAR;
                     insensitive,verbose,append,strict,
                     nodashes,remindfile,rptfile,untilEOF:BOOLEAN):CARDINAL;
CONST
    semicolon = ";";
    nullchar = CHR(0);
    sep = "----------";
VAR
    hin,hout : FIO.File;
    S,R : str1024;
    status : (waiting,gotopening);
    foundopening,foundclosing,alcatraz:BOOLEAN;
    separator,reminder : str128;
    fpos,fanchor:LONGCARD;
BEGIN
    Str.Copy(separator,nl);
    IF nodashes =FALSE THEN
        Str.Append(separator,sep+sep+sep+sep+sep+sep+sep);
    END;
    Str.Append(separator,nl+nl);

    IF verbose THEN verbose := rptfile; END;

    IF verbose THEN AltAnimation(cmdInit);END;

    IF insensitive THEN
        UpperCase(opening);
        UpperCase(closing);
    END;

    hin := FIO.OpenRead(src);
    FIO.AssignBuffer(hin,inBuffer);

    IF rptfile THEN
        IF append THEN
            hout:= FIO.Append(dest);
        ELSE
            hout:= FIO.Create(dest);
        END;
    ELSE
        hout:=FIO.StandardOutput;
    END;
    FIO.AssignBuffer(hout,outBuffer);
    IF remindfile THEN
       Str.Copy(reminder,nl+semicolon+nl+semicolon+" Source file : ");
       Str.Append(reminder,src);
       Str.Append(reminder,nl+semicolon+nl);
       FIO.WrStr(hout,reminder);
    END;

    FIO.EOF:=FALSE;

    status := waiting;
    fanchor:=0; (* default just in case *)
    LOOP
        IF FIO.EOF THEN EXIT; END;
        fpos:=FIO.GetPos(hin);
        FIO.RdStr(hin,S);
        IF ( (S[0]=nullchar) AND FIO.EOF ) THEN EXIT; END; (* ugly hack ! *)
        IF verbose THEN AltAnimation(cmdShow);END;
        Str.Copy(R,S);
        IF insensitive THEN UpperCase(R);END;
        foundopening := Str.Pos(R,opening) # MAX(CARDINAL);
        foundclosing := Str.Pos(R,closing) # MAX(CARDINAL);

        CASE status OF
        | waiting:
            IF foundopening THEN
                fanchor:= fpos;
                status := gotopening;
            END;
        | gotopening:
            IF untilEOF THEN foundclosing:=TRUE;fpos:= FIO.Size(hin);END;
            IF foundclosing THEN
                FIO.WrStr(hout,separator);
                FIO.Seek(hin,fanchor);
                LOOP
                    IF ( (FIO.GetPos(hin) > fpos) OR FIO.EOF ) THEN EXIT; END;
                    FIO.RdStr(hin,R);
                    FIO.WrStr(hout,R);FIO.WrLn(hout);
                END;
                IF foundopening THEN
                    fanchor:=fpos;
                ELSE
                    status:=waiting;
                END;
            ELSE
                IF foundopening THEN
                    IF strict THEN
                        fanchor:=fpos;
                    END;
                ELSE
                   ;
                END;
            END;
        END;
        alcatraz:=ChkEscape();
        IF alcatraz THEN EXIT; END; (* safety *)
    END;
    IF rptfile THEN
        FIO.Flush(hout);
        FIO.Close(hout);
    END;
    FIO.Close(hin);
    IF verbose THEN AltAnimation(cmdStop);END;
    IF alcatraz THEN
        RETURN errAborted;
    ELSE
        RETURN errNone;
    END;
END doBetween;

(* ------------------------------------------------------------ *)

PROCEDURE wrboolean (tf:BOOLEAN;sT,sF:ARRAY OF CHAR);
BEGIN
    IF tf THEN
        WrStr(sT);
    ELSE
        WrStr(sF);
    END;
    WrLn;
END wrboolean;

PROCEDURE chkLegal (S : ARRAY OF CHAR ) : BOOLEAN;
(* minimalist check ! assume S is not "" and is already in uppercase *)
VAR
    i : CARDINAL;
BEGIN
    IF Str.Pos(S,dotdot) # MAX(CARDINAL) THEN RETURN FALSE; END;
    RETURN ( Str.Pos(S,netslash) = MAX(CARDINAL) );
END chkLegal;

(* ------------------------------------------------------------ *)

CONST
    strSource = "<source>";
    strReport = "<report>";
VAR
    got        : (waiting,gotopening,gotclosing,gotsource,gotreport);

    overwrite     : BOOLEAN;
    notsensitive  : BOOLEAN;
    verbose       : BOOLEAN;
    append        : BOOLEAN;
    strict        : BOOLEAN;
    nodashes      : BOOLEAN;
    remindfile    : BOOLEAN;
    untilEOF      : BOOLEAN;
    usealias      : BOOLEAN;
    percentalias  : CHAR;
    rptfile       : BOOLEAN;
    aborthere     : BOOLEAN;

    opening    : str128;
    closing    : str128;
    source     : str128;
    report     : str128;

    parmcount  : CARDINAL;
    i,opt      : CARDINAL;
    S,R,tmp    : str128;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck  := FALSE;
    WrLn;

    got          := waiting;
    overwrite    := FALSE;
    notsensitive := TRUE;
    verbose      := TRUE;
    append       := FALSE;
    strict       := FALSE;
    nodashes     := FALSE;
    remindfile   := FALSE;
    untilEOF     := FALSE;
    usealias     := FALSE;

    aborthere    := FALSE;
    parmcount := Lib.ParamCount();
    CASE parmcount OF
    | 0 : aborthere:=TRUE;
    | 1 : Lib.ParamStr(S,1);cleantabs(S); (* for QDTOOLS *)
          IF same(S,"/?") THEN aborthere:=TRUE;END;
          IF same(S,"-?") THEN aborthere:=TRUE;END;
    ELSE
          aborthere:=FALSE;
    END;
    IF aborthere THEN abort(errHelp,"");END;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF ( isOption(R) AND (i > 2) ) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "O"+delim+"OVERWRITE"+delim+
                                 "C"+delim+"CASE"+delim+
                                 "Q"+delim+"QUIET"+delim+
                                 "A"+delim+"APPEND"+delim+
                                 "S"+delim+"STRICT"+delim+
                                 "N"+delim+"NODASHES"+delim+
                                 "F"+delim+"FILENAME"+delim+
                                 "P:"+delim+"PERCENT:"+delim+
                                 "*"+delim+"EOF"
                               );
            CASE opt OF
            | 1,2,3 :   abort(errHelp,"");
            | 4,5 :     overwrite := TRUE;
            | 6,7 :     notsensitive := FALSE;
            | 8,9 :     verbose := FALSE;
            | 10,11:    append := TRUE;
            | 12,13:    strict := TRUE;
            | 14,15:    nodashes := TRUE;
            | 16,17:    remindfile:=TRUE;
            | 18,19:    GetString(S,tmp);
                        IF Str.Length(tmp) # 1 THEN abort(errBadAlias,S);END;
                        IF tmp[0] = percent THEN abort(errBadAlias,S);END;
                        percentalias:=tmp[0];
                        usealias:=TRUE;
            | 20,21:    untilEOF:=TRUE;
            ELSE
                abort(errUnknownOption,S); (* could be errHelp, eh eh ! *)
            END;
        ELSE
            CASE got OF
            | waiting    : Str.Copy(opening,S);      (* keep case *)
            | gotopening : Str.Copy(closing,S);      (* ditto *)
            | gotclosing : Str.Copy(source,R);       (* uppercase *)
            | gotsource  : Str.Copy(report,R);       (* ditto *)
            | gotreport  : abort(errTooManyParms,S);
            END;
            INC(got);
        END;
    END;
    CASE got OF
    | gotsource:
        report :="";
        rptfile:=FALSE;
    | gotreport:
        IF same(source,report) THEN abort(errSame,"");END;
        IF chkJoker(report) THEN abort(errJokers,strReport);END;
        IF chkLegal(report)=FALSE THEN abort(errIllegal,strReport);END;
        CASE append OF
        | FALSE :
            IF FIO.Exists(report) THEN
                IF overwrite THEN (* yes, we COULD use setreadwrite... *)
                    IF isReadOnly(report) THEN abort(errReadOnly,strReport); END;
                ELSE
                    abort(errAlready,strReport);
                END;
            END;
        | TRUE:
            IF FIO.Exists(report) THEN
                IF overwrite THEN abort(errAbsurdity,"");END; (* we could just ignore *)
                IF isReadOnly(report) THEN abort(errReadOnly,strReport);END;
            ELSE
                append := FALSE;
            END;
        END;
        rptfile:=TRUE;
    ELSE
        abort(errSyntaxMissing,"");
    END;

    IF chkJoker(source) THEN abort(errJokers,strSource);END;
    IF chkLegal(source)=FALSE THEN abort(errIllegal,strSource);END;
    IF FIO.Exists(source)=FALSE THEN abort(errNotFound,strSource);END;

    IF usealias THEN
        ReplaceChar (opening, percentalias, percent);
        ReplaceChar (closing, percentalias, percent);
    END;

    IF verbose THEN
        WrStr(Banner);WrLn;
        WrLn;
        WrStr("Source     : ");WrStr(source);WrLn;
        IF rptfile THEN
        WrStr("Report     : ");WrStr(report);WrLn;
        ELSE
        WrStr("Report     : <Standard Output>");WrLn;
        END;
        WrStr("Mode       : ");wrboolean(append,"append","create");
        WrStr('Opening    : "');WrStr(opening);WrStr('"');WrLn;
        IF untilEOF THEN
        WrStr("Closing    : <End of File> (-* option)");WrLn;
        ELSE
        WrStr('Closing    : "');WrStr(closing);WrStr('"');WrLn;
        END;
        WrStr("Exact case : ");wrboolean(notsensitive,"no","YES");
        WrStr("Strict     : ");wrboolean(strict,"YES","no");
        WrStr("Separator  : ");wrboolean(nodashes,"no","YES");
        WrStr("Filename   : ");wrboolean(remindfile,"YES","no");
    END;

    i:=doBetween (source,report,opening,closing,
                  notsensitive,verbose,append,strict,
                  nodashes,remindfile,rptfile,untilEOF);
    IF i # errNone THEN abort(i,"");END;

    abort(errNone,"");
END Between.



(*

newer v1.0c against older v1.0b test : ok !

set p=f:\tmp\between0
set e=.old
%p%  3D      3D     jeux.lst   a%e%     -o
%p%  3D      3D     jeux.lst   a_%e% -s -o
%p%  3D    rainbow  jeux.lst   b%e%     -o
%p%  3D    rainbow  jeux.lst   b_%e% -s -o

set p=c:\tools\ascii\between
set e=.new
%p%  3D      3D     jeux.lst   a%e%     -o
%p%  3D      3D     jeux.lst   a_%e% -s -o
%p%  3D    rainbow  jeux.lst   b%e%     -o
%p%  3D    rainbow  jeux.lst   b_%e% -s -o

*)

