'--------------------------------------------------------------------
' Title         Explode
'
' wish list     a better animate and a better smooth
'--------------------------------------------------------------------

$CPU 8086

$OPTIMIZE SIZE
$COMPILE EXE

$DEBUG MAP OFF
$DEBUG PBDEBUG OFF

$LIB COM        OFF
$LIB CGA        ON              ' ON required by SCREEN 2 & 0
$LIB EGA        OFF
$LIB VGA        OFF
$LIB HERC       OFF
$LIB LPT        OFF
$LIB IPRINT     OFF
$LIB FULLFLOAT  OFF

$ERROR BOUNDS   OFF
$ERROR NUMERIC  OFF
$ERROR OVERFLOW OFF
$ERROR STACK    OFF

$FLOAT PROCEDURE

$COM    0
$STRING 16
$STACK  2048
$SOUND  1

$DIM ARRAY

$DYNAMIC
' $STATIC

$OPTION CNTLBREAK OFF

'--------------------------------------------------------------------

DEFINT A-Z
OPTION BINARY BASE 0

%False = 0
%True  = NOT %False

$LINK 	 "QDrand.PBU" ' for mouse detection
$INCLUDE "QDrand.DEF"
$LINK 	 "QDbox.PBU" ' for mouse detection
$INCLUDE "QDbox.DEF"

%FLAGS = 0
%AX    = 1
%BX    = 2
%CX    = 3
%DX    = 4
%SI    = 5
%DI    = 6
%BP    = 7
%DS    = 8
%ES    = 9

'

%Video          = &H10 ' int $10

%DACWriteIndex  = &H03C8
%DACDataRegister= &H03C9

%pageup=73
%pagedn=81
%uparrow=72
%downarrow=80
%leftarrow=75
%rightarrow=77
%homekey=71
%endkey=79

' screen setup for mode $13 : 320x200x256

%MinColor       = &H00
%MaxColor       = &HFF

%Xpixels    = 320
%Ypixels    = 200

%xmin=0
%xmax=%xpixels-1
%ymin=0
%ymax=%ypixels-1

%firstcolor = &h00?
%lastcolor  = &h7F?

'
%units = 1000

%maxmotionx = 2000 ' 2.000
%maxmotiony = 1000 ' 1.000

%mincoeff=   0
%maxcoeff=5000 ' 5.000

'

%deadlimit = 63800 ' in fact 63891?? but why ? 64000-109

%mindensity=0
%maxdensity=1
%defaultdensity=%maxdensity

%minrandomorg=0
%maxrandomorg=1
%defaultrandomorg=%maxrandomorg

%minEternal = 0
%maxEternal = 1
%defaulteternal=%minEternal

%minGrav = 0
%maxGrav = 5000 ' 5.000
%defaultGrav = 10

%minBrightness = 0
%maxBrightness = 1
%defaultBrightness = %minBrightness

%gravsmallincrement=1
%gravbigincrement=20

%firstdrop = 1 ' must be 1, for lastdrop is count of drops
%maxdrop   = 10000

%smallincrement=50
%bigincrement  =200

%defaultlastdrop=2000

type droptype
	x   as single
    y	as single
    xm 	as single ' xmotion
    ym	as single ' ymotion
end type

dim huge drop(%firstdrop:%maxdrop) as shared droptype

%hidden=1 ' needed for brightness
DIM V(%xmin:%xmax,%ymin:%ymax+%hidden) AS shared BYTE ' V is screen map

'

%redpal 	    = 0
%greenpal 		= 1
%bluepal 		= 2

%defaultpal     = %redpal

'

%useMouse=%true

%eNone      = 0
%eNeedVGA   = 1
%eBadRange  = 2
%eWrongNumber=3

'--------------------------------------------------------------------

DECLARE SUB GetStrLoc() ' PowerBasic runtime library

SUB StdOut ( BYVAL Text AS STRING )
! push DS                    ; save DS FOR PowerBASIC
! push WORD Ptr Text         ; push STRING handle ON stack
! CALL GetStrLoc
! jcxz ExitStdOut
! mov  DS, DX
! mov  DX, AX
! mov  AH, &H40              ; DOS WRITE TO file
! mov  BX, 1                 ; file handle 1 is CONS
! INT  &H21
ExitStdOut:
! pop  DS
END SUB

SUB StdOutLn( BYVAL s as string )
CALL StdOut (s + CHR$(13, 10) )
END SUB

'--------------------------------------------------------------------

SUB ResetMode
SCREEN 2
SCREEN 0
END SUB

SUB SetMode13h              ' 320x200x256
REG %AX,&H13
CALL INTERRUPT %Video
END SUB

SUB WaitVGARetrace
!   mov dx,&h3DA
l1:
!   in al,dx
!   and al,&h08
!   jnz l1
l2:
!   in al,dx
!   and al,&h08
!   jz  l2
END SUB

FUNCTION IsVGA
IF BIT (pbvScrnCard,5) = 0 THEN
    IsVGA = %False
ELSE
    IsVGA = %True
END IF
END FUNCTION

sub setdac(byval index,red,green,blue)
OUT %DACWriteIndex,index
OUT %DACDataRegister, red
OUT %DACDataRegister, green
OUT %DACDataRegister, blue
end sub

sub makepal (byval n)
select case n
case %redpal
	FOR i = 0 TO 63
		call setdac(i   ,i ,0 ,0)
	next
	FOR i = 0 TO 63
		call setdac(i+64,63,i ,0)
	next
case %greenpal
	FOR i = 0 TO 63
		call setdac(i   ,0 ,i ,0)
	next
	FOR i = 0 TO 63
		call setdac(i+64,i ,63,0)
	next
case %bluepal
	FOR i = 0 TO 63
		call setdac(i   ,0 ,0 ,i)
	next
	FOR i = 0 TO 63
		call setdac(i+64,0 ,i ,63)
	next
end select
end sub

'--------------------------------------------------------------------

SUB Show
s??=VARSEG(V?(%xmin,%ymin))
o??=VARPTR(V?(%xmin,%ymin))

! pushf                             ; old silly habit...
! push es
! push si
! push ds
! push di
! mov ax,s??
! mov es,ax
! mov si,o??                        ;es:si = source

! mov ax,&HA000
! mov ds,ax
! mov di,&H0000                     ;ds:di = destination

! mov dx,%ypixels                      ;dx = y
hline:
! mov cx,%xpixels                      ;cx = x

hlinefill:
! mov al,es:[si]
! mov ds:[di],al
! inc si
! inc di
! dec cx
! jnz hlinefill

! dec dx
! jnz hline

! pop di
! pop ds
! pop si
! pop es
! popf

END SUB

$if 0

sub smooth (byval density)
ax??=0
bx??=0
for y=%ymax to %ymin step -1
	for x=%xmax-1 to %xmin+1 step -1
        bx??=(bx?? and &hff00) +v?(x,y)
        ax??=ax??+bx??
        bx??=(bx?? and &hff00) +v?(x,y+1)
        ax??=ax??+bx??
        bx??=(bx?? and &hff00) +v?(x-1,y)
        ax??=ax??+bx??

        shift right ax??,2
        c?=ax?? and &h00ff
        v?(x,y)=c?
    next
next
end sub

$else

sub smooth(byval density)
count??=%xpixels * %ypixels
select case density
case %maxdensity
	s??=VARSEG(V(%xmin,%ymin))
	! pushf                             ; old silly habit...
	! push es
	! push si
	! push ds
	! push di
    ! mov es, s??
    ! Mov di, count??
	! xor ax, ax
    ! Xor bx, bx
goon:
    ! Mov bl, es:[di]       ;x,y
    ! Add ax, bx

    ! Mov bl, es:[di + %xpixels] ;x,y+1
    ! Add ax, bx

    ! Mov bl, es:[di - 1]   ;x-1,y
    ! Add ax, bx

	! shr ax,1
	! shr ax,1
    ! Mov es:[di], al
    ! Dec di
    ! Jnz goon
	! pop di
	! pop ds
	! pop si
    ! pop es
	! popf
case %mindensity
	s??=VARSEG(V(%xmin,%ymin))
	! pushf                             ; old silly habit...
	! push es
	! push si
	! push ds
	! push di
    ! mov es, s??
    ! Mov di, count??
zgoon:
	! xor bx,bx
    ! xor ax,ax

    ! Mov bl, es:[di]       ;x,y
    ! Add ax, bx

    ! Mov bl, es:[di + %xpixels] ;x,y+1
    ! Add ax, bx

    ! Mov bl, es:[di - 1]   ;x-1,y
    ! Add ax, bx

	! shr ax,1
	! shr ax,1
    ! Mov es:[di], al
    ! Dec di
    ! Jnz zgoon
	! pop di
	! pop ds
	! pop si
    ! pop es
	! popf
end select
end sub

$endif

sub changedrop(count, byval value)
count=count+value
if count < %firstdrop then count=%firstdrop
if count > %maxdrop then count=%maxdrop
end sub

sub changegrav(count, byval value)
count=count+value
if count < %mingrav then count=%mingrav
if count > %maxgrav then count=%maxgrav
end sub

sub neworg(byval rndorg,xorg,yorg)
select case rndorg
case %minrandomorg
	xorg=%xmax \ 2
	yorg=%ymax \ 2
case %maxrandomorg
	xorg=getrndrange#(%xmin,%xmax)
    yorg=getrndrange#(%ymin,%ymax)
end select
end sub

sub newdrop(byval i, byval xorg, byval yorg)
    drop(i).x!=xorg
    drop(i).y!=yorg
    dx! = getrndrange#(-%maxmotionx,+%maxmotionx) / %units
    dy! = getrndrange#(-%maxmotiony,+%maxmotiony) / %units
    ' now add a little variety in acceleration
    distance!=sqr(dx!*dx!+dy!*dy!)
    coeff! = getrndrange#(%mincoeff,%maxcoeff) / %units
    IF distance! <> 0 THEN
        dx! = dx! * (distance! * coeff!)
        dy! = dy! * (distance! * coeff!)
    end if
    drop(i).xm! = dx!
    drop(i).ym! = dy!
end sub

sub initdrops(byval n, byval rndorg)
call neworg (rndorg,xorg,yorg)
for i = 1 to n
	call newdrop(i,xorg,yorg)
next
for y = %ymin to %ymax+%hidden
	for x = %xmin to %xmax
    	v?(x,y)=%firstcolor
    next
next
end sub

'--------------------------------------------------------------------

function dead??
s??=VARSEG(V?(%xmin,%ymin))
o??=VARPTR(V?(%xmin,%ymin))

n??=0 ' force existence
ns??=VARSEG(n??)
no??=VARPTR(n??)

! pushf                             ; old silly habit...
! push es
! push si
! push ds
! push di
! mov ax,s??
! mov es,ax
! mov si,o??                        ;es:si = source, i.e. v?(0,0)

! mov bx,0

! mov dx,%ypixels                      ;dx = y
nhline:
! mov cx,%xpixels                      ;cx = x

nhlinefill:
! mov al,es:[si]
! cmp al,0
! jne notdead						   ; not %firstcolor?
! inc bx
notdead:
! inc si
! dec cx
! jnz nhlinefill

! dec dx
! jnz nhline

! mov ax,ns??
! mov es,ax
! mov si,no??
! mov es:[si],bx

! pop di
! pop ds
! pop si
! pop es
! popf

dead??=n??
end function

'--------------------------------------------------------------------

sub anim (byval lastdrop, byval grav, byval rndorg, byval eternity)
gravity! = grav
gravity! = gravity! / %units

    FOR i = %firstdrop TO lastdrop
    	incr drop(i).x, drop(i).xm
        incr drop(i).y, drop(i).ym
		x=drop(i).x
        y=drop(i).y

        if x < %xmin or x >= %xmax or y < %ymin or y >= %ymax then
        	' not very pretty
			'drop(i).xm=-drop(i).xm / 2
            'drop(i).ym=-drop(i).ym / 2
		  if eternity then
            ' see initdrops code
            call neworg(rndorg,xorg,yorg)
            call newdrop(i,xorg,yorg)
          end if
        else
        	'if getrndrange#(0,100) < 10 then
            '	drop(i).xm = drop(i).xm * getrndrange#(1,2)
            '    drop(i).ym = drop(i).ym * getrndrange#(1,2)
            'end if
        	incr drop(i).ym! , gravity!
        	v?(x,y)=%lastcolor
        end if

    NEXT
end sub

'--------------------------------------------------------------------

exe$="EXPLODE"
stdoutln ""

IF IsVGA = %False THEN
    StdOut exe$+" : VGA card required !"
    END %eNeedVGA
END IF

cli$=UCASE$(COMMAND$)
REPLACE CHR$(9) WITH " " IN cli$
cli$=RTRIM$(LTRIM$(cli$))
select case cli$
case "?","-?","/?","-H","/H"
	stdoutln "Usage #1 : "+exe$
	stdoutln "Usage #2 : "+exe$+" <color> <drops> <density> <randomness>"
    stdoutln "           "+space$(len(exe$))+" <eternity> <gravity> <brightness>"
    stdoutln ""
    stdoutln "    [*]=reset defaults, [R|G|B]=color, [Home|End]=density, [A|C]=randomness,"
    stdoutln "    [M|E]=eternity, [+|-|PageUp|PageDown]=number of drops, [D|I]=brightness"
    stdoutln "    [Left|Right|Up|Down] to change gravity"
	stdoutln ""
    stdoutln "    Color is Red, Green or Blue -- default is Red"
    stdout   "    Drops range is from"+str$(%firstdrop)+" to"+str$(%maxdrop)
    stdoutln "-- default is"+str$(%defaultlastdrop)
    stdout   "    Density range is from"+str$(%mindensity)+" to"+str$(%maxdensity)
    stdoutln "-- default is"+str$(%defaultdensity)
    stdout   "    Randomness (for explosion origin) range is from"+str$(%minRandomorg)+" to"+str$(%maxrandomorg)
    stdoutln "-- default is"+str$(%defaultrandomorg)
    stdout   "    Eternity range is from"+str$(%minEternal)+" to"+str$(%maxEternal)
    stdoutln "-- default is"+str$(%defaultEternal)
    stdout   "    Gravity range is from"+str$(%minGrav)+" to"+str$(%maxgrav)
    stdoutln "-- default is"+str$(%defaultgrav)
    stdout   "    Brightness range is from"+str$(%minBrightness)+" to"+str$(%maxBrightness)
    stdoutln "-- default is"+str$(%defaultBrightness)
	end %eNone
case else
	parmcount=argC(cli$)
    select case parmcount
    case 0
    	pal=%defaultpal
		lastdrop=%defaultlastdrop
        density=%defaultdensity
        userandomorg=%defaultrandomorg
        eternal=%defaulteternal
		grav=%defaultgrav
    	brightness=%defaultBrightness
    case 7
    	i=1
		s$=argV$(cli$,1)
        s$=ucase$(s$)
        select case s$
        case "R": pal=%redpal
        case "G": pal=%greenpal
        case "B": pal=%bluepal
        case else
        	stdoutln exe$+" : color is not legal !"
            END %eBadRange
        end select

        incr i
		lastdrop=val(argV$(cli$,i))
		IF lastdrop < %firstdrop OR lastdrop > %Maxdrop THEN
		    stdoutln exe$+" : number of drops is out of range !"
	    	END %eBadRange
    	end if

        incr i
		density=val(argV$(cli$,i))
		IF density < %mindensity OR density > %Maxdensity THEN
		    stdoutln exe$+" : density is out of range !"
	    	END %eBadRange
    	end if

        incr i
		userandomorg=val(argV$(cli$,i))
		IF useRandomorg < %minrandomorg OR userandomorg > %Maxrandomorg THEN
		    stdoutln exe$+" : randomness is out of range !"
	    	END %eBadRange
    	end if

        incr i
		eternal=val(argV$(cli$,i))
		IF eternal < %minEternal OR eternal > %MaxEternal THEN
		    stdoutln exe$+" : eternity is out of range !"
	    	END %eBadRange
    	end if

        incr i
        grav=val(argV$(cli$,i))
		IF grav < %Mingrav OR grav > %Maxgrav THEN
		    stdoutln exe$+" : gravity is out of range !"
	    	END %eBadRange
        end if

        incr i
        brightness=val(argV$(cli$,i))
		IF brightness < %MinBrightness OR brightness > %MaxBrightness THEN
		    stdoutln exe$+" : brightness is out of range !"
	    	END %eBadRange
        end if

    case else
		stdoutln exe$+" : wrong number of parameters !"
        end %eWrongNumber
    end select

end select

flagMouse=%false
IF %useMouse = %True THEN
	flagMouse=MouseHere
END IF

call initrnd
CALL SetMode13h
call makepal(pal)

call initdrops(lastdrop,userandomorg)

DO
	if instat then
    	c$=inkey$
		bye=%false
        select case c$

        case "R","r"
        	call makepal(%redpal)
            pal=%redpal
        case "G","g"
			call makepal(%greenpal)
            pal=%greenpal
        case "B","b"
			call makepal(%bluepal)
            pal=%bluepal

        case "C","c"
			userandomorg=%minrandomorg
        case "A","a"
        	userandomorg=%maxrandomorg

        case "E","e"
        	eternal = %maxEternal
        case "M","m"
        	eternal = %minEternal

        case "D","d" ' dim, smoothed
            brightness=%minBrightness
        case "I","i" ' intense
        	brightness=%maxBrightness

        case "+"
			call changedrop(lastdrop,+%smallincrement)
        case "-"
            call changedrop(lastdrop,-%smallincrement)
        case chr$(0,%pageup)
			call changedrop(lastdrop,+%bigincrement)
        case chr$(0,%pagedn)
			call changedrop(lastdrop,-%bigincrement)

        case "*"
            lastdrop=%defaultlastdrop
           	density=%defaultdensity
            userandomorg=%defaultrandomorg
   	    	grav=%defaultgrav

			call makepal(%defaultpal)

            call initdrops(lastdrop,userandomorg)

    	case chr$(0,%homekey)
        	density=%maxdensity
        case chr$(0,%endkey)
        	density=%mindensity

        case chr$(0,%uparrow)
			call changegrav(grav,+%gravsmallincrement)
        case chr$(0,%downarrow)
			call changegrav(grav,-%gravsmallincrement)
        case chr$(0,%leftarrow)
			call changegrav(grav,+%gravbigincrement)
        case chr$(0,%rightarrow)
			call changegrav(grav,-%gravbigincrement)

        case else ' chr$(13),chr$(27) ' cr or esc
        	bye=%true
		end select
        if bye=%true then exit loop
    end if

    IF ( (%useMouse=%True) AND (flagMouse = %True) ) THEN
    	IF MouseButtonClicked=%True THEN EXIT LOOP
    END IF

    select case brightness
    case %maxBrightness
    	'if smooth is done before anim, brighter dots
		call smooth(density)
		call anim(lastdrop,grav,useRandomorg, eternal)
    case %minBrightness
		call anim(lastdrop,grav,useRandomorg, eternal)
		call smooth(density)
    end select

    ' call waitVGAretrace
	call show

    if dead?? > %deadlimit then call initdrops(lastdrop,userandomorg)
LOOP

CALL ResetMode

select case pal
case %redpal
	s$="R"
case %greenpal
	s$="G"
case %bluepal
	s$="B"
end select
ink$=s$

stdoutln ""
stdoutln "Color           : "+ink$
stdoutln "Number of drops :"+str$(lastdrop)
stdoutln "Density         :"+str$(density)
stdoutln "Randomness      :"+str$(userandomorg)
stdoutln "Eternity        :"+str$(eternal)
stdoutln "Gravity         :"+str$(grav)
stdoutln "Brightness      :"+str$(brightness)
stdoutln ""
stdout   "Command line    : "+exe$+" "+ink$+str$(lastdrop)+str$(density)
stdoutln str$(userandomorg)+str$(eternal)+str$(grav)+str$(brightness)

END %eNone




