(* ---------------------------------------------------------------
Title         see help !
Author        PhG
Overview      see help !
Usage         see help !
Notes         with a 130Kb test file, 6s with animShow, 44s with animSHOW !
Bugs          well, if we want to change data containing quotes...
              but after all, this program was written to change identifiers !
              metaproc should probably enforce fascist number parsing
              to avoid problems such as escape sequence not being parsed
Wish List     -query to confirm changes ? bah...

--------------------------------------------------------------- *)

MODULE OldNew;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;

FROM IO IMPORT WrStr,WrLn,WrLngCard;

FROM Storage IMPORT Available,ALLOCATE,DEALLOCATE;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileIsDirectorySpec,
fileClose;

(* ------------------------------------------------------------ *)

CONST
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    dot           = ".";
    deg           = "";
    doublequote   = '"';
    singlequote   = "'";
    percent       = "%";
    vbar          = "|"; (* 7c *)
    dash          = "-";
    slash         = "/";
    antislash     = "\";
    quote         = "'";
    dollar        = "$";
    star          = "*";
    colon         = ":";
    nullchar      = 0C;
    stardotstar   = star+dot+star;
    dotdot        = dot+dot;
    escSet        = deg+dash+slash+quote;
    escCh         = deg; (* avoid \, already used in some batches for \\ etc. *)
    msgProcessing = " "; (* " is being processed, please wait..." *)
CONST
    extBAK        = ".BK!";
    extCOM        = ".COM";
    extEXE        = ".EXE";
    extDLL        = ".DLL";
    extOVR        = ".OVR";
    extOVL        = ".OVL";
    extDRV        = ".DRV";
    extZIP        = ".ZIP";
    extARJ        = ".ARJ";
    extLZH        = ".LZH";
    skippedextensions = extBAK+delim+extCOM+delim+extEXE+delim+
                        extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                        extZIP+delim+extARJ+delim+extLZH;
CONST
    ProgEXEname   = "OLDNEW";
    ProgTitle     = "Q&D identifier/word/sequence replacer";
    ProgVersion   = "v1.1d";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errBadExistingID    = 2;
    errBadReplacementID = 3;
    errTooMany          = 4;
    errNoMatch          = 5;
    errIn               = 6;
    errOut              = 7;
    errUnknownOption    = 8;
    errParmOverflow     = 9;
    errBadExistingWord  = 10;
    errBadReplacementWord=11;
    errConflict         = 12;
    errBadAlias         = 13;
    errBadJoker         = 14;
    errBadJokerSet      = 15;
    errJokerAlias       = 16;
    errBadMeta          = 17;
    errCmdConflict      = 18;
    errBadSpec          = 19;
    errStringSequence   = 20;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
00000000011111111112222222222333333333344444444445555555555666666666677777777778
1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
nl+
Banner+nl+
nl+
"Syntax 1 : "+ProgEXEname+" [option]... existing replacement infile(s)"+nl+
"Syntax 2 : "+ProgEXEname+" [option]... existing replacement < infile > outfile"+nl+
"Syntax 3 : "+ProgEXEname+" <-delete> [option]... existing infile(s)"+nl+
"Syntax 4 : "+ProgEXEname+" <-delete> [option]... existing < infile > outfile"+nl+
"Syntax 5 : "+ProgEXEname+" <-ASCII|-OEM>"+nl+
nl+
"  -w    process words instead of identifiers"+nl+
"  -r    process raw sequences"+nl+
"  -e    process only exact (case-sensitive) sequence matches"+nl+
"  -s    do not process strings (delimited with either single or double quotes)"+nl+
"  -d    delete sequence matches"+nl+
"  -v    verbose"+nl+
'  -p:?  replace specified character with "'+percent+'" in existing and replacement'+nl+
"  -j:?  use joker (matching exactly one character) in existing string"+nl+
"  -f    process all files (default extension protection is ignored)"+nl+
"  -a[a] display ASCII reference set (-aa = decimal)"+nl+
"  -o[o] display Windows OEM reference set (-oo = decimal)"+nl+
"  -lfn  disable LFN support even if available"+nl+
nl+
"a) This program replaces a sequence of characters with another one."+nl+
"b) An identifier starts with a letter, and contains only letters, numbers,"+nl+
"   or the underscore (" + '"_"' + ") character."+nl+
"c) A word is a sequence delimited by spaces, tabs, or control characters."+nl+
"d) -s option prevents strings content from being modified ;"+nl+
"   note -s and -r options are mutually exclusive."+nl+
'e) "' + escCh + 'n" = $0d0a, "' +
         escCh + 'p" = "%", "' +
         escCh+ 'q" = double quote, "' +
         escCh + 'b" = vertical bar ($7c),' +nl+
"   "+   escCh + '[' + escSet + ']" = symbol, ' +
         escCh + "[$|x]#[" + escCh + ']" = hex/dec value ($00 value not allowed).'+nl+

"f) For safety, all lines should end with a CRLF sequence."+nl+
"g) "+skippedextensions+" files are not processed,"+nl+
"   unless -f option is specified."+nl+
"h) Each original file will be backuped with "+extBAK+" extension."+nl+
nl+
"Examples : "+ProgEXEname+" i index *.MOD"+nl+
"           "+ProgEXEname+" -r -e Dummy$ bozo$"+nl+
"           "+ProgEXEname+" -r "+escCh+"$414243"+escCh+"d abcd"+nl;

VAR
    S : str1024;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errBadExistingID :
        Str.Concat(S,"Illegal existing identifier (",einfo);Str.Append(S,") !");
    | errBadReplacementID :
        Str.Concat(S,"Illegal replacement identifier (",einfo);Str.Append(S,") !");
    | errTooMany:
        Str.Concat(S,"Too many files match ",einfo);Str.Append(S," !");
    | errNoMatch:
        Str.Concat(S,"No valid file matches ",einfo);
        Str.Append(S," specification !");
    | errIn :
        S := "StandardInput error !";
    | errOut :
        S := "StandardOutput error !";
    | errUnknownOption :
        Str.Concat(S,"Unknown ",einfo);Str.Append(S," option !");
    | errParmOverflow :
        Str.Concat(S,"Uneeded ",einfo);Str.Append(S," parameter !");
    | errBadExistingWord :
        Str.Concat(S,"Illegal existing word (",einfo);Str.Append(S,") !");
    | errBadReplacementWord :
        Str.Concat(S,"Illegal replacement word (",einfo);Str.Append(S,") !");
    | errConflict:
        S := "-w and -r options are mutually exclusive !";
    | errBadAlias:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," percent alias !");
    | errBadJoker:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," joker !");
    | errBadJokerSet:
        S:="Joker cannot be in [A..Za..z] set !";
    | errJokerAlias:
        S := "-p:? and -j:? characters must be different from each other !";
    | errBadMeta:
        Str.Concat(S,"Illegal escape sequence (",einfo);Str.Append(S,") !");
    | errCmdConflict:
        S := "-a, -o, -aa and -oo options are mutually exclusive !";
    | errBadSpec:
        Str.Concat(S,"Illegal ",einfo);Str.Append(S," specification !");
    | errStringSequence:
        S := "-s and -r options are mutually exclusive !";
    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrLn; (* here, in order to avoid useless crlf when redirecting *)
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    pFname = POINTER TO fnameType;
    fnameType = RECORD
        next      : pFname;
        slen      : CARDINAL; (* a SHORTCARD could do but who knows ? *)
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pFname );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pFname);
VAR
    needed : CARDINAL;
    p      : pFname;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(fnameType) - SIZE(anchor^.str) + anchor^.slen;
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pFname; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(fnameType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pFname);
VAR
    len:CARDINAL;
BEGIN
    len := p^.slen;
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

(* ------------------------------------------------------------ *)

(* Str.Match is not case sensitive *)

PROCEDURE isReservedPattern (S,skipthem:ARRAY OF CHAR):BOOLEAN;
VAR
    e3 : str16;
    n:CARDINAL;
    rc:BOOLEAN;
BEGIN
    rc:=FALSE;
    n:=0;
    LOOP
        isoleItemS(e3, skipthem,delim,n);
        IF same(e3,"") THEN EXIT; END;
        Str.Prepend(e3,"*");
        IF Str.Match(S,e3) THEN rc:=TRUE;EXIT; END;
        INC(n);
    END;
    RETURN rc;
END isReservedPattern;

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildFileList (VAR anchor:pFname;
                        noskip,useLFN,DEBUG :BOOLEAN;
                        spec:pathtype):CARDINAL;
VAR
    count:CARDINAL; (* should do ! *)
    ok,found:BOOLEAN;
    unicodeconversion:unicodeConversionFlagType;
    w9Xentry : findDataRecordType;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    dosattr:FIO.FileAttr;
    entryname:pathtype;
    len : CARDINAL;
    pp:pFname;
    excludeme1,excludeme2:BOOLEAN;
BEGIN
    count:=0;
    IF useLFN THEN
        found := w9XfindFirst (spec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(spec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        excludeme1 := isReservedEntry   (entryname);  (* skip "." and ".." *)
        IF noskip THEN
            excludeme2 := FALSE;
        ELSE
            excludeme2 := isReservedPattern (entryname,skippedextensions );
        END;
        IF NOT(excludeme1 OR excludeme2) THEN
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF NOT (aD IN dosattr) THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                IF DEBUG THEN WrStr("Included : ");WrStr(entryname);WrLn; END;
                len:=Str.Length(entryname);
                IF buildNewPtr(anchor,pp,len)=FALSE THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN MAX(CARDINAL); (* errStorage *)
                END;
                INC(count);
                pp^.slen      := len;
                Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
            ELSE
                IF DEBUG THEN WrStr("Ignored  : ");WrStr(entryname);WrLn;END;
            END;
        ELSE
            IF DEBUG THEN WrStr("Excluded : ");WrStr(entryname);WrLn;END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN count;
END buildFileList;

(* ------------------------------------------------------------ *)

PROCEDURE doGetCurrent (useLFN:BOOLEAN;drive:SHORTCARD;
                       VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrent;

PROCEDURE makebase (useLFN:BOOLEAN;spec:pathtype;VAR basepath:pathtype);
VAR
    u,d,n,e,current:pathtype;
    unit:str2;
    drive:SHORTCARD;
BEGIN
    Lib.SplitAllPath(spec,u,d,n,e);
    Str.Concat(basepath,u,d);
    IF same(basepath,"") THEN
        drive:=FIO.GetDrive(); (* yes we could use 0 as default drive *)
        doGetCurrent(useLFN,drive,  unit,current); (* "u:" and "\" or "\*\" *)
        Str.Concat(basepath, unit,current);
    END;
END makebase;

PROCEDURE WrQuoted (S:ARRAY OF CHAR);
BEGIN
    WrStr('"');
    WrStr(S);
    WrStr('"');
END WrQuoted;

PROCEDURE WrFname (useLFN:BOOLEAN;S:pathtype );
BEGIN
    IF useLFN THEN
        WrQuoted(S);
    ELSE
        WrStr(S);
    END;
END WrFname;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    uppercase  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    lowercase  = "abcdefghijklmnopqrstuvwxyz";
    digits     = "0123456789";
    underscore = "_";
    letters    = lowercase+uppercase;
    legal      = letters+digits+underscore;

PROCEDURE isValidID (S:ARRAY OF CHAR;usejoker:BOOLEAN;joker:CHAR) : BOOLEAN;
VAR
    i   : CARDINAL;
    len : CARDINAL;
    allowed:str128;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN RETURN FALSE; END; (* should NEVER happen *)

    Str.Copy(allowed,letters);
    IF usejoker THEN Str.Append(allowed,joker);END;
    IF Belongs(allowed,S[0])=FALSE THEN RETURN FALSE; END; (* must begin with a letter *)

    Str.Copy(allowed,legal);
    IF usejoker THEN Str.Append(allowed,joker);END;
    FOR i := 1 TO (len-1) DO
        IF Belongs(allowed,S[i])=FALSE THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
END isValidID;

PROCEDURE isBlank (c:CHAR):BOOLEAN;
BEGIN
    CASE c OF
    | CHR(0)..CHR(32):
        RETURN TRUE; (* all control characters including space *)
    ELSE
        RETURN FALSE;
    END;
END isBlank;

PROCEDURE isValidWord (S:ARRAY OF CHAR) : BOOLEAN;
VAR
    i   : CARDINAL;
    len : CARDINAL;
BEGIN
    len := Str.Length(S);
    IF len = 0 THEN RETURN FALSE; END; (* should NEVER happen *)
    FOR i := 0 TO (len-1) DO
        IF isBlank(S[i]) THEN RETURN FALSE; END;
    END;
    RETURN TRUE;
END isValidWord;

(* not pretty but effective : who cares about speed nowadays ? ;-) *)
(* S2 is existing, with possible jokers *)

PROCEDURE sameIDref (S1,S2:ARRAY OF CHAR;keepcase,usejoker:BOOLEAN;joker:CHAR):BOOLEAN;
VAR
    mismatch,i:CARDINAL;
    c:CHAR;
BEGIN
    IF keepcase=FALSE THEN (* uppercase instead ? *)
        Str.Caps(S1);
        Str.Caps(S2);
    END;
    IF usejoker THEN
        mismatch:=0;
        FOR i:=1 TO Str.Length(S2) DO
            c:=S2[i-1];
            IF c # joker THEN
                IF c # S1[i-1] THEN INC(mismatch);END;
            END;
        END;
        RETURN (mismatch=0);
    ELSE
        IF S1[0] # S2[0] THEN RETURN FALSE; END;
        RETURN same(S1,S2);
    END;
END sameIDref;

PROCEDURE isLegal (c:CHAR;wordmode:BOOLEAN):BOOLEAN;
BEGIN
    CASE wordmode OF
    | FALSE:  RETURN Belongs(legal,c);
    | TRUE:   RETURN NOT( isBlank(c));
    END;
END isLegal;

(* chref is char in existing *)

PROCEDURE samerawch (ch,chref:CHAR; usejoker:BOOLEAN;joker:CHAR):BOOLEAN;
BEGIN
     IF usejoker THEN
         IF chref=joker THEN RETURN TRUE; END;
     END;
     (* either no joker, or chref was not our joker *)
     RETURN (ch=chref);
END samerawch;

(* ------------------------------------------------------------ *)

(*
shame on you not to have thought of more than one value at a time !
shame on you for relying on an external library to parse a mere hex value !
really gone is your Apple ][ genius... :-(
bah, old age is coming faster than end of the world...
*)

(* assume : digits already filtered and uppercased, base = 10 or 16, hex=## *)

PROCEDURE charvalToStr (VAR R:ARRAY OF CHAR; base:CARDINAL; digits:ARRAY OF CHAR):BOOLEAN;

    MODULE hxhelper;

    EXPORT hx;

    PROCEDURE hx (ch:CHAR):CARDINAL;
    CONST
        val0 = ORD("0");
        valA = ORD("A");
    VAR
        v:CARDINAL;
    BEGIN
        v:=ORD(ch);
        IF v < valA THEN
            DEC(v, val0 );
        ELSE
            DEC(v, valA );
            INC(v, 10);
        END;
        RETURN v;
    END hx;

    END hxhelper;

CONST
    maxcharval = MAX(SHORTCARD);
VAR
    rc : BOOLEAN;
    i,len,v: CARDINAL;
BEGIN
    rc := TRUE;
    len:= Str.Length(digits);
    Str.Copy(R,"");
    CASE base OF
    | 10: (* filtered for 0..9 *)
        v:=0;
        i:=1;
        LOOP
            IF i > len THEN EXIT;END;
            v := (v * 10);
            INC( v , ( ORD( digits[i-1] ) - ORD("0") ) );
            rc := ( v <= maxcharval ); IF NOT(rc) THEN EXIT; END;
            INC(i);
        END;
        IF rc THEN rc := (v # 0); END;
        IF rc THEN Str.Copy( R, CHR(v) );END;
    | 16: (* filtered for 0..9 A..F *)
        (* IF len < 2 THEN Str.Prepend(digits,"0"); INC(len);END; done by caller *)
        IF ODD(len) THEN
            rc:=FALSE;
        ELSE
            i:=1;
            LOOP
                IF i > len THEN EXIT; END;
                v:=  ( hx(digits[i-1]) << 4 );
                INC(i);
                INC(v, hx(digits[i-1]) );
                INC(i);
                rc := (v # 0);
                IF NOT(rc) THEN EXIT; END;
                Str.Append(R, CHR(v) );
            END;
        END;
    END;
    RETURN rc;
END charvalToStr;

(*

n  p  q  -  /  '  

###    $##    x##

*)

PROCEDURE metaproc (VAR S : ARRAY OF CHAR):BOOLEAN;
VAR
    ch:CHAR;
    c2:str80; (* really oversized for safety *)
    len,i,base:CARDINAL;
    R:str128;
    str:str128; (* in case we overflow ! *)
    state : (waiting,gotesc,grabhex,grabdec);
    rc:BOOLEAN;
BEGIN
    len := Str.Length(S);
    R   := "";
    i   := 1;
    rc  := TRUE;
    state := waiting;
    LOOP
        IF i > len THEN EXIT; END;
        ch := S[i-1];
        CASE state OF
        | waiting:
            CASE ch OF
            | escCh :
                state := gotesc;
            ELSE
                Str.Append(R,ch);
            END;
        | gotesc:
            CASE ch OF
            | "x","X","$":Str.Copy(str,"");         state:=grabhex; base:=16;
            | "0".."9" :  Str.Copy(str,ch);         state:=grabdec; base:=10;
            | "n","N" :   Str.Append(R,nl);         state:=waiting;
            | "p","P" :   Str.Append(R,percent);    state:=waiting;
            | "q","Q" :   Str.Append(R,doublequote);state:=waiting;
            | "b","B" :   Str.Append(R,vbar);       state:=waiting;
            ELSE
                IF Str.CharPos(escSet,ch) = MAX(CARDINAL) THEN
                    DEC(i); (* esc+verbatim : go back to make verbatim the next *)
                ELSE
                    Str.Append(R,ch); (* esc+reserved char *)
                END;
                state:=waiting;
            END;
        | grabhex:
            CASE ch OF
            | "0".."9", "A".."F", "a".."f" :
                Str.Append(str, CAP(ch) ); (* uppercase ! *)
            | escCh:
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=gotesc;
            ELSE
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        | grabdec:
            CASE ch OF
            | "0".."9" :
                Str.Append(str,ch);
            | escCh:
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=gotesc;
            ELSE
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        END;
        INC(i);
    END;
    CASE state OF
    | grabhex:
        IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    | grabdec:
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    END;
    Str.Copy(S,R);
    RETURN rc;
END metaproc;

(* ------------------------------------------------------------ *)

(* ripped and adapted from old PC2WIN v1.0a dated 29 Apr 00 *)

TYPE
    chardef   = RECORD
                    Code    : BYTE;
                    Flag    : CHAR;
                    MapChar : BYTE;
                END;
    CharTable = ARRAY [0..255] OF chardef;

CONST
    TwinTOpc  = CharTable(
    chardef(000H, "=", 000H),
    chardef(001H, "=", 001H),
    chardef(002H, "=", 002H),
    chardef(003H, "=", 003H),
    chardef(004H, "=", 004H),
    chardef(005H, "=", 005H),
    chardef(006H, "=", 006H),
    chardef(007H, "=", 007H),
    chardef(008H, "=", 008H),
    chardef(009H, "!", 009H),
    chardef(00AH, "=", 00AH),
    chardef(00BH, "=", 00BH),
    chardef(00CH, "=", 00CH),
    chardef(00DH, "=", 00DH),
    chardef(00EH, "=", 00EH),
    chardef(00FH, "=", 00FH),
    chardef(010H, "=", 010H),
    chardef(011H, "=", 011H),
    chardef(012H, "=", 012H),
    chardef(013H, "=", 013H),
    chardef(014H, "=", 014H),
    chardef(015H, "=", 015H),
    chardef(016H, "=", 016H),
    chardef(017H, "=", 017H),
    chardef(018H, "=", 018H),
    chardef(019H, "=", 019H),
    chardef(01AH, "=", 01AH),
    chardef(01BH, "=", 01BH),
    chardef(01CH, "=", 01CH),
    chardef(01DH, "=", 01DH),
    chardef(01EH, "=", 01EH),
    chardef(01FH, "=", 01FH),
    chardef(020H, "=",  " "),
    chardef(021H, "=",  "!"),
    chardef(022H, "=",  '"'),
    chardef(023H, "=",  "#"),
    chardef(024H, "=",  "$"),
    chardef(025H, "=",  "%"),
    chardef(026H, "=",  "&"),
    chardef(027H, "=",  "'"),
    chardef(028H, "=",  "("),
    chardef(029H, "=",  ")"),
    chardef(02AH, "=",  "*"),
    chardef(02BH, "=",  "+"),
    chardef(02CH, "=",  ","),
    chardef(02DH, "=",  "-"),
    chardef(02EH, "=",  "."),
    chardef(02FH, "=",  "/"),
    chardef(030H, "=",  "0"),
    chardef(031H, "=",  "1"),
    chardef(032H, "=",  "2"),
    chardef(033H, "=",  "3"),
    chardef(034H, "=",  "4"),
    chardef(035H, "=",  "5"),
    chardef(036H, "=",  "6"),
    chardef(037H, "=",  "7"),
    chardef(038H, "=",  "8"),
    chardef(039H, "=",  "9"),
    chardef(03AH, "=",  ":"),
    chardef(03BH, "=",  ";"),
    chardef(03CH, "=",  "<"),
    chardef(03DH, "=",  "="),
    chardef(03EH, "=",  ">"),
    chardef(03FH, "=",  "?"),
    chardef(040H, "=",  "@"),
    chardef(041H, "=",  "A"),
    chardef(042H, "=",  "B"),
    chardef(043H, "=",  "C"),
    chardef(044H, "=",  "D"),
    chardef(045H, "=",  "E"),
    chardef(046H, "=",  "F"),
    chardef(047H, "=",  "G"),
    chardef(048H, "=",  "H"),
    chardef(049H, "=",  "I"),
    chardef(04AH, "=",  "J"),
    chardef(04BH, "=",  "K"),
    chardef(04CH, "=",  "L"),
    chardef(04DH, "=",  "M"),
    chardef(04EH, "=",  "N"),
    chardef(04FH, "=",  "O"),
    chardef(050H, "=",  "P"),
    chardef(051H, "=",  "Q"),
    chardef(052H, "=",  "R"),
    chardef(053H, "=",  "S"),
    chardef(054H, "=",  "T"),
    chardef(055H, "=",  "U"),
    chardef(056H, "=",  "V"),
    chardef(057H, "=",  "W"),
    chardef(058H, "=",  "X"),
    chardef(059H, "=",  "Y"),
    chardef(05AH, "=",  "Z"),
    chardef(05BH, "=",  "["),
    chardef(05CH, "=",  "\"),
    chardef(05DH, "=",  "]"),
    chardef(05EH, "=",  "^"),
    chardef(05FH, "=",  "_"),
    chardef(060H, "=",  "`"),
    chardef(061H, "=",  "a"),
    chardef(062H, "=",  "b"),
    chardef(063H, "=",  "c"),
    chardef(064H, "=",  "d"),
    chardef(065H, "=",  "e"),
    chardef(066H, "=",  "f"),
    chardef(067H, "=",  "g"),
    chardef(068H, "=",  "h"),
    chardef(069H, "=",  "i"),
    chardef(06AH, "=",  "j"),
    chardef(06BH, "=",  "k"),
    chardef(06CH, "=",  "l"),
    chardef(06DH, "=",  "m"),
    chardef(06EH, "=",  "n"),
    chardef(06FH, "=",  "o"),
    chardef(070H, "=",  "p"),
    chardef(071H, "=",  "q"),
    chardef(072H, "=",  "r"),
    chardef(073H, "=",  "s"),
    chardef(074H, "=",  "t"),
    chardef(075H, "=",  "u"),
    chardef(076H, "=",  "v"),
    chardef(077H, "=",  "w"),
    chardef(078H, "=",  "x"),
    chardef(079H, "=",  "y"),
    chardef(07AH, "=",  "z"),
    chardef(07BH, "=",  "{"),
    chardef(07CH, "=",  "|"),
    chardef(07DH, "=",  "}"),
    chardef(07EH, "=",  "~"),
    chardef(07FH, "x",  " "),
    chardef(080H, "x",  " "),
    chardef(081H, "x",  " "),
    chardef(082H, "x",  " "),
    chardef(083H, "x",  " "),
    chardef(084H, "x",  " "),
    chardef(085H, "x",  " "),
    chardef(086H, "x",  " "),
    chardef(087H, "x",  " "),
    chardef(088H, "x",  " "),
    chardef(089H, "x",  " "),
    chardef(08AH, "x",  " "),
    chardef(08BH, "x",  " "),
    chardef(08CH, "x",  " "),
    chardef(08DH, "x",  " "),
    chardef(08EH, "x",  " "),
    chardef(08FH, "x",  " "),
    chardef(090H, "x",  " "),
    chardef(091H, "=",  "'"),
    chardef(092H, "=",  "'"),
    chardef(093H, "x",  " "),
    chardef(094H, "x",  " "),
    chardef(095H, "x",  " "),
    chardef(096H, "x",  " "),
    chardef(097H, "x",  " "),
    chardef(098H, "x",  " "),
    chardef(099H, "x",  " "),
    chardef(09AH, "x",  " "),
    chardef(09BH, "x",  " "),
    chardef(09CH, "x",  " "),
    chardef(09DH, "x",  " "),
    chardef(09EH, "x",  " "),
    chardef(09FH, "x",  " "),
    chardef(0A0H, "=",  " "),
    chardef(0A1H, "=",  ""),
    chardef(0A2H, "=",  ""),
    chardef(0A3H, "=",  ""),
    chardef(0A4H, "=",  ""),
    chardef(0A5H, "=",  ""),
    chardef(0A6H, "=",  "|"),
    chardef(0A7H, "!", 015H),
    chardef(0A8H, "?",  " "),
    chardef(0A9H, "!",  ""),
    chardef(0AAH, "=",  ""),
    chardef(0ABH, "=",  ""),
    chardef(0ACH, "=",  ""),
    chardef(0ADH, "=",  "-"),
    chardef(0AEH, "!",  ""),
    chardef(0AFH, "!",  "-"),
    chardef(0B0H, "=",  ""),
    chardef(0B1H, "=",  ""),
    chardef(0B2H, "=",  ""),
    chardef(0B3H, "?",  " "),
    chardef(0B4H, "?",  " "),
    chardef(0B5H, "=",  ""),
    chardef(0B6H, "!", 014H),
    chardef(0B7H, "?",  " "),
    chardef(0B8H, "?",  " "),
    chardef(0B9H, "?",  " "),
    chardef(0BAH, "=",  ""),
    chardef(0BBH, "=",  ""),
    chardef(0BCH, "=",  ""),
    chardef(0BDH, "=",  ""),
    chardef(0BEH, "?",  " "),
    chardef(0BFH, "=",  ""),
    chardef(0C0H, "=",  "A"),
    chardef(0C1H, "=",  "A"),
    chardef(0C2H, "=",  "A"),
    chardef(0C3H, "=",  "A"),
    chardef(0C4H, "=",  ""),
    chardef(0C5H, "=",  ""),
    chardef(0C6H, "=",  ""),
    chardef(0C7H, "=",  ""),
    chardef(0C8H, "=",  "E"),
    chardef(0C9H, "=",  ""),
    chardef(0CAH, "=",  "E"),
    chardef(0CBH, "=",  "E"),
    chardef(0CCH, "=",  "I"),
    chardef(0CDH, "=",  "I"),
    chardef(0CEH, "=",  "I"),
    chardef(0CFH, "=",  "I"),
    chardef(0D0H, "?",  " "),
    chardef(0D1H, "=",  ""),
    chardef(0D2H, "=",  "O"),
    chardef(0D3H, "=",  "O"),
    chardef(0D4H, "=",  "O"),
    chardef(0D5H, "=",  "O"),
    chardef(0D6H, "=",  ""),
    chardef(0D7H, "=",  "X"),
    chardef(0D8H, "=",  "O"),
    chardef(0D9H, "=",  "U"),
    chardef(0DAH, "=",  "U"),
    chardef(0DBH, "=",  "U"),
    chardef(0DCH, "=",  ""),
    chardef(0DDH, "=",  "Y"),
    chardef(0DEH, "?",  " "),
    chardef(0DFH, "=",  ""),
    chardef(0E0H, "=",  ""),
    chardef(0E1H, "=",  ""),
    chardef(0E2H, "=",  ""),
    chardef(0E3H, "=",  "a"),
    chardef(0E4H, "=",  ""),
    chardef(0E5H, "=",  ""),
    chardef(0E6H, "=",  ""),
    chardef(0E7H, "=",  ""),
    chardef(0E8H, "=",  ""),
    chardef(0E9H, "=",  ""),
    chardef(0EAH, "=",  ""),
    chardef(0EBH, "=",  ""),
    chardef(0ECH, "=",  ""),
    chardef(0EDH, "=",  ""),
    chardef(0EEH, "=",  ""),
    chardef(0EFH, "=",  ""),
    chardef(0F0H, "?",  " "),
    chardef(0F1H, "=",  ""),
    chardef(0F2H, "=",  ""),
    chardef(0F3H, "=",  ""),
    chardef(0F4H, "=",  ""),
    chardef(0F5H, "=",  "o"),
    chardef(0F6H, "=",  ""),
    chardef(0F7H, "=",  ""),
    chardef(0F8H, "=",  "o"),
    chardef(0F9H, "=",  ""),
    chardef(0FAH, "=",  ""),
    chardef(0FBH, "=",  ""),
    chardef(0FCH, "=",  ""),
    chardef(0FDH, "=",  "y"),
    chardef(0FEH, "?",  " "),
    chardef(0FFH, "=",  ""));

PROCEDURE num2str (n,base,wi:CARDINAL;padchar:CHAR):str16;
VAR
    R:str16;
    ok:BOOLEAN;
BEGIN
    Str.CardToStr( LONGCARD(n),R,base,ok );
    WHILE Str.Length(R) < wi DO
        Str.Prepend(R,padchar);
    END;
    IF base=16 THEN Str.Lows(R);Str.Prepend(R,dollar);END;
    RETURN R;
END num2str;

CONST
    ASCIIset = 1;
    OEMset   = 2;

PROCEDURE showset (what,base:CARDINAL);
CONST
    default = FALSE;
    (*%T default *)
    double = doublequote;
    single = quote;
    sep    = ":";
    (*%E *)
    (*%F default  *)
    double = " ";
    single = " ";
    sep    = " "; (* ":" *)
    (*%E  *)
VAR
    i,wi,last,v:CARDINAL;
    S,H:str128;
    V:str16;
    pad:CHAR;
BEGIN
    WrLn;

    CASE base OF
    | 10: wi:=3;pad:=" "; H:="   ";
    | 16: wi:=2;pad:="0"; H:="    ";
    END;
    FOR i:=1 TO base DO
        Str.Append(H," ");
        Str.Append(H,num2str(i-1,base,wi,pad));
    END;
    WrStr(H);WrLn;

    last:= ((255 DIV base)+1)*base;DEC(last);
    FOR i:=0 TO last DO
        IF (i MOD base) = 0 THEN
            Str.Copy(V,num2str(i,base,wi,pad));
            WrStr(V);WrStr(" ");
        END;
        WrStr(sep);
        CASE what OF
        | ASCIIset:
            CASE i OF
            | 0..4,7..0AH, 0DH, 1AH..1BH :
                S:="   ";
            | ORD(doublequote):
                Str.Concat(S,single,CHR(i));Str.Append(S,single);
            ELSE
                IF i > 255 THEN
                    v:=ORD(" ");
                ELSE
                    v:=i;
                END;
                Str.Concat(S,double,CHR(v));Str.Append(S,double);
            END;
        | OEMset:
            v := ORD( CHR(TwinTOpc[i].MapChar) );
            CASE v OF
            | 0..4,7..0AH, 0DH, 1AH..1BH :
                S:="   ";
            | ORD(doublequote) :
                Str.Concat(S,single,CHR(v));Str.Append(S,single);
            ELSE
                Str.Concat(S,double,CHR(v));Str.Append(S,double);
            END;
        END;
        WrStr(S);
        IF (i MOD base) = (base-1) THEN
            WrStr(sep+" ");WrStr(V);WrLn;
        END;
    END;
    WrStr(H);WrLn;
END showset;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE chkUD (S:pathtype):BOOLEAN ;
VAR
    u,d,n,e:pathtype;
    pb:CARDINAL;
BEGIN
    Lib.SplitAllPath(S , u,d,n,e);
    pb:=0;
    IF chkJoker(u) THEN INC(pb);END;
    IF chkJoker(d) THEN INC(pb);END;
    RETURN (pb=0);
END chkUD;

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    bufferIn : ioBufferType;
    bufferOut: ioBufferType;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    steps = 10;
    animcmd=animShow;
VAR
    lastportion,portion,currportion:LONGCARD;
VAR
    opt,parmcount,offset  : CARDINAL;
    mode        : (console,diskfile);

    tmp : str128;

    S,R               : pathtype;
    parm1,parm2,parm3 : pathtype;
    filespec,basedir  : pathtype;
    backup,file       : pathtype;

    lookfor     : (identifiers,words,sequences);
    keepcase, wordmode,delete,verbose,usealias,usejoker    : BOOLEAN;
    ignorestring:BOOLEAN;
    noskip:BOOLEAN;
    strdelimiter:CHAR;
    percentalias,joker : CHAR;

    cmdstate    : (waitingcmd,gotParm1,gotParm2,gotParm3);

    existing,replacement,ID : str128; (* much more than necessary ! *)
    ptrID       : CARDINAL; (* try and avoid Str.Append function *)

    state       : (waiting,grabbing,filtering,instring);
    cmd         : (work,showASCIIhex,showOEMhex,showASCIIdec,showOEMdec);

    hin,hout    : FIO.File;

    countFile   : CARDINAL;
    i,p,got     : CARDINAL;
    c           : CHAR;

    sequ        : str256; (* more than possible existing sequence *)
    here        : CARDINAL;
    matchlen    : CARDINAL;
    ch          : CHAR;
    k           : CARDINAL;

    replaced    : LONGCARD;  (* just in case ! *)
    addr        : LONGCARD;
    useLFN      : BOOLEAN;
    DEBUG       : BOOLEAN;
    ptr,anchor  : pFname;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    lookfor     := identifiers;
    keepcase    := FALSE;  (* not case sensitive *)
    delete      := FALSE;  (* replace *)
    verbose     := FALSE;
    usealias    := FALSE;
    usejoker    := FALSE;
    cmd         := work;
    useLFN      := TRUE;
    ignorestring:= FALSE;
    noskip:=FALSE;
    DEBUG       := FALSE;

    cmdstate := waitingcmd;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "E"+delim+"EXACT"+delim+
                                 "W"+delim+"WORD"+delim+
                                 "D"+delim+"DELETE"+delim+
                                 "R"+delim+"RAW"+delim+
                                 "V"+delim+"VERBOSE"+delim+
                                 "P:"+delim+"PERCENT:"+delim+
                                 "J:"+delim+"JOKER:"+delim+
                                 "A"+delim+"ASCII"+delim+
                                 "O"+delim+"OEM"+delim+"WINDOWS"+delim+
                                 "AA"+delim+
                                 "OO"+delim+
                                 "L"+delim+"LFN"+delim+
                                 "S"+delim+"STRING"+delim+
                                 "F"+delim+"ALLFILES"+delim+
                                 "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 :  abort(errHelp,"");
            | 4,5 :    keepcase := TRUE;
            | 6,7 :    IF lookfor = sequences THEN abort(errConflict,"");END;
                       lookfor := words;
            | 8,9 :    delete  := TRUE;
            | 10,11:   IF lookfor = words THEN abort(errConflict,"");END;
                       lookfor := sequences;
            | 12,13:   verbose := TRUE;
            | 14,15:   GetString(S,tmp);
                       IF Str.Length(tmp) # 1 THEN abort(errBadAlias,S);END;
                       IF tmp[0] = percent THEN abort(errBadAlias,S);END;
                       percentalias:=tmp[0];
                       usealias:=TRUE;
            | 16,17:   GetString(S,tmp);
                       IF Str.Length(tmp) # 1 THEN abort(errBadJoker,S);END;
                       joker:=tmp[0];
                       UpperCase(joker); (* thus, we'll skip accents too *)
                       IF Belongs(letters,joker) THEN abort(errBadJokerSet,"");END;
                       joker:=tmp[0]; (* retrieve original *)
                       usejoker:=TRUE;
            | 18,19:   CASE cmd OF
                       | work,showASCIIhex : cmd:=showASCIIhex;
                       ELSE
                           abort(errCmdConflict,"");
                       END;
            | 20,21,22:CASE cmd OF
                       | work,showOEMhex : cmd:=showOEMhex;
                       ELSE
                           abort(errCmdConflict,"");
                       END;
            | 23:      CASE cmd OF
                       | work,showASCIIdec : cmd:=showASCIIdec;
                       ELSE
                           abort(errCmdConflict,"");
                       END;
            | 24:      CASE cmd OF
                       | work,showOEMdec : cmd:=showOEMdec;
                       ELSE
                           abort(errCmdConflict,"");
                       END;
            | 25,26:   useLFN:=FALSE;
            | 27,28:   ignorestring:=TRUE;
            | 29,30:   noskip:=TRUE;
            | 31:      DEBUG := TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            CASE cmdstate OF
            | waitingcmd  : Str.Copy(parm1,S);
            | gotParm1    : Str.Copy(parm2,S);
            | gotParm2    : Str.Copy(parm3,S);
            | gotParm3    : abort(errParmOverflow,S);
            END;
            INC(cmdstate);
        END;
    END;

    CASE cmd OF
    | showASCIIhex:  showset(ASCIIset,16);
    | showOEMhex:    showset(OEMset,16);
    | showASCIIdec:  showset(ASCIIset,10);
    | showOEMdec:    showset(OEMset,10);
    END;
    CASE cmd OF
    | work:
        ;
    ELSE
        abort(errNone,"");
    END;

    CASE delete OF
    | FALSE:
        CASE cmdstate OF
        | gotParm2 :
            mode := console;
        | gotParm3 :
            Str.Copy(filespec,parm3);
            mode := diskfile;
        ELSE
            abort(errHelp,"");
        END;
        Str.Copy(existing,parm1);
        Str.Copy(replacement,parm2);
    | TRUE:
        CASE cmdstate OF
        | gotParm1: (* existing *)
            mode := console;
        | gotParm2: (* existing infile *)
            Str.Copy(filespec,parm2);
            mode := diskfile;
        ELSE
            abort(errHelp,"");
        END;
        Str.Copy(existing,parm1);
        Str.Copy(replacement,"");
    END;

    useLFN:=( useLFN AND w9XsupportLFN() );

    IF DEBUG THEN
        WrStr("1 - Existing    : ");WrQuoted(existing);WrLn;
        WrStr("1 - Replacement : ");WrQuoted(replacement);WrLn;
    END;

    IF usealias THEN
        IF usejoker THEN
            IF percentalias=joker THEN abort(errJokerAlias,"");END;
        END;
        ReplaceChar (existing,    percentalias, percent);
        ReplaceChar (replacement, percentalias, percent);
    END;
    IF usejoker THEN
        IF usealias THEN
            IF percentalias=joker THEN abort(errJokerAlias,"");END;
        END;
    END;

    IF DEBUG THEN
        WrStr("2 - Existing    : ");WrQuoted(existing);WrLn;
        WrStr("2 - Replacement : ");WrQuoted(replacement);WrLn;
    END;

    IF metaproc(existing)=FALSE THEN abort(errBadMeta,existing);END;
    IF metaproc(replacement)=FALSE THEN abort(errBadMeta,replacement);END;

    IF DEBUG THEN
        WrStr("3 - Existing    : ");WrQuoted(existing);WrLn;
        WrStr("3 - Replacement : ");WrQuoted(replacement);WrLn;
    END;

    CASE lookfor OF
    | identifiers :
        wordmode := FALSE;
        IF isValidID(existing,usejoker,joker)=FALSE THEN abort(errBadExistingID,existing);END;
        IF delete=FALSE THEN
            IF isValidID(replacement,FALSE,"")=FALSE THEN abort(errBadReplacementID,replacement);END;
        END;
    | words       :
        wordmode := TRUE;
        IF isValidWord(existing)=FALSE THEN abort(errBadExistingWord,existing);END;
        IF delete=FALSE THEN
            IF isValidWord(replacement)=FALSE THEN abort(errBadReplacementWord,replacement);END;
        END;
    | sequences   :
        IF keepcase = FALSE THEN UpperCase(existing); END;
        matchlen := Str.Length(existing); (* 1 or more... *)
    END;

    IF ignorestring THEN
        IF lookfor = sequences THEN abort(errStringSequence,"");END;
    END;

    IF (verbose AND (DEBUG=FALSE)) THEN
        WrStr("Existing        : ");WrQuoted(existing);WrLn;
        WrStr("Replacement     : ");WrQuoted(replacement);WrLn;

        WrStr("Processing mode : ");
        CASE lookfor OF
        | identifiers: S:="identifiers";
        | words:       S:="words";
        | sequences:   S:="raw sequences";
        END;
        WrStr(S);WrLn;

        WrStr("Strings content : ");
        IF ignorestring THEN
            S:="ignored";
        ELSE
            S:="processed";
        END;
        WrStr(S);WrLn;
    END;

    CASE mode OF
    | console:

            hin  := FIO.StandardInput;
            hout := FIO.StandardOutput;

            IF lookfor = sequences THEN
                here  := 0;
                state := filtering;
            ELSE
                state := waiting;
            END;

            LOOP
                c := FIO.RdChar(hin);
                IF FIO.IOresult() # 0 THEN abort(errIn,""); END;
                IF FIO.EOF=TRUE THEN EXIT; END;

                CASE state OF
                | waiting:
                    IF isLegal(c,wordmode) THEN
                        ptrID := 0;
                        ID[ptrID]:=c;
                        INC(ptrID);
                        ID[ptrID]:=CHR(0);
                        state := grabbing;
                    ELSE
                        IF ignorestring THEN
                             CASE c OF
                             | singlequote,doublequote:
                                 strdelimiter:=c;
                                 state:=instring;
                             END;
                        END;
                        FIO.WrChar(hout,c);
                        (* IF FIO.IOresult()#0 THEN abort(errOut,"");END; *)
                    END;
                | instring: (* ignorestring ON *)
                     FIO.WrChar(hout,c);
                     IF c = strdelimiter THEN state:=waiting; END;
                | grabbing:
                    IF isLegal(c,wordmode) THEN
                        ID[ptrID]:=c;
                        INC(ptrID);
                        ID[ptrID]:=CHR(0);
                    ELSE
                        IF sameIDref(ID,existing,keepcase,usejoker,joker) THEN
                            Str.Copy(ID,replacement);
                        END;
                        FIO.WrStr(hout,ID); (* let function handle length of string *)
                        FIO.WrChar(hout,c);
                        state:=waiting;
                    END;
                | filtering:
                    ch := c;
                    IF keepcase=FALSE THEN UpperCase(ch);END;
                    IF here < matchlen THEN
                        IF samerawch(ch,existing[here],usejoker,joker) THEN
                            sequ[here]:=c;
                            INC(here);
                        ELSE
                            FOR k:= 1 TO here DO
                                FIO.WrChar(hout,sequ[k-1]);
                            END;
                            here := 0;
                            IF samerawch(ch,existing[here],usejoker,joker) THEN
                                sequ[here]:=c;
                                INC(here);
                            ELSE
                                FIO.WrChar(hout,c);
                            END;
                        END;
                    ELSE
                        FIO.WrStr(hout,replacement);
                        here := 0;
                        IF ch=existing[here] THEN
                            sequ[here]:=c;
                            INC(here);
                        ELSE
                            FIO.WrChar(hout,c);
                        END;
                    END;

                END;
            END;
            CASE state OF
            | grabbing :
                IF ID[0]=existing[0] THEN (* a little speed *)
                    IF same(ID,existing) THEN
                        Str.Copy(ID,replacement);
                    END;
                END;
                FIO.WrStr(hout,ID);
            | filtering :
                IF here < matchlen THEN (* print aborted sequence *)
                    FOR k := 1 TO here DO
                        FIO.WrChar(hout,sequ[k-1]);
                    END;
                END;
            END;

    | diskfile:

        (* a few q&d sanity checks *)

        IF DEBUG THEN WrStr("Filespec : ");WrFname(useLFN,filespec);WrLn;END;
        IF chkUD(filespec)=FALSE THEN abort(errBadSpec,filespec);END;
        IF same(filespec,dot) THEN Str.Copy(filespec,stardotstar); END;
        IF same(filespec,star) THEN Str.Copy(filespec,stardotstar); END;
        IF Str.Match(filespec,"*"+antislash) THEN Str.Append(filespec,stardotstar); END;
        IF chkJoker(filespec)=FALSE THEN
            IF fileIsDirectorySpec ( useLFN,filespec) THEN
                fixDirectory(filespec);
                Str.Append(filespec,stardotstar);
            END;
        END;
        IF DEBUG THEN WrStr("Filespec : ");WrFname(useLFN,filespec);WrLn;END;
        makebase(useLFN,filespec,basedir);
        IF DEBUG THEN WrStr("Basedir  : ");WrFname(useLFN,basedir);WrLn;END;

        initList(anchor);
        countFile := buildFileList( anchor,noskip,useLFN,DEBUG,filespec);
        CASE countFile OF
        | MAX(CARDINAL): abort(errTooMany,filespec);
        | 0 :            abort(errNoMatch,filespec);
        END;

        WrLn; (* prettier display, as now we're very likely to end with errNone *)

        ptr:=anchor;
        WHILE ptr # NIL DO
            getStr(filespec,ptr);
            Str.Concat(backup,basedir,filespec);

            p := Str.RCharPos(backup,dot);
            IF p # MAX(CARDINAL) THEN
                Str.Slice(S,backup,0,p);
                Str.Copy(backup,S);
            END;
            Str.Append(backup,extBAK);

            getStr(filespec,ptr);
            Str.Concat(file,basedir,filespec);
            IF fileExists(useLFN,backup) THEN fileErase(useLFN,backup); END; (* don't keep previous backup, whatever it was *)
            fileRename(useLFN, file,backup);

            video(file,TRUE);
            video(msgProcessing,TRUE);

            (* Work(cmdInit); *)
            (* completed(completedInit,fileGetFileSize(backup)); *)
            animInit(steps, "[", "]", CHR(46), "", "\/" );
            portion:=fileGetFileSize(useLFN,backup) DIV steps; INC(portion); (* avoid DIV 0 ! *)
            lastportion := steps+1;

            addr := 0;

            hin :=fileOpenRead(useLFN,backup);
            FIO.AssignBuffer(hin,bufferIn);
            hout:=fileCreate(useLFN,file);
            FIO.AssignBuffer(hout,bufferOut);
            FIO.EOF:=FALSE;

            IF lookfor = sequences THEN
                here  := 0;
                state := filtering;
            ELSE
                state := waiting;
            END;
            replaced := 0;

            LOOP
                IF FIO.EOF=TRUE THEN EXIT; END;
                got:=FIO.RdBin(hin,c,1);
                IF got # 1 THEN EXIT; END;

                (* Work(cmdShow); *)
                (* completed(completedSHOW,addr); *)

                anim(animcmd);
                currportion:=addr DIV portion;
                IF currportion # lastportion THEN
                    anim(animAdvance);
                    lastportion:=currportion;
                END;

                INC(addr);
                CASE state OF
                | waiting:
                     IF isLegal(c,wordmode) THEN
                         ptrID := 0;
                         ID[ptrID]:=c;
                         INC(ptrID);
                         ID[ptrID]:=CHR(0);
                         state := grabbing;
                     ELSE
                         IF ignorestring THEN
                             CASE c OF
                             | singlequote,doublequote:
                                 strdelimiter:=c;
                                 state:=instring;
                             END;
                         END;
                         FIO.WrBin(hout,c,1);
                     END;
                | instring: (* ignorestring ON *)
                     FIO.WrBin(hout,c,1);
                     IF c = strdelimiter THEN state:=waiting; END;
                | grabbing:
                    IF isLegal(c,wordmode) THEN
                        ID[ptrID]:=c;
                        INC(ptrID);
                        ID[ptrID]:=CHR(0);
                    ELSE
                        IF sameIDref(ID,existing,keepcase,usejoker,joker) THEN
                            Str.Copy(ID,replacement);
                            INC(replaced);
                        END;
                        FIO.WrStr(hout,ID); (* eh eh, could use wrbin ! *)
                        FIO.WrBin(hout,c,1);
                        state:=waiting;
                    END;
                | filtering:

                    ch := c;
                    IF keepcase=FALSE THEN UpperCase(ch);END;
                    IF here < matchlen THEN
                        IF samerawch(ch,existing[here],usejoker,joker) THEN
                            sequ[here]:=c;
                            INC(here);
                        ELSE
                            FOR k:= 1 TO here DO
                                FIO.WrBin(hout,sequ[k-1],1);
                            END;
                            here := 0;
                            IF samerawch(ch,existing[here],usejoker,joker) THEN
                                sequ[here]:=c;
                                INC(here);
                            ELSE
                                FIO.WrBin(hout,c,1);
                            END;
                        END;
                    ELSE
                        FIO.WrStr(hout,replacement); (* eh eh, could use wrbin ! *)
                        INC(replaced);
                        here := 0;
                        IF ch=existing[here] THEN
                            sequ[here]:=c;
                            INC(here);
                        ELSE
                            FIO.WrBin(hout,c,1);
                        END;
                    END;

                END;
            END;
            CASE state OF
            | grabbing :
                IF ID[0]=existing[0] THEN (* a little speed *)
                    IF same(ID,existing) THEN
                        Str.Copy(ID,replacement);
                        INC(replaced);
                    END;
                END;
                FIO.WrStr(hout,ID);
            | filtering :
                IF here < matchlen THEN (* print aborted sequence *)
                    FOR k := 1 TO here DO
                        FIO.WrBin(hout,sequ[k-1],1);
                    END;
                END;
            END;

            FIO.Flush(hout);
            fileClose(useLFN,hout); (* yes, in fact, it's FIO.Close()  *)
            fileClose(useLFN,hin);

            (* Work(cmdStop); *)
            (* completed(completedEnd,0); *)
            anim(animEnd);anim(animClear);

            video(msgProcessing,FALSE);
            video(file,FALSE);

            IF replaced = 0 THEN (* backup was useless here *)
                fileErase(useLFN,file);
                fileRename(useLFN,backup,file);
            END;

            WrLngCard(replaced,5);
            (* WrStr(" replacement"); IF replaced > 1 THEN WrStr("s");END; *)
            WrStr(" replacement(s)");
            WrStr(" made in "); WrFname(useLFN,file); WrLn;

            ptr:=ptr^.next;
        END;
        freeList(anchor);

    END;
    abort(errNone,"");
END OldNew.





(*
            notinset:=0;

                    chindex := ORD (ch);
                    newch := CHAR (TpcTOwin[chindex].MapChar);
                    chFlag:= CHAR (TpcTOwin[chindex].Flag);
                    CASE chFlag OF
                    | "=" : ;
                    | "?" : INC(notinset); (* no match *)
                    | "@" : INC(notinset); (* graphic *)
                    | "!" : ;
                    END;
                    pattern[last]:=newch;
                    IF charset=unicode THEN
                        INC(last);
                        pattern[last]:=CHR(0);
                    END;
                END;
            END;
            IF notinset # 0 THEN abort(errNotInSet,sCharSet);END;
*)


(*

test :  foo Foo FOO FOO!
test : "foo Foo FOO FOO!"
test : 'foo Foo FOO FOO!'

*)

