(* ---------------------------------------------------------------
Title         see help !
Author        who cares ?
Overview      see help !
Usage         see help !
Notes         grep-like syntax : text then file !
              Str.Match is case-insensitive : it's useless to enable -e with
              delete/keep/viewmatch/viewgrep in joker mode !
              (check if -vv is always -v -z)

              beware of adding features
              (or "to be done" / "not finished yet" portions of code !)
              just because they MIGHT be used someday :
              this is the way quirks & bugs happen
              always add features which are needed in real world situations
              and code everything at once
              (here, without any REAL need or demand,
              we had thought of parsing #..# too
              yet without adding full support code for it :
              fortunately, we had thought of limiting check for #,# alone !)

Bugs          with -uu, last line should be empty in order to avoid a wrong duplicate
Wish List     use jokers in replace mode ? bah...
              allow removal of substrings delimited by chars, or path ?
              "keep first" command ? even though it's delete first + baseline ?
              process case before Str.Match ?

--------------------------------------------------------------- *)

MODULE NewLine;

IMPORT Lib;
IMPORT FIO;
IMPORT Str;
IMPORT IO;

FROM IO IMPORT WrStr,WrLn, WrLngCard, WrCard;

FROM Storage IMPORT ALLOCATE,DEALLOCATE,Available,
HeapTotalAvail,MainHeap;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
AltAnimation, str16, getCurrentDirectory, setReadWrite, setReadOnly,
getFileSize, verifyString, str4096, unfixDirectory,
animShow, animSHOW, animAdvance, animEnd, animClear,
animInit, animGetSdone, anim, cleantabs, UpperCaseAlt, LowerCaseAlt,
completedInit, completedShow, completedSHOW, completedEnd, completed,
removeDups, isValidHDunit, removePhantoms, removeFloppies,
getCDROMunits, getCDROMletters, removeCDROMs, getAllHDunits,
getAllLegalUnits;

FROM QD_LFN IMPORT path9X, huge9X, findDataRecordType,
unicodeConversionFlagType, w9XchangeDir,
w9XgetDOSversion, w9XgetTrueDOSversion, w9XisWindowsEnh, w9XisMSDOS7,
w9XfindFirst, w9XfindNext, w9XfindClose, w9XgetCurrentDirectory,
w9XlongToShort, w9XshortToLong, w9XtrueName, w9XchangeDir,
w9XmakeDir, w9XrmDir, w9Xrename, w9XopenFile, w9XcloseFile,
w9XsupportLFN;

FROM QD_File IMPORT pathtype, w9XnothingRequired,
fileOpenRead, fileOpen, fileExists, fileIsRO, fileSetRW, fileSetRO,
fileErase, fileCreate, fileRename, fileGetFileSize, fileGetFileStamp,
fileIsDirectorySpec, fileClose;

(* ------------------------------------------------------------ *)

CONST
    DEFAULT       = MAX(CARDINAL);
    nullchar      = 0C; (* CHR(0) *)
    tabchar       = CHR(9);
    cr            = CHR(13);
    lf            = CHR(10);
    nl            = cr+lf;
    space         = " ";
    dot           = ".";
    deg           = "";
    dash          = "-";
    slash         = "/";
    doublequote   = '"';
    quote         = "'";
    colon         = ":";
    percent       = "%";
    stardotstar   = "*.*";
    dotdot        = dot+dot;
    sEOL          = "*";
    MAXPROCESSEDLINES=MAX(LONGCARD) DIV 2;
    sALLLINES     = "*"; (* sEOL *)
    sMAXRANGE     = "4096"; (* max line length = until last char *)
    escCh         = deg; (* avoid \, already used in some batches for \\ etc. *)
    escSet        = deg+dash+slash+quote;
    msgProcessing = " ";
    msgWait       = "Please wait...";
    emudupfirst   = nl+"# ";
    emudup        = "; ";
    seplinenum    = " : ";
CONST
    extBAK        = ".BK!";
    extCOM        = ".COM";
    extEXE        = ".EXE";
    extDLL        = ".DLL";
    extOVR        = ".OVR";
    extOVL        = ".OVL";
    extDRV        = ".DRV";
    extZIP        = ".ZIP";
    extARJ        = ".ARJ";
    extLZH        = ".LZH";
    skippedextensions    = extBAK+delim+extCOM+delim+extEXE+delim+
                           extDLL+delim+extOVR+delim+extOVL+delim+extDRV+delim+
                           extZIP+delim+extARJ+delim+extLZH;
CONST
    ProgEXEname   = "NEWLINE";
    ProgTitle     = "Q&D textfile line modifier/viewer";
    ProgVersion   = "v1.1f";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;
CONST
    errNone             = 0;
    errHelp             = 1;
    errConflict         = 2;
    errUnknownOption    = 3;
    errParmOverflow     = 4;
    errExpected         = 5;
    errTooMany          = 6;
    errNoMatch          = 7;
    errNonsense         = 8;
    errBadColumn        = 9;
    errBadCount         = 10;
    errBadRange         = 11;
    errBadMeta          = 12;
    errRangeDefinedAlready=13;
    errBadBaseLine      = 14;
    errJoker            = 15;
    errNonsenseMatch    = 16;
    errBadNumSuffix     = 17;
    errBadFieldWidth    = 18;
    errBadIncrement     = 19;
    errBadExt           = 20;

    errStorage          = 21;
    errNetSlash         = 22;
    errPhantomUnit      = 23;
    errBadUnit          = 24;
    errColon            = 25;
    errNoParent         = 26;
    errInnerParent      = 27;
    errDirJoker         = 28;
    errBadTabWidth      = 29;

    errHelper           = 128;

    errUserAborted      = 255;

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
    placeholder = "~";
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
ProgEXEname+" utility may be called with the following options (-?? = more help) :"+nl+
nl+
"Syntax 1  : <-a|-append> [-trim] [-force] [-n:#] [-f:#] [-k:#] <text> <file(s)>"+nl+
"Syntax 2  : <-p|-prepend> [-trim] [-force] <text> <file(s)>"+nl+
"Syntax 3  : <-i|-insert> [-force] <-c:#> <text> <file(s)>"+nl+
"Syntax 4  : <-c|-change> [-e] [-c:#] <oldtext> <newtext> <file(s)>"+nl+
"Syntax 5  : <-r|-remove> [-e] [-c:#] <text> <file(s)>"+nl+
"Syntax 6  : <-d|-delete> [-e] [-c:#] [-j] <text> <file(s)>"+nl+
"Syntax 7  : <-k|-keep> [-e] [-c:#] [-j] <text> <file(s)>"+nl+
"Syntax 8  : <-v|-view> [-e] [-c:#] [-line] [-trim] [-z] [-j] <text> <file(s)>"+nl+
"Syntax 9  : <-df|-dl|-vf|-vl> [-line] [-baseline:#] <count> <file(s)>"+nl+
"Syntax 10 : <-u|-unique> [-ignore:#,#] [-only:#,#] [-e] [-strict|-y] <file(s)>"+nl+
"Syntax 11 : <-m|-merge> [-c:#] [-trim] [-tab] <datafile> <file(s)>"+nl+
"Syntax 12 : <-n|-reinject> <datafile> <file>"+nl+
"Syntax 13 : <-g|-untab[:#]> <file(s)>"+nl+
nl+
"The following options apply to all syntaxes :"+nl+
nl+
"  -x   disable LFN support even if available"+nl+
"  -s   allow processing of subdirectories"+nl+
"  -!   filter files using operating system jokers (see infra)"+nl+
"  -w   disable ESCape polling (may be necessary with Win9X/WinXP)"+nl+
nl+
"a) For each processed file, original version is kept with "+extBAK+" extension."+nl+
"b) Complex <text> specification should be delimited by double quotes ;"+nl+
"   note command line parsing prevents double quotes from being used in <text>."+nl+

'c) "' + escCh + 'n" = $0d0a, "' + escCh + 'p" = "%", "' + escCh+ 'q" = double quote, "' +
escCh + '[' + escSet + ']" = symbol,' + nl +
'   "' + escCh + "[$|x]#[" + escCh + ']" = hex/dec value ($00 value not allowed).'+nl+

"d) Tabs are NOT expanded and line length should be less than 4096 characters."+nl+
'e) Jokers may be "?" (any character) or "*" (any sequence, empty or not) :'+nl+
'   specify -SoL and/or -EoL not to automagically prepend/append "*" to <text>.'+nl+
"   -jj stands for -j -SoL -EoL, and [j[j]] can be appended to -d, -k or -v."+nl+
"f) -quiet option suppresses final report. Hit ESC to abort when viewing data."+nl+
'g) Without -! option, "?" and "*" jokers do NOT work the DOS or Win9X way :'+nl+
'   "?" matches exactly one character, "*" matches any sequence of characters.'+nl+
"h) "+skippedextensions+" files are not processed."+nl;

    verbosehelpmsg=
nl+
"Syntax 1 or 2 : prepend or append exact <text> to each line."+nl+
"  -force allows command to apply to empty or blank lines."+nl+
"  -trim performs left or right triming preprocessing."+nl+
"  -n:# specifies auto-incremented number appended to <text> (-append only)"+nl+
"  -f:# specifies auto-incremented number field width ([1..12], default is 4)"+nl+
"  -k:# specifies auto-incremented number increment ([1..100], default is 1)"+nl+
"Syntax 3 : insert <text> at specified <column> in each line."+nl+
"  -force allows command to apply to empty or blank lines."+nl+
"  -column:# (from 1 upwards) specifies column to insert <text> at."+nl+
"Syntax 4 : replace <oldtext> with <newtext> in each line."+nl+
"  -exact forces case-sensitive operation."+nl+
"  -column:# (from 1 upwards) removes only one occurrence of <oldtext>."+nl+
"Syntax 5 : remove <text> from each line."+nl+
"  -exact forces case-sensitive operation."+nl+
"  -column:# (from 1 upwards) removes only one occurrence of <text>."+nl+
"Syntax 6 or 7 : filter out or keep each line containing <text>."+nl+
"  -exact forces case-sensitive operation."+nl+
"  -column:# (from 1 upwards) requires <text> to be at specified column."+nl+
"  -joker specifies <text> to be a pattern searched for (read note infra)"+nl+
"Syntax 8 : show each line containing <text>."+nl+
"  -exact forces case-sensitive operation."+nl+
"  -column:# (from 1 upwards) scans for <text> from specified column."+nl+
"  -vv forces a display loosely similar to Borland GREP.COM utility."+nl+
"  -line shows line number."+nl+
"  -z prevents files with 0 match from being listed."+nl+
"  -zz acts as -z option, also preventing matching lines from being displayed."+nl+
"  -joker specifies <text> to be a pattern searched for (read note infra)"+nl+
"  -- reverses match condition, showing each line NOT containing <text>."+nl+
"Syntax 9 : delete or show <count> first or last lines, or from specified line."+nl+
'  If specified as "'+sALLLINES+'", <count> is maximum number of lines.'+nl+
"  -line shows line number."+nl+
"  -baseline:# (from 1 upwards) specifies line to begin from"+nl+
"Syntax 10 : filter out duplicate lines, keeping the first occurrence (default)."+nl+
"  File(s) to process MUST be already sorted."+nl+
'  Optional columns range is either "column,count" or "first..last" ("'+sEOL+'" = EOL).'+nl+
'  -ignore:#,# ignores specified columns range.'+nl+
'  -only:#,# uses only specified columns range.'+nl+
"  -exact forces case-sensitive operation."+nl+
"  -strict|-y removes duplicate lines, including the first occurrence."+nl+
"  --[-] reverses process, filtering out single lines (--- = DUPLINES format)"+nl+
"  -uu is a shortcut for -unique -strict|-y."+nl+
"Syntax 11 : append lines from <datafile> to lines from <file>."+nl+
"  -column:# (from 1 upwards) pads each line to specified column, if needed."+nl+
"  -trim performs left and right triming preprocessing to each line."+nl+
"  -tab uses a tab as separator (default is a space)."+nl+
"Syntax 12 : replace <file> lines with numbered <datafile> lines."+nl+
"   <datafile> must have been dumped with -line option, <file> must be unique."+nl+
"Syntax 13 : expand tabs (default tab width is 8 unless specified with -g:#)."+nl;
VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp,errHelper :
        WrStr(helpmsg);
        IF e=errHelper THEN
            WrStr(verbosehelpmsg);
            e := errHelp;
        END;
    | errConflict :
        S := "Commands are mutually exclusive !";
    | errUnknownOption :
        S := "Unknown ~ option !";Str.Subst(S,placeholder,einfo);
    | errParmOverflow :
        S := "Unexpected ~ parameter !";Str.Subst(S,placeholder,einfo);
    | errExpected:
        S := "~ expected !";Str.Subst(S,placeholder,einfo);
    | errTooMany:
        S := 'Too many files match "~" specification !';Str.Subst(S,placeholder,einfo);
    | errNoMatch:
        S := 'No legal match for "~" specification !';Str.Subst(S,placeholder,einfo);
    | errNonsense:
        S := "~ option is a nonsense with specified command !";Str.Subst(S,placeholder,einfo);
    | errBadColumn:
        S := "Illegal ~ column value !";Str.Subst(S,placeholder,einfo);
    | errBadCount:
        S := "Illegal ~ count value !";Str.Subst(S,placeholder,einfo);
    | errBadRange:
        S := "Illegal ~ range !";Str.Subst(S,placeholder,einfo);
    | errUserAborted:
        S := "Aborted by user !";
    | errBadMeta:
        S := "Illegal escape sequence (~) !";Str.Subst(S,placeholder,einfo);
    | errRangeDefinedAlready:
        S := "-unique command accepts only one -i: or -o: range !";
        (* "Columns range for -unique option has already been defined !" *)
    | errBadBaseLine:
        S := "Illegal ~ line value !";Str.Subst(S,placeholder,einfo);
    | errJoker:
        S := "~ cannot contain any joker !";Str.Subst(S,placeholder,einfo);
    | errNonsenseMatch:
        S := "~ option is a nonsense with -joker option !";Str.Subst(S,placeholder,einfo);
    | errBadNumSuffix:
        S := "Illegal ~ number suffix value !";Str.Subst(S,placeholder,einfo);
    | errBadFieldWidth:
        S := "Illegal ~ field width value !";Str.Subst(S,placeholder,einfo);
    | errBadIncrement:
        S := "Illegal ~ increment value !";Str.Subst(S,placeholder,einfo);
    | errBadExt :
        S := "File extension would prevent file(s) from being processed !";
    | errStorage :
        S:='Storage.ALLOCATE() failure while processing "~" specification !';
        Str.Subst(S,placeholder,einfo);
    | errNetSlash :
        S:='Illegal server "\\" in "~" specification !';Str.Subst(S,placeholder,einfo);
    | errPhantomUnit :
        S:='Unavailable unit in "~" specification !';Str.Subst(S,placeholder,einfo);
    | errBadUnit :
        S:='Illegal unit in "~" specification !';Str.Subst(S,placeholder,einfo);
    | errColon :
        S:='Unexpected ":" in "~" specification !';Str.Subst(S,placeholder,einfo);
    | errNoParent :
        S:='Unresolvable ".." in "~" specification !';Str.Subst(S,placeholder,einfo);
    | errInnerParent :
        S:='Illegal ".." in "~" specification !';Str.Subst(S,placeholder,einfo);
    | errDirJoker :
        S:='Illegal "~" directory joker(s) !';Str.Subst(S,placeholder,einfo);
    | errBadTabWidth:
        S := "Illegal ~ tab width !";Str.Subst(S,placeholder,einfo);

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        ; (* nada *)
    ELSE
        WrStr(ProgEXEname+" : "); WrStr(S); WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* //FIXME *)

CONST
    CHKEVERY9X = 64; (* let's call chkEscape every CHKEVERY LOOP *)
    CHKEVERYDOS= 4;  (* safety *)

PROCEDURE pollEscape (VAR chkrounds:CARDINAL; useLFN,ignoreESC:BOOLEAN):BOOLEAN;
VAR
    alcatraz:BOOLEAN;
    every:CARDINAL;
BEGIN
    (*
    9x really does NOT like ChkEscape() and randomely hangs till a keypress
    Flushkey() does NOT help
    *)
    (*
    IF useLFN THEN
        hit:=FALSE;
    ELSE
        hit:=ChkEscape();
    END;
    *)
    IF ignoreESC THEN RETURN FALSE;END;
    IF useLFN THEN
        every:=CHKEVERY9X;
    ELSE
        every:=CHKEVERYDOS;
    END;
    INC(chkrounds);
    IF (chkrounds MOD every) = 0 THEN
        chkrounds:=0;
        alcatraz:=ChkEscape();
    ELSE
        alcatraz:=FALSE;
    END;
    RETURN alcatraz;
END pollEscape;

(* ------------------------------------------------------------ *)

PROCEDURE padnum (lc:LONGCARD;wi:CARDINAL   ):str80;
VAR
    R:str80;
    ok:BOOLEAN;
    i:CARDINAL;
BEGIN
    Str.CardToStr(lc,R,10,ok);
    FOR i:=Str.Length(R)+1 TO wi DO
        Str.Prepend(R,"0");
    END;
    RETURN R;
END padnum;

(* fix : we assumed exactly 3 chars extensions : .ex would match .exe, .ex$, etc. *)

PROCEDURE legalextension (S,skipthem:ARRAY OF CHAR):BOOLEAN;
VAR
    e3 : str16;
    n,p,len:CARDINAL;
    rc:BOOLEAN;
BEGIN

    Str.Caps(S); (* ah, lowercase LFNs... *)

    rc:=TRUE;
    n:=0;
    len:=Str.Length(S);
    LOOP
        isoleItemS(e3, skipthem,delim,n);
        IF same(e3,"") THEN EXIT; END;
        p:=Str.Pos(S,e3);
        IF p # MAX(CARDINAL) THEN
            IF (len-p) = Str.Length(e3) THEN rc:=FALSE; EXIT; END;
        END;
        INC(n);
    END;
    RETURN rc;
END legalextension;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE doGetDir (useLFN:BOOLEAN;currdrive:SHORTCARD;
                   VAR currdir: pathtype);
VAR
    longform:pathtype;
    rc:CARDINAL;
BEGIN
    FIO.GetDir(currdrive,currdir); (* we could use 0 for default drive *)
    IF useLFN THEN
        IF w9XshortToLong(currdir,rc,longform) THEN
            Str.Copy(currdir,longform);
            (* seems this function always returns "u:\*" form  *)
            IF currdir[1]=colon THEN Str.Delete(currdir,0,2);END;
        END;
    END;
END doGetDir;

(* u, "\*\", "u:\*\" *)

PROCEDURE getAnchor (useLFN:BOOLEAN;
                     VAR currdrive:SHORTCARD;
                     VAR currdir,currpath:pathtype);
VAR
    driveletter:CHAR;
BEGIN
    currdrive := FIO.GetDrive(); (* 1=A, etc. *)
    doGetDir(useLFN,currdrive, currdir);
    fixDirectory(currdir);
    driveletter := CHAR (currdrive+ORD("A")-1);
    Str.Concat(currpath, driveletter,colon);
    Str.Append(currpath, currdir);
END getAnchor;

(* code adapted from FCOMP v1.3c *)

(* minimalist *)

PROCEDURE buildParent (VAR parent:pathtype; current:pathtype):BOOLEAN;
VAR
    p:CARDINAL;
BEGIN
    IF Str.Match(current,"\") THEN RETURN FALSE; END;
    unfixDirectory(current);
    p:=Str.RCharPos(current,"\");
    Str.Slice(parent,current,0,p+1); (* keep final "\" *)
    RETURN TRUE;
END buildParent;

PROCEDURE doGetCurrent (useLFN:BOOLEAN;drive:SHORTCARD;
                       VAR unit:str2; VAR current:pathtype);
VAR
    rc:CARDINAL;
    longform:pathtype;
BEGIN
    Str.Concat(unit, CHR( ORD("A")-1+ORD(drive) ),colon);

    FIO.GetDir(drive,current); (* \path without u: nor trailing \ except at root *)
    IF current[1] # colon THEN Str.Prepend(current,unit); END; (* safety *)
    IF useLFN THEN
        IF w9XshortToLong(current,rc,longform) THEN (* if error, keep DOS current *)
            Str.Copy(current,longform);
        END;
    END;
    (* LFN function seems to always return "u:\*" form except at root *)
    IF current[1] = colon THEN Str.Delete(current,0,2);END; (* safety *)
    fixDirectory(current);
END doGetCurrent;

(*
    remember dirs can have an extension, and LFNs can have inner dots
    we handle (whether u: or not) :

    .        current
    ..       parent
    .\xxx    current\xxx       F/D
    ..\xxx   parent\xxx        F/D

    xxx\     current\xxx\
    xxx\.    current\xxx\
    xxx      current\xxx       F/D

    \xxx\    \xxx\
    \xxx     \xxx              F/D
*)

PROCEDURE chkfixSpec (VAR base,spec:pathtype;
                     useLFN:BOOLEAN;orgS:pathtype;HDletters:ARRAY OF CHAR):CARDINAL;
VAR
    p,len,rc:CARDINAL;
    drive:SHORTCARD;
    u:CHAR;
    unit:str2;
    current,parent,S:pathtype;
    ok:BOOLEAN;
BEGIN
    Str.Copy(S,orgS);
    IF Str.Pos(S,"\\") # MAX(CARDINAL) THEN RETURN errNetSlash;END;

    (* process u: in S *)

    CASE CharCount(S,colon) OF
    | 0 :
        drive := FIO.GetDrive();
        rc:=errNone;
    | 1 :
        IF Str.CharPos(S,colon) = 1 THEN
            u:=CAP( S[0] );
            CASE u OF
            | "A".."Z" :
                IF verifyString(u,HDletters) THEN
                    drive := SHORTCARD( ORD(u) - ORD("A") +1 );
                    Str.Delete(S,0,2); (* remove u: *)
                    rc:=errNone;
                ELSE
                    rc:=errPhantomUnit;
                END;
            ELSE
                rc:=errBadUnit;
            END;
        ELSE
            rc:=errColon;
        END;
    ELSE
        rc:=errColon;
    END;
    IF rc # errNone THEN RETURN rc; END;

    (* note S no longer has u: *)

    doGetCurrent(useLFN,drive, unit,current); (* "u:" and "\" or "\*\" *)
    ok:=buildParent(parent, current);

    IF same(S,".") THEN Str.Copy(S,current);END;
    IF same(S,"..") THEN
        IF ok THEN Str.Copy(S,parent) ELSE RETURN errNoParent; END;
    END;
    IF Str.Match(S,".\*") THEN Str.Subst(S,".\",current); END;
    IF Str.Match(S,"..\*") THEN
        IF ok THEN Str.Subst(S,"..\",parent) ELSE RETURN errNoParent;END;
    END;
    IF Str.Match(S,"\*")=FALSE THEN Str.Prepend(S,current);END;
    IF Str.Match(S,"*\.") THEN
        (* S[Str.Length(S)-1]:=0C; *)
        len:=Str.Length(S);
        Str.Delete(S,len-1,1);
    END;
    (* we don't want inner or trailing ".." now *)
    IF Str.Pos(S,"..") # MAX(CARDINAL) THEN RETURN errInnerParent;END;

    (* base = "u:\xxx\" and spec = "xxx" *)

    IF Str.Match(S,"*\") THEN
        Str.Concat(base,unit,S);
        Str.Copy(spec,"*.*");
    ELSE
        Str.Prepend(S,unit);
        (* S is u:[\xxx]... without trailing "\" *)
        len:=Str.Length(S);
        p:=Str.RCharPos(S,"\");
        Str.Slice(base,S,0,p+1);
        Str.Slice(spec,S,p+1,len-p);
        IF chkJoker(spec)=FALSE THEN (* if spec has joker(s), assume files *)
            (* spec has no joker : dir or file ? *)
            IF fileIsDirectorySpec(useLFN,S) THEN
                Str.Copy(base,S);
                fixDirectory(base); (* safety *)
                Str.Copy(spec,"*.*");
            END;
        END;
    END;
    IF chkJoker(base) THEN RETURN errDirJoker; END;
    RETURN errNone;
END chkfixSpec;

(* ------------------------------------------------------------ *)

CONST
    firstindex = 1; (* because we'll need 1-1 *)
TYPE
    pEntry = POINTER TO entryType;
    entryType = RECORD
        next      : pEntry;
        index     : CARDINAL;  (* [1.. is ID of base dir for files *)
        slen      : SHORTCARD;
        str       : CHAR;
    END;

PROCEDURE initList (VAR anchor : pEntry );
BEGIN
    anchor := NIL;
END initList;

PROCEDURE freeList (anchor : pEntry);
VAR
    needed : CARDINAL;
    p      : pEntry;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(entryType) - SIZE(anchor^.str) + CARDINAL(anchor^.slen);
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END freeList;

PROCEDURE buildNewPtr (VAR anchor,p:pEntry; len:CARDINAL):BOOLEAN;
VAR
    needed : CARDINAL;
BEGIN
    needed := SIZE(entryType) - SIZE(p^.str) + len;
    IF Available(needed)=FALSE THEN RETURN FALSE; END;
    IF anchor = NIL THEN
        ALLOCATE(anchor,needed);
        p:=anchor;
    ELSE
        p:=anchor;
        WHILE p^.next # NIL DO
            p:=p^.next;
        END;
        ALLOCATE(p^.next,needed);
        p:=p^.next;
    END;
    p^.next := NIL;
    RETURN TRUE;
END buildNewPtr;

(* ------------------------------------------------------------ *)

(* assume p is valid *)

PROCEDURE getStr (VAR S : pathtype; p:pEntry);
VAR
    len:CARDINAL;
BEGIN
    len := CARDINAL(p^.slen);
    Lib.FastMove( ADR(p^.str),ADR(S),len);
    S[len] := nullchar; (* REQUIRED safety ! *)
END getStr;

PROCEDURE findByIndex(wanted:CARDINAL;anchor:pEntry) : pEntry;
VAR
    p:pEntry;
BEGIN
    p := anchor;
    LOOP
        IF p = NIL THEN EXIT;END; (* gloups ! should NEVER happen ! *)
        IF p^.index = wanted THEN EXIT; END;
        p := p^.next;
    END;
    RETURN p;
END findByIndex;

PROCEDURE isReservedEntry (S:ARRAY OF CHAR) : BOOLEAN;
BEGIN
    IF same(S,dot) THEN RETURN TRUE; END;
    RETURN same(S,dotdot);
END isReservedEntry;

PROCEDURE buildDirList (VAR lastdir:CARDINAL; VAR anchor:pEntry;
                       useLFN,recurse:BOOLEAN;base:pathtype):CARDINAL;
VAR
    p: pEntry;
    len : CARDINAL;
    root,rootspec,entryname,newroot : pathtype;
    entry : FIO.DirEntry;
    found : BOOLEAN;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    dosattr:FIO.FileAttr;
    w9Xhandle,errcode:CARDINAL;
    rc : CARDINAL;
    ok:BOOLEAN;
BEGIN
    Str.Copy(root,base);
    fixDirectory(root); (* safety *)

    (* assume base exists ! *)

    len:=Str.Length(root);
    IF buildNewPtr(anchor,p,len)=FALSE THEN RETURN errStorage; END;
    INC(lastdir);
    p^.index     := lastdir;
    p^.slen      := SHORTCARD(len);
    Lib.FastMove ( ADR(root),ADR(p^.str),len );

    IF NOT(recurse) THEN RETURN errNone; END;

    Str.Concat(rootspec,root,"*.*");
    IF useLFN THEN
        found := w9XfindFirst (rootspec,SHORTCARD(everything),SHORTCARD(w9XnothingRequired),
                              unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(rootspec,everything,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;
            IF (aD IN dosattr) THEN
                Str.Concat(newroot,root,entryname); (* u:\xx\ + xxx *)
                fixDirectory(newroot);
                rc:= buildDirList (lastdir,anchor,
                                  useLFN,recurse,newroot);
                IF rc # errNone THEN
                    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                    RETURN rc;
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN errNone;
END buildDirList;

PROCEDURE dmpDirs (anchor:pEntry;useLFN:BOOLEAN);
CONST
    sInfo = 'DIR  index= ~  "~"'; (* file must always be last with this placeholder *)
VAR
    p : pEntry;
    R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
BEGIN
    p:=anchor;
    WHILE p # NIL DO
        getStr(R,p);
        Str.Copy(S, sInfo);  Str.Subst(S,"~",padnum(LONGCARD(p^.index),5));
        Str.Subst(S,"~", R);
        WrStr(S);WrLn;
        p:=p^.next;
    END;
END dmpDirs;

PROCEDURE dmpFiles (fileanchor,diranchor:pEntry;dirindex:CARDINAL;useLFN:BOOLEAN);
CONST
    sInfo = 'File index= ~  "~"'; (* file must always be last with this placeholder *)
VAR
    p : pEntry;
    base,R: pathtype;
    ok:BOOLEAN;
    S:str1024;   (* oversized *)
BEGIN
    p:=findByIndex(dirindex,diranchor);
    getStr(base,p);

    p:=fileanchor;
    WHILE p # NIL DO
        getStr(R,p);
        Str.Copy(S, sInfo);
        Str.Subst(S,"~",padnum(LONGCARD(p^.index),5));
        Str.Prepend(R,base);
        Str.Subst(S,"~", R);
        WrStr(S);WrLn;
        p:=p^.next;
    END;
END dmpFiles;

(* modified DD v1.0h sub *)

PROCEDURE storeFiles (VAR globallastfile:LONGCARD; VAR lastfile:CARDINAL;
                     VAR fileanchor : pEntry;
                     useLFN,osjokers:BOOLEAN; base,spec:pathtype;
                     skipext:ARRAY OF CHAR):CARDINAL;
VAR
    matchspec,rootspec,entryname : pathtype;
    w9Xentry : findDataRecordType;
    unicodeconversion:unicodeConversionFlagType;
    dosattr:FIO.FileAttr;
    w9Xhandle,errcode:CARDINAL;
    entry : FIO.DirEntry;
    ok,keepit,found : BOOLEAN;
    len:CARDINAL;
    pp:pEntry;
BEGIN
    lastfile     := firstindex-1; (* 0 *)
    initList(fileanchor);

    IF osjokers THEN
        Str.Concat(rootspec,base,spec);
        Str.Copy(matchspec,"*");         (* match everything *)
    ELSE
        Str.Concat(rootspec,base,"*.*"); (* was spec before osjoker option *)
        Str.Copy(matchspec,spec);
    END;

    (* allfiles is a better choice than everything here *)
    IF useLFN THEN
        found := w9XfindFirst (rootspec,SHORTCARD(allfiles),SHORTCARD(w9XnothingRequired),
        unicodeconversion,w9Xentry,w9Xhandle,errcode);
    ELSE
        found := FIO.ReadFirstEntry(rootspec,allfiles,entry);
    END;
    WHILE found DO
        IF useLFN THEN
            Str.Copy(entryname,w9Xentry.fullfilename);
        ELSE
            Str.Copy(entryname,entry.Name);
        END;
        IF isReservedEntry (entryname) = FALSE THEN (* skip "." AND ".." *)
            IF useLFN THEN
                dosattr:=FIO.FileAttr(w9Xentry.attr AND 0FFH);
            ELSE
                dosattr:=entry.attr;
            END;

            ok := NOT (aD IN dosattr); (* was valid when we used everything attribute *)

            IF ok THEN
                ok := legalextension(entryname,skipext);
            END;

            IF ok THEN
                (* if file has no extension, add it as a marker *)
                IF Str.RCharPos(entryname,".")=MAX(CARDINAL) THEN
                    Str.Append(entryname,".");
                END;
                ok:=Str.Match(entryname,matchspec); (* was spec *)
                IF ok THEN
                    len:=Str.Length(entryname);
                    IF buildNewPtr(fileanchor,pp,len)=FALSE THEN
                        IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
                        RETURN errStorage;
                    END;
                    INC(lastfile);
                    INC(globallastfile);
                    pp^.index     := lastfile;
                    pp^.slen      := SHORTCARD(len);
                    Lib.FastMove ( ADR(entryname),ADR(pp^.str),len );
                END;
            END;
        END;
        IF useLFN THEN
            found :=w9XfindNext(w9Xhandle, unicodeconversion,w9Xentry,errcode);
        ELSE
            found :=FIO.ReadNextEntry(entry);
        END;
    END;
    IF useLFN THEN ok:=w9XfindClose(w9Xhandle,errcode); END;
    RETURN errNone;
END storeFiles;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

(* assume : digits already filtered and uppercased, base = 10 or 16, hex=## *)

PROCEDURE charvalToStr (VAR R:ARRAY OF CHAR; nbase:CARDINAL; digits:ARRAY OF CHAR):BOOLEAN;

    MODULE hxhelper;

    EXPORT hx;

    PROCEDURE hx (ch:CHAR):CARDINAL;
    CONST
        val0 = ORD("0");
        valA = ORD("A");
    VAR
        v:CARDINAL;
    BEGIN
        v:=ORD(ch);
        IF v < valA THEN
            DEC(v, val0 );
        ELSE
            DEC(v, valA );
            INC(v, 10);
        END;
        RETURN v;
    END hx;

    END hxhelper;

CONST
    maxcharval = MAX(SHORTCARD);
VAR
    rc : BOOLEAN;
    i,len,v: CARDINAL;
BEGIN
    rc := TRUE;
    len:= Str.Length(digits);
    Str.Copy(R,"");
    CASE nbase OF
    | 10: (* filtered for 0..9 *)
        v:=0;
        i:=1;
        LOOP
            IF i > len THEN EXIT;END;
            v := (v * 10);
            INC( v , ( ORD( digits[i-1] ) - ORD("0") ) );
            rc := ( v <= maxcharval ); IF NOT(rc) THEN EXIT; END;
            INC(i);
        END;
        IF rc THEN rc := (v # 0); END;
        IF rc THEN Str.Copy( R, CHR(v) );END;
    | 16: (* filtered for 0..9 A..F *)
        (* IF len < 2 THEN Str.Prepend(digits,"0"); INC(len);END; done by caller *)
        IF ODD(len) THEN
            rc:=FALSE;
        ELSE
            i:=1;
            LOOP
                IF i > len THEN EXIT; END;
                v:=  ( hx(digits[i-1]) << 4 );
                INC(i);
                INC(v, hx(digits[i-1]) );
                INC(i);
                rc := (v # 0);
                IF NOT(rc) THEN EXIT; END;
                Str.Append(R, CHR(v) );
            END;
        END;
    END;
    RETURN rc;
END charvalToStr;

(*

n  p  q  -  /  '  

###    $##    x##

*)

PROCEDURE metaproc (VAR S : ARRAY OF CHAR):BOOLEAN;
VAR
    ch:CHAR;
    c2:str80; (* really oversized for safety *)
    len,i,base:CARDINAL;
    R:str128;
    str:str128; (* in case we overflow ! *)
    state : (waiting,gotesc,grabhex,grabdec);
    rc:BOOLEAN;
BEGIN
    len := Str.Length(S);
    R   := "";
    i   := 1;
    rc  := TRUE;
    state := waiting;
    LOOP
        IF i > len THEN EXIT; END;
        ch := S[i-1];
        CASE state OF
        | waiting:
            CASE ch OF
            | escCh :
                state := gotesc;
            ELSE
                Str.Append(R,ch);
            END;
        | gotesc:
            CASE ch OF
            | "x","X","$":Str.Copy(str,"");         state:=grabhex; base:=16;
            | "0".."9" :  Str.Copy(str,ch);         state:=grabdec; base:=10;
            | "n","N" :   Str.Append(R,nl);         state:=waiting;
            | "p","P" :   Str.Append(R,percent);    state:=waiting;
            | "q","Q" :   Str.Append(R,doublequote);state:=waiting;
            ELSE
                IF Str.CharPos(escSet,ch) = MAX(CARDINAL) THEN
                    DEC(i); (* esc+verbatim : go back to make verbatim the next *)
                ELSE
                    Str.Append(R,ch); (* esc+reserved char *)
                END;
                state:=waiting;
            END;
        | grabhex:
            CASE ch OF
            | "0".."9", "A".."F", "a".."f" :
                Str.Append(str, CAP(ch) ); (* uppercase ! *)
            | escCh:
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=gotesc;
            ELSE
                IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        | grabdec:
            CASE ch OF
            | "0".."9" :
                Str.Append(str,ch);
            | escCh:
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                state:=gotesc;
            ELSE
                rc:=charvalToStr(c2,base,str); IF rc=FALSE THEN EXIT; END;
                Str.Append(R,c2);
                DEC(i); (* go back one char now to make it next *)
                state:=waiting;
            END;
        END;
        INC(i);
    END;
    CASE state OF
    | grabhex:
        IF Str.Length(str) < 2 THEN Str.Prepend(str,"0");END; (* one char fix *)
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    | grabdec:
        rc:=charvalToStr(c2,base,str);
        IF rc THEN Str.Append(R,c2); END;
    END;
    Str.Copy(S,R);
    RETURN rc;
END metaproc;

(* ------------------------------------------------------------ *)

PROCEDURE chkRange (VAR lc:LONGCARD;lower,upper:LONGCARD):BOOLEAN ;
BEGIN
    IF lc < lower THEN RETURN FALSE;END;
    IF lc > upper THEN RETURN FALSE;END;
    RETURN TRUE;
END chkRange;

CONST
    ioBufferSize    = (8 * 512) + FIO.BufferOverhead;
    firstBufferByte = 1;
    lastBufferByte  = ioBufferSize;
TYPE
    ioBufferType  = ARRAY [firstBufferByte..lastBufferByte] OF BYTE;
VAR
    bufferIn,bufferOut,bufferInData : ioBufferType;

(* ------------------------------------------------------------ *)

PROCEDURE isMatch (jokermode,exact:BOOLEAN;column:CARDINAL;
                  hugestring,text,textCAPS:ARRAY OF CHAR):BOOLEAN;
VAR
    colpos,p : CARDINAL;
    hugetrimed:str4096; (* same as main *)
    found:BOOLEAN;
BEGIN
    IF jokermode THEN
        Str.Copy(hugetrimed,hugestring);
        (* useless because of str.match design !
        IF exact THEN
            IF Str.Match(hugetrimed,text) THEN
                p:=0;
            ELSE
                p:=MAX(CARDINAL);
            END;
        ELSE
        *)
            UpperCase(hugetrimed);
            IF Str.Match(hugetrimed,textCAPS) THEN
                p:=0;
            ELSE
                p:=MAX(CARDINAL);
            END;
    ELSE
        IF column = DEFAULT THEN
            colpos:=0;
        ELSE
            colpos:=column-1;
        END;
        IF exact THEN
            p:=Str.NextPos(hugestring,text,colpos);
        ELSE
            Str.Copy(hugetrimed,hugestring);
            UpperCase(hugetrimed);
            p:=Str.NextPos(hugetrimed,textCAPS,colpos);
        END;
    END;

    found := (p # MAX(CARDINAL)) AND (p < Str.Length(hugestring));
    IF found THEN
        IF column # DEFAULT THEN found:= (p=(column-1));END;
    END;
    RETURN found;
END isMatch;

(* ------------------------------------------------------------ *)

PROCEDURE showmem(debug:BOOLEAN; S:ARRAY OF CHAR );
VAR
    heapsize    : CARDINAL; (* in PARAGRAPHS and not in bytes ! help is wrong ! *)
    n           : LONGCARD;
BEGIN
    IF debug THEN
        heapsize :=HeapTotalAvail(MainHeap);
        n := 16 * LONGCARD(heapsize);
        WrStr("::: ");
        WrLngCard(n,6);
        WrStr(" byte(s) free -- ");WrStr(S);WrLn;
    END;
END showmem;

PROCEDURE whatline ( showline, prefix:BOOLEAN; total:LONGCARD);
BEGIN
    IF showline THEN
        IF prefix THEN
            WrLngCard(total, 6 );
            WrStr(seplinenum);
        END;
        WrStr(doublequote);
    END;
END whatline;

(* ------------------------------------------------------------ *)

PROCEDURE untabme (VAR R : ARRAY OF CHAR; tabwidth:CARDINAL;S:ARRAY OF CHAR);
VAR
    i,j,add: CARDINAL;
    c : CHAR;
BEGIN
    Str.Copy(R,"");
    j:=0; (* yes, 0 and not 1 ! *)
    FOR i:=1 TO Str.Length(S) DO
        c := S[i-1];
        IF c = tabchar THEN
            add := tabwidth - (j MOD tabwidth);
            WHILE add > 0 DO
                Str.Append(R,space); INC(j);
                DEC(add);
            END;
        ELSE
            Str.Append(R,c); INC(j);
        END;
    END;
END untabme;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    ptrLine = POINTER TO lineType;
    lineType = RECORD
        next      : ptrLine;
        thisline  : LONGCARD;
        slen      : CARDINAL; (* account for possible long line *)
        str       : CHAR; (* variable *)
    END;

PROCEDURE initReinject (VAR anchor:ptrLine);
BEGIN
    anchor:=NIL;
END initReinject;

PROCEDURE grabReinject (VAR anchor:ptrLine;
                       debug,useLFN:BOOLEAN;datafile:pathtype ):BOOLEAN;
CONST
    linepat = "*"+seplinenum+doublequote+"*"+doublequote;
VAR
    hindata:FIO.File;
    S:str4096;
    p,len,needed:CARDINAL;
    N:str16;
    thisline:LONGCARD;
    ok,everythinggoes:BOOLEAN;
    newInList:ptrLine;
BEGIN
    everythinggoes:=TRUE;
    hindata :=fileOpenRead(useLFN,datafile);
    FIO.AssignBuffer(hindata,bufferInData);
    LOOP
        FIO.RdStr(hindata,S);
        IF FIO.EOF THEN EXIT; END;
        LtrimBlanks(S);
        RtrimBlanks(S);
        (*         !                               *)
        (* ''###### : "*"'' seplinenum+doublequote *)
        IF Str.Match(S,linepat) THEN
            p:=Str.Pos(S,seplinenum+doublequote); (* always found *)
            Str.Slice(N,S,0,p);
            LtrimBlanks(N);
            RtrimBlanks(N);
            thisline:=Str.StrToCard(N,10,ok);
            IF ok THEN
                p:=Str.CharPos(S,doublequote);    (* always found *)
                Str.Delete(S,0,p+1);
                p:=Str.RCharPos(S,doublequote);   (* always found *)
                S[p]:=nullchar;                   (* brutal ! *)
                IF debug THEN
                    WrStr(N);WrStr(seplinenum+doublequote);
                    WrStr(S);WrStr(doublequote);WrLn;
                END;
                len:=Str.Length(S);
                needed:=SIZE(lineType)-SIZE(anchor^.str)+len;
                IF Available(needed)=FALSE THEN everythinggoes:=FALSE;EXIT;END;
                IF anchor=NIL THEN
                    ALLOCATE(anchor,needed);
                    newInList:=anchor;
                ELSE
                    ALLOCATE(newInList^.next,needed);
                    newInList:=newInList^.next;
                END;
                Lib.FastMove( ADR(S), ADR(newInList^.str),len);
                newInList^.slen     := len;
                newInList^.thisline := thisline;
                newInList^.next     := NIL;
            END;
        END;
    END;
    fileClose(useLFN,hindata);
    RETURN everythinggoes;
END grabReinject;

PROCEDURE releaseReinject (anchor : ptrLine);
VAR
    needed : CARDINAL;
    p      : ptrLine;
BEGIN
    (* p:=anchor; *)
    WHILE anchor # NIL DO
        needed := SIZE(lineType) - SIZE(anchor^.str) + anchor^.slen;
        p := anchor^.next;
        DEALLOCATE(anchor,needed);
        anchor:=p;
    END
END releaseReinject;

(* change S only IF wanted found *)

PROCEDURE procReinjectMe (anchor:ptrLine;wanted:LONGCARD;VAR S:str4096 ):BOOLEAN;
VAR
    p:ptrLine;
    found:BOOLEAN;
    R:str4096;
    len:CARDINAL;
BEGIN
    found:=FALSE;
    LOOP
        IF anchor=NIL THEN EXIT;END;
        IF anchor^.thisline = wanted THEN
            len:=anchor^.slen;
            Lib.FastMove( ADR(anchor^.str), ADR(R), len);
            R[len]:=nullchar; (* required safety *)
            Str.Copy(S,R);
            found:=TRUE;
            EXIT;
        END;
        p:=anchor^.next;
        anchor:=p;
    END;
    RETURN found;
END procReinjectMe;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

TYPE
    rangetype = (norange,rangeignore,rangeonly);

(* legal : column,count  first..last  first-last *)

PROCEDURE parseRange (VAR firstcol,countcol:CARDINAL; VAR range:rangetype;
                     newrange:rangetype;R:ARRAY OF CHAR):CARDINAL;
VAR
    S2:str128;
    p:CARDINAL;
    rangesep,pattern,snum:str16;
    lc:LONGCARD;
    try : (trycount, tryrange, tryrangealt);
BEGIN
    IF range # norange THEN RETURN errRangeDefinedAlready;END;

    GetString(R,S2);

    firstcol  := DEFAULT;
    countcol  := DEFAULT;

    try:=trycount;
    LOOP
        CASE try OF
        | trycount:    rangesep:=",";
        | tryrange:    rangesep:="..";
        | tryrangealt: rangesep:="-";
        END;
        Str.Concat(pattern,"*",rangesep); Str.Append(pattern,"*");
        IF Str.Match(S2, pattern) THEN
            p:=Str.Pos(S2,rangesep);
            IF p > 0 THEN
                Str.Slice(snum,S2,0,p);
                Str.Delete(S2,0,p);
            ELSE
                snum:="";
            END;
            Str.Subst(S2,rangesep,"");
            Str.Prepend(snum,"="); (* ugly trick *)
            IF GetLongCard(snum,lc)=FALSE THEN RETURN errBadRange;END;
            IF ( (lc < 1) OR (lc > SIZE(str4096)) ) THEN RETURN errBadRange;END;
            firstcol:=CARDINAL(lc)-1; (* remember : 1-based for user, 0-based for Str library *)

            IF same(S2,sEOL) THEN S2:=sMAXRANGE;END;
            Str.Concat(snum,"=",S2);
            IF GetLongCard(snum,lc)=FALSE THEN RETURN errBadRange;END;
            IF ( (lc < 1) OR (lc > SIZE(str4096)) ) THEN RETURN errBadRange;END;
            CASE try OF
            | trycount:
                countcol:=CARDINAL(lc);
            | tryrange, tryrangealt:
                IF CARDINAL(lc) < (firstcol+1) THEN RETURN errBadRange;END;
                countcol:=(CARDINAL(lc)-1) -firstcol+1;
            END;
            range:=newrange;
            EXIT;
        END;
        IF try=tryrangealt THEN EXIT; END;
        INC(try);
    END;
    IF range # newrange THEN RETURN errBadRange;END;
    RETURN errNone;
END parseRange;

TYPE
    cmdtype = (nothing,
              append,prepend,remove,delete,keep,
              delfirst,dellast,viewfirst,viewlast,
              viewmatch,viewgrep,uniq,
              insert,replace,
              delrange,viewrange,
              merge,
              untab,reinject);

PROCEDURE newcmd (VAR cmd:cmdtype;wantedcmd:cmdtype);
BEGIN
    IF cmd = wantedcmd THEN RETURN; END;
    IF cmd # nothing THEN abort(errConflict,"");END;
    cmd:=wantedcmd;
END newcmd;

(* ------------------------------------------------------------ *)

CONST
    DEFAUTONUM    = 0; (* i.e. no renumbering suffix *)
    MINAUTONUM    = 1;
    MINFIELD      = 1;
    MAXFIELD      = 12;
    DEFFIELD      = 4;
    MINDELTA      = 1;
    MAXDELTA      = 100;
    DEFDELTA      = 1;
    MINTABWIDTH   = 1;
    MAXTABWIDTH   = 64;
    DEFTABWIDTH   = 8;
CONST
    strFile       = "::: File "; (* grep uses "File $:" *)
CONST
    firstparm = 1;
    maxparm   = 3;
VAR
    lastparm  : CARDINAL;
    parm      : ARRAY [firstparm..maxparm] OF pathtype; (* was str128 *)
VAR
    parmcount, i, opt,len,ii : CARDINAL;
    S,R   : pathtype;
    orgspec,currdir,currpath,specbase,spec:pathtype;
    file,backup,datafile,rootspec,basepath:pathtype;
    pf,diranchor,pdir,fileanchor:pEntry;
    sLegalUnits : str80;
    fileindex,lastfile,rc,lastdir:CARDINAL;
    globallastfile:LONGCARD;
    quiet,trim,all,exact,onlyshow,nameshown,showline:BOOLEAN;
    osjokers,skipempty,showmatchline,dmp,strict,tabsep:BOOLEAN;
    inverse,emuDuplines:BOOLEAN;
    jokermode,jokerprepend,jokerappend:BOOLEAN;
    range : rangetype;
    userAborted : BOOLEAN;
    debug             : BOOLEAN;
    text,textcli,newtextcli,newtext : str128;
    textCAPS,newtextCAPS:str128;
    cmd:cmdtype;
    hin, hout,hindata : FIO.File;
    p                 : CARDINAL;
    processed,total,bigtotal : LONGCARD;  (* just in case ! *)
    linecount,bigcount,orgbigcount,baseline,lastbaseline : LONGCARD;  (* just in case ! *)
    hugestring        : str4096;
    hugetrimed        : str4096;
    oldhuge,oldhugeorg,newhuge,tmphuge   : str4096;
    stateuniq         : (norefyet,refnow);
    dupcount          : CARDINAL;
    column,colpos     : CARDINAL;
    lc                : LONGCARD;
    count,firstcol,countcol : CARDINAL;
    snum : str16;
    autonum,autodelta:LONGCARD;
    autofieldwidth : CARDINAL;
    steps:CARDINAL;
    fsize,portion,currportion,lastportion:LONGCARD;
    showme,ignoreEsc,recurse,useLFN,keepEOF,found:BOOLEAN;
    dirindex,countFile,chkrounds:CARDINAL;
    currdrive:SHORTCARD;
    tabwi:CARDINAL;
    anchorReinject:ptrLine;
    showfilename:BOOLEAN;
    matchinglines,notmatchinglines: LONGCARD;
BEGIN
    Lib.DisableBreakCheck();
    FIO.IOcheck := FALSE;

    WrLn;

    parmcount := Lib.ParamCount();
    IF parmcount = 0 THEN abort(errHelp,"");END;

    useLFN:=TRUE;

    lastparm  := firstparm - 1;
    cmd       := nothing;
    trim      := FALSE;
    all       := FALSE;
    exact     := FALSE;
    quiet     := FALSE;
    showline  := FALSE;
    column    := DEFAULT;        (* none *)
    range     := norange;
    skipempty := FALSE;
    showmatchline:=TRUE;
    strict    := FALSE;
    tabsep    := FALSE;
    jokermode := FALSE;
    jokerprepend:=TRUE;
    jokerappend :=TRUE;
    recurse   := FALSE;
    osjokers  := TRUE;
    ignoreEsc := FALSE;
    baseline  := 0;
    inverse   := FALSE;
    emuDuplines:=FALSE;
    debug     := FALSE;
    stateuniq := norefyet;
    dupcount  := 0;
    chkrounds := 0;
    autonum        := DEFAUTONUM; (* 0 i.e. no renum *)
    autofieldwidth := DEFFIELD;
    autodelta      := DEFDELTA;
    tabwi          := DEFTABWIDTH;

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            (* bo *)
            opt := GetOptIndex(R,"?"+delim+"H"+delim+"HELP"+delim+
                                 "A"+delim+"APPEND"+delim+
                                 "P"+delim+"PREPEND"+delim+
                                 "T"+delim+"TRIM"+delim+
                                 "F"+delim+"FORCE"+delim+
                                 "D"+delim+"DELETE"+delim+
                                 "E"+delim+"EXACT"+delim+
                                 "R"+delim+"REMOVE"+delim+
                                 "C:"+delim+"COLUMN:"+delim+
                                 "K"+delim+"KEEP"+delim+
                                 "DF"+delim+"DELETEFIRST"+delim+
                                 "DL"+delim+"DELETELAST"+delim+
                                 "VF"+delim+"VIEWFIRST"+delim+
                                 "VL"+delim+"VIEWLAST"+delim+
                                 "V"+delim+"VIEW"+delim+"SHOW"+delim+
                                 "Q"+delim+"QUIET"+delim+
                                 "VV"+delim+"VIEWGREP"+delim+"GREP"+delim+
                                 "L"+delim+"LINE"+delim+
                                 "U"+delim+"UNIQUE"+delim+
                                 "I:"+delim+"IGNORE:"+delim+
                                 "Z"+delim+
                                 "Y"+delim+"STRICT"+delim+
                                 "UU"+delim+
                                 "I"+delim+"INSERT"+delim+
                                 "C"+delim+"CHANGE"+delim+"REPLACE"+delim+
                                 "O:"+delim+"ONLY:"+delim+
                                 "B:"+delim+"BASELINE:"+delim+
                                 "M"+delim+"MERGE"+delim+
                                 "TAB"+delim+
                                 "??"+delim+

                                 "J"+delim+"JOKER"+delim+
                                 "JS"+delim+"SOL"+delim+"STARTOFLINE"+delim+
                                 "JE"+delim+"EOL"+delim+"ENDOFLINE"+delim+
                                 "JJ"+delim+
                                 "ZZ"+delim+
                                 "KJ"+delim+
                                 "DJ"+delim+
                                 "VJ"+delim+
                                 "KJJ"+delim+
                                 "DJJ"+delim+
                                 "VJJ"+delim+
                                 "N:"+delim+"AUTONUM:"+delim+
                                 "F:"+delim+"FIELD:"+delim+
                                 "K:"+delim+"DELTA:"+delim+
                                 "X"+delim+"LFN"+delim+
                                 "S"+delim+"RECURSE"+delim+"SUBDIRS"+delim+"SUB"+delim+
                                 "!"+delim+"JOKERS"+delim+"OS"+delim+
                                 "W"+delim+"ESC"+delim+"WINQUIRK"+delim+

                                 "-"+delim+"INVERSE"+delim+
                                 "--"+delim+"DUPLINES"+delim+

                                 "U-"+delim+
                                 "U--"+delim+
                                 "UU-"+delim+
                                 "UU--"+delim+

                                 "N"+delim+"REINJECT"+delim+
                                 "G"+delim+"UNTAB"+delim+"EXPAND"+delim+
                                 "G:"+delim+"UNTAB:"+delim+"EXPAND:"+delim+
                                 (*
                                 "V-"+delim+"VIEW-"+delim+"SHOW-"+delim+
                                 "VV-"+delim+"VIEWGREP-"+delim+"GREP-"+delim+
                                 "VJ-"+delim+
                                 "VJJ-"+delim+
                                 *)
                                 "DEBUG"
                              );
            CASE opt OF
            | 1,2,3 :   abort(errHelp,"");
            | 4,5 :     newcmd(cmd,append);
            | 6,7 :     newcmd(cmd,prepend);
            | 8,9 :     trim := TRUE;
            | 10,11:    all := TRUE;
            | 12,13:    newcmd(cmd,delete);
            | 14,15:    exact := TRUE;
            | 16,17:    newcmd(cmd,remove);
            | 18,19:    IF GetLongCard(R,lc)=FALSE THEN abort(errBadColumn,S);END;
                        IF ( (lc < 1) OR (lc > SIZE(str4096)) ) THEN abort(errBadColumn,S);END;
                        column:=CARDINAL(lc);
            | 20,21:    newcmd(cmd,keep);
            | 22,23:    newcmd(cmd,delfirst);
            | 24,25:    newcmd(cmd,dellast);
            | 26,27:    newcmd(cmd,viewfirst);
            | 28,29:    newcmd(cmd,viewlast);
            | 30,31,32: newcmd(cmd,viewmatch);
            | 33,34:    quiet:=TRUE;
            | 35,36,37: newcmd(cmd,viewgrep);
            | 38,39:    showline:=TRUE;
            | 40,41:    newcmd(cmd,uniq);
            | 42,43:    rc:=parseRange (firstcol,countcol,range,  rangeignore,R);
                        IF rc # errNone THEN abort(rc,S);END;
            | 44:       skipempty:=TRUE;
            | 45,46:    strict:=TRUE;
            | 47:       newcmd(cmd,uniq);
                        strict:=TRUE;
            | 48,49:    newcmd(cmd,insert);
            | 50,51,52: newcmd(cmd,replace);
            | 53,54:    rc:=parseRange (firstcol,countcol,range,  rangeonly,R);
                        IF rc # errNone THEN abort(rc,S);END;
            | 55,56:    IF GetLongCard(R,lc)=FALSE THEN abort(errBadBaseLine,S);END;
                        IF ( (lc < 1) OR (lc > MAX(LONGCARD) )) THEN abort(errBadBaseLine,S);END;
                        baseline:=lc;
            | 57,58:    newcmd(cmd,merge);
            | 59:       tabsep := TRUE;
            | 60:       abort(errHelper,"");

            | 61,62:    jokermode:=TRUE;
            | 63,64,65: jokerprepend:=FALSE;
            | 66,67,68: jokerappend :=FALSE;
            | 69:       jokermode:=TRUE; jokerprepend:=FALSE; jokerappend :=FALSE;
            | 70:       skipempty:=TRUE; (* same as -z *)
                        showmatchline:=FALSE;
            | 71:       newcmd(cmd,keep);
                        jokermode:=TRUE;
            | 72:       newcmd(cmd,delete);
                        jokermode:=TRUE;
            | 73:       newcmd(cmd,viewmatch);
                        jokermode:=TRUE;
            | 74:       newcmd(cmd,keep);
                        jokermode:=TRUE; jokerprepend:=FALSE; jokerappend :=FALSE;
            | 75:       newcmd(cmd,delete);
                        jokermode:=TRUE; jokerprepend:=FALSE; jokerappend :=FALSE;
            | 76:       newcmd(cmd,viewmatch);
                        jokermode:=TRUE; jokerprepend:=FALSE; jokerappend :=FALSE;
            | 77,78:    IF GetLongCard(R,lc)=FALSE THEN abort(errBadNumSuffix,S);END;
                        IF chkRange(lc,MINDELTA,MAXDELTA)=FALSE THEN abort(errBadRange,S);END;
                        autonum:=lc;
            | 79,80:    IF GetLongCard(R,lc)=FALSE THEN abort(errBadFieldWidth,S);END;
                        IF chkRange(lc,MINFIELD,MAXFIELD)=FALSE THEN abort(errBadRange,S);END;
                        autofieldwidth:=CARDINAL(lc);
            | 81,82:    IF GetLongCard(R,lc)=FALSE THEN abort(errBadIncrement,S);END;
                        IF chkRange(lc,MINDELTA,MAXDELTA)=FALSE THEN abort(errBadRange,S);END;
                        autodelta:=lc;
            | 83,84:    useLFN:=FALSE;
            | 85,86,87,88: recurse:=TRUE;
            | 89,90,91: osjokers:=TRUE;
            | 92,93,94: ignoreEsc:=TRUE;

            | 95,96:    inverse:=TRUE;
            | 97,98:    inverse:=TRUE;  emuDuplines:=TRUE;

            | 99:       newcmd(cmd,uniq);
                        inverse:=TRUE;
            |100:       newcmd(cmd,uniq);
                        inverse:=TRUE;  emuDuplines:=TRUE;
            |101:       newcmd(cmd,uniq);
                        strict:=TRUE;
                        inverse:=TRUE;
            |102:       newcmd(cmd,uniq);
                        strict:=TRUE;
                        inverse:=TRUE;  emuDuplines:=TRUE;

            |103,104:   newcmd(cmd,reinject);
            |105,106,107: newcmd(cmd,untab);
            |108,109,110: newcmd(cmd,untab);
                        IF GetLongCard(R,lc)=FALSE THEN abort(errBadTabWidth,S);END;
                        IF ( (lc < MINTABWIDTH) OR (lc > MAXTABWIDTH) ) THEN abort(errBadTabWidth,S);END;
                        tabwi:=CARDINAL(lc);
            |111:       debug:=TRUE;
            ELSE
                abort(errUnknownOption,S);
            END;
        ELSE
            (* 1=text,2=filespec or 1=text,2=newtext,3=filespec or 1=filespec *)
            INC(lastparm); IF lastparm > maxparm THEN abort(errParmOverflow,S);END;
            Str.Copy(parm[lastparm],S);
        END;
    END;
    IF cmd=nothing THEN abort(errExpected,"command");END;

    CASE lastparm OF
    | firstparm-1 : (* complicated way to specify 0 i.e. no parms ! *)
        CASE cmd OF
        | uniq,untab:                          S:="<file(s)>";
        | merge,reinject:                      S:="<datafile>";
        | delfirst,dellast,viewfirst,viewlast: S:="<count>";
        | replace:                             S:="<oldtext>";
        ELSE
                                               S:="<text>";
        END;
        abort(errExpected,S);
    | firstparm :   (* one parm *)
        CASE cmd OF
        | uniq,untab :          Str.Copy(orgspec,parm[firstparm]);
        | replace:              abort(errExpected,"<newtext>");
        | reinject:             abort(errExpected,"<file>");
        ELSE
                                abort(errExpected,"<file(s)>");
        END;
    | firstparm+1 : (* two parms *)
        CASE cmd OF
        | uniq,untab:           abort(errParmOverflow,parm[firstparm+1]);
        | replace :             abort(errExpected,"<file(s)>");
        | merge,reinject:
                                Str.Copy(datafile ,parm[firstparm]);
                                Str.Copy(orgspec  ,parm[firstparm+1]);
        ELSE
                                Str.Copy(text     ,parm[firstparm]);
                                Str.Copy(orgspec  ,parm[firstparm+1]);
        END;
    | firstparm+2 : (* three parms *)
        CASE cmd OF
        | replace :
                                Str.Copy(text     ,parm[firstparm]);
                                Str.Copy(newtext  ,parm[firstparm+1]);
                                Str.Copy(orgspec  ,parm[firstparm+2]);
        ELSE
                                abort(errParmOverflow,parm[firstparm+2]);
        END;
    END;

    (* very, very important ! keep accents too ! *)

    UpperCaseAlt(orgspec);
    UpperCaseAlt(datafile);

    CASE cmd OF
    | viewmatch,viewgrep,viewfirst,viewlast:
        ;
    ELSE
        IF showline THEN abort(errNonsense,"-line");END;
    END;

    CASE cmd OF
    | viewmatch,viewgrep :
        ;
    ELSE
        IF NOT(showmatchline) THEN abort(errNonsense,"-zz");END;
        IF skipempty THEN abort(errNonsense,"-z");END;
    END;

    CASE cmd OF
    | uniq:
        ;
    ELSE
        IF strict THEN abort(errNonsense,"-strict|-y");END;
    END;

    CASE cmd OF
    | delete,keep,viewmatch,viewgrep:
        IF jokermode THEN
            IF exact THEN abort(errNonsenseMatch,"-exact");END; (* Str.Match is case-insensitive ! *)
            IF column # DEFAULT THEN abort(errNonsenseMatch,"-column:#");END;
            IF jokerprepend THEN Str.Prepend(text,"*");END;
            IF jokerappend  THEN Str.Append (text,"*");END;
        END;
    ELSE
        IF jokermode THEN abort(errNonsense,"-joker");END;
    END;

    CASE cmd OF
    | append,prepend:
        IF range # norange THEN abort(errNonsense,"-ignore:#,#");END;
        IF exact THEN abort(errNonsense,"-exact");END;
        IF column # DEFAULT THEN abort(errNonsense,"-column:#");END;
        IF baseline # 0 THEN abort(errNonsense,"-line:#");END;
        IF tabsep THEN abort(errNonsense,"-tab");END;
        IF autonum # DEFAUTONUM THEN
            IF cmd=prepend THEN abort(errNonsense,"-n:#");END;
        END;
        IF inverse THEN abort(errNonsense,"-inverse");END;
    | remove,delete,keep,replace:
        IF range # norange THEN abort(errNonsense,"-ignore:#,#");END;
        IF trim THEN abort(errNonsense,"-trim");END;
        IF all THEN abort(errNonsense,"-force");END;
        IF NOT(exact) THEN UpperCase(text);END;
        IF baseline # 0 THEN abort(errNonsense,"-line:#");END;
        IF tabsep THEN abort(errNonsense,"-tab");END;
        IF autonum # DEFAUTONUM THEN abort(errNonsense,"-n:#");END;
        IF inverse THEN abort(errNonsense,"-inverse");END;
    | viewmatch,viewgrep:
        IF range # norange THEN abort(errNonsense,"-ignore:#,#");END;
        IF all THEN abort(errNonsense,"-force");END;
        IF NOT(exact) THEN UpperCase(text);END;
        IF baseline # 0 THEN abort(errNonsense,"-line:#");END;
        IF tabsep THEN abort(errNonsense,"-tab");END;
        IF autonum # DEFAUTONUM THEN abort(errNonsense,"-n:#");END;
    | delfirst,dellast,viewfirst,viewlast:
        IF range # norange THEN abort(errNonsense,"-ignore:#,#");END;
        IF exact THEN abort(errNonsense,"-exact");END;
        IF trim THEN abort(errNonsense,"-trim");END;
        IF all THEN abort(errNonsense,"-force");END;
        IF column # DEFAULT THEN abort(errNonsense,"-column:#");END;
        IF same(text,sALLLINES) THEN
            lc:=MAXPROCESSEDLINES; (* was max(cardinal) thus preventing huge processing *)
        ELSE
            IF GetLongCard(text,lc)=FALSE THEN abort(errBadCount,text);END;
        END;
        IF ( (lc < 1) OR (lc > MAXPROCESSEDLINES) ) THEN abort(errBadCount,text);END;
        linecount:=lc;
        IF tabsep THEN abort(errNonsense,"-tab");END;
        IF autonum # DEFAUTONUM THEN abort(errNonsense,"-n:#");END;
        IF inverse THEN abort(errNonsense,"-inverse");END;
    | uniq:
        IF column # DEFAULT THEN abort(errNonsense,"-column:#");END;
        IF trim THEN abort(errNonsense,"-trim");END;
        IF all THEN abort(errNonsense,"-force");END;
        IF baseline # 0 THEN abort(errNonsense,"-line:#");END;
        IF tabsep THEN abort(errNonsense,"-tab");END;
        IF autonum # DEFAUTONUM THEN abort(errNonsense,"-n:#");END;
        (* IF inverse THEN abort(errNonsense,"-inverse");END; *)
    | insert:
        IF range # norange THEN abort(errNonsense,"-ignore:#,#");END;
        IF exact THEN abort(errNonsense,"-exact");END;
        IF trim THEN abort(errNonsense,"-trim");END;
        IF column = DEFAULT THEN abort(errExpected,"<-column:#>");END;
        IF baseline # 0 THEN abort(errNonsense,"-line:#");END;
        IF tabsep THEN abort(errNonsense,"-tab");END;
        IF autonum # DEFAUTONUM THEN abort(errNonsense,"-n:#");END;
        IF inverse THEN abort(errNonsense,"-inverse");END;
    | merge:
        IF range # norange THEN abort(errNonsense,"-ignore:#,#");END;
        IF exact THEN abort(errNonsense,"-exact");END;
        IF all THEN abort(errNonsense,"-force");END;
        IF baseline # 0 THEN abort(errNonsense,"-line:#");END;
        IF autonum # DEFAUTONUM THEN abort(errNonsense,"-n:#");END;
        IF inverse THEN abort(errNonsense,"-inverse");END;
    | untab,reinject: (* any option is a nonsense here *)
        IF range # norange THEN abort(errNonsense,"-ignore:#,#");END;
        IF exact THEN abort(errNonsense,"-exact");END;
        IF column # DEFAULT THEN abort(errNonsense,"-column:#");END;
        IF baseline # 0 THEN abort(errNonsense,"-line:#");END;
        IF tabsep THEN abort(errNonsense,"-tab");END;
        IF autonum # DEFAUTONUM THEN abort(errNonsense,"-n:#");END;
        IF inverse THEN abort(errNonsense,"-inverse");END;
        IF trim THEN abort(errNonsense,"-trim");END;
        IF all THEN abort(errNonsense,"-force");END;
        IF recurse THEN
            IF cmd=reinject THEN abort(errNonsense,"-recurse");END;
        END;
    END;

    CASE cmd OF
    | viewlast,dellast:
        IF baseline # 0 THEN abort(errNonsense,"-b:#");END;
    END;

    (* setup *)

    CASE cmd OF
    | viewfirst,viewlast,viewmatch,viewgrep:
        onlyshow:=TRUE;
    ELSE
        onlyshow:=FALSE;
    END;

    CASE cmd OF
    | delfirst,dellast,viewfirst,viewlast:
        ;
    | uniq:
        IF debug THEN
            (* 1-based for user *)
            WrStr("First column : ");WrCard(firstcol+1,5);WrLn;
            WrStr("Last column  : ");WrCard( (firstcol+countcol-1)+1,5);WrLn;
            WrStr("Count        : ");WrCard(countcol,5);WrLn;
        END;
    | replace :
        Str.Copy(textcli,text);
        IF metaproc(text)=FALSE THEN abort(errBadMeta,text);END;
        Str.Copy(newtextcli,newtext);
        IF metaproc(newtext)=FALSE THEN abort(errBadMeta,newtext);END;
        IF debug THEN
            WrStr("Raw old text    : ");WrStr(textcli);WrLn;
            WrStr("Cooked old text : ");WrStr(text);WrLn;
            WrStr("Raw new text    : ");WrStr(newtextcli);WrLn;
            WrStr("Cooked new text : ");WrStr(text);WrLn;
            WrLn;
        END;
        Str.Copy(textCAPS,text);
        UpperCase(textCAPS);
        Str.Copy(newtextCAPS,newtext);
        UpperCase(newtextCAPS);
    | merge,reinject:
        IF chkJoker(datafile) THEN abort(errJoker,datafile);END;
        IF legalextension(datafile,skippedextensions)=FALSE THEN abort(errNoMatch,datafile);END;
        IF fileExists(useLFN,datafile)=FALSE THEN abort(errNoMatch,datafile);END;
        IF cmd=reinject THEN
            IF chkJoker(orgspec) THEN abort(errJoker,orgspec);END;
        END;
    | untab:
        IF debug THEN
            WrStr("Tab width       : ");WrCard(tabwi,5);WrLn;
        END;
    ELSE
        Str.Copy(textcli,text);
        IF metaproc(text)=FALSE THEN abort(errBadMeta,text);END;
        IF debug THEN
            IF jokermode THEN
                WrStr("Pattern search mode is enabled.");WrLn;
                WrLn;
            END;
            WrStr("Raw text    : ");WrStr(textcli);WrLn;
            WrStr("Cooked text : ");WrStr(text);WrLn;
            WrLn;
        END;
        Str.Copy(textCAPS,text);
        UpperCase(textCAPS);
    END;

    CASE cmd OF
    | delfirst,dellast:
        IF baseline # 0 THEN cmd:=delrange; lastbaseline:=baseline+linecount-1;END;
    | viewfirst,viewlast:
        IF baseline # 0 THEN cmd:=viewrange;lastbaseline:=baseline+linecount-1;END;
    END;

    (* let's work now *)

    useLFN := ( useLFN AND w9XsupportLFN() );

    getAnchor(useLFN, currdrive,currdir, currpath); (* u, "\*\", "u:\*\" *)
    getAllLegalUnits(TRUE,TRUE,TRUE,sLegalUnits); (* floppy,hd,CDROM *)

    rc:= chkfixSpec( specbase,spec, useLFN,orgspec,sLegalUnits );
    IF rc # errNone THEN abort(rc,orgspec);END;
    IF legalextension (spec,skippedextensions)=FALSE THEN abort(errBadExt,"");END;

    showmem(debug,"step 1");

    initList(diranchor); (* global *)
    lastdir            := firstindex-1; (* we can't init count in recursive buildDirList() *)
    globallastfile     := firstindex-1;

    video(msgWait,TRUE);
    rc:= buildDirList (lastdir, diranchor,  useLFN,recurse, specbase);
    video(msgWait,FALSE);
    IF rc # errNone THEN abort(rc, orgspec); END;
    IF debug THEN dmpDirs(diranchor,useLFN); END;
    (* first minimalist "no match" check *)
    IF lastdir < firstindex THEN abort(errNoMatch,orgspec);END;

    showmem(debug,"step 2");

    initReinject(anchorReinject);
    IF cmd=reinject THEN
        IF grabReinject(anchorReinject,debug,useLFN,datafile)=FALSE THEN abort(errStorage,datafile);END;
    END;

    showmem(debug,"step 3");

    pdir:=findByIndex(firstindex,diranchor); (* we know we've got at least one dir now *)
    getStr(rootspec,pdir);

    dirindex:=firstindex;
    LOOP
        IF dirindex > lastdir THEN EXIT; END;
        pdir:=findByIndex(dirindex,diranchor);
        getStr(basepath,pdir);

        rc:= storeFiles (globallastfile,lastfile, fileanchor,
                        useLFN,osjokers, basepath,spec, skippedextensions);
        IF rc # errNone THEN abort(rc, orgspec); END;

        IF debug THEN dmpFiles(fileanchor,diranchor,dirindex,useLFN); END;

        fileindex:=firstindex;
        LOOP
            IF fileindex > lastfile THEN EXIT; END;
            pf := findByIndex(fileindex,fileanchor);

            getStr(file,pf);
            Str.Prepend(file,basepath);

            p := Str.RCharPos(file,dot);
            IF p = MAX(CARDINAL) THEN
                Str.Concat(backup,file,extBAK);
            ELSE
                Str.Slice(backup,file,0,p);
                Str.Append(backup,extBAK);
            END;

            nameshown:=FALSE; (* default for all *)
            bigcount:=linecount;

            IF onlyshow THEN
                hin :=fileOpenRead(useLFN,file);
                FIO.AssignBuffer(hin,bufferIn);
            ELSE
                IF fileExists(useLFN,backup) THEN fileSetRW(useLFN,backup);fileErase(useLFN,backup); END;
                fileRename(useLFN,file,backup);

                video(file,TRUE);
                video(msgProcessing,TRUE);

                (* Work(cmdInit); *)

                steps := 10;
                fsize := fileGetFileSize(useLFN,backup);
                portion:=fsize DIV LONGCARD(steps); INC(portion); (* avoid DIV 0 ! *)
                lastportion := LONGCARD(steps+1);

                animInit(steps, "[", "]", ".", "", "\/" );

                hin :=fileOpenRead(useLFN,backup);
                FIO.AssignBuffer(hin,bufferIn);
                hout:=fileCreate(useLFN,file);
                FIO.AssignBuffer(hout,bufferOut);
                IF cmd=merge THEN
                    hindata :=fileOpenRead(useLFN,datafile);
                    FIO.AssignBuffer(hindata,bufferInData);
                END;
            END;
            CASE cmd OF
            | dellast,viewlast:
                FIO.EOF:=FALSE;
                bigtotal:=0;
                LOOP
                    IF FIO.EOF THEN EXIT; END;
                    FIO.RdStr(hin,hugestring);
                    IF FIO.EOF THEN EXIT; END;
                    INC(bigtotal);
                END;
                FIO.Seek(hin,0); (* reset *)
                IF bigtotal < bigcount THEN
                    orgbigcount := bigtotal;
                    bigcount    := 0;
                ELSE
                    orgbigcount := bigcount;
                    bigcount    := bigtotal-bigcount;
                END;
            | uniq:
                oldhuge   :="";
                oldhugeorg:="";
            END;

            userAborted := FALSE;

            FIO.EOF:=FALSE;

            total     := 0;
            processed := 0;
            matchinglines:=0;
            notmatchinglines:=0;

            LOOP
                IF FIO.EOF THEN EXIT; END;
                FIO.RdStr(hin,hugestring);
                IF FIO.EOF THEN EXIT; END;

                INC(total);

                IF onlyshow=FALSE THEN
                    (* Work(cmdShow); *)

                    anim(animShow);
                    currportion:=FIO.GetPos(hin) DIV portion;
                    IF currportion # lastportion THEN
                        anim(animAdvance);
                        lastportion:=currportion;
                    END;
                END;
                CASE cmd OF
                | append,prepend:
                    Str.Copy(hugetrimed,hugestring);
                    LtrimBlanks(hugetrimed);
                    RtrimBlanks(hugetrimed);
                    IF (all OR (hugetrimed[0] # CHR(0))) THEN
                        CASE cmd OF
                        | append:
                            IF trim THEN RtrimBlanks(hugestring);END;
                            Str.Append(hugestring,text);
                            IF autonum # DEFAUTONUM THEN
                                Str.Append(hugestring, padnum(autonum,autofieldwidth));
                                INC(autonum,autodelta);
                            END;
                        | prepend:
                            IF trim THEN LtrimBlanks(hugestring);END;
                            Str.Prepend(hugestring,text);
                        END;
                        INC(processed);
                    END;
                    FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                | remove:
                    IF column = DEFAULT THEN
                        colpos:=0;
                    ELSE
                        colpos:=column-1;
                    END;
                    count:=0;
                    LOOP
                        IF exact THEN
                            p:=Str.NextPos(hugestring,text,colpos);
                        ELSE
                            Str.Copy(hugetrimed,hugestring);
                            UpperCase(hugetrimed);
                            p:=Str.NextPos(hugetrimed,textCAPS,colpos);
                        END;
                        IF p = MAX(CARDINAL) THEN EXIT;END;
                        IF column # DEFAULT THEN
                            IF p # (column-1) THEN EXIT; END;
                            Str.Delete(hugestring,p,Str.Length(text));
                            INC(count);
                            EXIT; (* there can be only one... removal ! *)
                        ELSE
                            Str.Delete(hugestring,p,Str.Length(text));
                            INC(count);
                        END;
                    END;
                    IF count # 0 THEN INC(processed);END; (* lines, not replacements *)
                    FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                | delete,keep:
                    found:= isMatch (jokermode,exact,column,hugestring,text,textCAPS);
                    CASE cmd OF
                    | delete:
                        IF found THEN
                            INC(processed);
                        ELSE
                            FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                        END;
                    | keep:
                        IF found THEN
                            FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                            INC(processed);
                        END;
                    END;
                | viewmatch,viewgrep:
                    found:= isMatch (jokermode,exact,column,hugestring,text,textCAPS);
                    IF found THEN
                        INC(matchinglines);
                    ELSE
                        INC(notmatchinglines);
                    END;
                    IF inverse THEN
                        showme:=NOT(found);
                    ELSE
                        showme:=found;
                    END;
                    IF showme THEN (* was using found boolean *)
                        IF nameshown=FALSE THEN

                            (* fix (logical) quirk "-v -zz --" *)
                            showfilename:=TRUE;
                            IF inverse THEN
                                IF NOT(showmatchline) THEN
                                    showfilename:= FALSE;
                                END;
                            END;

                            IF showfilename THEN
                                WrStr(strFile);WrStr(file);WrLn;
                                nameshown:=TRUE;
                            END;
                        END;
                        IF showmatchline THEN
                            whatline(showline, TRUE ,total);
                            IF trim THEN
                                Str.Copy(hugetrimed,hugestring);
                                LtrimBlanks(hugetrimed);
                                RtrimBlanks(hugetrimed);
                                WrStr(hugetrimed);
                            ELSE
                                WrStr(hugestring);
                            END;
                            whatline(showline, FALSE,total);
                            WrLn;
                        END;
                        INC(processed);
                    END;
                    userAborted:=pollEscape(chkrounds,useLFN,ignoreEsc);
                | delfirst:
                    IF total > bigcount THEN
                        FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                    ELSE
                        INC(processed);
                    END;
                | viewfirst:
                    IF total > bigcount THEN
                        ; (* EXIT would be prettier but we would not have grand total of lines *)
                    ELSE
                        IF nameshown=FALSE THEN
                            WrStr(strFile);WrStr(file);WrLn;
                            nameshown:=TRUE;
                        END;
                        whatline(showline, TRUE ,total);
                        WrStr(hugestring);
                        whatline(showline, FALSE,total);
                        WrLn;
                        INC(processed);
                    END;
                    userAborted:=pollEscape(chkrounds,useLFN,ignoreEsc);
                | dellast:
                    IF total > bigcount THEN
                        EXIT;
                    ELSE
                        FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                    END;
                | viewlast:
                    IF total > bigcount THEN
                        IF nameshown=FALSE THEN
                            WrStr(strFile);WrStr(file);WrLn;
                            nameshown:=TRUE;
                        END;
                        whatline(showline, TRUE ,total);
                        WrStr(hugestring);
                        whatline(showline, FALSE,total);
                        WrLn;
                        (* INC(processed); *)
                    END;
                    userAborted:=pollEscape(chkrounds,useLFN,ignoreEsc);
                | delrange:
                    IF ((total < baseline) OR (total > lastbaseline)) THEN
                        FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                    ELSE
                        INC(processed);
                    END;

                | viewrange:
                    IF ((total >= baseline) AND (total <= lastbaseline)) THEN
                        IF nameshown=FALSE THEN
                            WrStr(strFile);WrStr(file);WrLn;
                            nameshown:=TRUE;
                        END;
                        whatline(showline, TRUE ,total);
                        WrStr(hugestring);
                        whatline(showline, FALSE,total);
                        WrLn;
                        INC(processed);
                    END;
                    userAborted:=pollEscape(chkrounds,useLFN,ignoreEsc);
                | uniq:
                    Str.Copy(newhuge,hugestring);
                    CASE range OF
                    | rangeignore : Str.Delete(newhuge,firstcol,countcol);
                    | rangeonly   : Str.Slice(tmphuge, newhuge, firstcol,countcol);
                                    Str.Copy(newhuge,tmphuge);
                    END;
                    IF NOT(exact) THEN UpperCase(newhuge);END;
                    CASE stateuniq OF
                    | norefyet:
                        Str.Copy(oldhuge,newhuge);
                        Str.Copy(oldhugeorg,hugestring);
                        stateuniq:=refnow;
                        dupcount:=0;
                    | refnow:
                        IF same(newhuge,oldhuge) THEN
                            INC(dupcount);
                            IF inverse THEN
                                IF emuDuplines THEN
                                    IF dupcount = 1 THEN
                                        FIO.WrStr(hout,emudupfirst);
                                    ELSE
                                        FIO.WrStr(hout,emudup);
                                    END;
                                END;
                                FIO.WrStr(hout,oldhugeorg); FIO.WrLn(hout);
                                INC(processed);
                                Str.Copy(oldhuge,newhuge);
                                Str.Copy(oldhugeorg,hugestring);
                            END;
                            IF debug THEN WrStr("--- ");WrStr(newhuge);WrLn;END;
                        ELSE
                            IF inverse THEN
                                showme:=  (dupcount # 0) ;
                            ELSE
                                showme:= ((dupcount = 0) OR (strict=FALSE));
                            END;
                            IF showme THEN
                                IF emuDuplines THEN FIO.WrStr(hout,emudup);END;
                                FIO.WrStr(hout,oldhugeorg); FIO.WrLn(hout);
                                INC(processed);
                            END;
                            Str.Copy(oldhuge,newhuge);
                            Str.Copy(oldhugeorg,hugestring);
                            dupcount:=0;
                        END;
                    END;
                | insert : (* all *)
                    Str.Copy(hugetrimed,hugestring);
                    LtrimBlanks(hugetrimed);
                    RtrimBlanks(hugetrimed);
                    IF ( all OR (hugetrimed[0] # CHR(0)) ) THEN
                        len:=Str.Length(hugestring);
                        IF len < column THEN
                            LOOP
                                INC(len);
                                IF NOT(len < column) THEN EXIT; END;
                                Str.Append(hugestring," ");
                            END;
                        END;
                        Str.Insert(hugestring,text,column-1);
                        INC(processed);
                    END;
                    FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                | replace: (* column exact *)
                    IF column = DEFAULT THEN
                        colpos:=0;
                    ELSE
                        colpos:=column-1;
                    END;
                    len:=Str.Length(text);
                    count:=0;
                    LOOP
                        IF exact THEN
                            p:=Str.NextPos(hugestring,text,colpos);
                        ELSE
                            Str.Copy(hugetrimed,hugestring);
                            UpperCase(hugetrimed);
                            p:=Str.NextPos(hugetrimed,textCAPS,colpos);
                        END;
                        IF p = MAX(CARDINAL) THEN EXIT;END;
                        IF column # DEFAULT THEN
                            IF p # (column-1) THEN EXIT; END;
                            Str.Delete(hugestring,p,len);
                            Str.Insert(hugestring,newtext,p);
                            INC(count);
                            EXIT; (* there can be only one... removal ! *)
                        ELSE
                            Str.Delete(hugestring,p,len);
                            Str.Insert(hugestring,newtext,p);
                            INC(colpos,len);
                            INC(count);
                        END;
                    END;
                    IF count # 0 THEN INC(processed);END; (* lines, not replacements *)
                    FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                | merge:
                    keepEOF:=FIO.EOF;
                    FIO.RdStr(hindata,hugetrimed);
                    FIO.EOF:=keepEOF;
                    IF trim THEN
                        LtrimBlanks(hugestring);
                        RtrimBlanks(hugestring);
                        LtrimBlanks(hugetrimed);
                        RtrimBlanks(hugetrimed);
                    END;
                    IF column # DEFAULT THEN
                        len:= Str.Length(hugestring);
                        IF len < column THEN
                            FOR ii:=(len+1+1) TO column DO
                                Str.Append(hugestring,space);
                            END;
                        END;
                    END;
                    IF tabsep THEN
                        Str.Append(hugestring,tabchar);
                    ELSE
                        Str.Append(hugestring,space);
                    END;
                    Str.Append(hugestring,hugetrimed);
                    FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                    INC(processed);
                | untab:
                    Str.Copy(hugetrimed,hugestring);
                    untabme(hugestring,tabwi,hugetrimed);
                    FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                    INC(processed);
                | reinject:
                    IF procReinjectMe(anchorReinject,total,hugestring) THEN
                        INC(processed);
                    END;
                    FIO.WrStr(hout,hugestring); FIO.WrLn(hout);
                END;
                IF userAborted THEN EXIT; END;
            END;

            CASE cmd OF
            | viewmatch,viewgrep: (* adapted inner loop code *)
                IF nameshown=FALSE THEN

                    (* fix (logical) quirk "-v -zz --" *)
                    showfilename:=FALSE;
                    IF inverse THEN
                        IF NOT(showmatchline) THEN
                            showfilename:= (matchinglines=0);
                        END;
                    END;

                    IF showfilename THEN
                        WrStr(strFile);WrStr(file);WrLn;
                        nameshown:=TRUE;
                    END;
                END;
            | uniq: (* mere copy/paste of inner loop code *)
                    Str.Copy(newhuge,hugestring);
                    CASE range OF
                    | rangeignore : Str.Delete(newhuge,firstcol,countcol);
                    | rangeonly   : Str.Slice(tmphuge, newhuge, firstcol,countcol);
                                    Str.Copy(newhuge,tmphuge);
                    END;
                    IF NOT(exact) THEN UpperCase(newhuge);END;
                    CASE stateuniq OF
                    | norefyet:
                        Str.Copy(oldhuge,newhuge);
                        Str.Copy(oldhugeorg,hugestring);
                        stateuniq:=refnow;
                        dupcount:=0;
                    | refnow:
                        IF same(newhuge,oldhuge) THEN
                            INC(dupcount);
                            IF inverse THEN
                                IF emuDuplines THEN
                                    IF dupcount = 1 THEN
                                        FIO.WrStr(hout,emudupfirst);
                                    ELSE
                                        FIO.WrStr(hout,emudup);
                                    END;
                                END;
                                FIO.WrStr(hout,oldhugeorg);FIO.WrLn(hout);
                                INC(processed);
                                Str.Copy(oldhuge,newhuge);
                                Str.Copy(oldhugeorg,hugestring);
                            END;
                            IF debug THEN WrStr("--- ");WrStr(newhuge);WrLn;END;
                        ELSE
                            IF inverse THEN
                                showme:=  (dupcount # 0) ;
                            ELSE
                                showme:= ((dupcount = 0) OR (strict=FALSE));
                            END;
                            IF showme THEN
                                IF emuDuplines THEN FIO.WrStr(hout,emudup);END;
                                FIO.WrStr(hout,oldhugeorg); FIO.WrLn(hout);
                                INC(processed);
                            END;
                            Str.Copy(oldhuge,newhuge);
                            Str.Copy(oldhugeorg,hugestring);
                            dupcount:=0;
                        END;
                    END;

            END;

            IF onlyshow THEN
                FIO.Close(hin);
            ELSE
                FIO.Flush(hout);
                FIO.Close(hout);
                FIO.Close(hin);
                IF cmd=merge THEN FIO.Close(hindata); END;

                (* Work(cmdStop); *)
                anim(animEnd);anim(animClear);
                video(msgProcessing,FALSE);
                video(file,FALSE);
            END;

            IF userAborted THEN
                freeList(fileanchor);
                freeList(diranchor);
                abort(errUserAborted,"");
            END;

            CASE cmd OF
            | dellast,viewlast:
                processed := orgbigcount;
                total     := bigtotal;
            END;

            CASE cmd OF
            | viewgrep:
                dmp:=FALSE;
            | viewmatch:
                (* dmp:=NOT(skipempty); *)

                IF skipempty THEN (* -z or -zz *)
                    dmp:=showmatchline; (* was NOT() which was stupid ! *)
                ELSE
                    dmp:=TRUE;
                END;
            ELSE
                dmp:=TRUE;
            END;

            IF dmp AND NOT(quiet) THEN

                WrLngCard(processed,5);
                CASE cmd OF
                | uniq :
                    IF inverse THEN
                        WrStr(" duplicate");
                    ELSE
                        WrStr(" unique");
                    END;
                END;
                WrStr(" line(s)"); (* IF processed > 1 THEN WrStr("s");END; *)
                WrStr(" out of ");
                WrLngCard(total,5);

                WrStr(" ");
                CASE cmd OF
                | append,prepend,insert,replace,remove,merge : S:="modified";
                | delete,delfirst,dellast,delrange           : S:="deleted";
                | keep,uniq                                  : S:="kept";
                | viewmatch,viewgrep                         : S:="matched";
                | viewfirst,viewlast,viewrange               : S:="viewed";
                | untab                                      : S:="expanded";
                | reinject                                   : S:="reinjected";
                END;
                WrStr(S);
                CASE cmd OF
                | delfirst,viewfirst: WrStr(" from start");
                | dellast,viewlast:   WrStr(" from end");
                END;
                WrStr(" in ");
                IF useLFN THEN WrStr(doublequote);END;
                WrStr(file);
                IF useLFN THEN WrStr(doublequote);END;
                WrLn;
            END;

            INC(fileindex);
        END;

        freeList(fileanchor);
        INC(dirindex);
    END;
    freeList(diranchor);
    IF cmd=reinject THEN releaseReinject(anchorReinject);END;

    showmem(debug,"step 4");

    IF globallastfile=MAX(CARDINAL) THEN abort(errTooMany,orgspec);END; (* errStorage *)
    IF globallastfile < firstindex THEN abort(errNoMatch,orgspec); END;


    abort(errNone,"");
END NewLine.







(*
simple test file :

 1: a
 2: b
 3: b
 4: c
 5: d
 6: e
 7: e
 8: e
 9: f
10: g
11: g
12: h
13: h

*)

(*
::: PRESENT
foobar
here
foobar

::: ABSENT
foo
bar
foobar

::: TEST.BAT
@echo off

set f=old1.rpt

dt /f:" " "\n\ncommand is : -v\n" >  %f%
\bat\newline    -v        here *. >> %f%
dt /f:" " "\n\ncommand is : -v -z\n" >> %f%
\bat\newline    -v -z     here *. >> %f%
dt /f:" " "\n\ncommand is : -v -zz\n" >> %f%
\bat\newline    -v -zz    here *. >> %f%


set f=new1.rpt

dt /f:" " "\n\ncommand is : -v\n" >  %f%
\modula\newline -v        here *. >> %f%
dt /f:" " "\n\ncommand is : -v -z\n" >> %f%
\modula\newline -v -z     here *. >> %f%
dt /f:" " "\n\ncommand is : -v -zz\n" >> %f%
\modula\newline -v -zz    here *. >> %f%


set f=old2.rpt

dt /f:" " "\n\ncommand is : -v --\n" >  %f%
\bat\newline    -v     -- here *. >> %f%
dt /f:" " "\n\ncommand is : -v -z --\n" >> %f%
\bat\newline    -v -z  -- here *. >> %f%
dt /f:" " "\n\ncommand is : -v -zz --\n" >> %f%
\bat\newline    -v -zz -- here *. >> %f%

set f=new2.rpt

dt /f:" " "\n\ncommand is : -v --\n" >  %f%
\modula\newline -v     -- here *. >> %f%
dt /f:" " "\n\ncommand is : -v -z --\n" >> %f%
\modula\newline -v -z  -- here *. >> %f%
dt /f:" " "\n\ncommand is : -v -zz --\n" >> %f%
\modula\newline -v -zz -- here *. >> %f%

set f=

filecomp old1.rpt new1.rpt
filecomp old2.rpt new2.rpt

*)

