
(* ---------------------------------------------------------------
Title         Q&D Random Toolkit
Author        PhG
Overview
Notes
Bugs
Wish List

--------------------------------------------------------------- *)

IMPLEMENTATION MODULE QD_rand;

IMPORT Lib;

(* ------------------------------------------------------------ *)

CONST
    firstalea = 1;
    lastalea  = 128;
VAR
    pool : ARRAY [firstalea..lastalea] OF REAL;

(* ------------------------------------------------------------ *)

PROCEDURE InitRnd ();
VAR
    i : CARDINAL;
BEGIN
    Lib.RANDOMIZE;
    FOR i := firstalea TO lastalea DO
        pool[i] := Lib.RAND();
    END;
END InitRnd;

(* ------------------------------------------------------------ *)

(*
PROCEDURE GetRnd () : REAL;
VAR
    index:CARDINAL;
    lowerbound:REAL;
    upperbound:REAL;
    rnd:REAL;
BEGIN
    lowerbound:=REAL(firstalea);
    upperbound:=REAL(lastalea);
    rnd := (upperbound-lowerbound+1.0) * Lib.RAND() + lowerbound ;
    index := CARDINAL(rnd);
    rnd:=pool[index];
    pool[index]:=Lib.RAND();
    RETURN rnd;
END GetRnd;
*)

PROCEDURE GetRnd () : REAL;
VAR
    index:CARDINAL;
    rnd  :REAL;
BEGIN
    index := Lib.RANDOM(lastalea-firstalea+1); (* [0..128[ [0..127] *)
    rnd:=pool[firstalea+index];
    pool[firstalea+index]:=Lib.RAND();
    RETURN rnd;
END GetRnd;

(* ------------------------------------------------------------ *)

PROCEDURE GetRndCardRange (lowerlimit,upperlimit:CARDINAL) : CARDINAL;
VAR
    lowerbound:REAL;
    upperbound:REAL;
    rnd:REAL;
BEGIN
    lowerbound:=REAL(lowerlimit);
    upperbound:=REAL(upperlimit);
    rnd :=  (upperbound-lowerbound+1.0) * GetRnd()+ lowerbound ;
    RETURN CARDINAL(rnd);
END GetRndCardRange;

PROCEDURE GetRndLngCardRange (lowerlimit,upperlimit:LONGCARD) : LONGCARD;
VAR
    lowerbound:REAL;
    upperbound:REAL;
    rnd:REAL;
BEGIN
    lowerbound:=REAL(lowerlimit);
    upperbound:=REAL(upperlimit);
    rnd :=  (upperbound-lowerbound+1.0) * GetRnd()+ lowerbound ;
    RETURN LONGCARD(rnd);
END GetRndLngCardRange;

(* ------------------------------------------------------------ *)

(*
    eh, the formula does not work for reals ! try removing the -1.0
    maybe add an adjustement to upper limit, such as 0.0001 ?
*)

PROCEDURE GetRndLngRealRange (lowerlimit,upperlimit:LONGREAL) : LONGREAL;
VAR
    lowerbound:REAL;
    upperbound:REAL;
    rnd:REAL;
BEGIN
    lowerbound:=REAL(lowerlimit);
    upperbound:=REAL(upperlimit);
    rnd :=  (upperbound-lowerbound) * GetRnd()+ lowerbound ;
    RETURN LONGREAL(rnd);
END GetRndLngRealRange;

PROCEDURE GetRndRealRange (lowerbound,upperbound:REAL) : REAL;
VAR
    rnd:REAL;
BEGIN
    rnd :=  (upperbound-lowerbound) * GetRnd()+ lowerbound ;
    RETURN rnd;
END GetRndRealRange;

(* ------------------------------------------------------------ *)

BEGIN
    InitRnd();
END QD_rand.

(*

SHUFFLING

A simple way to greatly improve any random number generator is to
shuffle the output.  Start with an array of dimension around 100.  (The
exact size of array is not important.)  This is the array that will be
used to shuffle the output from the random number generator.
Initialize the array by filling it with random numbers from your random
number generator.  Then when the program wants a random number,
randomly choose one from the array and output it to the program.  Then
replace the number chosen in the array with a new random number from
the random number generator.

Note that this shuffling method uses two numbers from the random number
generator for each random number output to the calling program.  The
first random number is used to pick an element from the array of random
numbers, and the second random number is used to replace the number
chosen.

The improvement in randomness is quite dramatic.

*)


