
(* ---------------------------------------------------------------
Title         Q&D Zigzag demo
Author        PhG
Overview      tsk tsk...
Usage         see help
Notes         very, very, very quick & dirty... :-(
              minimal error messages and checking, etc.
              model should definitely be LARGE
              check if we leave private pause in spiro code instead of common main loop
Bugs          still problems in lower left corner : dots not erased !

Wish List     tsk tsk...

--------------------------------------------------------------- *)

MODULE ZigZag;

IMPORT Lib;
IMPORT SYSTEM;
IMPORT IO;
IMPORT Str;
IMPORT BiosIO;
IMPORT MATHLIB;
IMPORT MsMouse;

FROM IO IMPORT WrStr, WrLn;

FROM QD_Box IMPORT str80, str2, cmdInit, cmdShow, cmdStop, delim,
Work, video, Ltrim, Rtrim, UpperCase, LowerCase, ReplaceChar,
ChkEscape, Waitkey, WaitkeyDelay, Flushkey, IsRedirected, chkJoker,
isOption, GetOptIndex, GetLongCard, GetLongInt, GetString, CharCount,
same, aR, aH, aS, aD, aA, everything, isDirectory, fixDirectory,
str128, str256, Animation, allfiles, Belongs, FixAE, CodePhonetic,
CodeSoundex, CodeSoundexOrg, isReadOnly, LtrimBlanks, RtrimBlanks,
getStrIndex, cmdSHOW,BiosWaitkey,BiosWaitkeyShifted,BiosFlushkey,
str1024, isoleItemS, dmpTTX, str2048, Elapsed, TerminalReadString,
getDosVersion, DosVersion, warning95, runningWindows,
aV, reallyeverything, chkClassicTextMode, setClassicTextMode,
cleantabs;

FROM Lib IMPORT FarFill,FarWordMove;
FROM Storage IMPORT ALLOCATE;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

CONST
    cr         = CHR(13);
    lf         = CHR(10);
    nl         = cr+lf;
CONST
    escape     = 01B00H;
    space      = 02000H;
    keyCR      = 00D00H;
    keyTAB     = 00900H;
    keyTABshift= 0000FH;
    keyDivide  = ORD("/") << 8 ;
    upperR     = ORD("R") << 8 ;   lowerR     = ORD("r") << 8 ;
    upperG     = ORD("G") << 8 ;   lowerG     = ORD("g") << 8 ;
    upperB     = ORD("B") << 8 ;   lowerB     = ORD("b") << 8 ;
    upperD     = ORD("D") << 8 ;   lowerD     = ORD("d") << 8 ;
    upperN     = ORD("N") << 8 ;   lowerN     = ORD("n") << 8 ;
    upperI     = ORD("I") << 8 ;   lowerI     = ORD("i") << 8 ;
    upperC     = ORD("C") << 8 ;   lowerC     = ORD("c") << 8 ;
    upperL     = ORD("L") << 8 ;   lowerL     = ORD("l") << 8 ;
    upperS     = ORD("S") << 8 ;   lowerS     = ORD("s") << 8 ;
    upperO     = ORD("O") << 8 ;   lowerO     = ORD("o") << 8 ;
    upperX     = ORD("X") << 8 ;   lowerX     = ORD("x") << 8 ;
    upperP     = ORD("P") << 8 ;   lowerP     = ORD("p") << 8 ;
    upperF     = ORD("F") << 8 ;   lowerF     = ORD("f") << 8 ;
    upperT     = ORD("T") << 8 ;   lowerT     = ORD("t") << 8 ;
    upperQ     = ORD("Q") << 8 ;   lowerQ     = ORD("q") << 8 ;

    keyStar    = ORD("*") << 8 ;
    keyplus    = ORD("+") << 8 ;
    keyminus   = ORD("-") << 8 ;
    keydollar  = ORD("$") << 8 ;
    keyexclam  = ORD("!") << 8 ;
    keyequal   = ORD("=") << 8 ;
    key1       = ORD("1") << 8 ;
    key2       = ORD("2") << 8 ;
    key3       = ORD("3") << 8 ;
    key0       = ORD("0") << 8 ;
    keyF1      = 0003BH;
    keyF2      = 0003CH;
    keyF3      = 0003DH;
    keyF4      = 0003EH;
    keyF5      = 0003FH;
    keyF6      = 00040H;
    keyPgUp    = 00049H;
    keyPgDn    = 00051H;

    maxWaitInSeconds = 10;
TYPE
    palettetype = (redpal,greenpal,bluepal,rpal,gpal,bpal,
                   rainbowpal,randompal,rndpal,descentpal,
                   rougepal,vertpal,bleupal,grispal,
                   systempal,userpal);

(* ------------------------------------------------------------ *)

CONST
    ProgEXEname   = "ZIGZAG";
    ProgTitle     = "Q&D Zigzag demo";
    ProgVersion   = "v1.0g";
    ProgCopyright = "by PhG";
    Banner        = ProgTitle+" "+ProgVersion+" "+ProgCopyright;

CONST
    errNone           = 0;
    errHelp           = 1;
    errIllegalParm    = 2;
    errUnknownOpt     = 3;
    errRange          = 4;
    errBothRequired   = 5;

(* ------------------------------------------------------------ *)

PROCEDURE abort (e : CARDINAL; einfo : ARRAY OF CHAR);
CONST
(*
 00000000011111111112222222222333333333344444444445555555555666666666677777777778
 1...'....0....'....0....'....0....'....0....'....0....'....0....'....0....'....0
*)
    helpmsg =
Banner+nl+
nl+
"Syntax : "+ProgEXEname+" [option]..."+nl+
nl+
"  -a   show palette until keypress or 10 seconds"+nl+
"  -z   end on mouseclick too"+nl+
"  -p:# color palette (0..14=rgbRGB$*/!=1230)"+nl+
"  -d   diagonal cross fade (default is normal cross fade)"+nl+
"  -i   independant lines (default is chained lines)"+nl+
"  -s   splines (default is lines)"+nl+
"  -o   softer splines (-t:1 recommended)"+nl+
"  -q   quix"+nl+
"  -b   blobs (circles)"+nl+
"  -f   blobs (disks)"+nl+
"  -t   spiros"+nl+
"  -x   autocenter (spiros only), default is random"+nl+
"  -c:# number of control points ([2..100], default=20)"+nl+
"  -s:# number of segments ([2..50], default=10)"+nl+
"  -t:# number of trails ([1..50], default=10)"+nl+
"  -l:# lower speed ([1..50], default=5)"+nl+
"  -u:# upper speed ([1..50], default=10)"+nl+
"  -w:# wait ([0..50], default=0)"+nl+
"  -i:# RGB ink color (user palette) -- hex prefix is $"+nl+
"  -f:# RGB ink to fade to color (user palette) -- hex prefix is $"+nl+
"  -m:# minimum color index when drawing lines (default=112)"+nl+
nl+
"While running : [rgbRGB$/*!=1230]-palette, [nd]-normal/dithered, [+-]-trails"+nl+
"[ic]-independant/continuous lines, [F1 F2]-control points or spiro count"+nl+
"[lsoqpft]-lines/splines/softsplines/quix/circles/disks/spiros, [PgUp|PgDn]-wait"+nl+
"[x]-spiro autocenter, [F3 F4]-lower speed, [F5 F6]-upper speed, [Escape|CR]"+nl;

VAR
    S : str256;
BEGIN
    CASE e OF
    | errHelp :
        WrStr(helpmsg);
    | errIllegalParm :
        Str.Concat(S,"Illegal ",einfo); Str.Append(S," parameter !");
    | errUnknownOpt :
        Str.Concat(S,"Unknown ",einfo); Str.Append(S," option !");
    | errRange :
        Str.Concat(S,"Value for ",einfo);
        Str.Append(S," not in legal range !");
    | errBothRequired:
        S := "Both ink and ink to fade to are required for user palette !";

    ELSE
        S := "This is illogical, Captain !";
    END;
    CASE e OF
    | errNone,errHelp :
        (* nada *)
    ELSE
        WrStr(ProgEXEname+" : ");
        WrStr(S);
        WrLn;
    END;
    Lib.SetReturnCode(SHORTCARD(e));
    HALT;
END abort;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE getrndrange (lower,upper:CARDINAL):CARDINAL;
VAR
    range : CARDINAL;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN CARDINAL(rnd);
END getrndrange;

PROCEDURE getrndrangeint (lower,upper:INTEGER):INTEGER;
VAR
    range : INTEGER;
    rnd   : REAL;
BEGIN
    range := upper-lower+1;
    rnd := (REAL(range) * Lib.RAND()) + REAL(lower);
    RETURN INTEGER(rnd);
END getrndrangeint;

PROCEDURE flushKeyboard (  );
VAR
    c : CHAR;
BEGIN
    LOOP
        IF BiosIO.KeyPressed()=FALSE THEN EXIT; END;
        c := BiosIO.RdKey();
        IF c = CHR(0) THEN c := BiosIO.RdKey(); END;
    END;
END flushKeyboard;

PROCEDURE getKeyboardCode (VAR keycode:CARDINAL):BOOLEAN;
VAR
    c1,c2:CHAR;
BEGIN
    IF BiosIO.KeyPressed()=FALSE THEN RETURN FALSE; END;
    c1 := BiosIO.RdKey();
    IF c1 = CHR(0) THEN
        c2 := BiosIO.RdKey();
    ELSE
        c2 := CHR(0);
    END;
    keycode := ORD(c1)*256 + ORD(c2);
    RETURN TRUE;
END getKeyboardCode;

PROCEDURE input (maxWait:LONGINT); (* in seconds *)
VAR
    keycode:CARDINAL;
    h,m,s,ss:CARDINAL;
    start : LONGINT;
    now   : LONGINT;
BEGIN
    Lib.GetTime(h,m,s,ss);
    start := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
    LOOP
        IF getKeyboardCode(keycode) THEN EXIT; END;
        Lib.GetTime(h,m,s,ss);
        now := (LONGINT(h)*60+LONGINT(m))*60+LONGINT(s);
        IF ABS(now-start) > maxWait THEN EXIT; END;
    END;
END input;

(* ------------------------------------------------------------ *)

PROCEDURE setVideoMode (mode:CARDINAL);
VAR
    R : SYSTEM.Registers;
BEGIN
    R.AH := 00H;
    R.AL := BYTE(mode);
    Lib.Intr(R,10H);
END setVideoMode;

PROCEDURE WaitVGAretrace ();
BEGIN
    WHILE (SYSTEM.In(03DAH) AND 08H) # 0 DO
    END;
    WHILE (SYSTEM.In(03DAH) AND 08H) = 0 DO
    END;
END WaitVGAretrace;

CONST
    hires = 13H; (* 320x200x256 *)
    text  = 03H; (* 80x25 *)
    xcount = 320;
    ycount = 200;
    xmin = 0;
    xmax = xcount-1;
    ymin = 0;
    ymax = ycount-1;
    xcenter = xmax DIV 2;
    ycenter = ymax DIV 2;
    screensize = xcount * ycount + xcount; (* added REQUIRED safety *)
    screensizeW=(screensize DIV 2);
TYPE
    screenType = ARRAY [0..screensize-1 +1] OF BYTE;   (* 320x200=64000 with security *)
VAR
    SmoothScreen : POINTER TO screenType;
    Screen       : POINTER TO screenType;
VAR
    videoscreen [0A000H:0000H] : ARRAY [0..screensize-1] OF BYTE;
    Ybase                      : ARRAY [ymin..ymax] OF CARDINAL;
    gInk,gInkFadeTo : LONGCARD; (* for user palette *)

PROCEDURE initYbase ();
VAR
    i,p:CARDINAL;
BEGIN
    p := 0;
    FOR i := ymin TO ymax DO
        Ybase[i]:=p;
        INC(p,xcount);
    END;
END initYbase;

(* ------------------------------------------------------------ *)

CONST
    black       = LONGCARD(0000000H);
    white       = LONGCARD(03F3F3FH); (* ega/vga range is $00..$3F *)
    red         = LONGCARD(03F0000H);
    green       = LONGCARD(0003F00H);
    darkgreen   = LONGCARD(0002000H);
    blue        = LONGCARD(000003FH);
    darkblue    = LONGCARD(0000020H);
    cyan        = LONGCARD(0002F3FH);
    yellow      = LONGCARD(03F3F00H);
    darkred     = LONGCARD(0200000H);
    orange      = LONGCARD(02F2F00H);
CONST
    egarange = 40H;
    minColor   = 0000000H;
    maxColor   = 0FFFFFFH;
    mininkindex = 0;
    maxinkindex = 128-1;
    lastinkindex= 256-1;
    ndxblack = mininkindex;
VAR
    mininkline : CARDINAL; (* default is 104 *)
TYPE
    triplet = RECORD
        r,g,b:SHORTCARD;
    END;
VAR
    orgpal     : ARRAY [0..255] OF triplet;

PROCEDURE setDAC(index:CARDINAL;red,green,blue:BYTE);
CONST
    DACWriteIndex  = 03C8H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACWriteIndex,SHORTCARD(index));
    SYSTEM.Out (DACDataRegister, red);
    SYSTEM.Out (DACDataRegister, green);
    SYSTEM.Out (DACDataRegister, blue);
END setDAC;

PROCEDURE getDAC (index:CARDINAL;VAR r,g,b:SHORTCARD);
CONST
    DACReadIndex   = 03C7H;
    DACDataRegister= 03C9H;
BEGIN
    SYSTEM.Out (DACReadIndex,SHORTCARD(index));
    r:=SYSTEM.In (DACDataRegister);
    g:=SYSTEM.In (DACDataRegister);
    b:=SYSTEM.In (DACDataRegister);
END getDAC;

PROCEDURE readDACrgb (index:CARDINAL):LONGCARD;
VAR
    r,g,b:SHORTCARD;
    rgb : LONGCARD;
BEGIN
    getDAC(index,r,g,b);
    rgb := (LONGCARD(r) << 16) + (LONGCARD(g) << 8) + LONGCARD(b);
    RETURN rgb;
END readDACrgb;

PROCEDURE resetdac (index,red,green,blue:CARDINAL);
BEGIN
    setDAC(index,BYTE(red),BYTE(green),BYTE(blue));
END resetdac;

PROCEDURE blend (ndx,count:CARDINAL; startink, endink:LONGCARD);
CONST
    rshift = LONGCARD(16);
    gshift = LONGCARD(8);
VAR
    r1,g1,b1:INTEGER;
    r2,g2,b2:INTEGER;
    r,g,b:INTEGER;
    i : CARDINAL;
BEGIN
    r1 := INTEGER (startink >> rshift) MOD egarange;
    g1 := INTEGER (startink >> gshift) MOD egarange;
    b1 := INTEGER (startink          ) MOD egarange;
    r2 := INTEGER (endink   >> rshift) MOD egarange;
    g2 := INTEGER (endink   >> gshift) MOD egarange;
    b2 := INTEGER (endink            ) MOD egarange;

    FOR i := 1 TO count DO
        r := r1 + ((r2 - r1) * INTEGER(i) ) DIV INTEGER(count);
        g := g1 + ((g2 - g1) * INTEGER(i) ) DIV INTEGER(count);
        b := b1 + ((b2 - b1) * INTEGER(i) ) DIV INTEGER(count);
        IF r < 0 THEN r:=0; END;
        IF g < 0 THEN g:=0; END;
        IF b < 0 THEN b:=0; END;
        IF r >= egarange THEN r:=egarange-1; END;
        IF g >= egarange THEN g:=egarange-1; END;
        IF b >= egarange THEN b:=egarange-1; END;
        setDAC(ndx+i-1,BYTE(r),BYTE(g),BYTE(b));
    END;
END blend;

PROCEDURE normalize (VAR lc:LONGCARD);
VAR
    r,g,b:CARDINAL;
BEGIN
    r := CARDINAL(lc MOD 100H);
    g := CARDINAL(lc DIV 100H) MOD 100H;
    b := CARDINAL(lc DIV 10000H);
    r := r >> 2; (* MOD egarange; *)
    g := g >> 2;
    b := b >> 2;
    lc := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
END normalize;

PROCEDURE genRGB (  ):LONGCARD;
CONST
    dimmest   = 000H;
    brightest = 03FH;
VAR
    r,g,b : CARDINAL;
    bgr : LONGCARD;
BEGIN
    r := getrndrange(dimmest,brightest);
    g := getrndrange(dimmest,brightest);
    b := getrndrange(dimmest,brightest);
    bgr := LONGCARD(b) << 16 + LONGCARD(g) << 8 + LONGCARD(r);
    RETURN bgr;
END genRGB;

PROCEDURE newPalette (pal:palettetype);
VAR
    ndx : CARDINAL;
    n   : CARDINAL;
    i,j : CARDINAL;
    r,g,b:BYTE;
    ir,ig,ib:CARDINAL;
BEGIN
    WaitVGAretrace(); (* reduce noise on screen *)
    (* 0..127 *)
    (* we were starting from $1F1F03 ! *)
    CASE pal OF
    | redpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,02F0804H);
        INC(ndx,n);       n := 48;
        blend (ndx,n,02F0804H,03F2F2FH);
        INC(ndx,n);       n := 64;
        blend (ndx,n,03F2F2FH,03F3F3FH);
    | greenpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,0082F04H);
        INC(ndx,n);       n := 64;
        blend (ndx,n,0082F04H,01F3F1FH);
        INC(ndx,n);       n := 48;
        blend (ndx,n,01F3F1FH,03F3F3FH);
    | bluepal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,004082FH);
        INC(ndx,n);       n := 64;
        blend (ndx,n,004082FH,01F2F3FH);
        INC(ndx,n);       n := 48;
        blend (ndx,n,01F2F3FH,03F3F3FH);
    | rpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,02F0804H);
        INC(ndx,n);       n := 64;
        blend (ndx,n,02F0804H,yellow);
        INC(ndx,n);       n := 48;
        blend (ndx,n,yellow,white);
    | gpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,0082F04H);
        INC(ndx,n);       n := 64;
        blend (ndx,n,0082F04H,yellow);
        INC(ndx,n);       n := 48;
        blend (ndx,n,yellow,white);
    | bpal:
        ndx := 0;         n := 16;
        blend (ndx,n,0000000H,004082FH);
        INC(ndx,n);       n := 64;
        blend (ndx,n,004082FH,cyan);
        INC(ndx,n);       n := 48;
        blend (ndx,n,cyan,white);
    | rainbowpal:      (* 63 9  63 9  63 21 *)
        ndx := 0;
        FOR ir := 0 TO 127 BY 9 DO
            FOR ig := 0 TO 127 BY 9 DO
                FOR ib := 0 TO 127 BY 21 DO
                    resetdac(ndx,ir,ig,ib);
                    INC(ndx);
                    (* now prevent artefact *)
                    ndx:=ndx MOD 256;
                    IF ndx=0 THEN INC(ndx);END;
                END;
            END;
        END;
    | randompal :
        FOR i := mininkindex TO maxinkindex DO
            setDAC(i,BYTE(getrndrange(0,egarange-1)),BYTE(getrndrange(0,egarange-1)),BYTE(getrndrange(0,egarange-1)));
        END;
    | rndpal:
        i := mininkindex;
        LOOP
            blend(i,8,genRGB(),genRGB());
            INC(i,8);
            IF i > maxinkindex THEN EXIT;END;
        END;
    | userpal:
        ndx := 0;         n := 128;
        blend (ndx,n,gInkFadeTo,gInk);
    | systempal: (* do nothing *)
        FOR i := 0 TO 255 DO
            setDAC(i,orgpal[i].r,orgpal[i].g,orgpal[i].b);
        END;
    | descentpal:
	    FOR i:=0 TO 64 DO
            (* Make 0-63 be red shades *)		
            r:= BYTE(i); g:= 0; b:= 0; j:=i DIV 2;
            setDAC(j,r,g,b);
            (* Make 64-127 be green shades *)
		    r:= 0; g:= BYTE(i); b:= 0; j:= (i+64) DIV 2;
            setDAC(j, r,g,b);
            (* Make 128-191 be blue shades *)
		    r:= 0; g:= 0; b:= BYTE(i); j := (i+128) DIV 2;
            setDAC(j, r,g,b);
		    (* Make 192-255 be greyscale *)
		    r:= BYTE(i); g:= BYTE(i); b:= BYTE(i); j := (i+192) DIV 2;
            setDAC(j,r,g,b);
        END;
    | rougepal:
        ndx:=0;
        FOR i := 32 TO 64 DO
            r:= BYTE(i); g:= 0; b:= 0; j:=i DIV 2;
            FOR j:= 1 TO 4 DO setDAC(ndx,r,g,b);INC(ndx);END;
        END;
    | vertpal:
        ndx:=0;
        FOR i := 32 TO 64 DO
		    r:= 0; g:= BYTE(i); b:= 0; j:= (i+64) DIV 2;
            FOR j:= 1 TO 4 DO setDAC(ndx,r,g,b);INC(ndx);END;
        END;
    | bleupal:
        ndx:=0;
        FOR i := 32 TO 64 DO
		    r:= 0; g:= 0; b:= BYTE(i); j := (i+128) DIV 2;
            FOR j:= 1 TO 4 DO setDAC(ndx,r,g,b);INC(ndx);END;
		END;
    | grispal:
        ndx:=0;
        FOR i := 32 TO 64 DO
		    r:= BYTE(i); g:= BYTE(i); b:= BYTE(i); j := (i+192) DIV 2;
            FOR j:= 1 TO 4 DO setDAC(ndx,r,g,b);INC(ndx);END;
		END;
    END;
    setDAC(ndxblack,00H,00H,00H);


    ndx:=maxinkindex;       n := lastinkindex-maxinkindex+1;
    blend (ndx,n,readDACrgb(maxinkindex),readDACrgb(maxinkindex));

END newPalette;

PROCEDURE showPalette (  );
VAR
   i    : CARDINAL;
   xpos : CARDINAL;
   ypos : CARDINAL;
   p    : CARDINAL;
BEGIN
   FarFill(FarADR(videoscreen[0]),screensize,ndxblack); (* index of sky, so black *)
   FOR i := 0 TO 255 DO
       FOR ypos := ymin TO ymax DO
           p := Ybase[ypos] + i; (* was ypos * xcount + i *)
           videoscreen[p]:=BYTE(i);
       END;
   END;
   input (maxWaitInSeconds);
END showPalette;


(* assume all coordinates are >= 0 and within range *)

(*
    was goodalgo=FALSE, for not so bugfree an algo

PROCEDURE zline (x1,y1,x2,y2:CARDINAL;ink:BYTE);
VAR
    x,y:CARDINAL;
    dx,dy,sx,sy,d:INTEGER;
BEGIN
    (*
        dx, dy = distance, d = deviation,
        sx, sy = sign of distance.
    *)

    dx := x2 - x1;
    dy := y2 - y1;
    IF dx > 0 THEN
        sx := 1
    ELSE
        sx := -1;
    END;
    IF dy > 0 THEN
        sy := 1
    ELSE
        sy := -1;
    END;
    dx := ABS(dx);
    dy := ABS(dy);
    x := x1;
    y := y1;

    IF dx > dy THEN
        d := (dy - dx) DIV 2;       (* X is major axis *)
        WHILE x # x2 DO
            Screen^[Ybase[y]+x]:=ink;  (* Put pixel *)
            IF d >= 0 THEN          (* Minor-axis change? *)
                DEC(d, dx);         (* Decrease by 1 *)
                INC(y, sy);
            END;
            INC(d, dy);             (* Increase by dy/dx *)
            INC(x, sx);
        END;
        Screen^[Ybase[y]+x]:=ink;      (* Put last pixel *)
    ELSE
        d := (dx - dy) DIV 2;       (* Y is major axis *)
        WHILE y # y2 DO
            Screen^[Ybase[y]+x]:=ink;
            IF d >= 0 THEN          (* Minor-axis change? *)
                DEC(d, dy);         (* Decrease by 1 *)
                INC(x, sx);
            END;
            INC(d, dx);             (* Increase by dx/dy *)
            INC(y, sy);
        END;
        Screen^[Ybase[y]+x]:=ink;
    END;
END zline;
*)

(* goodalgo TRUE *)
PROCEDURE zline(x1, y1, x2, y2 : CARDINAL; ink:BYTE);
VAR
    i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : INTEGER;
BEGIN
    (* Calculate deltax and deltay for initialisation *)
    deltax := ABS( INTEGER(x2) - INTEGER(x1) );
    deltay := ABS( INTEGER(y2) - INTEGER(y1) );

    (* Initialize all vars based on which is the independent variable *)
    IF deltax >= deltay THEN
        (* x is independent variable *)
        numpixels := deltax + 1;
        d := (2 * deltay) - deltax;
        dinc1 := deltay << 1;
        dinc2 := (deltay - deltax) << 1;
        xinc1 := 1;
        xinc2 := 1;
        yinc1 := 0;
        yinc2 := 1;
    ELSE
        (* y is independent variable *)
        numpixels := deltay + 1;
        d := (2 * deltax) - deltay;
        dinc1 := deltax << 1;
        dinc2 := (deltax - deltay) << 1;
        xinc1 := 0;
        xinc2 := 1;
        yinc1 := 1;
        yinc2 := 1;
    END;

    (* Make sure x and y move in the right directions *)
    IF x1 > x2 THEN
        xinc1 := - xinc1;
        xinc2 := - xinc2;
    END;
    IF y1 > y2 THEN
        yinc1 := - yinc1;
        yinc2 := - yinc2;
    END;

    (* Start drawing at <x1, y1> *)
    x := CARDINAL(x1);
    y := CARDINAL(y1);

    (* Draw the pixels *)
    FOR i := 1 TO numpixels DO
        Screen^[Ybase[y]+CARDINAL(x)]:=ink;
        IF d < 0 THEN
            d := d + dinc1;
            x := x + xinc1;
            y := y + yinc1;
        ELSE
            d := d + dinc2;
            x := x + xinc2;
            y := y + yinc2;
        END;
    END;
END zline;

PROCEDURE zplot (x,y:CARDINAL;ink:BYTE);
BEGIN
    IF x < xmin THEN RETURN; END;
    IF x > xmax THEN RETURN; END;
    IF y < ymin THEN RETURN; END;
    IF y > ymax THEN RETURN; END;
    Screen^[Ybase[y]+x]:=ink;  (* Put pixel *)
END zplot;

(* ------------------------------------------------------------ *)

CONST
    minalpha = 0;
    maxalpha = 90;
    k        = 255;
VAR
    tcos : ARRAY [minalpha..maxalpha] OF INTEGER;
    tsin : ARRAY [minalpha..maxalpha] OF INTEGER;

PROCEDURE initcostable (  );
VAR
    pi,deg2rad,angle,d1,d2:LONGREAL;
    i : CARDINAL;
BEGIN
    pi := 4.0 * MATHLIB.ATan(1.0);
    deg2rad := pi / 180.0;
    FOR i := 0 TO 90 DO
        angle := LONGREAL(i) * deg2rad;
        d1 := MATHLIB.Cos(angle);
        tcos[i] := INTEGER(d1 * LONGREAL(k) );

        angle := LONGREAL(i) * deg2rad;
        d2 := MATHLIB.Sin(angle);
        tsin[i] := INTEGER(d2 * LONGREAL(k) );
    END;
END initcostable;

PROCEDURE clipxy (VAR x,y:INTEGER);
BEGIN
    IF x < xmin THEN
        x:=xmin;
    ELSIF x > xmax THEN
        x:=xmax;
    END;
    IF y < ymin THEN
        y:=ymin;
    ELSIF y > ymax THEN
        y:=ymax;
    END;
END clipxy;

PROCEDURE plotsym (filled:BOOLEAN; cx,cy,dx,dy:INTEGER;ink:BYTE);
VAR
    x1,y1,x2,y2:INTEGER;
BEGIN
  IF filled THEN
    x1:=cx-dx;
    y1:=cy-dy;
    x2:=cx+dx;
    y2:=cy-dy;
    clipxy(x1,y1);
    clipxy(x2,y2);
    zline(x1,y1,x2,y2,ink);

    x1:=cx-dx;
    y1:=cy+dy;
    x2:=cx+dx;
    y2:=cy+dy;
    clipxy(x1,y1);
    clipxy(x2,y2);
    zline(x1,y1,x2,y2,ink);
  ELSE
    x1:=cx-dx;
    y1:=cy-dy;
    zplot(x1,y1,ink);
    x2:=cx+dx;
    y2:=cy-dy;
    zplot(x2,y2,ink);

    x1:=cx-dx;
    y1:=cy+dy;
    zplot(x1,y1,ink);
    x2:=cx+dx;
    y2:=cy+dy;
    zplot(x2,y2,ink);
  END;
END plotsym;

PROCEDURE aellipse (filled:BOOLEAN; cx,cy,rx,ry:INTEGER;ink:BYTE);
VAR
    i:CARDINAL;
    dx,dy,cosinus,sinus:INTEGER;
BEGIN
    FOR i:=minalpha TO maxalpha DO
        cosinus := tcos[i];
        dx := (cosinus * rx) DIV k;
        sinus   := tsin[i];
        dy := (  sinus * ry) DIV k;
        plotsym(filled,cx,cy,dx,dy,ink);
    END;
END aellipse;

PROCEDURE zcircle (filled:BOOLEAN; cx,cy,r:INTEGER;ink:BYTE);
BEGIN
    aellipse(filled,cx,cy,r,r,ink);
END zcircle;

(* ------------------------------------------------------------ *)

PROCEDURE smoothAndRefresh (net,maxblur:BOOLEAN);
VAR
    x,y:CARDINAL;
    ink,inkl,inkr,inku,inkd:CARDINAL;
    inklu,inkld,inkru,inkrd:CARDINAL;
    p:CARDINAL;
    divisor : CARDINAL;
BEGIN
    (*
    (* seems to cure the weird apparition of dots at lower left side ! *)
    zline(xmin,ymax,xmax,ymax,ndxblack);
    *)
    IF maxblur THEN
        divisor := 6;
    ELSE
        divisor := 5;
    END;

    FarFill(FarADR(SmoothScreen^),screensize,ndxblack);
    FOR y := ymin+1 TO ymax-1 DO
        p := Ybase[y]+xcount; (* was xcount * y *)
        FOR x := xmin+1 TO xmax-1 DO
            ink :=CARDINAL(Screen^[p+x])   ;
            IF net THEN
                inklu:=CARDINAL(Screen^[p+x-1-xcount]) ;
                inkru:=CARDINAL(Screen^[p+x+1-xcount]) ;
                inkld:=CARDINAL(Screen^[p+x-1+xcount]) ;
                inkrd:=CARDINAL(Screen^[p+x+1+xcount]) ;
                ink := (ink + inklu+inkru+inkld+inkrd ) DIV divisor;
            ELSE
                inkl:=CARDINAL(Screen^[p+x-1]) ;
                inkr:=CARDINAL(Screen^[p+x+1]) ;
                inku:=CARDINAL(Screen^[p+x-xcount]) ;
                inkd:=CARDINAL(Screen^[p+x+xcount]) ;
                ink := (ink + inkl +inkr + inku + inkd ) DIV divisor;
            END;

            SmoothScreen^[p+x]:=BYTE(ink);

        END;
    END;
    FarWordMove(FarADR(SmoothScreen^),FarADR(videoscreen[0]),screensizeW);
END smoothAndRefresh;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    gControlPoints : CARDINAL;
    gSegments      : CARDINAL;
    gTrails        : CARDINAL;
    gMinSpeed      : CARDINAL;
    gMaxSpeed      : CARDINAL;
    gWait          : CARDINAL;

CONST
    minControlPoints = 2;
    maxControlPoints = 100;
    minSegments      = 2;
    maxSegments      = 50;
    minTrails        = 1;
    maxTrails        = 50;
    minSpeed         = 1;
    maxSpeed         = 50;
    minWait          = 0;
    maxWait          = 50;

PROCEDURE initSplineDefaults ();
BEGIN
    gControlPoints := 20;
    gSegments      := 10;
    gTrails        := 10;
    gMinSpeed      := 5;
    gMaxSpeed      := 10;
    gWait          := 0;
END initSplineDefaults;

CONST
    firstknot        = 1;
    maxknot          = maxControlPoints;
    firstknotndx     = firstknot-1;
    maxknotndx       = maxknot+2;
    firsttrail       = minTrails;
    maxtrail         = maxTrails+1;
TYPE
    knotentry = RECORD
        x : INTEGER;
        y : INTEGER;
        dx: INTEGER;
        dy: INTEGER;
    END;
VAR
    knot : ARRAY [firstknotndx..maxknotndx],[firsttrail..maxtrail] OF knotentry;
    couleur : ARRAY [firsttrail..maxtrail] OF BYTE;


PROCEDURE newdelta (lower,upper:INTEGER):INTEGER;
VAR
    delta : INTEGER;
BEGIN
    LOOP
        delta := getrndrangeint (-upper, upper);
        IF ABS(delta) >= lower THEN EXIT; END;
    END;
    RETURN delta;
END newdelta;

PROCEDURE initknots (numPts,numTrails:CARDINAL);
VAR
    i,ndx:CARDINAL;
BEGIN
    ndx := firsttrail;
    FOR i := firstknot TO numPts DO
        knot[i,ndx].x := getrndrange(xmin,xmax);
        knot[i,ndx].y := getrndrange(ymin,ymax);
        knot[i,ndx].dx:= newdelta(gMinSpeed,gMaxSpeed);
        knot[i,ndx].dy:= newdelta(gMinSpeed,gMaxSpeed);
    END;
    FOR i := firstknot TO numPts DO
        FOR ndx := numTrails TO firsttrail BY -1 DO
            knot[i,ndx+1] := knot[i,ndx];
        END;
    END;
END initknots;

PROCEDURE moveknots (numPts,numTrails:CARDINAL);
VAR
    i,ndx: CARDINAL;
    p:INTEGER;
BEGIN
    FOR i := firstknot TO numPts DO
        FOR ndx := numTrails TO firsttrail BY -1 DO
            knot[i,ndx+1] := knot[i,ndx];
        END;
    END;
    ndx := firsttrail;
    FOR i := firstknot TO numPts DO
        LOOP
            p := knot[i,ndx].x + knot[i,ndx].dx;
            IF ( (p >= xmin) AND (p < xmax) ) THEN EXIT; END;
            knot[i,ndx].dx := newdelta(gMinSpeed,gMaxSpeed);
        END;
        knot[i,ndx].x := p;
        LOOP
            p := knot[i,ndx].y + knot[i,ndx].dy;
            IF ( (p >= ymin) AND (p < ymax) ) THEN EXIT; END;
            knot[i,ndx].dy := newdelta(gMinSpeed,gMaxSpeed);
        END;
        knot[i,ndx].y := p;
    END;
END moveknots;

(* ------------------------------------------------------------ *)

PROCEDURE Parab_Calc (T,D : REAL; Apx, Bpx, Cpx, Apy, Bpy, Cpy:INTEGER; VAR x,y:INTEGER);
VAR
    T2 : REAL;
    xx,yy:REAL;
BEGIN
    T2 := T * T;
    xx := ((REAL(Apx) * T2) + (REAL(Bpx) * T) + REAL(Cpx)) / D;
    yy := ((REAL(Apy) * T2) + (REAL(Bpy) * T) + REAL(Cpy)) / D;
    x := INTEGER(xx);
    y := INTEGER(yy);
END Parab_Calc;

PROCEDURE Parab_ComputeCoeffs (n, ndx:CARDINAL; VAR Apx, Bpx, Cpx, Apy, Bpy, Cpy:INTEGER);
BEGIN
    Apx := knot[n - 1, ndx].x - 2 * knot[n, ndx].x + knot[n + 1, ndx].x;
    Bpx := -2 * knot[n - 1, ndx].x + 2 * knot[n, ndx].x;
    Cpx := knot[n - 1, ndx].x + knot[n, ndx].x;
    Apy := knot[n - 1, ndx].y - 2 * knot[n, ndx].y + knot[n + 1, ndx].y;
    Bpy := -2 * knot[n - 1, ndx].y + 2 * knot[n, ndx].y;
    Cpy := knot[n - 1, ndx].y + knot[n, ndx].y;
END Parab_ComputeCoeffs;

PROCEDURE parabolicSplineIndividual (numPts,ndx,numSegments:CARDINAL;ink:BYTE);
VAR
    i,j,n:CARDINAL;
    Apx,Bpx,Cpx,Apy,Bpy,Cpy:INTEGER;
    lastX,lastY:INTEGER;
    x,y:INTEGER;
    v1,res : REAL;
    half:CARDINAL;
BEGIN
    n := numPts;
    knot[firstknot - 1, ndx] := knot[n, ndx];
    knot[n + 1, ndx] := knot[firstknot, ndx];
    knot[n + 2, ndx] := knot[firstknot + 1, ndx];

    lastX := knot[firstknot, ndx].x;
    lastY := knot[firstknot, ndx].y;

    res := REAL(numSegments);
    half := numSegments DIV 2;

    i := firstknot;
    Parab_ComputeCoeffs (i, ndx, Apx, Bpx, Cpx, Apy, Bpy, Cpy);
    FOR j := 0 TO numSegments DO
        v1 := REAL(j);
        Parab_Calc (v1 / res, 2.0, Apx, Bpx, Cpx, Apy, Bpy, Cpy, x, y);
        IF j >= half THEN
            zline(lastX, lastY, x, y, ink);
        END;
        lastX := x;
        lastY := y;
    END;

    FOR i := firstknot + 1 TO n DO
        Parab_ComputeCoeffs (i, ndx, Apx, Bpx, Cpx, Apy, Bpy, Cpy);
        FOR j := 0 TO numSegments DO
            v1 := REAL(j);
            Parab_Calc (v1 / res, 2.0, Apx, Bpx, Cpx, Apy, Bpy, Cpy, x, y);
            zline(lastX, lastY, x, y, ink);
            lastX := x;
            lastY := y;
        END;
    END;

    i := n+1;
    Parab_ComputeCoeffs (i, ndx, Apx, Bpx, Cpx, Apy, Bpy, Cpy);
    FOR j := 0 TO numSegments DO
        v1 := REAL(j);
        Parab_Calc (v1 / res, 2.0, Apx, Bpx, Cpx, Apy, Bpy, Cpy, x, y);
        IF j < half THEN
            zline(lastX, lastY, x, y, ink);
        END;
        lastX := x;
        lastY := y;
    END;
END parabolicSplineIndividual;

PROCEDURE parabolicSpline (numPts,numTrails,numSegments:CARDINAL);
VAR
    i,ndx:CARDINAL;
BEGIN
    FOR ndx := numTrails TO firsttrail BY -1 DO
        parabolicSplineIndividual (numPts, ndx, numSegments,couleur[ndx]); (* was ink-BYTE(ndx*4) *)
    END;
END parabolicSpline;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE showTheseKnots (filled:BOOLEAN; numPts,numTrails:CARDINAL;ink:BYTE);
VAR
    i,ndx: CARDINAL;
    x,y,r:INTEGER;
BEGIN
    ndx := firsttrail;
    FOR i := firstknot TO numPts DO
        x:=knot[i,ndx].x;
        y:=knot[i,ndx].y;
        r:=(knot[i,ndx].dx+knot[i,ndx].dy) DIV 4;
        zcircle(filled, x,y,r,ink);
    END;
END showTheseKnots;

PROCEDURE showKnots (filled:BOOLEAN; numPts,numTrails:CARDINAL);
VAR
    i,ndx:CARDINAL;
BEGIN
    FOR ndx := numTrails TO firsttrail BY -1 DO
        showTheseKnots(filled,numPts, ndx, couleur[ndx]); (* was ink-BYTE(ndx*4) *)
    END;
END showKnots;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

VAR
    gMinSpeedQuix : CARDINAL;
    gMaxSpeedQuix : CARDINAL;

PROCEDURE initQuixDefaults (  );
BEGIN
    gMinSpeedQuix  := 1;
    gMaxSpeedQuix  := 16;
END initQuixDefaults;

PROCEDURE movequix (VAR x1,y1:CARDINAL; VAR dx1,dy1:INTEGER;
                    VAR x2,y2:CARDINAL; VAR dx2,dy2:INTEGER );
VAR
    p : INTEGER;
BEGIN
    LOOP
        p := INTEGER(x1)+dx1;
        IF ( (p >= xmin) AND (p < xmax) ) THEN EXIT; END;
        dx1 := newdelta(gMinSpeedQuix,gMaxSpeedQuix);
    END;
    x1 := CARDINAL(p);
    LOOP
        p := INTEGER(y1)+dy1;
        IF ( (p >= ymin) AND (p < ymax) ) THEN EXIT; END;
        dy1 := newdelta(gMinSpeedQuix,gMaxSpeedQuix);
    END;
    y1 := CARDINAL(p);

    LOOP
        p := INTEGER(x2)+dx2;
        IF ( (p >= xmin) AND (p < xmax) ) THEN EXIT; END;
        dx2 := newdelta(gMinSpeedQuix,gMaxSpeedQuix);
    END;
    x2 := CARDINAL(p);
    LOOP
        p := INTEGER(y2)+dy2;
        IF ( (p >= ymin) AND (p < ymax) ) THEN EXIT; END;
        dy2 := newdelta(gMinSpeedQuix,gMaxSpeedQuix);
    END;
    y2 := CARDINAL(p);
END movequix;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE zplotInt (x,y:INTEGER;ink:BYTE);
BEGIN
    IF x < INTEGER(xmin) THEN RETURN; END;
    IF x > INTEGER(xmax) THEN RETURN; END;
    IF y < INTEGER(ymin) THEN RETURN; END;
    IF y > INTEGER(ymax) THEN RETURN; END;
    Screen^[Ybase[ CARDINAL(y) ]+ CARDINAL(x)]:=ink;  (* Put pixel *)
END zplotInt;

(* goodalgo TRUE, but for integers, required for spiro code *)

PROCEDURE zlineInt(x1, y1, x2, y2 : INTEGER; ink:BYTE);
VAR
    i, deltax, deltay, numpixels,
    d, dinc1, dinc2,
    x, xinc1, xinc2,
    y, yinc1, yinc2 : INTEGER;
BEGIN
    (* Calculate deltax and deltay for initialisation *)
    deltax := ABS( INTEGER(x2) - INTEGER(x1) );
    deltay := ABS( INTEGER(y2) - INTEGER(y1) );

    (* Initialize all vars based on which is the independent variable *)
    IF deltax >= deltay THEN
        (* x is independent variable *)
        numpixels := deltax + 1;
        d := (2 * deltay) - deltax;
        dinc1 := deltay << 1;
        dinc2 := (deltay - deltax) << 1;
        xinc1 := 1;
        xinc2 := 1;
        yinc1 := 0;
        yinc2 := 1;
    ELSE
        (* y is independent variable *)
        numpixels := deltay + 1;
        d := (2 * deltax) - deltay;
        dinc1 := deltax << 1;
        dinc2 := (deltax - deltay) << 1;
        xinc1 := 0;
        xinc2 := 1;
        yinc1 := 1;
        yinc2 := 1;
    END;

    (* Make sure x and y move in the right directions *)
    IF x1 > x2 THEN
        xinc1 := - xinc1;
        xinc2 := - xinc2;
    END;
    IF y1 > y2 THEN
        yinc1 := - yinc1;
        yinc2 := - yinc2;
    END;

    (* Start drawing at <x1, y1> *)
    x := CARDINAL(x1);
    y := CARDINAL(y1);

    (* Draw the pixels *)
    FOR i := 1 TO numpixels DO
        zplot(x,y,ink);

        IF d < 0 THEN
            d := d + dinc1;
            x := x + xinc1;
            y := y + yinc1;
        ELSE
            d := d + dinc2;
            x := x + xinc2;
            y := y + yinc2;
        END;
    END;
END zlineInt;

(* slightly adapted from SPIRO v1.1b *)

PROCEDURE vpause (n:CARDINAL   );
VAR
    i:CARDINAL;
BEGIN
    FOR i:=1 TO n DO WaitVGAretrace; END;
END vpause;

PROCEDURE GetRndCardRange (lower,upper:CARDINAL   ):CARDINAL ;
BEGIN
    RETURN getrndrange (lower,upper);
END GetRndCardRange;

PROCEDURE newint (VAR v:INTEGER;shifted:BOOLEAN;
                  small,big:INTEGER;lower,upper:INTEGER;roll:BOOLEAN );
VAR
    tmp:INTEGER;
BEGIN
    tmp:=v;
    IF shifted THEN
        INC(tmp,big);
    ELSE
        INC(tmp,small);
    END;
    IF tmp < lower THEN
        IF roll THEN
            v:=upper-ABS(lower-tmp);
        END;
    ELSIF tmp > upper THEN
        IF roll THEN
            v:=lower+ABS(tmp-upper);
        END;
    ELSE
        v:=tmp;
    END;
END newint;

PROCEDURE newcard (VAR v:CARDINAL;shifted:BOOLEAN;
                   small,big:INTEGER;lower,upper:CARDINAL;roll:BOOLEAN);
VAR
    vv:INTEGER;
BEGIN
    vv:=INTEGER(v);
    newint( vv, shifted, small,big, INTEGER(lower), INTEGER(upper), roll );
    v:=CARDINAL(vv);
END newcard;

PROCEDURE f2i ( v:LONGREAL  ):INTEGER ;
CONST
    fk = LONGREAL(0.5);
    minint = LONGREAL (MIN(INTEGER));
    maxint = LONGREAL (MAX(INTEGER));
VAR
    vv:LONGREAL;
BEGIN
    (* // try and handle v bigger than an INTEGER, the brutal way  *)
    vv:=v+fk;
    IF vv > maxint THEN
        RETURN MAX(INTEGER);
    ELSIF vv < minint THEN
        RETURN MIN(INTEGER);
    ELSE
        RETURN VAL( INTEGER, vv);
    END;
END f2i;

PROCEDURE fGrLine (x1,y1,x2,y2:LONGREAL;ink:BYTE);
VAR
    a,b,c,d:INTEGER;
BEGIN
    a:=f2i(x1);
    b:=f2i(y1);
    c:=f2i(x2);
    d:=f2i(y2);

    zlineInt(a,b,c,d, ink );
END fGrLine;

VAR
    PI      : LONGREAL;
    deg2rad : LONGREAL;

PROCEDURE inittrigo (  );
BEGIN
    PI      := 4.0 * MATHLIB.ATan(1.0);
    deg2rad := PI / 180.0;
END inittrigo;

PROCEDURE DegreesToRadians ( alphadeg : LONGREAL ) : LONGREAL ;
BEGIN
    RETURN (alphadeg * deg2rad);
END DegreesToRadians;

PROCEDURE RadiansToDegrees( alpha : LONGREAL ) : LONGREAL ;
BEGIN
    RETURN (alpha / deg2rad);
END RadiansToDegrees;

(*
(* with these coeffs/signs, up=0 and right=90 *)

PROCEDURE PolarToRectangular (alphadeg:LONGREAL;radius,cx,cy:INTEGER;
                             VAR x,y : INTEGER);
VAR
    alpha,dx,dy,co,si : LONGREAL;
BEGIN
    alpha := DegreesToRadians(alphadeg);
    co    := MATHLIB.Cos(alpha);
    si    := MATHLIB.Sin(alpha);
    dx    := LONGREAL(radius) * si;
    dy    := LONGREAL(radius) * co;
    x     := cx+VAL(INTEGER,dx);
    y     := cy-VAL(INTEGER,dy);
END PolarToRectangular;
*)

(* with these coeffs/signs, up=0 and right=270 *)

PROCEDURE PolarToRectangular (alphadeg:LONGREAL;radius:INTEGER;
                             cx,cy:LONGREAL;
                             VAR x,y : LONGREAL);
VAR
    alpha,dx,dy,co,si : LONGREAL;
BEGIN
    alpha := DegreesToRadians(alphadeg);
    co    := MATHLIB.Cos(alpha);
    si    := MATHLIB.Sin(alpha);
    dx    := LONGREAL(radius) * si;
    dy    := LONGREAL(radius) * co;
    x     := cx-dx;
    y     := cy-dy;
END PolarToRectangular;

CONST
    mincount     =    1;   maxcount     =  500; maxcount2     = 50;
    minangle     = -180;   maxangle     =  180; (* was 360 *)
    minmotion    =    1;   maxmotion    =  100; maxmotion2    = 20;
    minmotionval = -100;   maxmotionval = +100; maxmotionval2 = 10;
    minscale     =    1;   maxscale     =  500; maxscale2     = 10;
    midAngle     =    0;
    midMotionval =    0;
VAR
    rotation,rotationAnchor         : INTEGER;
    motion           : ARRAY [minmotion..maxmotion] OF INTEGER;
    count,lastmotion : CARDINAL;
VAR
    xx,yy,scale    : INTEGER;
    orgbadalgo,autocenter : BOOLEAN;

PROCEDURE genparms ();
VAR
    i:CARDINAL;
BEGIN
    count      := GetRndCardRange(mincount,maxcount2);
    rotation   := INTEGER ( GetRndCardRange(midAngle,maxangle) );
    IF GetRndCardRange(0,1)=1 THEN rotation:=-rotation;END;
    lastmotion := GetRndCardRange (minmotion,maxmotion2);
    FOR i:=minmotion TO lastmotion DO
        motion[i]:=INTEGER( GetRndCardRange(midMotionval,maxmotionval2) );
        IF GetRndCardRange(0,1)=1 THEN motion[i]:=-motion[i];END;
    END;
    scale      := INTEGER ( GetRndCardRange(minscale,maxscale2) );
END genparms;

VAR
    cx,cy:INTEGER;
    orgX,orgY,loX,hiX,loY,hiY:LONGREAL;

PROCEDURE redraw ( speed:CARDINAL;  chklimits:BOOLEAN;ink:BYTE  );
VAR
    i,j:CARDINAL;
    x,y,rotdeg,thetadeg,lastx,lasty,dx,dy:LONGREAL;
    radius:INTEGER;
BEGIN
    IF chklimits THEN
        orgX:=LONGREAL(xx);
        orgY:=LONGREAL(yy);
        loX:=orgX;
        hiX:=orgX;
        loY:=orgY;
        hiY:=orgY;
    ELSE
        (* cls (paper); *)
    END;

    x := LONGREAL(xx);
    y := LONGREAL(yy);

    rotdeg   := LONGREAL(rotation);
    thetadeg := 0.0;

    i:=mincount;
    LOOP
        j:=minmotion;
        LOOP
            IF j > lastmotion THEN EXIT; END;
            lastx := x;
            lasty := y;
            radius:= scale * motion[j];

            IF orgbadalgo THEN
                thetadeg:=thetadeg+rotdeg;
                IF radius < 0 THEN
                    radius := ABS(radius);
                    thetadeg:=thetadeg+LONGREAL(180.0);
                END;
            ELSE
                IF radius < 0 THEN
                    radius   := ABS(radius);
                    thetadeg := thetadeg+LONGREAL(180.0)+rotdeg;
                ELSE
                    thetadeg := thetadeg-LONGREAL(180.0)-rotdeg;
                END;
            END;
            thetadeg:=MATHLIB.Mod(thetadeg, 360.0);
            PolarToRectangular (thetadeg+LONGREAL(90.0),radius,lastx,lasty, x,y);
            IF chklimits THEN
                IF x < loX THEN loX:=x;END;
                IF x > hiX THEN hiX:=x;END;
                IF y < loY THEN loY:=y;END;
                IF y > hiY THEN hiY:=y;END;
            ELSE
                fGrLine(lastx,lasty,x,y,ink);
            END;
            INC(j);
        END;
        INC(i);
        IF i > count THEN EXIT; END;

        IF NOT(chklimits) THEN (* // only when really drawing ! *)
            vpause(speed);
            IF BiosIO.KeyPressed() THEN EXIT; END; (* or RETURN  *)
        END;

    END;

    IF chklimits THEN
        dx:=(hiX-loX)/2.0;
        dy:=(hiY-loY)/2.0;

        xx:=f2i( orgX+dx-(hiX-orgX) ); xx:=INTEGER(cx)+ xx-f2i(orgX);
        yy:=f2i( orgY+dy-(hiY-orgY) ); yy:=INTEGER(cy)+ yy-f2i(orgY);
    END;
END redraw;

PROCEDURE initSpiro (forcecenter:BOOLEAN );
BEGIN
    genparms;
    orgbadalgo:= GetRndCardRange(0,1)=1;
    IF forcecenter THEN
        autocenter:=TRUE;
    ELSE
        autocenter:= GetRndCardRange(0,1)=1;
    END;
    cx:=INTEGER(xcenter);
    cy:=INTEGER(ycenter);
    xx:=cx;
    yy:=cy;
    rotationAnchor:=rotation;
END initSpiro;

CONST
    small = 1;
    big   = 10;

PROCEDURE updateSpiro (speed:CARDINAL;  forcecenter:BOOLEAN;  ink:BYTE  );
BEGIN
     IF autocenter THEN redraw(speed,TRUE,ink); END;
     redraw(speed,FALSE,ink); (* use our globerks here *)
     newint(rotation,FALSE,small,small,minangle,maxangle,TRUE );
     IF rotation=rotationAnchor THEN initSpiro(forcecenter); END;
END updateSpiro;

(* ------------------------------------------------------------ *)
(* ------------------------------------------------------------ *)

PROCEDURE okrange (lower,upper:CARDINAL; VAR v:CARDINAL;n:INTEGER):BOOLEAN ;
VAR
    i,k:CARDINAL;
    vv:INTEGER;
BEGIN
    vv:=INTEGER(v);
    k:=0;
    FOR i := 1 TO ABS(n) DO
        IF n < 0 THEN
            DEC(vv);
            IF vv < INTEGER(lower) THEN vv:=INTEGER(lower);INC(k);END;
        ELSE
            INC(vv);
            IF vv > INTEGER(upper) THEN vv:=INTEGER(upper);INC(k);END;
        END;
    END;
    v:=CARDINAL(vv);
    RETURN (k=0);
END okrange;

PROCEDURE newxy (VAR x,y:CARDINAL);
BEGIN
    x  := getrndrange(xmin+1,xmax-1);
    y  := getrndrange(ymin+1,ymax-1);
END newxy;

PROCEDURE longvalue (S:ARRAY OF CHAR;min,max:LONGCARD;VAR r:LONGCARD):BOOLEAN;
VAR
    R : str128;
    ok: BOOLEAN;
BEGIN
    GetString(S,R);
    IF Str.Length(R)=0 THEN RETURN FALSE; END;
    IF R[0]="$" THEN
        Str.Delete(R,0,1);
        r:=Str.StrToCard(R,16,ok);
        IF ok=FALSE THEN RETURN FALSE; END;
    ELSE
        IF GetLongCard(S,r)=FALSE THEN RETURN FALSE; END;
    END;
    IF r < min THEN RETURN FALSE; END;
    IF r > max THEN RETURN FALSE; END;
    RETURN TRUE;
END longvalue;

PROCEDURE ivalue (S:ARRAY OF CHAR;min,max:INTEGER;VAR r:INTEGER):BOOLEAN;
VAR
    v : LONGINT;
BEGIN
    IF GetLongInt(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGINT(min) THEN RETURN FALSE; END;
    IF v > LONGINT(max) THEN RETURN FALSE; END;
    r := INTEGER(v);
    RETURN TRUE;
END ivalue;

PROCEDURE value (S:ARRAY OF CHAR;min,max:CARDINAL;VAR r:CARDINAL):BOOLEAN;
VAR
    v : LONGCARD;
BEGIN
    IF GetLongCard(S,v)=FALSE THEN RETURN FALSE; END;
    IF v < LONGCARD(min) THEN RETURN FALSE; END;
    IF v > LONGCARD(max) THEN RETURN FALSE; END;
    r := CARDINAL(v);
    RETURN TRUE;
END value;

PROCEDURE mouseclick (  ):BOOLEAN;
VAR
    msdata:MsMouse.MsData;
BEGIN
    MsMouse.GetStatus(msdata);
    IF msdata.left_pressed THEN RETURN TRUE; END;
    IF msdata.right_pressed THEN RETURN TRUE; END;
    RETURN msdata.middle_pressed;
END mouseclick;

PROCEDURE swapCards (VAR v1,v2:CARDINAL);
VAR
    tmp:CARDINAL;
BEGIN
    (* v1.0e : weird trick to prevent lockup when both speed limits are the same *)
    IF v1 = v2 THEN INC(v2); RETURN; END;

    IF v1 <= v2 THEN RETURN; END;
    tmp := v2;
    v2  := v1;
    v1  := tmp;
END swapCards;

(* ------------------------------------------------------------ *)

VAR
    parmcount,i,opt   : CARDINAL;
    S,R           : str128;
    v           : CARDINAL;

    palette     : palettetype;
    resille     : BOOLEAN;
    chained     : BOOLEAN;
    stopmouse   : BOOLEAN;
    showpal     : BOOLEAN;
    forcecenter : BOOLEAN;
    mode        : (lines,splines,softsplines,quix,blobs,blobsfilled,spiros);

    pause       : BOOLEAN;
    keycode     : CARDINAL;
    oldx,oldy   : CARDINAL;
    newx,newy   : CARDINAL;
    dx1,dy1,dx2,dy2 : INTEGER;
    ink         : BYTE;
    lasteffect  : BOOLEAN;
    gotInk,gotInkFadeTo,rc : BOOLEAN;
    ival : INTEGER;
BEGIN
    Lib.DisableBreakCheck();
    WrLn;                       (* must be here for pretty ulterior display ! *)

    palette      := redpal;
    resille      := FALSE;
    chained      := TRUE;
    stopmouse    := FALSE;
    showpal      := FALSE;
    mode         := lines;
    gotInk       := FALSE;
    gotInkFadeTo := FALSE;
    gInk         := 0FFFF00H;
    gInkFadeTo   := 0AF0000H;
    mininkline   := 112;
    forcecenter  := FALSE;
    initSplineDefaults;
    initQuixDefaults;

    parmcount := Lib.ParamCount();

    FOR i := 1 TO parmcount DO
        Lib.ParamStr(S,i); cleantabs(S);
        Str.Copy(R,S);
        UpperCase(R);
        IF isOption(R) THEN
            opt := GetOptIndex (R, "?"+delim+"H"+delim+"HELP"+delim+
                                   "A"+delim+"SHOWPAL"+delim+
                                   "Z"+delim+"MOUSE"+delim+
                                   "P:"+delim+"PALETTE:"+delim+
                                   "D"+delim+"DIAGONAL"+delim+
                                   "I"+delim+"INDEPENDANT"+delim+
                                   "S"+delim+"SPLINES"+delim+
                                   "C:"+delim+"CONTROLPOINTS:"+delim+
                                   "S:"+delim+"SEGMENTS:"+delim+
                                   "L:"+delim+"LOWERSPEED:"+delim+
                                   "U:"+delim+"UPPERSPEED:"+delim+
                                   "W:"+delim+"WAIT:"+delim+
                                   "T:"+delim+"TRAILS:"+delim+
                                   "I:"+delim+"INK:"+delim+
                                   "F:"+delim+"INKFADETO:"+delim+
                                   "M:"+delim+"MININKLINE:"+delim+
                                   "O"+delim+"SOFTSPLINES"+delim+
                                   "Q"+delim+"QUIX"+delim+
                                   "B"+delim+"BLOBS"+delim+
                                   "F"+delim+"FILLED"+delim+
                                   "T"+delim+"SPIROS"+delim+
                                   "X"+delim+"AUTOCENTER"
                               );
            CASE opt OF
            | 1,2,3 : abort(errHelp,"");
            | 4,5 :   showpal := TRUE;
            | 6,7:    stopmouse:=TRUE;
            | 8,9:
                IF value(R,ORD(redpal),ORD(systempal),v)=FALSE THEN
                    abort(errRange,"palette");
                END;
                palette:=palettetype(v);
            | 10,11:  resille := TRUE;
            | 12,13:  chained := FALSE;
            | 14,15:  mode:=splines;
            | 16,17 :
                IF value(R,minControlPoints,maxControlPoints,gControlPoints)=FALSE THEN
                    abort(errRange,"number of control points");
                END;
            | 18,19 :
                IF value(R,minSegments,maxSegments,gSegments)=FALSE THEN
                    abort(errRange,"number of segments");
                END;
            | 20,21 :
                IF value(R,minSpeed,maxSpeed,gMinSpeed)=FALSE THEN
                    abort(errRange,"minimum speed");
                END;
                gMinSpeedQuix := gMinSpeed;
            | 22,23:
                IF value(R,minSpeed,maxSpeed,gMaxSpeed)=FALSE THEN
                    abort(errRange,"maximum speed");
                END;
                gMaxSpeedQuix := gMaxSpeed;
            | 24,25:
                IF value(R,minWait,maxWait,gWait)=FALSE THEN
                    abort(errRange,"wait");
                END;
            | 26,27:
                IF value(R,minTrails,maxTrails,gTrails)=FALSE THEN
                    abort(errRange,"number of trails");
                END;
            | 28,29:
                IF longvalue(R,minColor,maxColor,gInk)=FALSE THEN
                    abort(errRange,"ink");
                END;
                gotInk := TRUE;
            | 30,31:
                IF longvalue(R,minColor,maxColor,gInkFadeTo)=FALSE THEN
                    abort(errRange,"ink to fade to");
                END;
                gotInkFadeTo := TRUE;
            | 32,33:
                IF value(R,mininkindex,maxinkindex,mininkline)=FALSE THEN
                    abort(errRange,"minimum color index");
                END;
            | 34,35:  mode := softsplines;
            | 36,37:  mode := quix;
            | 38,39:  mode := blobs;
            | 40,41:  mode := blobsfilled;
            | 42,43:  mode := spiros;
            | 44,45:  forcecenter:=TRUE;
            ELSE
                abort(errUnknownOpt,S);
            END;
        ELSE
            abort(errIllegalParm,S);
        END;
    END;

    CASE gotInk OF
    | TRUE:
        CASE gotInkFadeTo OF
        | TRUE:  palette := userpal; normalize(gInk); normalize(gInkFadeTo);
        | FALSE: abort(errBothRequired,"");
        END;
    | FALSE:
        CASE gotInkFadeTo OF
        | TRUE:  abort(errBothRequired,"");
        | FALSE: (* let it be *)
        END;
    END;

    IF stopmouse THEN
        IF MsMouse.Reset()=MAX(INTEGER) THEN
            stopmouse := FALSE;
        END;
    END;


    initcostable();

    Lib.RANDOMIZE;
    initYbase;
    NEW(Screen);
    NEW(SmoothScreen);

    inittrigo(); (* for spiro *)

    CASE mode OF
    | splines, softsplines,blobs,blobsfilled:
        (* initSplineDefaults; *)
        swapCards(gMinSpeed,gMaxSpeed);
        initknots(gControlPoints,maxTrails); (* was gTrails *)
        FOR i := firsttrail TO gTrails DO
            v := i << 1;
            IF maxinkindex < v THEN v := mininkindex; END;
            couleur[i] := BYTE(maxinkindex -v);
        END;
    | lines:
        (* useless *)
    | quix:
        dx1:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);
        dy1:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);
        dx2:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);
        dy2:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);

        (* oldx,oldy initialized later in common code *)
        newxy(newx,newy);
    | spiros:
        initSpiro(forcecenter);
    END;

    setVideoMode(hires);

    FOR i := 0 TO 255 DO
        getDAC(i,orgpal[i].r,orgpal[i].g,orgpal[i].b);
    END;

    newPalette(palette);

    FarFill(FarADR(videoscreen[0]),screensize,ndxblack);

    IF showpal THEN
        showPalette;
        FarFill(FarADR(videoscreen[0]),screensize,ndxblack);
    END;

    flushKeyboard;

    pause := FALSE;
    lasteffect := FALSE;

    newxy(oldx,oldy);
    LOOP
        (* vpause(gWait); *)
        IF pause=FALSE THEN
            ink:=BYTE( getrndrange(mininkline,maxinkindex) );
            CASE mode OF
            | lines:
                FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
                newxy(newx,newy);
                IF chained = FALSE THEN newxy(oldx,oldy); END;
                zline(oldx,oldy,newx,newy,ink);
                oldx:=newx;
                oldy:=newy;
                smoothAndRefresh(resille,FALSE);
            | splines:
                FarFill(FarADR(Screen^),screensize,ndxblack);
                moveknots(gControlPoints,gTrails);
                parabolicSpline(gControlPoints,gTrails,gSegments);
                smoothAndRefresh(resille,FALSE);
            | softsplines:
                FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
                moveknots(gControlPoints,gTrails);
                parabolicSpline(gControlPoints,gTrails,gSegments);
                smoothAndRefresh(resille,TRUE);
            | quix:
                FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
                movequix(oldx,oldy,dx1,dy1,newx,newy,dx2,dy2);
                zline(oldx,oldy,newx,newy,ink);
                smoothAndRefresh(resille,FALSE);
            | blobs:
                FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
                moveknots(gControlPoints,gTrails);
                showKnots(FALSE,gControlPoints,gTrails);
                smoothAndRefresh(resille,TRUE);
            | blobsfilled:
                FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
                moveknots(gControlPoints,gTrails);
                showKnots(TRUE,gControlPoints,gTrails);
                smoothAndRefresh(resille,TRUE);
            | spiros:
                FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
                updateSpiro(gWait,forcecenter,ink);
                smoothAndRefresh(resille,TRUE);
            END;
        END;

        vpause(gWait);

        IF getKeyboardCode(keycode) THEN
            CASE keycode OF
            | lowerR :   palette:=rpal      ;newPalette(palette);
            | lowerG :   palette:=gpal      ;newPalette(palette);
            | lowerB :   palette:=bpal      ;newPalette(palette);
            | upperR :   palette:=redpal    ;newPalette(palette);
            | upperG :   palette:=greenpal  ;newPalette(palette);
            | upperB :   palette:=bluepal   ;newPalette(palette);
            | keydollar: palette:=rainbowpal;newPalette(palette);
            | keyStar:   palette:=randompal ;newPalette(palette);
            | keyDivide: palette:=rndpal    ;newPalette(palette);
            | keyexclam: palette:=systempal ;newPalette(palette);
            | keyequal:  palette:=descentpal;newPalette(palette);
            | key1 :     palette:=rougepal  ;newPalette(palette);
            | key2 :     palette:=vertpal   ;newPalette(palette);
            | key3 :     palette:=bleupal   ;newPalette(palette);
            | key0 :     palette:=grispal   ;newPalette(palette);
            | keyTAB:
                 IF palette = MAX(palettetype) THEN
                     palette:=MIN(palettetype);
                 ELSE
                     INC(palette);
                 END;
                 newPalette(palette);
            | keyTABshift:
                 IF palette = MIN(palettetype) THEN
                     palette:=MAX(palettetype);
                 ELSE
                     DEC(palette);
                 END;
                 newPalette(palette);

            | upperD,lowerD : resille := TRUE;
            | upperN,lowerN : resille := FALSE;
            | upperC,lowerC : chained := TRUE;
            | upperI,lowerI : chained := FALSE;
            | upperL,lowerL : mode := lines;
            | upperQ,lowerQ : mode := quix;
                 dx1:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);
                 dy1:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);
                 dx2:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);
                 dy2:=newdelta(gMinSpeedQuix,gMaxSpeedQuix);
                 newxy(newx,newy); (* may be undefined, while oldxy always exist *)
            | upperS,lowerS : mode := splines;
                (* initSplineDefaults; *)
                swapCards(gMinSpeed,gMaxSpeed);
                initknots(gControlPoints,maxTrails); (* was gTrails *)
                FOR i := firsttrail TO gTrails DO
                    v := i << 1;
                    IF maxinkindex < v THEN v := mininkindex; END;
                    couleur[i] := BYTE(maxinkindex -v);
                END;
            | upperO,lowerO : mode := softsplines;
                (* initSplineDefaults; *)
                swapCards(gMinSpeed,gMaxSpeed);
                initknots(gControlPoints,maxTrails); (* was gTrails *)
                FOR i := firsttrail TO gTrails DO
                   v := i << 1;
                   IF maxinkindex < v THEN v := mininkindex; END;
                   couleur[i] := BYTE(maxinkindex -v);
                END;
            | upperP,lowerP : mode := blobs;
                (* initSplineDefaults; *)
                swapCards(gMinSpeed,gMaxSpeed);
                initknots(gControlPoints,maxTrails); (* was gTrails *)
                FOR i := firsttrail TO gTrails DO
                   v := i << 1;
                   IF maxinkindex < v THEN v := mininkindex; END;
                   couleur[i] := BYTE(maxinkindex -v);
                END;
            | upperF,lowerF : mode := blobsfilled;
                (* initSplineDefaults; *)
                swapCards(gMinSpeed,gMaxSpeed);
                initknots(gControlPoints,maxTrails); (* was gTrails *)
                FOR i := firsttrail TO gTrails DO
                   v := i << 1;
                   IF maxinkindex < v THEN v := mininkindex; END;
                   couleur[i] := BYTE(maxinkindex -v);
                END;
            | upperT,lowerT : mode := spiros;
                initSpiro(forcecenter);
            | upperX,lowerX : forcecenter:=NOT(forcecenter);

            | space         : pause:=NOT(pause);
            | escape        : EXIT;
            | keyCR         : lasteffect:=TRUE; EXIT;
            | keyplus       :
                 IF gTrails < maxTrails THEN
                     INC(gTrails);
                     (* ugly refresh if we fully reinit here *)
                     FOR i := firsttrail TO gTrails DO
                         v := i << 1;
                         IF maxinkindex < v THEN v := mininkindex; END;
                         couleur[i] := BYTE(maxinkindex -v);
                     END;
                 END;
            | keyminus      :
                 IF gTrails > minTrails THEN
                     DEC(gTrails);
                     (* ugly refresh if we fully reinit here *)
                     FOR i := firsttrail TO gTrails DO
                         v := i << 1;
                         IF maxinkindex < v THEN v := mininkindex; END;
                         couleur[i] := BYTE(maxinkindex -v);
                     END;
                 END;
            | keyF1:
                ival := -1;
                IF okrange(minControlPoints,maxControlPoints,gControlPoints, ival) THEN
                    initknots(gControlPoints,maxTrails);
                END;
                IF mode=spiros THEN
                    newcard(count,FALSE,-small,-big,mincount,maxcount,FALSE);
                END;
            | keyF2:
                ival := 1;
                IF okrange(minControlPoints,maxControlPoints,gControlPoints, ival) THEN
                    initknots(gControlPoints,maxTrails);
                END;
                IF mode=spiros THEN
                    newcard(count,FALSE,small,big,mincount,maxcount,FALSE);
                END;
            | keyF3:
                ival := -1;
                IF okrange(minSpeed,maxSpeed,gMinSpeed, ival) THEN
                    swapCards(gMinSpeed,gMaxSpeed);
                END;
            | keyF4:
                ival := 1;
                IF okrange(minSpeed,maxSpeed,gMinSpeed, ival) THEN
                    swapCards(gMinSpeed,gMaxSpeed);
                END;
            | keyF5:
                ival := -1;
                IF okrange(minSpeed,maxSpeed,gMaxSpeed, ival) THEN
                    swapCards(gMinSpeed,gMaxSpeed);
                END;
            | keyF6:
                ival := 1;
                IF okrange(minSpeed,maxSpeed,gMaxSpeed, ival) THEN
                    swapCards(gMinSpeed,gMaxSpeed);
                END;
            | keyPgUp:
                newcard (gWait, FALSE,-1,-1,minWait,maxWait, FALSE);
            | keyPgDn:
                newcard (gWait, FALSE, 1, 1,minWait,maxWait, FALSE);
            END;
            IF keycode # space THEN pause := FALSE; END;
        END;
        IF stopmouse THEN
            IF mouseclick() THEN EXIT; END;
        END;
    END;
    IF lasteffect THEN
        CASE mode OF
        | lines,quix: v:= 63;
        | splines, softsplines,blobs,blobsfilled,spiros: v:=127;
        END;
        i := 0;
        LOOP
            FarWordMove(FarADR(videoscreen[0]),FarADR(Screen^),screensizeW);
            smoothAndRefresh(resille,FALSE);
            INC(i);
            IF i > v THEN EXIT; END;
            IF getKeyboardCode(keycode) THEN EXIT; END;
        END;
    END;

    (* newPalette(systempal); *)

    setVideoMode(text);

    abort(errNone,"");
END ZigZag.

